/***************************************************************************
*   Copyright (C) 2004 by Christoph Thielecke                             *
*   crissi99@gmx.de                                                       *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#ifndef IMPORTCERTIFICATEDIALOG_H
#define IMPORTCERTIFICATEDIALOG_H

#include "importcertificatedialogbase.h"
#include <tqprocess.h>
#include <tqstring.h>
#include <tqstringlist.h>
#include <kdialogbase.h>
#include "kvpncconfig.h"

/**
@author Christoph Thielecke
*/
class ImportCertificateDialog : public KDialogBase {
		Q_OBJECT
  
	public:
		ImportCertificateDialog(TQWidget *parent, const char* caption, KVpncConfig *GlobalConfig);

		~ImportCertificateDialog();
		void canAccept();
		TQString filename;
		TQString certpath;
		TQString importpassword;
		TQString privatekeypassword;
		TQString privatekeyagainpassword;
		TQString pathToOpenSSL;
		TQString certHash;
		TQString certName;
		TQString CertFullPath;
		TQString CaCertFullPath;
		bool importOk;
		bool doHash;
		bool importSuccess;
		bool doExit;

		enum ImportType {pkcs12_freeswan=0,pkcs12_racoon=1,ca_der=2,pkcs12_openvpn=3,cisco=4, ciscoca=5, ciscouserca=6};

protected:
		TQProcess *ImportProcess;
		KVpncConfig *GlobalConfig;
		bool done;
		bool error_found;
		int askpasscount;
		TQStringList *env;

	public slots:
		void accept();
		void reject();
		void exit();
		void typeToggeled(int);
		void usePrivateKeyPassToggled(bool);
		void removePrivateKey();

	private slots:
		void readFromStdout_import();
		void readFromStderr_import();
		void doLink();
		void doCacert();
		void doPrivateKey();
		void doCreateHash();
		void ciscoCertMgrExited();


	public:
		ImportCertificateDialogBase *main;
};

#endif
