/* Domino widget style for KDE 3
   Copyright (C) 2006 Michael Lentner <michaell@gmx.net>

   based on the KDE style "Plastik":
   Copyright (C) 2003 Sandro Giessl <ceebx@users.sourceforge.net>

   based on the KDE style "dotNET":
   Copyright (C) 2001-2002, Chris Lee <clee@kde.org>
					Carsten Pfeiffer <pfeiffer@kde.org>
					Karol Szwed <gallium@kde.org>
   Drawing routines completely reimplemented from KDE3 HighColor, which was
   originally based on some stuff from the KDE2 HighColor.

   based on drawing routines of the style "Keramik":
   Copyright (c) 2002 Malte Starostik <malte@kde.org>
			 (c) 2002,2003 Maksim Orlovich <mo002j@mail.rochester.edu>
   based on the KDE3 HighColor Style
   Copyright (C) 2001-2002 Karol Szwed		<gallium@kde.org>
			 (C) 2001-2002 Fredrik H�glund	<fredrik@kde.org>
   Drawing routines adapted from the KDE2 HCStyle,
   Copyright (C) 2000 Daniel M. Duley		<mosfet@kde.org>
			 (C) 2000 Dirk Mueller			<mueller@kde.org>
			 (C) 2001 Martijn Klingens		<klingens@kde.org>
   Progressbar code based on TDEStyle,
   Copyright (C) 2001-2002 Karol Szwed <gallium@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License version 2 as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this library; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 */


#include <tdeglobalsettings.h>
#include <tqpainter.h>
#include <tqtabbar.h>
#include <tqprogressbar.h>
#include <tqcheckbox.h>
#include <tqlineedit.h>
#include <tqlistbox.h>
#include <tqstyleplugin.h>
#include <tqpushbutton.h>
#include <tqtoolbutton.h>
#include <tdepopupmenu.h>
#include <tqradiobutton.h>
#include <tqslider.h>
#include <tqsettings.h>
#include <kpixmap.h>
#include <tqgroupbox.h>
#include <tqmenudata.h>
#include <tqdockarea.h>
#include <tqobjectlist.h>
#include <tqheader.h>
#include <tdelistview.h>
#include <tqstatusbar.h>
#include <tqcombobox.h>
#include <tqtabwidget.h>
#include <tdetoolbar.h>
#include <tqlabel.h>
#include <tqsimplerichtext.h>
#include <tqiconview.h>
#include <tdeconfig.h>
#include <tqapplication.h>
#include <tqtoolbox.h>
#include <tqstylesheet.h>
// #include <tqsplitter.h>
#include <tqwidgetstack.h>
#include <tqtimer.h>
#include <tdemultitabbar.h>
#include <tqspinbox.h>
#include <tqcursor.h>
#include <tqtextedit.h>
#include <tdeversion.h>
#include <kimageeffect.h>

#include <X11/Xlib.h>
#include <ft2build.h>
#include FT_FREETYPE_H

#include "domino.h"

#include <X11/Xft/Xft.h>
// #include <X11/extensions/Xrender.h>
#include <X11/extensions/shape.h>



// popupmenu item constants...
static const int itemHMargin = 6;
static const int itemFrame = 7;
static const int arrowHMargin = 6;

ButtonContour::ButtonContour()
{
	
	state = Contour_Default;
	alpha_mode = false;
		
	for(int t = 0; t < num_types; t++)
		for(int s = 0; s < num_states; s++)
			created[t][s] = 0;
	
	for(int s = 0; s < num_states; s++)
		shadowCreated[s] = 0;
		
	ContourType ty;
	ty = Contour_Sunken;
	for(int s = 0; s < num_states; s++) {
		c1[ty][s] = tqRgba(31, 31, 31, 32);  // top first shadow line
		c4[ty][s] = tqRgba(255, 255, 255, 78); // bottom first shadow line
		c5[ty][s] = tqRgba(255, 255, 255, 30); // bottom second shadow line
		c6[ty][s] = tqRgba(217, 217, 217, 34); // first left shadow line
	}
	ty = Contour_Raised;
	for(int s = 0; s < num_states; s++) {
		c1[ty][s] = tqRgba(0, 0, 0, 14);  // top first shadow line
		c4[ty][s] = tqRgba(0, 0, 0, 26); // bottom first shadow line
		c5[ty][s] = tqRgba(0, 0, 0, 10); // bottom second shadow line
		c6[ty][s] = tqRgba(0, 0, 0, 12); // first left shadow line
	}
	ty = Contour_Simple;
	for(int s = 0; s < num_states; s++) {
		c1[ty][s] = tqRgba(0, 0, 0, 0);  // top first shadow line
		c4[ty][s] = tqRgba(0, 0, 0, 0); // bottom first shadow line
		c5[ty][s] = tqRgba(0, 0, 0, 0); // bottom second shadow line
		c6[ty][s] = tqRgba(0, 0, 0, 0); // first left shadow line
	}
	drawButtonSunkenShadow = true;
}


ButtonContour::~ButtonContour()
{
	
	for(int t = 0; t < num_types; t++) {
		for(int s = 0; s < num_states; s++) {
			if(created[t][s]) {
				delete btnEdges[t][s];
				delete btnVLines[t][s];
				delete btnHLines[t][s];
			}
		}
	}
	for(int s = 0; s < num_states; s++) {
		if(shadowCreated[s])
			delete buttonShadowRectangular[s];
	}
}

RubberWidget::RubberWidget(Window window )
	: TQWidget()
{
	setWState(WState_Disabled|WState_Polished);
	TQWidget::create( window, true, true);
}

RubberWidget::~RubberWidget()
{
}



Rubber::Rubber(uint col)
{

	rubber = 0;
	parent = 0;
	window = 0;
	mask = TQRegion();
	Display *dpy = tqt_xdisplay();
	int screen = tqt_xscreen();
	visual = 0;
	colormap = 0;
	int event_base, error_base;
	
	if ( XRenderQueryExtension( dpy, &event_base, &error_base ) )
	{
		int nvi;
		XVisualInfo templ;
		templ.screen  = screen;
		templ.depth   = 32;
		templ.c_class = TrueColor;
		XVisualInfo *xvi = XGetVisualInfo( dpy, VisualScreenMask | VisualDepthMask
				| VisualClassMask, &templ, &nvi );

		for ( int i = 0; i < nvi; i++ ) {
			XRenderPictFormat *format = XRenderFindVisualFormat( dpy, xvi[i].visual );
			if ( format->type == PictTypeDirect && format->direct.alphaMask ) {
				visual = xvi[i].visual;
				colormap = XCreateColormap( dpy, RootWindow( dpy, screen ), visual, AllocNone );
				break;
			}
		}
	}
	
	wsa.border_pixel = 0;
	wsa.colormap = colormap;
	wsa.background_pixel = 0x00000000;
	wsa.override_redirect = true;
	
	color = col;
}

void Rubber::create(TQRect& r, TQRegion& m) {
	if(parent)
		return;
	
	mask = m;
	
	wsa.background_pixel = 0x00000000;
	Window parentwin = XCreateWindow(tqt_xdisplay(), tqApp->desktop()->winId(), r.x(), r.y(), r.width(), r.height(), 0, 32, InputOutput, visual, CWBackPixel|CWColormap|CWBorderPixel|CWOverrideRedirect, &wsa);
	parent = new RubberWidget(parentwin);
	
	wsa.background_pixel = color;
	window = XCreateWindow(tqt_xdisplay(), parentwin, 0, 0, r.width(), r.height(), 0, 32, InputOutput, visual, CWBackPixel|CWColormap|CWBorderPixel|CWOverrideRedirect, &wsa);
	rubber = new RubberWidget(window);
	
#ifdef ShapeInput
	TQBitmap bm(r.width(), r.height(), true);
	XShapeCombineMask(tqt_xdisplay(), rubber->winId(), ShapeInput, 0, 0, bm.handle(), ShapeSet);
#endif
	XShapeCombineRegion( tqt_xdisplay(), rubber->winId(), ShapeBounding, 0, 0, mask.handle(), ShapeSet );
	
	rubber->show();
	parent->show();
	
	XFlush(tqt_xdisplay());
}

Rubber::~Rubber()
{
}

void Rubber::updateMask(TQRegion& m) {
	if(mask != m)
		XShapeCombineRegion( tqt_xdisplay(), rubber->winId(), ShapeBounding, 0, 0, m.handle(), ShapeSet );
}


// -- Style Plugin Interface -------------------------
class DominoStylePlugin : public TQStylePlugin
{
	public:
		DominoStylePlugin() {}
		~DominoStylePlugin() {}

		TQStringList keys() const {
			return TQStringList() << "Domino";
		}

		TQStyle* create( const TQString& key ) {
			if (key.lower() == "domino")
				return new DominoStyle;
			return 0;
		}
};

KDE_Q_EXPORT_PLUGIN( DominoStylePlugin )
// -- end --

	DominoStyle::DominoStyle() : TDEStyle( TDEStyle::Default /*AllowMenuTransparency*/, ThreeButtonScrollBar )
{
	konsoleMode = false;
	kickerMode = false;
	konquerorMode = false;
	flatMode = false;
	viewPortPressed = false;
	oldRubberRect = TQRect();
	rubber = 0;
	ignoreNextFocusRect = false;
#if TDE_VERSION < 0x30506
	compositeManagerRunning = true;
#endif
	configMode = "0"; // temporaly to avoid cache problems between the configs previewStyle and this style
	spinWidgetDown = false;
	
	popupTimer = new TQTimer(this);
	
	TQColor background = tqApp->palette().active().background();
	TQColor buttonColor = tqApp->palette().active().button();
	TQColor highlight = tqApp->palette().active().highlight();
	TQSettings settings;
// 	_contrast = settings.readNumEntry("/TQt/KDE/contrast", 0);
	
	settings.beginGroup("/domino/Settings");
	
	//konqTabBarContrast = 150;
	konqTabBarContrast = settings.readNumEntry("/konqTabBarContrast", 15)+100;
	
	_animateProgressBar = settings.readBoolEntry("/animateProgressBar", true);
	_centerTabs = settings.readBoolEntry("/centerTabs", false);
	_drawTriangularExpander = settings.readBoolEntry("/drawTriangularExpander", true);
	_customCheckMarkColor = settings.readBoolEntry("/customCheckMarkColor", false);
	_checkMarkColor.setNamedColor( settings.readEntry("/checkMarkColor", "black") );
	groupBoxSettings.tintBackground = settings.readBoolEntry("/tintGroupBoxBackground", true);
	groupBoxSettings.customColor = settings.readBoolEntry("/customGroupBoxBackgroundColor", false);
	groupBoxSettings.brightness = settings.readNumEntry("/groupBoxBrightness", 10);
	groupBoxSettings.color = settings.readEntry("/groupBoxBackgroundColor", darkenColor(background, 10).name());
	bool customToolTipColor = settings.readBoolEntry("/customToolTipColor", false);
	_toolTipColor = customToolTipColor? settings.readEntry("/toolTipColor", TQColor(218,218,179).name()) : TQColor(218,218,179);
	//_toolTipColor = TQColor(255,255,220); // yellow
	_smoothScrolling = settings.readBoolEntry("/smoothScrolling", true);
	_buttonHeightAdjustment = settings.readNumEntry("/buttonHeightAdjustment", 0);
	_customPopupMenuColor = settings.readBoolEntry("/customPopupMenuColor", false);
	_popupMenuColor = _customPopupMenuColor ? settings.readEntry("/popupMenuColor", background.name()) : background.name();
	_customSelMenuItemColor = settings.readBoolEntry("/customSelMenuItemColor", false);
	_selMenuItemColor = _customSelMenuItemColor ? settings.readEntry("/selMenuItemColor", highlight.name()) : highlight.name();
	_drawPopupMenuGradient = settings.readBoolEntry("/drawPopupMenuGradient", true);
	_indentPopupMenuItems = settings.readBoolEntry("/indentPopupMenuItems", true);
	_toolBtnAsBtn = settings.readBoolEntry("/drawToolButtonAsButton", true);
	_highlightToolBtnIcon = settings.readBoolEntry("/highlightToolBtnIcon", false);
	
	rubberBandType = (RubberType) settings.readNumEntry("/rubberBandType", DistRubber);
	if(rubberBandType == ArgbRubber) {
		int dummy;
		if(XQueryExtension(tqt_xdisplay(), "Composite", &dummy, &dummy, &dummy)) {
			TQColor c = settings.readEntry("/rubberBandColor", highlight.name());
			int a = settings.readNumEntry("/rubberBandOpacity", 30)*255/100;
			_argbRubberBandColor = tqRgba(c.red(), c.green(), c.blue(), a);
			
			rubber = new Rubber(preMultiplyColor(_argbRubberBandColor));
		}
		else
			rubberBandType = DistRubber;
	}
	
	
	focusIndicatorSettings.indicateFocus = settings.readBoolEntry("/indicateFocus", true);
	if(focusIndicatorSettings.indicateFocus) {
		focusIndicatorSettings.color = settings.readEntry("/indicatorColor", highlight.name());
		focusIndicatorSettings.opacity = settings.readNumEntry("/indicatorColorOpacity", 60)*255/100;
		focusIndicatorSettings.buttonColor = settings.readEntry("/indicatorButtonColor", highlight.name());
		focusIndicatorSettings.buttonOpacity = settings.readNumEntry("/indicatorColorButtonOpacity", 60)*255/100;
	}
	focusIndicatorSettings.drawUnderline = settings.readBoolEntry("/drawFocusUnderline", true);
	
	buttonContour = new ButtonContour();
	buttonContour->setDefaultType((ContourType)settings.readNumEntry("/buttonContourType", Contour_Raised), false); // we need to know the ContourType to adjust the contour colors
	buttonContour->setColor(Contour_Default, settings.readEntry("/buttonContourColor", background.dark(250).name()));
	buttonContour->setColor(Contour_DefaultButton, settings.readEntry("/buttonDefaultContourColor", highlight.name()));
	buttonContour->setColor(Contour_MouseOver, settings.readEntry("/buttonMouseOverContourColor", background.dark(250).name()));
	buttonContour->setColor(Contour_Pressed, settings.readEntry("/buttonPressedContourColor", background.dark(250).name()));
	buttonContour->drawButtonSunkenShadow = settings.readBoolEntry("/drawButtonSunkenShadow", true);
	buttonContour->setDefaultType(buttonContour->defaultType); // create this time the tinted pixmaps
	
	if(buttonContour->defaultType == Contour_Raised)
		buttonContour->drawButtonSunkenShadow = false;
	
	_customSliderHandleContourColor = settings.readBoolEntry("/customSliderHandleContourColor", false);
	
	bool drawTextEffect = settings.readBoolEntry("/drawTextEffect", true);
	if(drawTextEffect) {
		
		textEffectSettings.mode = settings.readNumEntry("/textEffectMode", 0) ? TextEffect_Everywhere : TextEffect_OnlyButton;
		textEffectSettings.color = settings.readEntry("/textEffectColor", TQt::white.name());
		textEffectSettings.opacity = settings.readNumEntry("/textEffectOpacity", 60)*255/100;
		textEffectSettings.buttonColor = settings.readEntry("/textEffectButtonColor", TQt::white.name());
		textEffectSettings.buttonOpacity = settings.readNumEntry("/textEffectButtonOpacity", 60)*255/100;
		int textEffectPos = settings.readNumEntry("/textEffectPos", 5);
		switch(textEffectPos) {
			case 0:
				textEffectSettings.pos = TQPoint(-1,-1);
				break;
			case 1:
				textEffectSettings.pos = TQPoint(0,-1);
				break;
			case 2:
				textEffectSettings.pos = TQPoint(1,-1);
				break;
			case 3:
				textEffectSettings.pos = TQPoint(1,0);
				break;
			case 4:
				textEffectSettings.pos = TQPoint(1,1);
				break;
			case 5:
				textEffectSettings.pos = TQPoint(0,1);
				break;
			case 6:
				textEffectSettings.pos = TQPoint(-1,1);
				break;
			case 7:
				textEffectSettings.pos = TQPoint(-1,0);
				break;
			default:
				textEffectSettings.pos = TQPoint(0,1);
		}
		
		int textEffectButtonPos = settings.readNumEntry("/textEffectButtonPos", 5);
		switch(textEffectButtonPos) {
			case 0:
				textEffectSettings.buttonPos = TQPoint(-1,-1);
				break;
			case 1:
				textEffectSettings.buttonPos = TQPoint(0,-1);
				break;
			case 2:
				textEffectSettings.buttonPos = TQPoint(1,-1);
				break;
			case 3:
				textEffectSettings.buttonPos = TQPoint(1,0);
				break;
			case 4:
				textEffectSettings.buttonPos = TQPoint(1,1);
				break;
			case 5:
				textEffectSettings.buttonPos = TQPoint(0,1);
				break;
			case 6:
				textEffectSettings.buttonPos = TQPoint(-1,1);
				break;
			case 7:
				textEffectSettings.buttonPos = TQPoint(-1,0);
				break;
			default:
				textEffectSettings.buttonPos = TQPoint(0,1);
		}
	}
	else
		textEffectSettings.mode = TextEffect_None;
	
	btnSurface.numGradients = settings.readNumEntry("/btnSurface_numGradients", 2);
	btnSurface.g1Color1 = settings.readEntry("/btnSurface_g1Color1", buttonColor.name());
	btnSurface.g1Color2 = settings.readEntry("/btnSurface_g1Color2", buttonColor.dark(120).name());
	btnSurface.g2Color1 = settings.readEntry("/btnSurface_g2Color1", buttonColor.dark(120).name());
	btnSurface.g2Color2 = settings.readEntry("/btnSurface_g2Color2", buttonColor.dark(110).name());
	btnSurface.background = settings.readEntry("/btnSurface_background", buttonColor.name());
	btnSurface.g1Top = settings.readNumEntry("/btnSurface_g1Top", 0);
	btnSurface.g1Bottom = settings.readNumEntry("/btnSurface_g1Bottom", 50);
	btnSurface.g2Top = settings.readNumEntry("/btnSurface_g2Top", 50);
	btnSurface.g2Bottom = settings.readNumEntry("/btnSurface_g2Bottom", 100);
	
	activeTabTopSurface.numGradients = settings.readNumEntry("/activeTabTopSurface_numGradients", 2);
	activeTabTopSurface.g1Color1 = settings.readEntry("/activeTabTopSurface_g1Color1", background.light(110).name());
	activeTabTopSurface.g1Color2 = settings.readEntry("/activeTabTopSurface_g1Color2", background.name());
	activeTabTopSurface.g2Color1 = settings.readEntry("/activeTabTopSurface_g2Color1", background.name());
	activeTabTopSurface.g2Color2 = settings.readEntry("/activeTabTopSurface_g2Color2", background.name());
	activeTabTopSurface.background = settings.readEntry("/activeTabTopSurface_background", background.name());
	activeTabTopSurface.g1Top = settings.readNumEntry("/activeTabTopSurface_g1Top", 0);
	activeTabTopSurface.g1Bottom = settings.readNumEntry("/activeTabTopSurface_g1Bottom", 50);
	activeTabTopSurface.g2Top = settings.readNumEntry("/activeTabTopSurface_g2Top", 50);
	activeTabTopSurface.g2Bottom = settings.readNumEntry("/activeTabTopSurface_g2Bottom", 100);
	
	tabTopSurface.numGradients = settings.readNumEntry("/tabTopSurface_numGradients", 2);
	tabTopSurface.g1Color1 = settings.readEntry("/tabTopSurface_g1Color1", background.light(110).name());
	tabTopSurface.g1Color2 = settings.readEntry("/tabTopSurface_g1Color2", background.dark(110).name());
	tabTopSurface.g2Color1 = settings.readEntry("/tabTopSurface_g2Color1", background.dark(110).name());
	tabTopSurface.g2Color2 = settings.readEntry("/tabTopSurface_g2Color2", background.dark(110).name());
	tabTopSurface.background = settings.readEntry("/tabTopSurface_background", background.dark(110).name());
	tabTopSurface.g1Top = settings.readNumEntry("/tabTopSurface_g1Top", 0);
	tabTopSurface.g1Bottom = settings.readNumEntry("/tabTopSurface_g1Bottom", 50);
	tabTopSurface.g2Top = settings.readNumEntry("/tabTopSurface_g2Top", 50);
	tabTopSurface.g2Bottom = settings.readNumEntry("/tabTopSurface_g2Bottom", 100);
	
	activeTabBottomSurface.numGradients = settings.readNumEntry("/activeTabBottomSurface_numGradients", 2);
	activeTabBottomSurface.g1Color1 = settings.readEntry("/activeTabBottomSurface_g1Color1", background.name());
	activeTabBottomSurface.g1Color2 = settings.readEntry("/activeTabBottomSurface_g1Color2", background.name());
	activeTabBottomSurface.g2Color1 = settings.readEntry("/activeTabBottomSurface_g2Color1", background.name());
	activeTabBottomSurface.g2Color2 = settings.readEntry("/activeTabBottomSurface_g2Color2", background.dark(120).name());
	activeTabBottomSurface.background = settings.readEntry("/activeTabBottomSurface_background", background.name());
	activeTabBottomSurface.g1Top = settings.readNumEntry("/activeTabBottomSurface_g1Top", 0);
	activeTabBottomSurface.g1Bottom = settings.readNumEntry("/activeTabBottomSurface_g1Bottom", 50);
	activeTabBottomSurface.g2Top = settings.readNumEntry("/activeTabBottomSurface_g2Top", 50);
	activeTabBottomSurface.g2Bottom = settings.readNumEntry("/activeTabBottomSurface_g2Bottom", 100);
	
	tabBottomSurface.numGradients = settings.readNumEntry("/tabBottomSurface_numGradients", 2);
	tabBottomSurface.g1Color1 = settings.readEntry("/tabBottomSurface_g1Color1", background.dark(110).name());
	tabBottomSurface.g1Color2 = settings.readEntry("/tabBottomSurface_g1Color2", background.dark(110).name());
	tabBottomSurface.g2Color1 = settings.readEntry("/tabBottomSurface_g2Color1", background.dark(110).name());
	tabBottomSurface.g2Color2 = settings.readEntry("/tabBottomSurface_g2Color2", background.dark(120).name());
	tabBottomSurface.background = settings.readEntry("/tabBottomSurface_background", background.dark(110).name());
	tabBottomSurface.g1Top = settings.readNumEntry("/tabBottomSurface_g1Top", 0);
	tabBottomSurface.g1Bottom = settings.readNumEntry("/tabBottomSurface_g1Bottom", 50);
	tabBottomSurface.g2Top = settings.readNumEntry("/tabBottomSurface_g2Top", 50);
	tabBottomSurface.g2Bottom = settings.readNumEntry("/tabBottomSurface_g2Bottom", 100);
	
	scrollBarSurface.numGradients = settings.readNumEntry("/scrollBarSurface_numGradients", 2);
	scrollBarSurface.g1Color1 = settings.readEntry("/scrollBarSurface_g1Color1", buttonColor.name());
	scrollBarSurface.g1Color2 = settings.readEntry("/scrollBarSurface_g1Color2", buttonColor.dark(120).name());
	scrollBarSurface.g2Color1 = settings.readEntry("/scrollBarSurface_g2Color1", buttonColor.dark(120).name());
	scrollBarSurface.g2Color2 = settings.readEntry("/scrollBarSurface_g2Color2", buttonColor.dark(110).name());
	scrollBarSurface.background = settings.readEntry("/scrollBarSurface_background", buttonColor.name());
	scrollBarSurface.g1Top = settings.readNumEntry("/scrollBarSurface_g1Top", 0);
	scrollBarSurface.g1Bottom = settings.readNumEntry("/scrollBarSurface_g1Bottom", 50);
	scrollBarSurface.g2Top = settings.readNumEntry("/scrollBarSurface_g2Top", 50);
	scrollBarSurface.g2Bottom = settings.readNumEntry("/scrollBarSurface_g2Bottom", 100);
	
	scrollBarGrooveSurface.numGradients = settings.readNumEntry("/scrollBarGrooveSurface_numGradients", 0);
	scrollBarGrooveSurface.g1Color1 = settings.readEntry("/scrollBarGrooveSurface_g1Color1", background.name());
	scrollBarGrooveSurface.g1Color2 = settings.readEntry("/scrollBarGrooveSurface_g1Color2", background.dark(120).name());
	scrollBarGrooveSurface.g2Color1 = settings.readEntry("/scrollBarGrooveSurface_g2Color1", background.dark(120).name());
	scrollBarGrooveSurface.g2Color2 = settings.readEntry("/scrollBarGrooveSurface_g2Color2", background.dark(110).name());
	scrollBarGrooveSurface.background = settings.readEntry("/scrollBarGrooveSurface_background", background.dark(150).name());
	scrollBarGrooveSurface.g1Top = settings.readNumEntry("/scrollBarGrooveSurface_g1Top", 0);
	scrollBarGrooveSurface.g1Bottom = settings.readNumEntry("/scrollBarGrooveSurface_g1Bottom", 50);
	scrollBarGrooveSurface.g2Top = settings.readNumEntry("/scrollBarGrooveSurface_g2Top", 50);
	scrollBarGrooveSurface.g2Bottom = settings.readNumEntry("/scrollBarGrooveSurface_g2Bottom", 100);

	headerSurface.numGradients = settings.readNumEntry("/headerSurface_numGradients", 2);
	headerSurface.g1Color1 = settings.readEntry("/headerSurface_g1Color1", background.name());
	headerSurface.g1Color2 = settings.readEntry("/headerSurface_g1Color2", background.dark(120).name());
	headerSurface.g2Color1 = settings.readEntry("/headerSurface_g2Color1", background.dark(120).name());
	headerSurface.g2Color2 = settings.readEntry("/headerSurface_g2Color2", background.dark(110).name());
	headerSurface.background = settings.readEntry("/headerSurface_background", background.name());
	headerSurface.g1Top = settings.readNumEntry("/headerSurface_g1Top", 0);
	headerSurface.g1Bottom = settings.readNumEntry("/headerSurface_g1Bottom", 50);
	headerSurface.g2Top = settings.readNumEntry("/headerSurface_g2Top", 50);
	headerSurface.g2Bottom = settings.readNumEntry("/headerSurface_g2Bottom", 100);

	// checkBoxes + radioButtons
	checkItemSurface.numGradients = settings.readNumEntry("/checkItemSurface_numGradients", 2);
	checkItemSurface.g1Color1 = settings.readEntry("/checkItemSurface_g1Color1", buttonColor.name());
	checkItemSurface.g1Color2 = settings.readEntry("/checkItemSurface_g1Color2", buttonColor.dark(120).name());
	checkItemSurface.g2Color1 = settings.readEntry("/checkItemSurface_g2Color1", buttonColor.dark(120).name());
	checkItemSurface.g2Color2 = settings.readEntry("/checkItemSurface_g2Color2", buttonColor.dark(110).name());
	checkItemSurface.background = settings.readEntry("/checkItemSurface_background", buttonColor.name());
	checkItemSurface.g1Top = settings.readNumEntry("/checkItemSurface_g1Top", 0);
	checkItemSurface.g1Bottom = settings.readNumEntry("/checkItemSurface_g1Bottom", 50);
	checkItemSurface.g2Top = settings.readNumEntry("/checkItemSurface_g2Top", 50);
	checkItemSurface.g2Bottom = settings.readNumEntry("/checkItemSurface_g2Bottom", 100);

	settings.endGroup();
	
	if(!strcmp(tqApp->argv()[0], "konqueror")) {
		TDEGlobal::config()->setGroup("General");
		minTabLength = TDEGlobal::config()->readNumEntry("MinimumTabLength", 3);
	}
	else
		minTabLength = 0;
	
	if(!strcmp(tqApp->className(), "TDEApplication")) {
		TQString oldgroup = TDEGlobal::config()->group();
		TDEGlobal::config()->setGroup("KDE");
		macStyleBar = TDEGlobal::config()->readBoolEntry("macStyle", false);
		TDEGlobal::config()->setGroup(oldgroup); // reset the group, do not interfere with the application
		TDEApplicationMode = true;
	}
	else {
		macStyleBar = false;
		TDEApplicationMode = false;
	}
	
	
	hoverWidget = 0;
	horizontalLine = 0;
	verticalLine = 0;
	sideRepaint = 0;
	hoveredToolBoxTab = 0;

	checkMark = createCheckMark(_customCheckMarkColor? _checkMarkColor : tqApp->palette().active().foreground());
	radioIndicator = createRadioIndicator(_customCheckMarkColor? _checkMarkColor : tqApp->palette().active().foreground());
	
	popupFrame = new TQPixmap(tintImage(qembed_findImage("popup5"), _popupMenuColor.dark(150) ));
	
	// setup pixmap cache...
	pixmapCache = new TQIntCache<CacheEntry>(150000, 499);
	pixmapCache->setAutoDelete(true);

	if ( _animateProgressBar )
	{
		animationTimer = new TQTimer( this );
		connect( animationTimer, SIGNAL(timeout()), this, SLOT(updateProgressPos()) );
	}

	scrollDistance = 0;
	scrollWidget = 0;
	scrollTimer = new TQTimer(this);
	connect( scrollTimer, SIGNAL(timeout()), this, SLOT(updateScrollPos()) );
	
	TQColor tabContour2 = tqApp->palette().active().background().dark(150);
	border1= new TQPixmap(tintImage(qembed_findImage("border1"), tabContour2));
}

void DominoStyle::updateProgressPos()
{
	
	TQProgressBar* pb;
	//Update the registered progressbars.
	TQMap<TQWidget*, int>::iterator iter;
	bool visible = false;
	for (iter = progAnimWidgets.begin(); iter != progAnimWidgets.end(); iter++)
	{	
		if ( !dynamic_cast<TQProgressBar*>(iter.key()) )
			continue;
		
		pb = dynamic_cast<TQProgressBar*>(iter.key());
		if ( iter.key() -> isEnabled() && 
				   pb->progress() != pb->totalSteps() && pb->progress())
		{
			// update animation Offset of the current Widget
			iter.data() = (iter.data() + 1) % 20;
			iter.key()->update();
		}
		if (iter.key()->isVisible())
			visible = true;
	}
	if (!visible)
		animationTimer->stop();
}

void DominoStyle::updateScrollPos()
{
	if(dynamic_cast<TQScrollView*>(scrollWidget) && scrollDistance != 0) {
		int scroll;
		if(scrollDistance < 0) {
			if(scrollDistance < -200)
				scroll = +45;
			else if(scrollDistance < -100)
				scroll = +30;
			else
				scroll = +15;
			
			scrollDistance += scroll;
			scrollDistance = TQMIN(scrollDistance, 0);
		}
		else {
			if(scrollDistance > 200)
				scroll = -45;
			else if(scrollDistance > 100)
				scroll = -30;
			else
				scroll = -15;
			
			scrollDistance += scroll;
			scrollDistance = TQMAX(scrollDistance, 0);
		}
		
		if(scrollVertical)
			scrollWidget->scrollBy(0, scroll);
		else
			scrollWidget->scrollBy(scroll, 0);
	}
	else if(scrollTimer->isActive()) {
		scrollTimer->stop();
	}
}


DominoStyle::~DominoStyle()
{
	delete pixmapCache;
	delete horizontalLine;
	delete verticalLine;
	
	delete checkMark;
	delete radioIndicator;
	delete border1;
	delete popupFrame;
	
	delete buttonContour;
}

void DominoStyle::applicationPolish( const TQStyleControlElementData &ceData, ControlElementFlags elementFlags, void *ptr )
{
	if (!ceData.widgetObjectTypes.contains(TQAPPLICATION_OBJECT_NAME_STRING)) {
		return;
	}
	TQApplication *app = reinterpret_cast<TQApplication*>(ptr);
	if(!qstrcmp(app->name(), "konsole"))
		konsoleMode = true;
	else if(!qstrcmp(app->name(), "konqueror"))
		konquerorMode = true;
	else if(!qstrcmp(app->name(), "kicker"))
		kickerMode = true;
	
	TQPixmapCache::clear();
}

void DominoStyle::polish(TQPalette &p) {
	
	p.setBrush(TQColorGroup::Button, p.active().background());

	if(!_customPopupMenuColor)
		_popupMenuColor = tqApp->palette().active().background();
	if(!_customSelMenuItemColor)
		_selMenuItemColor = tqApp->palette().active().highlight();
	
	TQColor tabContour2 = tqApp->palette().active().background().dark(150);
	delete border1;
	border1= new TQPixmap(tintImage(qembed_findImage("border1"), tabContour2));
	delete popupFrame;
	popupFrame = new TQPixmap(tintImage(qembed_findImage("popup5"), _popupMenuColor.dark(150)));
	if(!_customCheckMarkColor) {
		delete checkMark;
		checkMark = createCheckMark(tqApp->palette().active().foreground());
		delete radioIndicator;
		radioIndicator = createRadioIndicator(tqApp->palette().active().foreground());
	}
}

void DominoStyle::polish( const TQStyleControlElementData &ceData, ControlElementFlags elementFlags, void *ptr )
{
	if (!ceData.widgetObjectTypes.contains(TQWIDGET_OBJECT_NAME_STRING)) {
		return;
	}
	TQWidget *widget = reinterpret_cast<TQWidget*>(ptr);

	if(!strcmp(widget->name(), "__tdehtml")) { // is it a tdehtml widget...?
		tdehtmlWidgets[widget] = true;
		connect(widget, SIGNAL(destroyed(TQObject*)), this, SLOT(tdehtmlWidgetDestroyed(TQObject*)));
	}
	else if((!strcmp(widget->name(), "tdefile button") || (widget->isA("KLineEdit") && widget->parentWidget())) && !strcmp(widget->parentWidget()->name(), "__tdehtml")) {
		widget->setBackgroundMode(TQt::NoBackground);
		widget->parentWidget()->setBackgroundMode(TQt::NoBackground);
		tdehtmlWidgets[widget] = true;
		connect(widget, SIGNAL(destroyed(TQObject*)), this, SLOT(tdehtmlWidgetDestroyed(TQObject*)));
	}
	
	if(dynamic_cast<TQPushButton*>(widget)) {
		
		setDominoButtonPalette(widget, Palette_Widget);
		
		if (widget->isA("KDockButton_Private"))
			widget->setFixedSize(13, 13); // 12x12 pixmap + 1px top and right spacing
		else {
			((DominoTQWidget*)widget)->setWFlags(TQt::WNoAutoErase);
			if(widget->parentWidget() && widget->parentWidget()->paletteBackgroundPixmap() && !tdehtmlWidgets.contains(widget)) {
				widget->setBackgroundMode(TQt::PaletteButton);
				widget->setBackgroundPixmap(*widget->parentWidget()->paletteBackgroundPixmap());
				widget->setBackgroundOrigin(setPixmapOrigin(widget->parentWidget()->backgroundOrigin()));
			}
		}
		
		installObjectEventHandler(ceData, elementFlags, ptr, this);
	}
	else if(dynamic_cast<TQCheckBox*>(widget)) {
		((DominoTQWidget*)widget)->setWFlags(TQt::WNoAutoErase);
		installObjectEventHandler(ceData, elementFlags, ptr, this);
	}
	else if(dynamic_cast<TDEToolBarButton*>(widget)) {
		TDEToolBarButton* tb = static_cast<TDEToolBarButton*>(widget);
		//setDominoButtonPalette(widget); // ### changing the palette breaks them!
		
		if(tb->popupDelay() < 1)
			tb->setPopupDelay(5); // now we have time to draw a pressed button
		installObjectEventHandler(ceData, elementFlags, ptr, this);
	}
	else if(dynamic_cast<TQToolButton*>(widget)) {
		TQToolButton* tb = static_cast<TQToolButton*>(widget);
		tb->setBackgroundMode(TQt::PaletteBackground);
		tb->setPaletteForegroundColor(tb->palette().active().buttonText());
		setDominoButtonPalette(widget, Palette_Widget);
		
		if(tb->popupDelay()  < 1) {
			disconnect(tb, SIGNAL(pressed()), tb, SLOT(popupPressed()));
			connect(tb, SIGNAL(pressed()), this, SLOT(toolPopupPressed()));
			connect(tb, SIGNAL(released()), this, SLOT(toolPopupReleased()));
		}
		
		if(tb->popupDelay() < 1)
			tb->setPopupDelay(5);
		
		if(tb->parentWidget() && tb->parentWidget()->paletteBackgroundPixmap()) {
			tb->setPaletteBackgroundPixmap(*tb->parentWidget()->paletteBackgroundPixmap());
			tb->setBackgroundOrigin(setPixmapOrigin(tb->parentWidget()->backgroundOrigin()));
		}
		
// 		if(widget->isA("TaskContainer"))
// 			((DominoTQWidget*)widget)->setWFlags(TQt::WNoAutoErase);
// 		else
			installObjectEventHandler(ceData, elementFlags, ptr, this);
			((DominoTQWidget*)widget)->setWFlags(TQt::WNoAutoErase);
	}
	else if(dynamic_cast<TQRadioButton*>(widget)) {
		((DominoTQWidget*)widget)->setWFlags(TQt::WNoAutoErase);
		installObjectEventHandler(ceData, elementFlags, ptr, this);
	}
	else if(dynamic_cast<TQComboBox*>(widget)) {
		TQComboBox* cb = static_cast<TQComboBox*>(widget);
		
		((DominoTQWidget*)widget)->setWFlags(TQt::WNoAutoErase);
		if(widget->parentWidget() && widget->parentWidget()->paletteBackgroundPixmap() && !tdehtmlWidgets.contains(widget)) {
			widget->setBackgroundMode(TQt::PaletteButton);
			widget->setBackgroundOrigin(setPixmapOrigin(widget->parentWidget()->backgroundOrigin()));
		}
		
		setDominoButtonPalette(widget, Palette_Widget);
		if(cb->listBox())
			cb->listBox()->setFrameStyle(TQFrame::Panel|TQFrame::Sunken);
		installObjectEventHandler(ceData, elementFlags, ptr, this);
	}
	else if(dynamic_cast<TQGroupBox*>(widget)) {
		TQGroupBox* gb = dynamic_cast<TQGroupBox*>(widget);
		gb->setAlignment(TQt::AlignHCenter);
		
		if(!gb->isFlat() && !gb->lineWidth() <= 0) {
			if(gb->layout() && gb->layout()->margin() < 7)
				gb->layout()->setMargin(7);
			bool groupBoxFrame = gb->frameShape() == TQFrame::GroupBoxPanel;
			if(groupBoxFrame)
				((DominoTQWidget*)widget)->setWFlags(TQt::WNoAutoErase);
			
			if(groupBoxSettings.tintBackground && groupBoxFrame) {
				TQColor color = getGroupBoxColor(gb);
				TQPalette pal(widget->palette());
				int h, s, v;
				pal.active().foreground().hsv(&h, &s, &v);
				pal.setColor(TQPalette::Active, TQColorGroup::Background, color);
				pal.setColor(TQPalette::Inactive, TQColorGroup::Background, color);
				pal.setColor(TQPalette::Disabled, TQColorGroup::Background, color);
				pal.setColor(TQPalette::Disabled, TQColorGroup::Text, alphaBlendColors(pal.active().foreground(), color, 40));
				gb->setPalette(pal);
				
				if(gb->isCheckable()) {
					((TQCheckBox*)gb->child("qt_groupbox_checkbox", 0, false))->setPaletteBackgroundColor(gb->parentWidget()->paletteBackgroundColor());
				}
			}
			connect(widget, SIGNAL(destroyed(TQObject*)), this, SLOT(groupBoxDestroyed(TQObject*)));
		}
		installObjectEventHandler(ceData, elementFlags, ptr, this);
	}
	else if(dynamic_cast<TQSpinWidget*>(widget)) {
		 // Don't like this widget... too much private stuff and the spinBox/spinWidget mess.
		// We check here if the spinBox has a backgroundPixmap. If it's a spinWidget without a spinBox, well, maybe we should fill the widget black then >:)
		if(widget->parentWidget() && widget->parentWidget()->parentWidget() && widget->parentWidget()->parentWidget()->paletteBackgroundPixmap()) {
			TQWidget::BackgroundOrigin origin = widget->parentWidget()->backgroundOrigin();
			if(origin == TQWidget::WidgetOrigin) {
				widget->parentWidget()->setBackgroundOrigin(TQWidget::ParentOrigin);
				widget->setBackgroundOrigin(TQWidget::AncestorOrigin);
			}
			else
				widget->setBackgroundOrigin(setPixmapOrigin(origin));
		}
		((DominoTQWidget*)widget)->setWFlags(TQt::WNoAutoErase);
		setDominoButtonPalette(widget, Palette_Widget);
		installObjectEventHandler(ceData, elementFlags, ptr, this);
	}
	else if(dynamic_cast<TQSpinBox*>(widget)) {
		connect(dynamic_cast<TQSpinBox*>(widget), SIGNAL(valueChanged(int)), this, SLOT(spinBoxValueChanged(int)));
	}
	else if(dynamic_cast<TQLineEdit*>(widget)) {
		TQLineEdit* le = dynamic_cast<TQLineEdit*>(widget);
		TQRect r = le->rect();
		le->setFrameRect(TQRect(r.x()+1, r.y(), r.width()-1, r.height()));
		installObjectEventHandler(ceData, elementFlags, ptr, this);
	}
	else if(dynamic_cast<TQScrollBar*>(widget)) {
		installObjectEventHandler(ceData, elementFlags, ptr, this);
	}
	else if(dynamic_cast<TQStatusBar*>(widget)) {
		installObjectEventHandler(ceData, elementFlags, ptr, this);
	}
	else if(dynamic_cast<TQHeader*>(widget)) {
		setDominoButtonPalette(widget, Palette_Widget);
		installObjectEventHandler(ceData, elementFlags, ptr, this);
	}
	else if(dynamic_cast<TQPopupMenu*>(widget)) {
		widget->setBackgroundMode( NoBackground );
		installObjectEventHandler(ceData, elementFlags, ptr, this);
	}
	else if(dynamic_cast<TQTabWidget*>(widget)) {
		installObjectEventHandler(ceData, elementFlags, ptr, this);
	}
	else if(dynamic_cast<TQTabBar*>(widget)) {
		TQTabBar* tb = dynamic_cast<TQTabBar*>(widget);
		if(widget->parentWidget() && widget->parentWidget()->isA("KonqFrameTabs")) {
			tb->setShape(TQTabBar::RoundedBelow);
			widget->setEraseColor(widget->paletteBackgroundColor().dark(konqTabBarContrast));
		}
		connect(tb, SIGNAL(layoutChanged()), this, SLOT(updateTabWidgetFrame()));
		connect(tb, SIGNAL(selected(int)), this, SLOT(updateTabWidgetFrame()));
		setDominoButtonPalette(widget, Palette_Widget);
		installObjectEventHandler(ceData, elementFlags, ptr, this);
	}
	else if(dynamic_cast<TQIconView*>(widget)) {
		((DominoTQWidget*)dynamic_cast<TQIconView*>(widget)->viewport())->setWFlags(TQt::WNoAutoErase);
		((DominoTQWidget*)widget)->setWFlags(TQt::WNoAutoErase);
		installObjectEventHandler(ceData, elementFlags, dynamic_cast<TQIconView*>(widget)->viewport(), this); // rubberband
		if(strcmp(widget->className(), "KDIconView"))
			installObjectEventHandler(ceData, elementFlags, ptr, this);
	}
	else if(dynamic_cast<TQListView*>(widget)) {
		installObjectEventHandler(ceData, elementFlags, dynamic_cast<TQListView*>(widget)->viewport(), this); // rubberband
		if(widget->isA("KonqTreeViewWidget")) { // konqi frames
			TQFrame* f = dynamic_cast<TQFrame*>(widget);
			f->setFrameStyle(TQFrame::Box|TQFrame::Plain);
			f->setLineWidth(1);
		}
		
		if(!widget->isA("KopeteContactListView") && !widget->isA("ViewTree")) // they have their own mousewheel handling
			installObjectEventHandler(ceData, elementFlags, ptr, this);
	}
	else if(widget->isA("KActiveLabel")) { // before TQScrollView
		if(dynamic_cast<TQGroupBox*>(widget->parentWidget()))
			widget->setPaletteBackgroundColor(widget->parentWidget()->paletteBackgroundColor());
	}
	else if(dynamic_cast<TQTextEdit*>(widget)) {
		installObjectEventHandler(ceData, elementFlags, dynamic_cast<TQTextEdit*>(widget)->viewport(), this);
		installObjectEventHandler(ceData, elementFlags, ptr, this);
	}
	else if(dynamic_cast<TQScrollView*>(widget)) {
		TQFrame* f = dynamic_cast<TQFrame*>(widget);
		if((konquerorMode && widget->isA("TDEHTMLView")) || f->parentWidget() && !strcmp(f->parentWidget()->name(), "KonqFrame")) { // konqi frames
			f->setFrameStyle(TQFrame::Box|TQFrame::Plain);
			f->setLineWidth(1);
			installObjectEventHandler(ceData, elementFlags, ptr, this);
		}
		else if(_smoothScrolling && !widget->isA("TaskBar") && !widget->isA("Gwenview::ImageView"))
			installObjectEventHandler(ceData, elementFlags, ptr, this);
	}
	else if(dynamic_cast<TQSlider*>(widget)) {
		((DominoTQWidget*)widget)->setWFlags(TQt::WNoAutoErase);
	}
	else if(dynamic_cast<TQListBox*>(widget)) {
		installObjectEventHandler(ceData, elementFlags, ptr, this);
	}
	else if(dynamic_cast<TDEToolBarSeparator*>(widget) || dynamic_cast<TQToolBar*>(widget)) {
		widget->setBackgroundMode(TQt::PaletteBackground);
	}

	else if(widget->isA("KonqCheckBox")) {
		installObjectEventHandler(ceData, elementFlags, ptr, this);
	}
	else if(widget->isA("TQTipLabel")) {
		installObjectEventHandler(ceData, elementFlags, ptr, this);
	}
	else if(widget->isA("TQWhatsThat")) {
		installObjectEventHandler(ceData, elementFlags, ptr, this);
	}
	else if(widget->isA("KonqFileTip")) {
		installObjectEventHandler(ceData, elementFlags, ptr, this);
	}

	else if(dynamic_cast<TQButton*>(widget) && widget->parentWidget() && widget->parentWidget()->isA("TQToolBox")) {
		installObjectEventHandler(ceData, elementFlags, ptr, this);
	}
	else if( dynamic_cast<TQProgressBar*>(widget) && _animateProgressBar)
	{
		setDominoButtonPalette(widget, Palette_Widget);
		
		progAnimWidgets[widget] = 0;
		connect(widget, SIGNAL(destroyed(TQObject*)), this, SLOT(progressBarDestroyed(TQObject*)));
// 		if (!animationTimer->isActive())
// 			animationTimer->start( 50, false );
		installObjectEventHandler(ceData, elementFlags, ptr, this);
	}
	else if(dynamic_cast<TDEPopupTitle*>(widget)) {
		installObjectEventHandler(ceData, elementFlags, ptr, this);
	}
	else if(dynamic_cast<TQFrame*>(widget)) {
		TQFrame* f = dynamic_cast<TQFrame*>(widget);
		
		switch (f->frameShape()) {
			case TQFrame::Box:
				f->setFrameStyle(TQFrame::StyledPanel|TQFrame::Sunken);
				f->setLineWidth(2);
				break;
			case TQFrame::Panel:
				if(kickerMode && f->parentWidget() &&  f->parentWidget()->isA("ClockApplet")) {
					f->setLineWidth(0);
					break;
				}
			case TQFrame::WinPanel:
				f->setLineWidth(1);
				installObjectEventHandler(ceData, elementFlags, ptr, this);
				break;
			case TQFrame::LineEditPanel: {
				installObjectEventHandler(ceData, elementFlags, ptr, this);
				break;
			}
			case TQFrame::TabWidgetPanel:
				if(dynamic_cast<TQWidgetStack*>(widget)) {
					if(f->parentWidget() && f->parentWidget()->isA("KonqFrameTabs"))
						break;
					
					f->setLineWidth(4);
					f->setFrameRect(TQRect(0, 0, f->width(), f->height()-1));
					f->setMargin(0);

					TQWidget* w = widget->parentWidget();
					for(int i=0; i<3; i++) { // the third parentcheck is for the tabWidget on kcm tdehtml_plugins
						if(!w) break;
						if(dynamic_cast<TQGroupBox*>(w)) {
							widget->setPaletteBackgroundColor(tqApp->palette().active().background());
								break;
						}
						w = w->parentWidget();
					}
					
					if(dynamic_cast<TQWidgetStack*>(widget)->widget(0)) // only if it has contents
						((DominoTQWidget*)widget)->setWFlags(TQt::WNoAutoErase);
				}
			case TQFrame::HLine:
			case TQFrame::VLine: {
				installObjectEventHandler(ceData, elementFlags, ptr, this);
				break;
				}
			case TQFrame::StyledPanel:
				if(dynamic_cast<TQDockWindow*>(widget)) {
					installObjectEventHandler(ceData, elementFlags, ptr, this);
				}
				else if(widget->isA("TQWorkspaceChild")) {
					f->setFrameStyle(TQFrame::Panel|TQFrame::Sunken);
					f->setLineWidth(1);
					installObjectEventHandler(ceData, elementFlags, ptr, this);
				}
				else if(widget->isA("KAnimWidget"))
					f->setLineWidth(0);
				
			default:
				break;
		}
	}
// 	else if (dynamic_cast<KDockSplitter*>(widget)) {
// 		installObjectEventHandler(ceData, elementFlags, ptr, this);
// 	} else if (dynamic_cast<KDockWidgetAbstractHeaderDrag*>(widget)) {
// 		installObjectEventHandler(ceData, elementFlags, ptr, this);
	else if(widget->isA("TQDateTimeEditor")) {
		installObjectEventHandler(ceData, elementFlags, ptr, this);
	}
	else if(widget->inherits("TQDockWindowHandle") || widget->isA("TQDockWindowResizeHandle") ||
		        widget->isA("AppletHandleDrag")) { // !qstrcmp(widget->name(), "qt_dockwidget_internal")
		installObjectEventHandler(ceData, elementFlags, ptr, this);
	}
	else if(widget->isA("KDockWidget") && widget->parentWidget() && widget->parentWidget()->parentWidget()
		       && widget->parentWidget()->parentWidget()->isA("Sidebar_Widget")) {
		widget->setEraseColor(widget->palette().active().base());
	}
	
// 	installObjectEventHandler(ceData, elementFlags, ptr, this);
	//tqDebug("className %s, name: %s", widget->className(), widget->name());
	
}

void DominoStyle::unPolish( const TQStyleControlElementData &ceData, ControlElementFlags elementFlags, void *ptr )
{
	if (!ceData.widgetObjectTypes.contains(TQWIDGET_OBJECT_NAME_STRING)) {
		return;
	}
	TQWidget *widget = reinterpret_cast<TQWidget*>(ptr);

	if( !strcmp(widget->name(), "__tdehtml") || (!strcmp(widget->name(), "tdefile button") && !strcmp(widget->parentWidget()->name(), "__tdehtml"))) { // is it a tdehtml widget...?
		tdehtmlWidgets.remove(widget);
	}

	if (dynamic_cast<TQPushButton*>(widget) || 
		   dynamic_cast<TQSpinWidget*>(widget) || dynamic_cast<TQSlider*>(widget) ||
		   dynamic_cast<TQRadioButton*>(widget) ||
		   dynamic_cast<TQListBox*>(widget) || dynamic_cast<TQListView*>(widget) ||
		   dynamic_cast<TQStatusBar*>(widget) || widget->isA("AppletHandleDrag") ||
		   widget->isA("TQDockWindowHandle"))
	{
		((DominoTQWidget*)widget)->clearWFlags(TQt::WNoAutoErase);
		widget->removeEventFilter(this);
	}
	else if(widget->isA("KonqCheckBox") || widget->isA("TQWhatsThat") || widget->isA("TQTipLabel")) {
		widget->removeEventFilter(this);
		widget->setPaletteBackgroundColor(tqApp->palette().active().background());
		widget->setBackgroundMode(TQt::PaletteBackground);
	}
	else if(dynamic_cast<TQTabWidget*>(widget) || dynamic_cast<TQTabBar*>(widget)) {
		widget->removeEventFilter(this);
		widget->setBackgroundMode(TQt::PaletteBackground);
	}
	else if(dynamic_cast<TQCheckBox*>(widget)) {
		((DominoTQWidget*)widget)->clearWFlags(TQt::WNoAutoErase);
		widget->removeEventFilter(this);
	}
	else if(dynamic_cast<TQComboBox*>(widget)) { // after KonqCheckBox
		((DominoTQWidget*)widget)->clearWFlags(TQt::WNoAutoErase);
		widget->removeEventFilter(this);
	}
	else if(dynamic_cast<TQHeader*>(widget)) {
		widget->removeEventFilter(this);
		widget->setBackgroundMode(TQt::PaletteButton);
	}
	else if(dynamic_cast<TQPopupMenu*>(widget)) {
		widget->removeEventFilter(this);
		widget->setBackgroundMode(TQt::PaletteBackground);
		static_cast<TQFrame*>(widget)->setLineWidth(2);
		widget->clearMask();
	}
	else if(dynamic_cast<TDEToolBarButton*>(widget)) {
		widget->removeEventFilter(this);
		widget->setBackgroundMode(TQt::PaletteBackground);
	}
	else if(dynamic_cast<TQGroupBox*>(widget)) {
		widget->removeEventFilter(this);
		((DominoTQWidget*)widget)->clearWFlags(TQt::WNoAutoErase);
		TQGroupBox* gb = dynamic_cast<TQGroupBox*>(widget);
		gb->setBackgroundMode(TQt::PaletteBackground);
		gb->setPalette(tqApp->palette());
		gb->setAlignment(TQt::AlignLeft|TQt::AlignBottom);
	}
	else if(dynamic_cast<TQLineEdit*>(widget)) {
		widget->removeEventFilter(this);
		widget->setBackgroundMode(TQt::PaletteBase);
		TQLineEdit* le = dynamic_cast<TQLineEdit*>(widget);
		TQRect r = le->rect();
		le->setFrameRect(TQRect(r.x()-1, r.y(), r.width()+1, r.height()));
		widget->clearMask();
	}
	else if(dynamic_cast<TQProgressBar*>(widget) ) {
		progAnimWidgets.remove(widget);
	}
	else if(dynamic_cast<TDEToolBarSeparator*>(widget) || dynamic_cast<TQToolBar*>(widget) ) {
		widget->removeEventFilter(this);
		widget->setBackgroundMode(TQt::PaletteButton);
	}
	if(widget->isA("KonqFileTip")) {
		widget->removeEventFilter(this);
		widget->setPaletteBackgroundColor(widget->palette().active().background());
		TQFrame* f = dynamic_cast<TQFrame*>(widget);
		f->setMargin(1);
		f->setFrameStyle(TQFrame::Plain|TQFrame::Box);

		TQObjectList *list = const_cast<TQObjectList *>(widget->children());
		TQObjectListIt it( *list );
		TQObject * o;
		while ( (o = it.current()) != 0 ) {
			++it;
			if(dynamic_cast<TQLabel*>(o)) {
				TQLabel* l = dynamic_cast<TQLabel*>(o);
				l->setBackgroundOrigin(TQWidget::WidgetOrigin);
				l->setBackgroundMode(TQt::PaletteBackground);
				l->setPaletteBackgroundColor(l->palette().active().background());
			}
		}
	}
	else if(dynamic_cast<TQScrollView*>(widget)) {
		TQFrame* f = dynamic_cast<TQFrame*>(widget);
		if((konquerorMode && widget->isA("TDEHTMLView")) || f->parentWidget() && !strcmp(f->parentWidget()->name(), "KonqFrame")) { // konqi frames
			widget->removeEventFilter(this);
			f->setFrameStyle(TQFrame::NoFrame|TQFrame::Plain);
			f->setLineWidth(0);
		}
	}
	else if(dynamic_cast<TDEPopupTitle*>(widget)) {
		widget->removeEventFilter(this);
	}
	else if(dynamic_cast<TQFrame*>(widget)) {
		widget->removeEventFilter(this);
		TQFrame* f = dynamic_cast<TQFrame*>(widget);
		switch(f->frameShape()) {
			case TQFrame::Panel:
				if(widget->isA("TQWorkspaceChild")) {
					f->setFrameStyle(TQFrame::StyledPanel|TQFrame::Sunken);
					f->setLineWidth(2);
				}
				break;
			case TQFrame::WinPanel:
				f->setLineWidth(2);
				break;
			case TQFrame::TabWidgetPanel:
				f->setLineWidth(2);
				f->setMargin(2);
				f->setFrameRect(TQRect(0, 0, 0, 0));
				break;
			case TQFrame::StyledPanel:
				if(widget->isA("KAnimWidget"))
					f->setLineWidth(2);
				break;
			default:
				break;
		}
	}

	
	TDEStyle::unPolish( ceData, elementFlags, ptr );
}

void DominoStyle::tdehtmlWidgetDestroyed(TQObject* obj)
{
	tdehtmlWidgets.remove(static_cast<TQWidget*>(obj));
}

void DominoStyle::groupBoxDestroyed(TQObject* obj)
{
	groupBoxPixmaps.remove(static_cast<TQGroupBox*>(obj));
}

void DominoStyle::progressBarDestroyed(TQObject* obj)
{
	progAnimWidgets.remove(static_cast<TQWidget*>(obj));
}


void DominoStyle::renderContour(TQPainter *p, const TQRect &r, const TQColor &backgroundColor, const TQColor &contour, const uint flags) const {
	
	if((r.width() <= 0)||(r.height() <= 0))
		return;
	
	const bool drawLeft = flags&Draw_Left;
	const bool drawRight = flags&Draw_Right;
	const bool drawTop = flags&Draw_Top;
	const bool drawBottom = flags&Draw_Bottom;
//	const bool disabled = flags&Is_Disabled;
	const bool alphaBlend = flags&Draw_AlphaBlend;

	const bool roundUpperLeft = flags&Round_UpperLeft;
	const bool roundUpperRight = flags&Round_UpperRight;
	const bool roundBottomLeft = flags&Round_BottomLeft;
	const bool roundBottomRight = flags&Round_BottomRight;
	const bool isButton = flags&Is_Button;
	const bool isHorizontal = flags&Is_Horizontal;
	const bool isScrollBarBtn = flags&Is_ScrollBarBtn;
	
	TQColor appButtonColor = tqApp->palette().active().button();
	
	if(isButton) {
		
		TQRect sr = TQRect(r.x(), r.y()+2, r.width(), r.height()-5); // surface rect
		int top = sr.y()+sr.height()*btnSurface.g1Top/100;
		int bottom = sr.height()*btnSurface.g1Bottom/100;
		int top2 = sr.y()+sr.height()*btnSurface.g2Top/100;
		int bottom2 = sr.y()+sr.height()*btnSurface.g2Bottom/100-top2;

		int left = sr.x()+sr.width()*btnSurface.g1Top/100;
		int width = sr.width()*btnSurface.g1Bottom/100;
		int left2 = sr.x()+sr.width()*btnSurface.g2Top/100;
		int width2 = sr.width()*btnSurface.g2Bottom/100-left2;
		
		// darker surface colors for the inner part of the contour
		TQColor insideBackground;
		TQColor gr1TopColor;
		TQColor gr1BottomColor;
		TQColor gr2TopColor;
		TQColor gr2BottomColor;
		
		const int alphaInside = tqAlpha(buttonContour->color3());
		
		insideBackground = alphaBlendColors(buttonContour->color3(),
				((contour != appButtonColor) ? alphaBlendColors(contour, btnSurface.background, 127) : btnSurface.background), alphaInside);

		switch (btnSurface.numGradients) {
			case 2:{
				
				gr1TopColor = alphaBlendColors(buttonContour->color3(),
						((contour != appButtonColor) ? alphaBlendColors(contour, btnSurface.g1Color1, 127) : btnSurface.g1Color1), alphaInside);
				
				gr1BottomColor = alphaBlendColors(buttonContour->color3(),
						((contour != appButtonColor) ? alphaBlendColors(contour, btnSurface.g1Color2, 127) : btnSurface.g1Color2), alphaInside);
				
				gr2TopColor = alphaBlendColors(buttonContour->color3(),
						((contour != appButtonColor) ? alphaBlendColors(contour, btnSurface.g2Color1, 127) : btnSurface.g2Color1), alphaInside);
				
				gr2BottomColor = alphaBlendColors(buttonContour->color3(),
						((contour != appButtonColor) ? alphaBlendColors(contour, btnSurface.g2Color2, 127) : btnSurface.g2Color2), alphaInside);
				
				break;
			}
			case 1: {
				gr1TopColor = alphaBlendColors(buttonContour->color3(),
						((contour != appButtonColor) ? alphaBlendColors(contour, btnSurface.g1Color1, 127) : btnSurface.g1Color1), alphaInside);
				
				gr1BottomColor = alphaBlendColors(buttonContour->color3(),
						((contour != appButtonColor) ? alphaBlendColors(contour, btnSurface.g1Color2, 127) : btnSurface.g1Color2), alphaInside);
				break;
			}
			default: {
				insideBackground = insideBackground;
				gr1TopColor = insideBackground;
				gr1BottomColor = insideBackground;
				gr2TopColor = insideBackground;
				gr2BottomColor = insideBackground;
				break;
			}
		}
	
		if(flags & Is_Down) {
			gr1TopColor = darkenColor(gr1TopColor, 15);
			gr1BottomColor = darkenColor(gr1BottomColor, 15);
			gr2TopColor = darkenColor(gr2TopColor, 15);
			gr2BottomColor = darkenColor(gr2BottomColor, 15);
			insideBackground = darkenColor(insideBackground, 15);
		}
	
		
		
		TQRegion clip;
		if(drawTop)
			clip += TQRegion(r.left()+6, r.top()+2, r.width()-12, 1);
		if(drawBottom)
			clip += TQRegion(r.left()+6, r.bottom()-3, r.width()-12, 1);
		if(drawLeft)
			clip += TQRegion(r.left()+2, r.top()+6, 1, r.height()-13);
		if(drawRight)
			clip += TQRegion(r.right()-2, r.top()+6, 1, r.height()-13);
		p->setClipRegion(clip);
		
		
		p->fillRect(sr, insideBackground);
		switch(btnSurface.numGradients) {
			case 1:
				if(isHorizontal)
					renderGradient(p, TQRect(sr.x(), top, sr.width(), bottom), gr1TopColor, gr1BottomColor, true);
				else
					renderGradient(p, TQRect(left, sr.y(), width, sr.height()), gr1TopColor, gr1BottomColor, false);
				break;
			case 2:
				if(isHorizontal) {
					renderGradient(p, TQRect(r.x(), top, r.width(), bottom), gr1TopColor, gr1BottomColor, true);
					renderGradient(p, TQRect(r.x(), top2, r.width(), bottom2), gr2TopColor, gr2BottomColor, true);
				}
				else {
					renderGradient(p, TQRect(left, sr.y(), width, sr.height()), gr1TopColor,gr1BottomColor, false);
					renderGradient(p, TQRect(left2, sr.y(), width2, sr.height()), gr2TopColor,gr2BottomColor, false);
				}
			default:
				break;
		}
		p->setClipping(false);
		
		
		const TQColor color1 = alphaBlendColors(buttonContour->color1(), backgroundColor, tqAlpha(buttonContour->color1())); // 1.top
		const TQColor color4 = alphaBlendColors(buttonContour->color4(), backgroundColor, tqAlpha(buttonContour->color4())); // 3.bottom
		const TQColor color5 = alphaBlendColors(buttonContour->color5(), backgroundColor, tqAlpha(buttonContour->color5())); // 4.bottom
		const TQColor color2 = alphaBlendColors(buttonContour->color2(), backgroundColor, tqAlpha(buttonContour->color2())); // 2.top 2.left  2.bottom
		const TQColor color6 = alphaBlendColors(buttonContour->color6(), backgroundColor, tqAlpha(buttonContour->color6())); // 1.left
		
		
		if(roundUpperLeft)
			p->drawPixmap(r.left(), r.top(), *buttonContour->buttonEdges(), 0, 0, 6, 6);
		
		if(roundUpperRight)
			p->drawPixmap(r.right()-5, r.top(), *buttonContour->buttonEdges(), 6, 0, 6, 6);
		
		if(roundBottomLeft)
			p->drawPixmap(r.left(), r.bottom()-6, *buttonContour->buttonEdges(), 0, 6, 6, 7);
		
		if(roundBottomRight)
			p->drawPixmap(r.right()-5, r.bottom()-6, *buttonContour->buttonEdges(), 6, 6, 6, 7);
		
		if(drawTop) {
			if(!alphaBlend) {
				p->setPen(color1);
				p->drawLine(r.left()+6, r.top(), r.right()-6, r.top());
				p->setPen(color2);
				p->drawLine(r.left()+6, r.top()+1, r.right()-6, r.top()+1);
			}
			else {
				p->drawTiledPixmap(r.left()+6, r.top(), r.width()-12, 2, *buttonContour->buttonHLines(), 0, 0);
			}
		}
		
		if(drawBottom) {
			if(!alphaBlend) {
				p->setPen(color2);
				p->drawLine(r.left()+6, r.bottom()-2, r.right()-6, r.bottom()-2);
				p->setPen(color4);
				p->drawLine(r.left()+6, r.bottom()-1, r.right()-6, r.bottom()-1);
				p->setPen(color5);
				p->drawLine(r.left()+6, r.bottom(), r.right()-6, r.bottom());
			}
			else {
				p->drawTiledPixmap(r.left()+6, r.bottom()-2, r.width()-12, 3, *buttonContour->buttonHLines(), 0, 4);
			}
		}
		
		if(drawLeft) {
			if(!alphaBlend) {
				p->setPen(color6);
				p->drawLine(r.left(), r.top()+6, r.left(), r.bottom()-7);
				p->setPen(color2);
				p->drawLine(r.left()+1, r.top()+6, r.left()+1, r.bottom()-7);
			}
			else {
				p->drawTiledPixmap(r.left(), r.top()+6, 2, r.height()-13, *buttonContour->buttonVLines(), 0, 0);
			}
		}
		
		if(drawRight) {
			if(!alphaBlend) {
				p->setPen(color2);
				p->drawLine(r.right()-1, r.top()+6, r.right()-1, r.bottom()-7);
				p->setPen(color6);
				p->drawLine(r.right(), r.top()+6, r.right(), r.bottom()-7);
			}
			else {
				p->drawTiledPixmap(r.right()-1, r.top()+6, 2, r.height()-13, *buttonContour->buttonVLines(), 4, 0);
			}
		}
		
		
		
		
	}
	else if(isScrollBarBtn) {
		
		TQColor background;
		TQColor gr1TopColor;
		TQColor gr1BottomColor;
		TQColor gr2TopColor;
		TQColor gr2BottomColor;
		
		
		if(contour != appButtonColor) {
			gr1TopColor = alphaBlendColors(contour, scrollBarSurface.g1Color1, 127);
			gr1BottomColor = alphaBlendColors(contour, scrollBarSurface.g1Color2, 127);
			gr2TopColor = alphaBlendColors(contour, scrollBarSurface.g2Color1, 127);
			gr2BottomColor = alphaBlendColors(contour, scrollBarSurface.g2Color2, 127);
			background = alphaBlendColors(contour, scrollBarSurface.background, 127);
		}
		else {
			gr1TopColor = scrollBarSurface.g1Color1;
			gr1BottomColor = scrollBarSurface.g1Color2;
			gr2TopColor = scrollBarSurface.g2Color1;
			gr2BottomColor = scrollBarSurface.g2Color2;
			background = scrollBarSurface.background;
		}
		
		TQColor btnContour = buttonContour->contourColor(Contour_Default);
		TQColor whiteColor( tqRgba(TQt::white.red(), TQt::white.green(), TQt::white.blue(), 23)); // first white layer
		TQColor blackColor( tqRgba(btnContour.red(), btnContour.green(), btnContour.blue(), 35)); // second contour layer
		
		
		gr1TopColor = blendColors(gr1TopColor, whiteColor);
		gr1TopColor = blendColors(gr1TopColor, blackColor);
		
		gr1BottomColor = blendColors(gr1BottomColor, whiteColor);
		gr1BottomColor = blendColors(gr1BottomColor, blackColor);
		
		gr2TopColor = blendColors(gr2TopColor, whiteColor);
		gr2TopColor = blendColors(gr2TopColor, blackColor);
		
		gr2BottomColor = blendColors(gr2BottomColor, whiteColor);
		gr2BottomColor = blendColors(gr2BottomColor, blackColor);
		
		background = blendColors(background, whiteColor);
		background = blendColors(background, blackColor);
		
		
		
		
		TQRegion clip;
		if(drawTop)
			clip += TQRegion(r.left(), r.top()+1, r.width(), 1);
		if(drawBottom)
			clip += TQRegion(r.left(), r.bottom()-1, r.width(), 1);
		if(drawLeft)
			clip += TQRegion(r.left()+1, r.top(), 1, r.height());
		if(drawRight)
			clip += TQRegion(r.right()-1, r.top(), 1, r.height());
		
		p->setClipRegion(clip);
		
		
		TQRect sr = r;
		int top = sr.y()+sr.height()*scrollBarSurface.g1Top/100;
		int bottom = sr.height()*scrollBarSurface.g1Bottom/100;
		int top2 = sr.y()+sr.height()*scrollBarSurface.g2Top/100;
		int bottom2 = sr.height()*scrollBarSurface.g2Bottom/100-top2;
		int left = sr.x()+sr.width()*scrollBarSurface.g1Top/100;
		int width = sr.width()*scrollBarSurface.g1Bottom/100;
		int left2 = sr.x()+sr.width()*scrollBarSurface.g2Top/100;
		int width2 = sr.width()*scrollBarSurface.g2Bottom/100-left2;
		
		p->fillRect(sr, background);
		switch(scrollBarSurface.numGradients) {
			case 1:
				if(isHorizontal)
					renderGradient(p, TQRect(sr.x(), top, sr.width(), bottom), gr1TopColor, gr1BottomColor, true);
				else
					renderGradient(p, TQRect(left, sr.y(), width, sr.height()), gr1TopColor, gr1BottomColor, false);
				break;
			case 2:
				if(isHorizontal) {
					renderGradient(p, TQRect(r.x(), top, r.width(), bottom), gr1TopColor, gr1BottomColor, true);
					renderGradient(p, TQRect(r.x(), top2, r.width(), bottom2), gr2TopColor, gr2BottomColor, true);
				}
				else {
					renderGradient(p, TQRect(left, sr.y(), width, sr.height()), gr1TopColor,gr1BottomColor, false);
					renderGradient(p, TQRect(left2, sr.y(), width2, sr.height()), gr2TopColor,gr2BottomColor, false);
				}
			default:
				break;
		}
		p->setClipping(false);
		
		
		
		TQColor color1 = alphaBlendColors(buttonContour->contourColor(Contour_Default), backgroundColor, 203); // like btn contour
		TQColor color2 = alphaBlendColors(TQColor(255, 255, 255), color1, 25);
		
		p->setPen(color1);
		if(drawTop) {
			p->drawLine(r.left(), r.top(), r.right(), r.top()); // top
		}
		if(drawBottom) {
			p->drawLine(r.left(), r.bottom(), r.right(), r.bottom()); // bottom
		}
		if(drawLeft) {
			p->drawLine(r.left(), r.top(), r.left(), r.bottom()); // left
		}
		if(drawRight) {
			p->drawLine(r.right(), r.top(), r.right(), r.bottom()); // right
		}
		
		
		color1 = blendColors(color1, whiteColor);
		p->setPen(color2);
		if(roundUpperLeft) {
			renderPixel(p, TQPoint(r.x()+1, r.y()+1), 127, color1, color1, true);
			p->drawPoint(r.x(), r.y());
		}
		if(roundUpperRight) {
			renderPixel(p, TQPoint(r.right()-1, r.top()+1), 127, color1, color1, true);
			p->drawPoint(r.right(), r.y());
			
		}
		if(roundBottomLeft) {
			renderPixel(p, TQPoint(r.x()+1, r.bottom()-1), 127, color1, color1, true);
			p->drawPoint(r.x(), r.bottom());
		}
		if(roundBottomRight) {
			renderPixel(p, TQPoint(r.right()-1, r.bottom()-1), 127, color1, color1, true);
			p->drawPoint(r.right(), r.bottom());
		}
	}
	return;
}


void DominoStyle::renderSurface(TQPainter *p,
								 const TQRect &r,
								 const TQColor &backgroundColor,
								 const TQColor &buttonColor,
								 const TQColor &/*highlightColor*/,
								 const uint flags) const
{
	
	if((r.width() <= 0)||(r.height() <= 0))
		return;
	
	const DSurface* ds = 0;
	const bool isButton = flags&Is_Button;
	const bool isScrollBarBtn = flags&Is_ScrollBarBtn;
	const bool isScrollBarGroove = flags&Is_ScrollBarGroove;
	const bool isCheckItem = flags&Is_CheckItem;
	const bool isHeader = flags&Is_Header;
	const bool isTabTop = flags&Is_TabTop;
	const bool isActiveTabTop = flags&Is_ActiveTabTop;
	const bool isTabBottom = flags&Is_TabBottom;
	const bool isActiveTabBottom = flags&Is_ActiveTabBottom;
	const bool horizontal = flags&Is_Horizontal;
	const bool isDown = flags&Is_Down;
	
	if(isButton)
		ds = &btnSurface;
	else if(isCheckItem)
		ds = &checkItemSurface;
	else if(isScrollBarBtn)
		ds = &scrollBarSurface;
	else if(isScrollBarGroove)
		ds = &scrollBarGrooveSurface;
	else if(isHeader)
		ds = &headerSurface;
	else if(isTabTop)
		ds = &tabTopSurface;
	else if(isActiveTabTop)
		ds = &activeTabTopSurface;
	else if(isTabBottom)
		ds = &tabBottomSurface;
	else if(isActiveTabBottom)
		ds = &activeTabBottomSurface;
	
	
	
	
	
	TQColor g1Color1;
	TQColor g1Color2;
	TQColor g2Color1;
	TQColor g2Color2;
	TQColor background;

	if(buttonColor != tqApp->palette().active().button()) {
		g2Color1 = alphaBlendColors(buttonColor, ds->g2Color1, 127);
		g2Color2 = alphaBlendColors(buttonColor, ds->g2Color2, 127);
		g1Color1 = alphaBlendColors(buttonColor, ds->g1Color1, 127);
		g1Color2 = alphaBlendColors(buttonColor, ds->g1Color2, 127);
		background = alphaBlendColors(buttonColor, ds->background, 127);
	}
	else {
		g1Color1 = ds->g1Color1;
		g1Color2 = ds->g1Color2;
		g2Color1 = ds->g2Color1;
		g2Color2 = ds->g2Color2;
		background = ds->background;
	}
	if(isDown) {
		g1Color1 = darkenColor(g1Color1, 15);
		g1Color2 = darkenColor(g1Color2, 15);
		g2Color1 = darkenColor(g2Color1, 15);
		g2Color2 = darkenColor(g2Color2, 15);
		background = darkenColor(background, 15);
	}

	if(isButton) { // button / toolButton / comboBox / spinWidget / slider / progressBar
		
		if(!flatMode) {
			TQRegion mask(r.x()+2, r.y(), r.width()-4, r.height());
			mask += TQRegion(r.x()+1, r.y()+1, r.width()-2, r.height()-2);
			mask += TQRegion(r.x(), r.y()+2, r.width(), r.height()-4);
			p->setClipRegion(mask, TQPainter::CoordPainter);
		}
		
		
		TQRect re = r;
		if(re.x() < 0 ) {
			re.setWidth(re.width()+TQABS(re.x()));
			re.setX(0);
		}
		else if(re.y() < 0 ) {
			re.setHeight(re.height()+TQABS(re.y()));
			re.setY(0);
		}

		TQPixmap pix(re.width(), re.height());
		pix.fill(background);
		TQPainter painter(&pix);

		int top = re.height()*btnSurface.g1Top/100;
		int bottom = re.height()*btnSurface.g1Bottom/100;
		int top2 = re.height()*btnSurface.g2Top/100;
		int bottom2 = re.height()*btnSurface.g2Bottom/100-top2;
		
		int left = re.width()*btnSurface.g1Top/100;
		int width = re.width()*btnSurface.g1Bottom/100;
		int left2 = re.width()*btnSurface.g2Top/100;
		int width2 = re.width()*btnSurface.g2Bottom/100-left2;
		
		switch (btnSurface.numGradients) {
			case 1:{
				if(horizontal) {
					renderGradient(&painter, TQRect(0, top, re.width(), bottom), g1Color1, g1Color2, true);
				}
				else {
					renderGradient(&painter, TQRect(left, 0, width, re.height()), g1Color1, g1Color2, false);
				}
				break;
			}
			case 2: {
				if(horizontal) {
					renderGradient(&painter, TQRect(0, top, re.width(), bottom), g1Color1, g1Color2, true);
					renderGradient(&painter, TQRect(0, top2, re.width(), bottom2), g2Color1, g2Color2, true);
				}
				else {
					renderGradient(&painter, TQRect(left, 0, width, re.height()), g1Color1, g1Color2, false);
					renderGradient(&painter, TQRect(left2, 0, width2, re.height()), g2Color1, g2Color2, false);
				}
			}
			default: break;
		}
		
		p->drawPixmap(r.x(), r.y(), pix);
		p->setClipping(false);

	}
	else if(isTabTop || isActiveTabTop || isTabBottom || isActiveTabBottom) {
		
		int top = r.y()+r.height()*ds->g1Top/100;
		int bottom = r.height()*ds->g1Bottom/100;
		int top2 = r.y()+r.height()*ds->g2Top/100;
		int bottom2 = r.height()*ds->g2Bottom/100-top2;
		
		p->fillRect(r, background);
		switch (ds->numGradients) {
			case 1:{
				renderGradient(p, TQRect(r.x(), top, r.width(), bottom), g1Color1, g1Color2, true);
				break;
			}
			case 2: {
				renderGradient(p, TQRect(r.x(), top, r.width(), bottom), g1Color1, g1Color2, true);
				renderGradient(p, TQRect(r.x(), top2, r.width(), bottom2), g2Color1, g2Color2, true);
			}
			default: break;
		}
	}
	else if(isScrollBarBtn) {

		int top = r.height()*scrollBarSurface.g1Top/100;
		int bottom = r.height()*scrollBarSurface.g1Bottom/100;
		int top2 = r.height()*scrollBarSurface.g2Top/100;
		int bottom2 = r.height()*scrollBarSurface.g2Bottom/100-top2;
		int left = r.width()*scrollBarSurface.g1Top/100;
		int width = r.width()*scrollBarSurface.g1Bottom/100;
		int left2 = r.width()*scrollBarSurface.g2Top/100;
		int width2 = r.width()*scrollBarSurface.g2Bottom/100-left2;
		
		p->fillRect(r, background);
		switch (scrollBarSurface.numGradients) {
			case 1: {
				if(horizontal) {
					renderGradient(p, TQRect(r.left(), top, r.width(), bottom), g1Color1, g1Color2, true);
				}
				else {
					renderGradient(p, TQRect(left, r.top(), width, r.height()), g1Color1, g1Color2, false);
				}
				break;
			}
			case 2: {
				if(horizontal) {
					renderGradient(p, TQRect(r.left(), top, r.width(), bottom), g1Color1, g1Color2, true);
					renderGradient(p, TQRect(r.left(),  top2, r.width(), bottom2), g2Color1, g2Color2, true);
				}
				else {
					renderGradient(p, TQRect(left, r.top(), width, r.height()), g1Color1, g1Color2, false);
					renderGradient(p, TQRect(left2, r.top(), width2, r.height()), g2Color1, g2Color2, false);
				}
			}
			default:
				break;
		}
		
		
	}
	else if(isScrollBarGroove) {

		int top = r.height()*scrollBarGrooveSurface.g1Top/100;
		int bottom = r.height()*scrollBarGrooveSurface.g1Bottom/100;
		int top2 = r.height()*scrollBarGrooveSurface.g2Top/100;
		int bottom2 = r.height()*scrollBarGrooveSurface.g2Bottom/100-top2;
		int left = r.width()*scrollBarGrooveSurface.g1Top/100;
		int width = r.width()*scrollBarGrooveSurface.g1Bottom/100;
		int left2 = r.width()*scrollBarGrooveSurface.g2Top/100;
		int width2 = r.width()*scrollBarGrooveSurface.g2Bottom/100-left2;
		
		p->fillRect(r, background);
		switch (scrollBarGrooveSurface.numGradients) {
			case 1: {
				if(horizontal) {
					renderGradient(p, TQRect(r.left(), top, r.width(), bottom), g1Color1, g1Color2, true);
				}
				else {
					renderGradient(p, TQRect(left, r.top(), width, r.height()), g1Color1, g1Color2, false);
				}
				break;
			}
			case 2: {
				if(horizontal) {
					renderGradient(p, TQRect(r.left(), top, r.width(), bottom), g1Color1, g1Color2, true);
					renderGradient(p, TQRect(r.left(),  top2, r.width(), bottom2), g2Color1, g2Color2, true);
				}
				else {
					renderGradient(p, TQRect(left, r.top(), width, r.height()), g1Color1, g1Color2, false);
					renderGradient(p, TQRect(left2, r.top(), width2, r.height()), g2Color1, g2Color2, false);
				}
			}
			default:
				break;
		}
		
	}
	else if(isCheckItem) {
		
		TQPixmap pix(r.width(), r.height());
		pix.fill(background);
		TQPainter painter(&pix);

		int top = r.height()*checkItemSurface.g1Top/100;
		int bottom = r.height()*checkItemSurface.g1Bottom/100;
		int top2 = r.height()*checkItemSurface.g2Top/100;
		int bottom2 = r.height()*checkItemSurface.g2Bottom/100-top2;
		
		switch(checkItemSurface.numGradients) {
			case 1:{
				renderGradient(&painter, TQRect(0, top, r.width(), bottom), g1Color1, g1Color2, true);
				break;
			}
			case 2: {
				renderGradient(&painter, TQRect(0, top, r.width(), bottom), g1Color1, g1Color2, true);
				renderGradient(&painter, TQRect(0, top2, r.width(), bottom2), g2Color1, g2Color2, true);
				break;
			}
			default: break;
		}
		painter.end();
		p->drawPixmap(TQRect(r.x(), r.y()+3, r.width(), r.height()-7), pix);
		
	}
	else if(isHeader) {
		TQHeader* hdr = dynamic_cast<TQHeader*>(p->device());
		bool needErasePixmap = false;
		TQRect re = r;
		bool horizontal = false;
		bool drawTop = false;
		
		if(hdr) {
			if(hdr->orientation() == TQt::Horizontal) {
				horizontal = true;
				bool hasErasePixmap = hdr->erasePixmap();
				if(hasErasePixmap && !isDown) {
					hdr->erase(r);
					return;
				}
				else if(!hasErasePixmap && !isDown) {
					needErasePixmap = true;
					re = TQRect(0, 0, 10, r.height());
				}
			}
			else if(hdr->sectionAt(r.top()+hdr->offset()) == 0 && r.y() == 0)
				drawTop = true;
		}
		
		TQPixmap pix(re.width(), re.height());
		pix.fill(background);
		TQPainter painter(&pix);
		
		int top = re.height()*headerSurface.g1Top/100;
		int bottom = re.height()*headerSurface.g1Bottom/100;
		int top2 = re.height()*headerSurface.g2Top/100;
		int bottom2 = re.height()*headerSurface.g2Bottom/100-top2;
		
		switch (headerSurface.numGradients) {
			case 1:{
				renderGradient(&painter, TQRect(0, top, re.width(), bottom), g1Color1, g1Color2, true);
				break;
			}
			case 2: {
				renderGradient(&painter, TQRect(0, top, re.width(), bottom), g1Color1, g1Color2, true);
				renderGradient(&painter, TQRect(0, top2, re.width(), bottom2), g2Color1, g2Color2, true);
				break;
			}
			default: break;
		}
		
		painter.setPen(alphaBlendColors(buttonContour->contourColor(Contour_Default), backgroundColor, 179));
		if(horizontal || drawTop)
			painter.drawLine(0, re.y(), re.width(), re.y());
		painter.drawLine(0, re.height()-1, re.width(), re.height()-1);
		
		if(needErasePixmap) {
			hdr->setUpdatesEnabled(false);
			hdr->setErasePixmap(pix);
			hdr->setUpdatesEnabled(true);
			hdr->erase(r);
		}
		else {
			// same problem as with the scrollbars, if we don't clip, the text above will be randomly erased.
			p->setClipRect(re);
			p->drawPixmap(r.x(), r.y(), pix);
			p->setClipping(false);
		}
	}
}


void DominoStyle::renderPixel(TQPainter *p,
			const TQPoint &pos,
			const int alpha,
			const TQColor &color,
			const TQColor &background,
			bool fullAlphaBlend) const
{	 
	if(fullAlphaBlend)
	// full alpha blend: paint into an image with alpha buffer and convert to a pixmap ...
	{
		TQRgb rgb = color.rgb();
		// generate a quite unique key -- use the unused width field to store the alpha value.
		CacheEntry search(cAlphaDot, alpha, 0, rgb);
		int key = search.key();

		CacheEntry *cacheEntry;
		if( (cacheEntry = pixmapCache->find(key)) ) {
			if( search == *cacheEntry ) { // match! we can draw now...
				if(cacheEntry->pixmap)
					p->drawPixmap(pos, *(cacheEntry->pixmap) );
				return;
			} else { //Remove old entry in case of a conflict!
				pixmapCache->remove( key );
			}
		}


		TQImage aImg(1,1,32); // 1x1
		aImg.setAlphaBuffer(true);
		aImg.setPixel(0,0,tqRgba(tqRed(rgb),tqGreen(rgb),tqBlue(rgb),alpha));
		TQPixmap *result = new TQPixmap(aImg);

		p->drawPixmap(pos, *result);

		// add to the cache...
		CacheEntry *toAdd = new CacheEntry(search);
		toAdd->pixmap = result;
		bool insertOk = pixmapCache->insert( key, toAdd, result->depth()/8);
		if(!insertOk)
			delete result;
	} else
	// don't use an alpha buffer: calculate the resulting color from the alpha value, the fg- and the bg-color.
	{
		TQRgb rgb_a = color.rgb();
		TQRgb rgb_b = background.rgb();
		int a = alpha;
		if(a>255) a = 255;
		if(a<0) a = 0;
		int a_inv = 255 - a;

		TQColor res	= TQColor( tqRgb(tqRed(rgb_b)*a_inv/255 + tqRed(rgb_a)*a/255,
							  tqGreen(rgb_b)*a_inv/255 + tqGreen(rgb_a)*a/255,
							  tqBlue(rgb_b)*a_inv/255 + tqBlue(rgb_a)*a/255) );
		p->setPen(res);
		p->drawPoint(pos);
	} 
}

void DominoStyle::renderButtonShadow(TQPainter *p, const TQRect &r, const uint flags) const {
	
	if((!buttonContour->drawButtonSunkenShadow && buttonContour->defaultType == Contour_Sunken) || (buttonContour->defaultType != Contour_Sunken && !flatMode))
		return;
	
	
	if(flags&Round_UpperLeft) {
		bitBlt(p->device(), r.left(), r.top(), buttonContour->shadowRound(), 0, 0, 5, 5, TQt::CopyROP);
	}
	else if(flags&Rectangular_UpperLeft){
		bitBlt(p->device(), r.left(), r.top(), buttonContour->shadowRectangular(), 0, 0, 5, 5, TQt::CopyROP);
	}
	if(flags&Round_UpperRight) {
		bitBlt(p->device(), r.right()-6, r.top(), buttonContour->shadowRound(), 5, 0, 5, 5, TQt::CopyROP);
	}
	else if(flags&Rectangular_UpperRight){
		bitBlt(p->device(), r.right()-6, r.top(), buttonContour->shadowRectangular(), 5, 0, 5, 5, TQt::CopyROP);
	}
	if(flags&Round_BottomLeft) {
		bitBlt(p->device(), r.left(), r.bottom()-5, buttonContour->shadowRound(), 0, 5, 4, 4, TQt::CopyROP);
	}
	else if(flags&Rectangular_BottomLeft)
		bitBlt(p->device(), r.left(), r.bottom()-5, buttonContour->shadowRectangular(), 0, 5, 4, 4, TQt::CopyROP);
	if(flags&Round_BottomRight) {
		bitBlt(p->device(), r.right()-5, r.bottom()-5, buttonContour->shadowRound(), 4, 5, 4, 4, TQt::CopyROP);
	}
	else if(flags&Rectangular_BottomRight)
		bitBlt(p->device(), r.right()-5, r.bottom()-5, buttonContour->shadowRectangular(), 4, 5, 4, 4, TQt::CopyROP);
	
	if(flags&Draw_Top)
		p->drawTiledPixmap(r.left()+5, r.top(), r.width()-12, 3, *buttonContour->shadowHLines(), 0, 0);
	if(flags&Draw_Left)
		p->drawTiledPixmap(r.left(), r.top()+5, 3, r.height()-11, *buttonContour->shadowVLines(), 0, 0);
	if(flags&Draw_Right)
		p->drawTiledPixmap(r.right()-4, r.top()+5, 3, r.height()-11, *buttonContour->shadowVLines(), 3, 0);
	if(flags&Draw_Bottom)
		p->drawTiledPixmap(r.left()+4, r.bottom()-3, r.width()-10, 2, *buttonContour->shadowHLines(), 0, 3);
	
}

void DominoStyle::renderButton(TQPainter *p,
							   const TQRect &r,
							   const TQColorGroup &g,
							   bool sunken,
							   bool /*mouseOver*/,
							   bool horizontal,
							   bool enabled,
							   bool tdehtmlMode) const
{
	
	uint contourFlags = Draw_Left|Draw_Right|Draw_Top|Draw_Bottom;

	if(!enabled) contourFlags|=Is_Disabled;
	
	if(tdehtmlMode || buttonContour->alphaMode() /* || kickerMode*/) {
		contourFlags|=Draw_AlphaBlend;
	}

	uint surfaceFlags = Is_Button;
	if(horizontal) {
		 surfaceFlags|=Is_Horizontal;
		 contourFlags|=Is_Horizontal;
	}
	if(!enabled)
		surfaceFlags|=Is_Disabled;
	else {
		if(sunken) {
			surfaceFlags|=Is_Down;
			contourFlags|=Is_Down;
		}
	}

// 	TQColor buttonColor = tdehtmlMode ? g.button() : tqApp->palette().active().background();
	
	if (!flatMode) {
		contourFlags |= Round_UpperLeft|Round_UpperRight|Round_BottomLeft|Round_BottomRight|Is_Button;
		renderSurface(p, TQRect(r.x()+2, r.y()+2, r.width()-4, r.height()-5), g.background(), g.button(), g.button(), surfaceFlags);
		renderContour(p, r, g.background(), g.button(), contourFlags);
		if(sunken) {
			renderButtonShadow(p, TQRect(r.x()+2, r.y()+2, r.width()-2, r.height()-3), contourFlags);
		}
	}
	else {
		renderSurface(p, TQRect(r.x()-3, r.y()-1, r.width()+6, r.height()+2), g.background(), g.button(), g.button(), surfaceFlags);

		if(sunken) {
			contourFlags |= Rectangular_UpperLeft|Rectangular_UpperRight|Rectangular_BottomLeft|Rectangular_BottomRight;
			renderButtonShadow(p, TQRect(r.x()-2, r.y()-2, r.width()+4, r.height()+4), contourFlags);
		}
	}
}

void DominoStyle::renderHeader(TQPainter *p,
								const TQRect &r,
								const TQColorGroup &g,
								bool sunken,
								bool /*mouseOver*/,
								bool /*horizontal*/,
								bool /*enabled*/) const
{
	p->save();
	bool drawLeft = true;
	TQHeader* hd = dynamic_cast<TQHeader*>(p->device());
	if(hd && hd->orientation() == TQt::Horizontal)
		drawLeft = r.x() == 0 && hd->sectionAt(r.left()+hd->offset()) == 0;
	
	uint surfaceFlags = Is_Header|Is_Horizontal;
	if(sunken)
		surfaceFlags |= Is_Down;
	renderSurface(p, TQRect(r.left(), r.top(), r.width(), r.height()), g.button(), g.button(), g.button(), surfaceFlags);
	
// 	p->setPen(buttonContour->contourColor(Contour_Default));
	p->setPen(alphaBlendColors(buttonContour->contourColor(Contour_Default), g.background(), 179));
	if(drawLeft)
		p->drawLine(r.left(), r.top(), r.left(), r.bottom());
	if(!hd)
		p->drawLine(r.right(), r.top(), r.left(), r.top());
	p->drawLine(r.right(), r.top(), r.right(), r.bottom());
	p->restore();
}


void DominoStyle::renderGradient(TQPainter *painter,
								  const TQRect &rect,
								  const TQColor &c1,
								  const TQColor &c2,
								  bool horizontal) const
{
	if((rect.width() <= 0)||(rect.height() <= 0))
		return;

	// generate a quite unique key for this surface.
	CacheEntry search(cGradientTile,
					  horizontal ? 0 : rect.width(),
					  horizontal ? rect.height() : 0,
					  c1.rgb(), c2.rgb(), horizontal );
	int key = search.key();

	CacheEntry *cacheEntry;
	if( (cacheEntry = pixmapCache->find(key)) ) {
		if( search == *cacheEntry ) { // match! we can draw now...
			if(cacheEntry->pixmap) {
				painter->drawTiledPixmap(rect, *(cacheEntry->pixmap) );
			}
			return;
		} else {
			// Remove old entry in case of a conflict!
			// This shouldn't happen very often, see comment in CacheEntry.
			pixmapCache->remove(key);
		}
	}

	// there wasn't anything matching in the cache, create the pixmap now...
	TQPixmap *result = new TQPixmap(horizontal ? 10 : rect.width(),
								  horizontal ? rect.height() : 10);
	TQPainter p(result);

	int r_w = result->rect().width();
	int r_h = result->rect().height();
	int r_x, r_y, r_x2, r_y2;
	result->rect().coords(&r_x, &r_y, &r_x2, &r_y2);

	int rDiff, gDiff, bDiff;
	int rc, gc, bc;

	int x, y;

	rDiff = ( c2.red())	  - (rc = c1.red());
	gDiff = ( c2.green()) - (gc = c1.green());
	bDiff = ( c2.blue())  - (bc = c1.blue());

	int rl = rc << 16;
	int gl = gc << 16;
	int bl = bc << 16;

	int rdelta = ((1<<16) / (horizontal ? r_h : r_w)) * rDiff;
	int gdelta = ((1<<16) / (horizontal ? r_h : r_w)) * gDiff;
	int bdelta = ((1<<16) / (horizontal ? r_h : r_w)) * bDiff;

	// these for-loops could be merged, but the if's in the inner loop
	// would make it slow
	if(horizontal) {
		for ( y = 0; y < r_h; y++ ) {
			rl += rdelta;
			gl += gdelta;
			bl += bdelta;

			p.setPen(TQColor(rl>>16, gl>>16, bl>>16));
			p.drawLine(r_x, r_y+y, r_x2, r_y+y);
		}
	} else {
		for( x = 0; x < r_w; x++) {
			rl += rdelta;
			gl += gdelta;
			bl += bdelta;

			p.setPen(TQColor(rl>>16, gl>>16, bl>>16));
			p.drawLine(r_x+x, r_y, r_x+x, r_y2);
		}
	}

	p.end();

	// draw the result...
	painter->drawTiledPixmap(rect, *result);

	// insert into cache using the previously created key.
	CacheEntry *toAdd = new CacheEntry(search);
	toAdd->pixmap = result;
	bool insertOk = pixmapCache->insert( key, toAdd, result->width()*result->height()*result->depth()/8 );

	if(!insertOk)
		delete result;
}

void DominoStyle::renderTab(TQPainter *p,
							const TQRect &r,
							const TQColorGroup &g,
							bool /*mouseOver*/,
							const bool selected,
							const bool bottom,
							const TabPosition pos,
							const bool /*triangular*/,
							const bool /*cornerWidget*/,
							const bool konqTab) const
{
	
	const bool isFirst = (pos == First);
	const bool isLast = (pos == Last);
	const bool isSingle = (pos == Single);
	
	TQPixmap buffer(r.width(), r.height());
	TQPainter painter(&buffer);
	
	TQColor tabContour2 = g.background().dark(150);
	TQPixmap* tabEdges;
	if(!(tabEdges = TQPixmapCache::find(TQString::number(tabContour2.pixel(), 16)+"tabEdges"))) {
		TQImage img1 = tintImage(qembed_findImage("border1"), tabContour2);
		TQImage img2 = qembed_findImage("tabInsideWhite");
		blend(img1, img2, img2);
		tabEdges = new TQPixmap(img2);
		TQPixmapCache::insert(TQString::number(tabContour2.pixel(), 16)+"tabEdges", tabEdges);
	}
	
	TQPixmap* tabHLines;
	if(!(tabHLines = TQPixmapCache::find("tabHLines"))) {
		tabHLines = new TQPixmap(qembed_findImage("tabHLines"));
		TQPixmapCache::insert("tabHLines", tabHLines);
	}
	
	TQPixmap* tabVLines;
	if(!(tabVLines = TQPixmapCache::find("tabVLines"))) {
		tabVLines = new TQPixmap(qembed_findImage("tabVLines"));
		TQPixmapCache::insert("tabVLines", tabVLines);
	}
	
	
	if(konqTab) {
		
		const TQColor background = g.background().dark(konqTabBarContrast);
		
		if (selected) {
			
			///painter.fillRect(0, r.height()-9, r.width(), 9, background); // rect below gradient
			///painter.fillRect(0, 0, r.width(), r.height()-9, g.background()); // rect above gradient
			painter.fillRect(0, 0, r.width(), 2, g.background()); // rect above gradient
			
			painter.translate(0, 2);
			renderSurface(&painter, TQRect(1, 0, r.width()-2, r.height()-3), g.background(), g.button(), g.button(), Is_ActiveTabBottom);
			painter.translate(0, -2);

			
			TQPixmap* tabEdges2;
			TQString position = isFirst ? "first" : isLast ? "last" : isSingle ? "single" : "middle";
			if(!(tabEdges2 = TQPixmapCache::find(position+"tabEdges2-k-sel"+TQString::number(g.background().pixel(), 16)+TQString::number(r.height())))) {
				tabEdges2 = new TQPixmap(16, 8);
				tabEdges2->fill(background);
				TQPainter painter2(tabEdges2);
				
				// parts of the unselected tabs under the rounded edges
				if(!isSingle) {
					if(!isFirst) {
						painter2.translate(0, -r.height()+12);
						renderSurface(&painter2, TQRect(0, 0, 3, r.height()-5-3), g.background(), g.button(), g.button(), Is_TabBottom);
						painter2.resetXForm();
						painter2.drawTiledPixmap(0, 3, 3, 1, *tabHLines, 0, 2); // left
						painter2.setPen(alphaBlendColors(TQColor(0,0,0), background, 79)); // bottomShadow1
						painter2.drawLine(0, 4, 1, 4);
						painter2.setPen(alphaBlendColors(TQColor(0,0,0), background, 30)); // bottomShadow2
						painter2.drawPoint(2,4); // last point from bottomShadow1 a tad lighter (will be overpainted by the circle)
						painter2.drawLine(0, 5, 3, 5);
					}
					if(!isLast) {
						painter2.translate(0, -r.height()+12);
						renderSurface(&painter2, TQRect(13, 0, 3, r.height()-5-3), g.background(), g.button(), g.button(), Is_TabBottom);
						painter2.resetXForm();
						painter2.drawTiledPixmap(13, 3, 3, 1, *tabHLines, 0, 2); // right
						painter2.setPen(alphaBlendColors(TQColor(0,0,0), background, 79)); // bottomShadow1
						painter2.drawLine(14, 4, 15, 4);
						painter2.setPen(alphaBlendColors(TQColor(0,0,0), background, 30)); // bottomShadow2
						painter2.drawPoint(13,4);
						painter2.drawLine(12, 5, 15, 5);
					}
				}
				// fill the rect under the gradients (faster as clipping the gradients)
				painter2.fillRect(TQRect(0, 6, 16, 2), background);
				painter2.end();
				
				TQPixmap tabEdgesMask = qembed_findImage("groupBoxMask"); // this fits because the tab frame is just an inverted groupbox frame, but pssst ;)
				painter2.begin(&tabEdgesMask);
				painter2.translate(0, -r.height()+19);
				renderSurface(&painter2, TQRect(0, 0, 16, r.height()-3), g.background(), g.button(), g.button(), Is_ActiveTabBottom);
				painter2.end();
				bitBlt(tabEdges2, 0, 0, &tabEdgesMask, 0, 8);
				
				TQPixmap circle = qembed_findImage("tabWidget");
				bitBlt(tabEdges2, 0, 0, &circle, 0, 8);
				
				TQPixmapCache::insert(position+"tabEdges2-k-sel"+TQString::number(g.background().pixel(), 16)+TQString::number(r.height()), tabEdges2);
			}
			
			
			
			painter.setPen(alphaBlendColors(TQColor(0,0,0), background, 79)); // bottomShadow1
			painter.drawLine(8, r.height()-3, r.width()-9, r.height()-3);
			painter.setPen(alphaBlendColors(TQColor(0,0,0), background, 30)); // bottomShadow2
			painter.drawLine(8, r.height()-2, r.width()-9, r.height()-2);
			
			painter.setPen(alphaBlendColors(TQColor(0,0,0), background, 35));
			painter.translate(0,3);
			if(isFirst || isSingle)
				painter.drawLine(0, -1, 0, r.height()-13); // left
			else
				renderTabSeparator(&painter, TQRect(0, 0, 1, r.height()-5-3), g.button(), false);
			if(isLast || isSingle)
				painter.drawLine(r.width()-1, -1, r.width()-1, r.height()-13); // right
			else
				renderTabSeparator(&painter, TQRect(r.width()-1, 0, 1, r.height()-5-3), g.button(), false);
			painter.translate(0,-3);
			
			bitBlt(&buffer, 0, r.height()-9, tabEdges2, 0, 0, 8, 8);
			bitBlt(&buffer, r.width()-8, r.height()-9, tabEdges2, 8, 0, 8, 8);
			
			painter.drawTiledPixmap(8, r.height()-4, r.width()-16, 1, *tabHLines, 0, 2);
			painter.drawTiledPixmap(1, 2, 1, r.height()-11, *tabVLines); // left
			painter.drawTiledPixmap(r.width()-2, 2, 1, r.height()-11, *tabVLines); // right
			
			
			
			painter.setPen(alphaBlendColors(TQColor(0,0,0), g.background(), 20));
			painter.drawPoint(0,1);
			painter.drawPoint(r.width()-1,1);
			painter.setPen(alphaBlendColors(TQColor(0,0,0), g.background(), 50));
			painter.drawPoint(0,2);
			painter.drawPoint(r.width()-1,2);
			//TQColor tmp = alphaBlendColors(TQColor(255,255,255), g.background(), 14);
			TQColor tmp = g.background();
			painter.setPen(alphaBlendColors(tmp, activeTabBottomSurface.g1Top == 0 ? activeTabBottomSurface.g1Color1 : activeTabBottomSurface.background, 127));
// 			painter.drawPoint(1,2);
// 			painter.drawPoint(r.width()-2,2);
			painter.drawLine(1,2, r.width()-2, 2);
			
			// under the tab
			painter.setPen(background);
			painter.drawLine(0, r.height()-1, r.width(), r.height()-1);
			
		}
		else { // unselected
			
			painter.setPen(g.background());// 0. tabbarline
			painter.drawLine(0, 0, r.width(), 0);
			painter.setPen(g.background().dark(120));//TQColor(110,110,110) // 1. tabbarline
			painter.drawLine(0, 1, r.width(), 1);
			painter.setPen(g.background().dark(konqTabBarContrast+20)); //TQColor(110,110,110)
			
			
			// topline
// 			painter.setPen(g.background().dark(150-15));
			painter.setPen(g.background().dark(150-15));
			painter.drawLine(0, 2, r.width(), 2);
			
			
			if(isFirst || isLast) {
				
				painter.translate(0, 3);
				renderSurface(&painter, TQRect(1, 0, r.width()-2, r.height()-5-3), g.background(), g.button(), g.button(), Is_TabBottom);
				painter.translate(0, -3);
				
				
				TQPixmap* tabEdges2;
				if(!(tabEdges2 = TQPixmapCache::find("tabEdges2-k"+TQString::number(g.background().pixel(), 16)+TQString::number(r.height())))) {
					tabEdges2 = new TQPixmap(16, 8);
					tabEdges2->fill(background);
				
					TQPixmap tabEdgesMask = qembed_findImage("groupBoxMask");
					TQPainter painter2(&tabEdgesMask);
					painter2.translate(0, -r.height()+19+3);
					renderSurface(&painter2, TQRect(1, 0, 14, r.height()-5-3), g.background(), g.button(), g.button(), Is_TabBottom);
					painter2.end();
					bitBlt(tabEdges2, 0, 0, &tabEdgesMask, 0, 8);
				
					TQPixmap circle = qembed_findImage("tabWidget");
					bitBlt(tabEdges2, 0, 0, &circle, 0, 8);
				
					TQPixmapCache::insert("tabEdges2-k"+TQString::number(g.background().pixel(), 16)+TQString::number(r.height()), tabEdges2);
				}
				
				
				if(isFirst) {
					
					painter.translate(0,3);
					renderTabSeparator(&painter, TQRect(r.width()-1, 0, 1, r.height()-5-3), g.button(), false);// right
					painter.translate(0,-3);
					
					painter.setPen(alphaBlendColors(TQColor(0,0,0), background, 79)); // bottomShadow1
					painter.drawLine(8, r.height()-5, r.width()-1, r.height()-5);
					painter.setPen(alphaBlendColors(TQColor(0,0,0), background, 30)); // bottomShadow2
					painter.drawLine(8, r.height()-4, r.width()-1, r.height()-4);
					
					painter.setPen(alphaBlendColors(TQColor(0,0,0), background, 35));
					painter.drawLine(0, 2, 0, r.height()-11); // left
					
					
					bitBlt(&buffer, 0, r.height()-11, tabEdges2, 0, 0, 8, 8);
					
					painter.drawTiledPixmap(8, r.height()-6, r.width()-8, 1, *tabHLines, 0, 2); // bottom
					painter.drawTiledPixmap(1, 3, 1, r.height()-14, *tabVLines); // left
					
				}
				else {
					
					painter.translate(0,3);
					renderTabSeparator(&painter, TQRect(0, 0, 1, r.height()-5-3), g.button(), false); // left
					painter.translate(0,-3);
					
					painter.setPen(alphaBlendColors(TQColor(0,0,0), background, 79)); // bottomShadow1
					painter.drawLine(0, r.height()-5, r.width()-8, r.height()-5);
					painter.setPen(alphaBlendColors(TQColor(0,0,0), background, 30)); // bottomShadow2
					painter.drawLine(0, r.height()-4, r.width()-8, r.height()-4);
						
					painter.setPen(alphaBlendColors(TQColor(0,0,0), background, 35));
					painter.drawLine(r.width()-1, 2, r.width()-1, r.height()-11); // right
					
					
					bitBlt(&buffer, r.width()-8, r.height()-11, tabEdges2, 8, 0, 8, 8);
					
					painter.drawTiledPixmap(0, r.height()-6, r.width()-8, 1, *tabHLines, 0, 2); // bottom
					painter.drawTiledPixmap(r.width()-2, 3, 1, r.height()-14, *tabVLines); // right
				}
			}
			else { // middle
				
				painter.translate(0,3);
				renderTabSeparator(&painter, TQRect(0, 0, 1, r.height()-5-3), g.button(), false); // left
				renderTabSeparator(&painter, TQRect(r.width()-1, 0, 1, r.height()-5-3), g.button(), false);// right
				painter.translate(0,-3);
				
				painter.translate(0, 3);
				renderSurface(&painter, TQRect(1, 0, r.width()-2, r.height()-5-3), g.background(), g.button(), g.button(), Is_TabBottom);
				painter.translate(0, -3);
				
				painter.setPen(alphaBlendColors(TQColor(0,0,0), background, 79)); // bottomShadow1
				painter.drawLine(0, r.height()-5, r.width()-1, r.height()-5);
				painter.setPen(alphaBlendColors(TQColor(0,0,0), background, 30)); // bottomShadow2
				painter.drawLine(0, r.height()-4, r.width()-1, r.height()-4);
				
				painter.drawTiledPixmap(0, r.height()-6, r.width(), 1, *tabHLines, 0, 2); // bottom
				
			}
			painter.fillRect(TQRect(0, r.height()-3, r.width(), 3), background);
		}
		p->drawPixmap(r.left(), r.top(), buffer);
	}
	else { // standard tabs
		
		if(bottom) {
			if (selected) {
	
				renderSurface(&painter, TQRect(1, 0, r.width()-2, r.height()-2), g.background(), g.button(), g.button(), Is_ActiveTabBottom);
				
				
				TQPixmap* tabEdges2;
				TQString position = isFirst ? "first" : isLast ? "last" : isSingle ? "single" : "middle";
				if(!(tabEdges2 = TQPixmapCache::find(position+"tabEdges2-bottom-sel"+TQString::number(g.background().pixel(), 16)+TQString::number(r.height())))) {
					tabEdges2 = new TQPixmap(16, 8);
					tabEdges2->fill(g.background());
					TQPainter painter2(tabEdges2);
					
					if(!isSingle) {
						if(!isFirst) {
							painter2.translate(0, -r.height()+8);
							renderSurface(&painter2, TQRect(0, 0, 2, r.height()-5), g.background(), g.button(), g.button(), Is_TabBottom);
							painter2.resetXForm();
							painter2.drawTiledPixmap(0, 2, 2, 1, *tabHLines, 0, 2); // left
							painter2.setPen(alphaBlendColors(TQColor(0,0,0), g.background(), 79));
							painter2.drawLine(0, 3, 1,3);
							painter2.setPen(alphaBlendColors(TQColor(0,0,0), g.background(), 30));
							painter2.drawLine(0, 4, 3, 4);
						}
						if(!isLast) {
							
							painter2.translate(0, -r.height()+8);
							renderSurface(&painter2, TQRect(14, 0, 2, r.height()-5), g.background(), g.button(), g.button(), Is_TabBottom);
							painter2.resetXForm();
							painter2.drawTiledPixmap(14, 2, 2, 1, *tabHLines, 0, 2); // right
							painter2.setPen(alphaBlendColors(TQColor(0,0,0), g.background(), 79));
							painter2.drawLine(14, 3, 15, 3);
							painter2.setPen(alphaBlendColors(TQColor(0,0,0), g.background(), 30));
							painter2.drawLine(12, 4, 15, 4);
						}
					}
					painter2.fillRect(TQRect(0, 5, 16, 3), g.background());
					painter2.end();
					
				
					TQPixmap tabEdgesMask = qembed_findImage("groupBoxMask");
					painter2.begin(&tabEdgesMask);
					painter2.translate(0, -r.height()+16);
					renderSurface(&painter2, TQRect(1, 0, 14, r.height()-2), g.background(), g.button(), g.button(), Is_ActiveTabBottom);
					painter2.end();
					bitBlt(tabEdges2, 0, 0, &tabEdgesMask, 0, 8);
				
					TQPixmap circle = qembed_findImage("tabWidget");
					bitBlt(tabEdges2, 0, 0, &circle, 0, 8);
				
					TQPixmapCache::insert(position+"tabEdges2-bottom-sel"+TQString::number(g.background().pixel(), 16)+TQString::number(r.height()), tabEdges2);
				}
				
				
				painter.setPen(alphaBlendColors(TQColor(0,0,0), g.background(), 79)); // bottomShadow1
				painter.drawLine(8, r.height()-2, r.width()-9, r.height()-2);
				painter.setPen(alphaBlendColors(TQColor(0,0,0), g.background(), 30)); // bottomShadow2
				painter.drawLine(8, r.height()-1, r.width()-9, r.height()-1);
				
				painter.setPen(alphaBlendColors(TQColor(0,0,0), g.background(), 35));
				if(isFirst || isSingle)
					painter.drawLine(0, 0, 0, r.height()-8); // left
				else
					renderTabSeparator(&painter, TQRect(0, 0, 1, r.height()-5), g.button(), false);
				if(isLast || isSingle)
					painter.drawLine(r.width()-1, 0, r.width()-1, r.height()-8); // right
				else
					renderTabSeparator(&painter, TQRect(r.width()-1, 0, 1, r.height()-5), g.button(), false);
				
				bitBlt(&buffer, 0, r.bottom()-7, tabEdges2, 0, 0, 8, 8);
				bitBlt(&buffer, r.width()-8, r.bottom()-7, tabEdges2, 8, 0, 8, 8);
				
				
				painter.drawTiledPixmap(8, r.height()-3, r.width()-16, 1, *tabHLines, 0, 2); // bottom
				painter.drawTiledPixmap(1, 0, 1, r.height()-8, *tabVLines); // left
				painter.drawTiledPixmap(r.width()-2, 0, 1, r.height()-8, *tabVLines); // right
				
				painter.setPen(alphaBlendColors(TQColor(0,0,0), g.background(), 35)); // clip the first pixels of the separators
				painter.drawPoint(0, 0);
				painter.drawPoint(r.width()-1, 0);
				
			}
			else { // unselected
				
				renderSurface(&painter, TQRect(1, 0, r.width()-2, r.height()-5), g.background(), g.button(), g.button(), Is_TabBottom);
				
				
				if(isFirst || isLast) {
					
					TQPixmap* tabEdges2;
					if(!(tabEdges2 = TQPixmapCache::find("tabEdges2-bottom"+TQString::number(g.background().pixel(), 16)+TQString::number(r.height())))) {
						tabEdges2 = new TQPixmap(16, 8);
						tabEdges2->fill(g.background());
				
						TQPixmap tabEdgesMask = qembed_findImage("groupBoxMask");
						TQPainter painter2(&tabEdgesMask);
						painter2.translate(0, -r.height()+19);
						renderSurface(&painter2, TQRect(1, 0, 14, r.height()-5), g.background(), g.button(), g.button(), Is_TabBottom);
						painter2.end();
						bitBlt(tabEdges2, 0, 0, &tabEdgesMask, 0, 8);
				
						TQPixmap circle = qembed_findImage("tabWidget");
						bitBlt(tabEdges2, 0, 0, &circle, 0, 8);
				
						TQPixmapCache::insert("tabEdges2-bottom"+TQString::number(g.background().pixel(), 16)+TQString::number(r.height()), tabEdges2);
					}
					
					
					if(isFirst) {
						renderTabSeparator(&painter, TQRect(r.width()-1, 0, 1, r.height()-5), g.button(), false);// right
						
						painter.setPen(alphaBlendColors(TQColor(0,0,0), g.background(), 79)); // bottomShadow1
						painter.drawLine(8, r.height()-5, r.width()-1, r.height()-5);
						painter.setPen(alphaBlendColors(TQColor(0,0,0), g.background(), 30)); // bottomShadow2
						painter.drawLine(8, r.height()-4, r.width()-1, r.height()-4);
						
						painter.setPen(alphaBlendColors(TQColor(0,0,0), g.background(), 35));
						painter.drawLine(0, 1, 0, r.height()-12); // left
						
						bitBlt(&buffer, 0, r.height()-11, tabEdges2, 0, 0, 8, 8);
						
						painter.drawTiledPixmap(1, 1, 1, r.height()-12, *tabVLines); // left
						painter.drawTiledPixmap(8, r.height()-6, r.width()-8, 1, *tabHLines, 0, 2); // bottom
						
						painter.setPen(alphaBlendColors(TQColor(0,0,0), g.background(), 55));
						painter.drawLine(0, 0, r.width()-1, 0); // top
						
					}
					else {
						renderTabSeparator(&painter, TQRect(0, 0, 1, r.height()-5), g.button(), false); // left
						
						painter.setPen(alphaBlendColors(TQColor(0,0,0), g.background(), 79)); // bottomShadow1
						painter.drawLine(0, r.height()-5, r.width()-8, r.height()-5);
						painter.setPen(alphaBlendColors(TQColor(0,0,0), g.background(), 30)); // bottomShadow2
						painter.drawLine(0, r.height()-4, r.width()-8, r.height()-4);
						
						painter.setPen(alphaBlendColors(TQColor(0,0,0), g.background(), 35));
						painter.drawLine(r.width()-1, 1, r.width()-1, r.height()-12); // right
						
						bitBlt(&buffer, r.width()-8, r.height()-11, tabEdges2, 8, 0, 8, 8);
						
						painter.drawTiledPixmap(r.width()-2, 1, 1, r.height()-12, *tabVLines); // right
						painter.drawTiledPixmap(0, r.height()-6, r.width()-8, 1, *tabHLines, 0, 2); // bottom
						
						painter.setPen(alphaBlendColors(TQColor(0,0,0), g.background(), 55));
						painter.drawLine(0, 0, r.width()-1, 0); // top
					}
				}
				else { // middle
					renderTabSeparator(&painter, TQRect(0, 0, 1, r.height()-5), g.button(), false); // left
					renderTabSeparator(&painter, TQRect(r.width()-1, 0, 1, r.height()-5), g.button(), false);// right
					
					painter.setPen(alphaBlendColors(TQColor(0,0,0), g.background(), 79)); // bottomShadow1
					painter.drawLine(0, r.height()-5, r.width()-1, r.height()-5);
					painter.setPen(alphaBlendColors(TQColor(0,0,0), g.background(), 30)); // bottomShadow2
					painter.drawLine(0, r.height()-4, r.width()-1, r.height()-4);
					painter.drawTiledPixmap(0, r.height()-6, r.width(), 1, *tabHLines, 0, 2); // bottom
					
					painter.setPen(alphaBlendColors(TQColor(0,0,0), g.background(), 55));
					painter.drawLine(0, 0, r.width()-1, 0); // top
				}
				
				painter.fillRect(TQRect(0, r.height()-3, r.width(), 3), g.background()); // rect under the tab, clips also the tabSeperator
				
			}
		}
		else { // above
			if (selected) {
				
				renderSurface(&painter, TQRect(1, 1, r.width()-2, r.height()), g.background(), g.button(), g.button(), Is_ActiveTabTop);
				
				TQPixmap* tabEdges2;
				TQString position = isFirst ? "first" : isLast ? "last" : isSingle ? "single" : "middle";
				if(!(tabEdges2 = TQPixmapCache::find(position+"tabEdges2-top-sel"+TQString::number(g.background().pixel(), 16)+TQString::number(r.height())))) {
					tabEdges2 = new TQPixmap(16,8);
					tabEdges2->fill(g.background());
					TQPainter painter2(tabEdges2);
					
					if(!isSingle) {
						painter2.setPen(alphaBlendColors(TQColor(0,0,0), g.background(), 25));
						if(!isFirst) {
							renderSurface(&painter2, TQRect(0, 4, 2, r.height()), g.background(), g.button(), g.button(), Is_TabTop);
							painter2.drawLine(0, 3, 1, 3); // topLine
							painter2.drawTiledPixmap(0, 4, 2, 2, *tabHLines);
						}
						if(!isLast) {
							renderSurface(&painter2, TQRect(14, 4, 2, r.height()), g.background(), g.button(), g.button(), Is_TabTop);
							painter2.drawLine(14, 3, 15, 3); // topLine
							painter2.drawTiledPixmap(14, 4, 2, 2, *tabHLines);
						}
					}
					painter2.end();
					
					TQPixmap tabEdgesMask = qembed_findImage("groupBoxMask");
					painter2.begin(&tabEdgesMask);
					renderSurface(&painter2, TQRect(1, 1, 14, r.height()), g.background(), g.button(), g.button(), Is_ActiveTabTop);
					painter2.end();
					bitBlt(tabEdges2, 0, 0, &tabEdgesMask);
				
					TQPixmap circle = qembed_findImage("tabWidget");
					bitBlt(tabEdges2, 0, 0, &circle);
				
					TQPixmapCache::insert(position+"tabEdges2-top-sel"+TQString::number(g.background().pixel(), 16)+TQString::number(r.height()), tabEdges2);
				}
				
				///////////////////////////////////////////////
				painter.setPen(alphaBlendColors(TQColor(0,0,0), g.background(), 35));
				///painter.setPen(alphaBlendColors(TQColor(0,0,0), g.background(), 40));
				if(isFirst || isSingle)
					painter.drawLine(0, 8, 0, r.height()-1); // left
				else
					renderTabSeparator(&painter, TQRect(0, 4, 1, r.height()), g.button(), true);
				if(isLast || isSingle)
					painter.drawLine(r.width()-1, 8, r.width()-1, r.height()-1); // right
				else
					renderTabSeparator(&painter, TQRect(r.width()-1, 4, 1, r.height()), g.button(), true);
				
				painter.setPen(alphaBlendColors(TQColor(0,0,0), g.background(), 25));
				painter.drawLine(8, 0, r.width()-9, 0); // top
				
				
				bitBlt(&buffer, 0, 0, tabEdges2, 0, 0, 8, 8, TQt::CopyROP);
				bitBlt(&buffer, r.width()-8, 0, tabEdges2, 8, 0, 8, 8, TQt::CopyROP);
				
				painter.drawTiledPixmap(8, 1, r.width()-16, 2, *tabHLines); // top
				painter.drawTiledPixmap(1, 8, 1, r.height()-1, *tabVLines); // left
				painter.drawTiledPixmap(r.width()-2, 8, 1, r.height()-1, *tabVLines); // right
				
				painter.setPen(alphaBlendColors(TQColor(0,0,0), g.background(), 35)); // clip the last pixels of the separators
				painter.drawPoint(0, r.height()-1);
				painter.drawPoint(r.width()-1, r.height()-1);
				
				
			}
			else { // unselected
				
				painter.fillRect(0, 0, r.width(), 10, g.background());
				painter.setPen(g.background().dark(150));
				
				renderSurface(&painter, TQRect(1, 4, r.width()-2, r.height()), g.background(), g.button(), g.button(), Is_TabTop);
				
				if(isFirst || isLast) {
					
					TQPixmap* tabEdges2;
					if(!(tabEdges2 = TQPixmapCache::find("tabEdges2-top"+TQString::number(g.background().pixel(), 16)+TQString::number(r.height())))) {
						tabEdges2 = new TQPixmap(16, 8);
						tabEdges2->fill(g.background());
				
						TQPixmap tabEdgesMask = qembed_findImage("groupBoxMask");
						TQPainter painter2(&tabEdgesMask);
						renderSurface(&painter2, TQRect(1, 1, r.width()-2, r.height()), g.background(), g.button(), g.button(), Is_TabTop);
						painter2.end();
						bitBlt(tabEdges2, 0, 0, &tabEdgesMask);
				
						TQPixmap circle = qembed_findImage("tabWidget");
						bitBlt(tabEdges2, 0, 0, &circle);
				
						TQPixmapCache::insert("tabEdges2-top"+TQString::number(g.background().pixel(), 16)+TQString::number(r.height()), tabEdges2);
					}
					
					
					
					if(isFirst) {
						// darker separator
						renderTabSeparator(&painter, TQRect(r.width()-1, 4, 1, r.height()), g.button(), true); // left
						
						painter.setPen(alphaBlendColors(TQColor(0,0,0), g.background(), 25));
						painter.drawLine(8, 3, r.width()-1, 3); // topLine
						
						painter.setPen(alphaBlendColors(TQColor(0,0,0), g.background(), 35));
						painter.drawLine(0, 10, 0, r.height()-1); // left
						painter.drawLine(1, r.height()-1, r.width()-1, r.height()-1); // bottom
						
						painter.drawTiledPixmap(8, 4, r.width()-1, 2, *tabHLines); // top
						painter.drawTiledPixmap(1, 11, 1, r.height()-12, *tabVLines); // left
						
						bitBlt(&buffer, 0, 3, tabEdges2, 0, 0, 8, 8);

					}
					else {
						// darker separator
						renderTabSeparator(&painter, TQRect(0, 4, 1, r.height()), g.button(), true); // right
						
						painter.setPen(alphaBlendColors(TQColor(0,0,0), g.background(), 25));
						painter.drawLine(0, 3, r.width()-9, 3); // topLine
						
						painter.setPen(alphaBlendColors(TQColor(0,0,0), g.background(), 35));
						painter.drawLine(r.width()-1, 10, r.width()-1, r.height()-1); // right
						painter.drawLine(0, r.height()-1, r.width()-2, r.height()-1); // bottom
						
						painter.drawTiledPixmap(0, 4, r.width()-8, 2, *tabHLines); // top
						painter.drawTiledPixmap(r.width()-2, 11, 1, r.height()-12, *tabVLines); // right
						
						bitBlt(&buffer, r.width()-8, 3, tabEdges2, 8, 0, 8, 8);
					}
					
				}
				else {  // middle
					
					renderTabSeparator(&painter, TQRect(r.width()-1, 4, 1, r.height()), g.button(), true); // left
					renderTabSeparator(&painter, TQRect(0, 4, 1, r.height()), g.button(), true); // right
					
					painter.setPen(alphaBlendColors(TQColor(0,0,0), g.background(), 25));
					painter.drawLine(0, 3, r.width()-1, 3); // top
					painter.drawTiledPixmap(0, 4, r.width(), 2, *tabHLines);
					
					painter.setPen(alphaBlendColors(TQColor(0,0,0), g.background(), 35));
					painter.drawLine(0, r.height()-1, r.width()-1, r.height()-1); // bottom
						
				}
			}
		}
		p->drawPixmap(r.left(), r.top(), buffer);
	}
}

void DominoStyle::drawTDEStylePrimitive(TDEStylePrimitive kpe,
									  TQPainter *p,
									  const TQStyleControlElementData &ceData,
									  ControlElementFlags elementFlags,
									  const TQRect &r,
									  const TQColorGroup &cg,
									  SFlags flags,
									  const TQStyleOption& opt,
									  const TQWidget* widget) const
{
	//return TDEStyle::drawTDEStylePrimitive(kpe, p, ceData, elementFlags, r, cg, flags, opt, widget);

//	SLIDER
//	------
	switch( kpe ) {
		case KPE_SliderGroove: {
			
			bool horizontal = ((const TQSlider*)widget)->orientation() == Horizontal;
			
			TQRect re;
			if(horizontal)
				re.setRect(r.left(), r.y()+r.height()/2-3, r.width(), 4);
			else
				re.setRect(r.x()+r.width()/2-3, r.top(), 4, r.height());
			
			bool parentBgPix = widget->parentWidget() ? widget->parentWidget()->paletteBackgroundPixmap() : 0;
			TQString hori = horizontal ? "1" : "0";
			TQString trans = parentBgPix ? "1" : "0";
			TQPixmap* sliderGroove;
			if(!(sliderGroove = TQPixmapCache::find(TQString::number(cg.background().pixel(), 16)+"sliderGroove"+hori+trans))) {

				if(parentBgPix) { // ### the pix are transparent!
					if(!horizontal) {
						TQWMatrix m;
						m.rotate(-90);
						sliderGroove = new TQPixmap(qembed_findImage("slGHBody").xForm(m));
					}
					else
						sliderGroove = new TQPixmap(qembed_findImage("slGHBody"));
				}
				else {
					const TQColor c1 = alphaBlendColors(TQColor(0,0,0), cg.background(), 11);
					const TQColor c2 = alphaBlendColors(TQColor(53,53,53), cg.background(), 155);
					const TQColor c3 = alphaBlendColors(TQColor(67,67,67), cg.background(), 146);
					const TQColor c4 = alphaBlendColors(TQColor(83,83,83), cg.background(), 140);
					const TQColor c5 = alphaBlendColors(TQColor(101,101,101), cg.background(), 134);
					const TQColor c6 = alphaBlendColors(TQColor(254,254,254), cg.background(), 43);
					const TQColor c7 = alphaBlendColors(TQColor(255,255,255), cg.background(), 9);
					
					sliderGroove = new TQPixmap(7, 7);
					TQPainter painter(sliderGroove);
					TQRect rr = sliderGroove->rect();
					
					if (horizontal) {
						painter.setPen(c1);
						painter.drawLine(0, 0, 7, 0);
						painter.setPen(c2);
						painter.drawLine(0, 1, 7, 1);
						painter.setPen(c3);
						painter.drawLine(0, 2, 7, 2);
						painter.setPen(c4);
						painter.drawLine(0, 3, 7, 3);
						painter.setPen(c5);
						painter.drawLine(0, 4, 7, 4);
						painter.setPen(c6);
						painter.drawLine(0, 5, 7, 5);
						painter.setPen(c7);
						painter.drawLine(0, 6, 7, 6);
					}
					else {
						painter.setPen(c1);
						painter.drawLine(0, 0, 0, 7);
						painter.setPen(c2);
						painter.drawLine(1, 0, 1 , 7);
						painter.setPen(c3);
						painter.drawLine(2, 0, 2 , 7);
						painter.setPen(c4);
						painter.drawLine(3, 0, 3, 7);
						painter.setPen(c5);
						painter.drawLine(4, 0, 4, 7);
						painter.setPen(c6);
						painter.drawLine(5, 0, 5, 7);
						painter.setPen(c7);
						painter.drawLine(6, 0, 6, 7);
					}
				}
				TQPixmapCache::insert(TQString::number(cg.background().pixel(), 16)+"sliderGroove"+hori+trans, sliderGroove);
			}
			
			if (horizontal) {
				TQPixmap* slGh;
				if(parentBgPix || !(slGh = TQPixmapCache::find(TQString::number(cg.background().pixel(), 16)+"slGh"))) { // rounded edges
					
					if(parentBgPix)
						slGh = new TQPixmap(qembed_findImage("slGh"));
					else {
						slGh = new TQPixmap(6, 7);
						slGh->fill(cg.background());
						TQPixmap pix = qembed_findImage("slGh");
						bitBlt(slGh, 0, 0, &pix, 0, 0, -1, -1, TQt::CopyROP);
					}
					TQPixmapCache::insert(TQString::number(cg.background().pixel(), 16)+"slGh",slGh );
				}
				
				bitBlt(p->device(), re.x(), re.y(), slGh, 0, 0, 3, 7, TQt::CopyROP);
				bitBlt(p->device(), r.width()-3, re.y(), slGh, 3, 0, 3, 7, TQt::CopyROP);
				p->drawTiledPixmap(re.x()+3, re.y(), r.width()-6, 7, *sliderGroove);
			}
			else {
				TQPixmap* slGv;
				if(parentBgPix || !(slGv = TQPixmapCache::find(TQString::number(cg.background().pixel(), 16)+"slGv"))) {
					if(parentBgPix)
						slGv = new TQPixmap(qembed_findImage("slGv"));
					else {
						slGv = new TQPixmap(7, 6);
						slGv->fill(cg.background());
						TQPixmap pix = qembed_findImage("slGv");
						bitBlt(slGv, 0, 0, &pix, 0, 0, -1, -1, TQt::CopyROP);
					}
					TQPixmapCache::insert(TQString::number(cg.background().pixel(), 16)+"slGv",slGv );
				}
				bitBlt(p->device(), re.x(), re.y(), slGv, 0, 0, 7, 3, TQt::CopyROP);
				bitBlt(p->device(), re.x(), re.height()-3, slGv, 0, 3, 7, 3, TQt::CopyROP);
				p->drawTiledPixmap(re.x(), re.y()+3, 7, r.height()-6, *sliderGroove);
			}
			
			break;
		}

		case KPE_SliderHandle: {
			const TQSlider* slider = (const TQSlider*)widget;
			
			int y, x;
			if(slider->orientation() == Horizontal) {
				x = r.x();
				y =r.y()+r.height()/2-8+1;
			}
			else {
				y = r.y()+1;
				x = r.x()+r.width()/2-8;
			}
			
			TQPixmap* handle;
			if(!(handle = TQPixmapCache::find("sliderHandle"+TQString::number(cg.button().pixel(), 16)))) {
				TQPixmap insidePix =  qembed_findImage("sliderHandle2inside"); // a filled antialiased circle to draw the gradients on
				TQPainter painter(&insidePix);
				flatMode=true;
				renderSurface(&painter, TQRect(1, 0, 13, 15), cg.background(), cg.button(), cg.button(), Is_Button|Is_Horizontal);
				flatMode=false;
				TQImage inside = insidePix.convertToImage();
				
				TQImage circle = tintImage(qembed_findImage("sliderHandle2circle"),
						_customSliderHandleContourColor ? buttonContour->contourColor(Contour_Default) : alphaBlendColors(black, cg.button(), 110));
				
				TQImage shadow =  qembed_findImage("sliderHandle2shadow");
				blend(shadow, inside, inside);
				blend(circle, inside, inside);
				handle = new TQPixmap(inside);
				TQPixmapCache::insert("sliderHandle"+TQString::number(cg.button().pixel(), 16), handle );
			}
			bitBlt(p->device(), x, y, handle, 0, 0, -1, -1, TQt::CopyROP);
			
			break;
		}

		case KPE_ListViewExpander: {
			
			TQWidget* w = dynamic_cast<TQWidget*>(p->device());
			p->setPen( cg.text() );
			TQColor bg = w ? w->paletteBackgroundColor() : cg.background();
			TQString hasBgPix = w && w->paletteBackgroundPixmap() ? "1" : "0";
			TQString expanded = flags & Style_Off ? "1" : "0";
			TQPixmap* lve;
			
			if(_drawTriangularExpander) {
				
				if(!(lve = TQPixmapCache::find(TQString::number(bg.pixel(), 16)+TQString::number(cg.text().pixel(), 16)+"lveT"+hasBgPix+expanded))) {
					TQWMatrix m;
					m.rotate(90);
					if(w && !w->paletteBackgroundPixmap()) {
						TQImage img = tintImage(qembed_findImage("lveTriangular"), cg.text());
						int w=7, h=9;
						if(flags & Style_Off) {
							w=9, h=7;
							img = img.xForm(m);
						}
						TQImage imgBG(w,h,32);
						imgBG.fill(bg.rgb());
						bitBlt(&imgBG, 0, 0, &img);
						lve = new TQPixmap(imgBG);
					}
					else {
						if(flags & Style_Off)
							lve = new TQPixmap(tintImage(qembed_findImage("lveTriangular").xForm(m), cg.text()));
						else
							lve = new TQPixmap(tintImage(qembed_findImage("lveTriangular"), cg.text()));
					}
					TQPixmapCache::insert(TQString::number(bg.pixel(), 16)+TQString::number(cg.text().pixel(), 16)+"lveT"+hasBgPix+expanded, lve);
				}
				
				p->drawPixmap(r.x(), r.y(), *lve);

			}
			else {
				
				if(!(lve = TQPixmapCache::find(TQString::number(bg.pixel(), 16)+TQString::number(cg.text().pixel(), 16)+"lveC"+hasBgPix+expanded))) {
					if(w && !w->paletteBackgroundPixmap()) {
						lve = new TQPixmap(11,11);
						lve->fill(bg);
						TQPainter painter(lve);
						painter.drawPixmap(0, 0, tintImage(qembed_findImage("lve"), cg.text()));
						
						// plus or minus
						painter.drawLine( 3, 5, 7, 5 );
						if ( flags & Style_On ) // Collapsed = On
							painter.drawLine( 5, 3, 5, 7 );
						
						TQPixmapCache::insert(TQString::number(bg.pixel(), 16)+TQString::number(cg.text().pixel(), 16)+"lveC"+hasBgPix+expanded, lve);
					}
					else {
						TQImage img = TQImage(11, 11, 32);
						img.setAlphaBuffer(true);
						for(int x=0; x < img.width(); ++x) {
							for(int y=0; y < img.height(); ++y) {
								img.setPixel(x, y, tqRgba(0, 0, 0, 0));
							}
						}
						
						
						TQImage img2 = tintImage(qembed_findImage("lve"), cg.text());
						bitBlt(&img, 0, 0, &img2);
						
						int r, b, g;
						int a = 255;
						cg.text().getRgb(&r, &g, &b);
						
						// minus
						img.setPixel(3, 5, tqRgba(r, b, g, a));
						img.setPixel(4, 5, tqRgba(r, b, g, a));
						img.setPixel(5, 5, tqRgba(r, b, g, a));
						img.setPixel(6, 5, tqRgba(r, b, g, a));
						img.setPixel(7, 5, tqRgba(r, b, g, a));
						
						
						if ( flags & Style_Off )
							lve = new TQPixmap(img);
						TQPixmapCache::insert(TQString::number(bg.pixel(), 16)+TQString::number(cg.text().pixel(), 16)+"lveC"+hasBgPix+"1", new TQPixmap(img));
						
						// plus
						img.setPixel(5, 3, tqRgba(r, b, g, a));
						img.setPixel(5, 4, tqRgba(r, b, g, a));
						img.setPixel(5, 6, tqRgba(r, b, g, a));
						img.setPixel(5, 7, tqRgba(r, b, g, a));
						
						if ( flags & Style_On )
							lve = new TQPixmap(img);
						
						TQPixmapCache::insert(TQString::number(bg.pixel(), 16)+TQString::number(cg.text().pixel(), 16)+"lveC"+hasBgPix+"0", new TQPixmap(img));
					}
				}
				p->drawPixmap(r.x()-1,r.y()-1, *lve);
			}
			break;
		}

		// copied and slightly modified from TDEStyle.
		case KPE_ListViewBranch: {
			if(_drawTriangularExpander) break;
			// Typical Windows style listview branch element (dotted line).
			
			// Create the dotline pixmaps if not already created
			if ( !verticalLine )
			{
				// make 128*1 and 1*128 bitmaps that can be used for
				// drawing the right sort of lines.
				verticalLine   = new TQBitmap( 1, 129, true );
				horizontalLine = new TQBitmap( 128, 1, true );
				TQPointArray a( 64 );
				TQPainter p2;
				p2.begin( verticalLine );
	
				int i;
				for( i=0; i < 64; i++ )
					a.setPoint( i, 0, i*2+1 );
				p2.setPen( color1 );
				p2.drawPoints( a );
				p2.end();
				TQApplication::flushX();
				verticalLine->setMask( *verticalLine );
	
				p2.begin( horizontalLine );
				for( i=0; i < 64; i++ )
					a.setPoint( i, i*2+1, 0 );
				p2.setPen( color1 );
				p2.drawPoints( a );
				p2.end();
				TQApplication::flushX();
				horizontalLine->setMask( *horizontalLine );
			}
	
			p->setPen( cg.mid() );
	
			if (flags & Style_Horizontal)
			{
				int point = r.x();
				int other = r.y();
				int end = r.x()+r.width();
				int thickness = r.height();
	
				while( point < end )
				{
					int i = 128;
					if ( i+point > end )
						i = end-point;
					p->drawPixmap( point, other, *horizontalLine, 0, 0, i, thickness );
					point += i;
				}
	
			} else {
				int point = r.y();
				int other = r.x();
				int end = r.y()+r.height();
				int thickness = r.width();
				int pixmapoffset = (flags & Style_NoChange) ? 0 : 1;	// ### Hackish
	
				while( point < end )
				{
					int i = 128;
					if ( i+point > end )
						i = end-point;
					p->drawPixmap( other, point, *verticalLine, 0, pixmapoffset, thickness, i );
					point += i;
				}
			}
			break;
		}
		
		default:
			TDEStyle::drawTDEStylePrimitive( kpe, p, ceData, elementFlags, r, cg, flags, opt, widget );
	}
}


void DominoStyle::drawPrimitive(PrimitiveElement pe,
								TQPainter *p,
								const TQStyleControlElementData &ceData,
								ControlElementFlags elementFlags,
								const TQRect &r,
								const TQColorGroup &cg,
								SFlags flags,
								const TQStyleOption &opt ) const
{
	bool down	= flags & Style_Down;
	bool on		= flags & Style_On;
	bool sunken = flags & Style_Sunken;
	bool horiz	= flags & Style_Horizontal;
	const bool enabled = flags & Style_Enabled;
	const bool mouseOver = flags & Style_MouseOver;

//	bool hasFocus = flags & Style_HasFocus;

	int x = r.x();
	int y = r.y();
	int w = r.width();
	int h = r.height();


	
	//return TDEStyle::drawPrimitive(pe, p, ceData, elementFlags, r, cg, flags, opt);
	
	switch(pe) {

		case PE_FocusRect: {
			
			if(rubberBandType == DistRubber || (rubberBandType == ArgbRubber && !compositeManagerRunning)) {
				p->drawWinFocusRect( r );
				break;
			}
			
			TQWidget* w =  dynamic_cast<TQWidget*>(p->device());
			if(rubberBandType == ArgbRubber && compositeManagerRunning && viewPortPressed && dynamic_cast<TQListView*>(w->parentWidget())) {
				TQListView* lv = dynamic_cast<TQListView*>(w->parentWidget());
				if(!lv->currentItem())
					break;
				TQRect sr = lv->itemRect(lv->currentItem());
				TQRect rr = r.normalize();
				int step = lv->rootIsDecorated() ? (lv->currentItem()->depth()+1)*lv->treeStepSize() : lv->currentItem()->depth()*lv->treeStepSize();
				if(dynamic_cast<TQCheckListItem*>(lv->currentItem()))
					step += 16+lv->itemMargin()+4;
				
				// why is the focusrect misused as a rubberband!?
				if((lv->selectionMode() == TQListView::Multi || lv->selectionMode() == TQListView::Extended) && 
								!((sr.y() == rr.y()) && (sr.height() == rr.height()) && (sr.x()+step == rr.x()))) {
					
					TQScrollView* sv = static_cast<TQScrollView*>(w);
					
					TQPoint po = w->mapFrom(sv, r.topLeft());
					TQRect re = TQRect(po.x(), po.y(), r.width(), r.height());
					
					drawPrimitive(PE_RubberBand, p, ceData, elementFlags, r, cg, flags, opt);
					break;
				}
			}
			if(ignoreNextFocusRect) {
				ignoreNextFocusRect= false;
				break;
			}
			
			TQColor color = alphaBlendColors(cg.highlight(), cg.foreground(), 160);
			
			if(w && (w->isA("TQViewportWidget") || dynamic_cast<TQWidget*>(p->device())->isA("RegionGrabber"))) { // TQListView, TQListBox, KSnapshot...
				// we can't be sure if the pixamp edges will be erased, so only a simple rect.
				p->setPen(TQPen(color, 1, TQt::SolidLine));
				p->drawRect(r);
				break;
			}
			
			TQPixmap* edges;
			if(!(edges = TQPixmapCache::find("fre"+TQString::number(color.pixel(), 16)))) {
				edges = new TQPixmap(tintImage(qembed_findImage("focusRectEdges"), color));
				TQPixmapCache::insert("fre"+TQString::number(color.pixel(), 16), edges);
			}
			
			p->drawPixmap(r.left(), r.top(), *edges, 0, 0, 3, 3);
			p->drawPixmap(r.left(), r.bottom()-2, *edges, 0, 3, 3, 3);
			p->drawPixmap(r.right()-2, r.top(), *edges, 3, 0, 3, 3);
			p->drawPixmap(r.right()-2, r.bottom()-2, *edges, 3, 3, 3, 3);
			
			p->setPen(color);
			p->drawLine(r.left()+3, r.top(), r.right()-2, r.y());
			p->drawLine(r.left()+3, r.bottom(), r.right()-2, r.bottom());
			p->drawLine(r.left(), r.top()+3, r.left(), r.bottom()-2);
			p->drawLine(r.right(), r.top()+3, r.right(), r.bottom()-2);
			
			break;
		}
		
		case PE_HeaderSection: { // also taskbar buttons
			if(dynamic_cast<TQWidget*>(p->device()) && dynamic_cast<TQWidget*>(p->device())->isA("PanelKMenu")) {
				TQWidget* w = dynamic_cast<TQWidget*>(p->device());
				
				if(w->parentWidget() && w->parentWidget()->paletteBackgroundPixmap()) {
					
					TQPixmap pix(w->width(), w->height());
					TQPainter painter(&pix);
					TQPoint point = TQPoint(w->geometry().x(), w->geometry().y());
					painter.drawTiledPixmap( 0, 0, w->width(), w->height(),
							*w->parentWidget()->backgroundPixmap(),
							point.x(), point.y() );
					// if the PopupTitle is hovered by the mouse, we don't have access to the parent background pixmap,
					// so it must have have its own one.
					w->setUpdatesEnabled(false);
					w->setErasePixmap(pix);
					w->setUpdatesEnabled(true);
					w->erase();
				}
				else
					w->erase(r);
				break;
			}
			
			renderHeader(p, r, cg, (on||down||sunken), mouseOver, true, enabled );
			break;
		}
		
		
	// BUTTONS
	// -------
		
		case PE_ButtonTool:
		case PE_ButtonDropDown:
		case PE_ButtonBevel:
		case PE_ButtonCommand: {
			
			// the above promitives are not called from within the style
			if(dynamic_cast<TQPixmap*>(p->device())) // more likely a backgroundPixmap than a doublebuffer
				buttonContour->setAlphaMode();
			
			renderButton(p, r, cg, (on||down), mouseOver, true, enabled, tdehtmlWidgets.contains(opt.widget()) );
			buttonContour->reset();
			break;
		}
		
		case PE_ButtonDefault: {
			break;
		}

		case PE_SpinWidgetPlus:
		case PE_SpinWidgetMinus: {
			p->setPen( cg.buttonText() );

			int l = TQMIN( w-2, h-2 );
			// make the length even so that we get a nice symmetric plus...
			if(l%2 != 0)
				--l;
			TQPoint c = r.center();

			p->drawLine( c.x()-l/2, c.y(), c.x()+l/2, c.y() );
			if ( pe == PE_SpinWidgetPlus ) {
				p->drawLine( c.x(), c.y()-l/2, c.x(), c.y()+l/2 );
			}
			break;
		}

		case PE_ScrollBarSlider: {
			
			TQColor buttonColor = cg.button();
			
			TQPixmap buffer;
			if(horiz)
				buffer.resize(r.width()-14, r.height());
			else
				buffer.resize(r.width(), r.height()-14);
			if(buffer.isNull()) break;
			
			TQRect br = buffer.rect();
			TQPainter painter(&buffer);

			if(horiz) {
				uint surfaceFlags = Is_ScrollBarBtn|Is_Horizontal;
				renderSurface(&painter, br, cg.button(), cg.button(), buttonColor, surfaceFlags);

				uint contourFlags = Is_ScrollBarBtn|Is_Horizontal|Draw_Top|Draw_Bottom;
				renderContour(&painter, TQRect(-2, 0, br.width()+4, br.height()), cg.button(), buttonColor, contourFlags);

				p->drawPixmap(r.left()+7, r.y(), buffer);
			}
			else {
				uint surfaceFlags = Is_ScrollBarBtn;
				renderSurface(&painter, br, cg.button(), cg.button(), buttonColor, surfaceFlags);
				
				uint contourFlags = Is_ScrollBarBtn|Draw_Left|Draw_Right;
				renderContour(&painter, TQRect(0, -2, br.width(), br.height()+4), cg.button(), buttonColor, contourFlags);

				bitBlt(p->device(), r.x(), r.y()+7, &buffer, 0, 0, -1, -1, TQt::CopyROP);
			}
			break;
		}

		case PE_ScrollBarAddPage: { // bottom / right
			
			TQColor buttonColor = cg.button();
			TQColor contourColor = alphaBlendColors(buttonContour->contourColor(Contour_Default), buttonColor, 203);
			TQPixmap* addPageBtn;
			TQPixmap buffer;
			
			uint surfaceFlags = Is_ScrollBarBtn;
			if(horiz)
				surfaceFlags |= Is_Horizontal;
			
			int sl = 6;
			if(sliderlen < 14)
				sl = sliderlen/2-1;
			
			//// button part
			if(horiz) {
				buffer.resize(r.width()+sl, r.height());
				if(buffer.isNull()) break;
				
				if(!(addPageBtn = TQPixmapCache::find(TQString::number(buttonColor.pixel(), 16)+"ah"+configMode ))) {

					TQPixmap gradientPix = qembed_findImage("scrollBtnHMask");
					TQPainter painter(&gradientPix);
					renderSurface(&painter, TQRect(0, 0, gradientPix.width(), gradientPix.height()), buttonColor, buttonColor, buttonColor, surfaceFlags);
					TQImage img1 = gradientPix.convertToImage();
					TQImage img2 = qembed_findImage("scrollBtnHShadow");
					TQImage img3 = tintImage(qembed_findImage("scrollBtnHContour"), contourColor);
					
					blend(img2, img1, img1);
					blend(img3, img1, img1);
					
					addPageBtn = new TQPixmap(img1);
					
					TQPixmapCache::insert(TQString::number(buttonColor.pixel(), 16)+"ah"+configMode, addPageBtn);
				}
			}
			else {
				buffer.resize(r.width(), r.height()+sl);
				if(buffer.isNull()) break;
				if(!(addPageBtn = TQPixmapCache::find(TQString::number(buttonColor.pixel(), 16)+"av"+configMode ))) {

					TQPixmap gradientPix = qembed_findImage("scrollBtnVMask");
					TQPainter painter(&gradientPix);
					renderSurface(&painter, TQRect(0, 0, gradientPix.width(), gradientPix.height()), buttonColor, buttonColor, buttonColor, surfaceFlags);
					TQImage img1 = gradientPix.convertToImage();
					TQImage img2 = qembed_findImage("scrollBtnVShadow");
					TQImage img3 = tintImage(qembed_findImage("scrollBtnVContour"), contourColor);
					
					blend(img2, img1, img1);
					blend(img3, img1, img1);
					
					addPageBtn = new TQPixmap(img1);
					
					TQPixmapCache::insert(TQString::number(buttonColor.pixel(), 16)+"av"+configMode, addPageBtn);
				}
			}
			
			TQRect br(buffer.rect() );
			TQPainter bp(&buffer);
			
			//// groove
			if(sliderlen >= 10) {
				surfaceFlags = Is_ScrollBarGroove;
				if(horiz)
					surfaceFlags |= Is_Horizontal;
				
				TQColor grooveLine = alphaBlendColors(black, buttonColor, 80);
				renderSurface(&bp, TQRect(0, 0, br.width(), br.height()), grooveLine, grooveLine, grooveLine, surfaceFlags);
				bp.setClipRegion(horiz ? TQRect(0, 1, br.width(), br.height()-2) : TQRect(1, 0, br.width()-2, br.height()));
				renderSurface(&bp, TQRect(0, 0, br.width(), br.height()), buttonColor, buttonColor, buttonColor, surfaceFlags);
				bp.setClipping(false);
			}
			else {
				renderSurface(&bp, TQRect(0, 0, br.width(), br.height()), buttonColor, buttonColor, buttonColor, surfaceFlags);
				uint contourFlags = Is_ScrollBarBtn;
				contourFlags |= (horiz)? Draw_Top|Draw_Bottom : Draw_Left|Draw_Right;
				renderContour(&bp, horiz?TQRect(-2, 0, br.width()+4, br.height()):TQRect(0, -2, br.width(), br.height()+4), buttonColor, buttonColor, contourFlags);
			}
			
			
			
			TQString docked = (!horiz && r.height() == 1) || (horiz && r.width() == 1) ? "1" : "0";
			TQPixmap* sliderCap;
			if(horiz) {
				if(!(sliderCap = TQPixmapCache::find("sHCap"+TQString::number(buttonColor.pixel(), 16)+docked+configMode))) {
					if(r.width() == 1) {
						TQPixmap gradientPix(16, 15);
						TQPainter painter(&gradientPix);
						renderSurface(&painter, TQRect(0, 0, gradientPix.width(), gradientPix.height()), cg.button(), cg.button(), buttonColor, Is_ScrollBarBtn|Is_Horizontal);
						TQImage img1 = gradientPix.convertToImage();
						
						TQImage img2 = qembed_findImage("scrollSliderHDockedShadow");
						TQImage img3 = tintImage(qembed_findImage("scrollSliderHDockedContour"), contourColor);
						
						bitBlt(&img1, 0, 0, &img2);
						bitBlt(&img1, 0, 0, &img3);
						
						sliderCap = new TQPixmap(img1);
					}
					else {
						TQPixmap gradientPix = qembed_findImage("scrollSliderHMask");
						TQPainter painter(&gradientPix);
						
						renderSurface(&painter, TQRect(0, 0, gradientPix.width(), gradientPix.height()), cg.button(), cg.button(), buttonColor, Is_ScrollBarBtn|Is_Horizontal);
						TQImage img1 = gradientPix.convertToImage();
						TQImage img2 = qembed_findImage("scrollSliderHShadow");
						TQImage img3 = tintImage(qembed_findImage("scrollSliderHContour"), contourColor);
						
						blend(img2, img1, img1);
						blend(img3, img1, img1);
						
						sliderCap = new TQPixmap(img1);
					}
					TQPixmapCache::insert("sHCap"+TQString::number(buttonColor.pixel(), 16)+docked+configMode, sliderCap);
				}
			}
			else {
				if(!(sliderCap = TQPixmapCache::find("sVCap"+TQString::number(buttonColor.pixel(), 16)+docked+configMode))) {
					if(r.height() == 1) {
						TQPixmap gradientPix(15, 16);
						TQPainter painter(&gradientPix);
						renderSurface(&painter, TQRect(0, 0, gradientPix.width(), gradientPix.height()), cg.button(), cg.button(), buttonColor, Is_ScrollBarBtn);
						TQImage img1 = gradientPix.convertToImage();
						
						TQImage img2 = qembed_findImage("scrollSliderVDockedShadow");
						TQImage img3 = tintImage(qembed_findImage("scrollSliderVDockedContour"), contourColor);
						
						bitBlt(&img1, 0, 0, &img2);
						bitBlt(&img1, 0, 0, &img3);
						
						sliderCap = new TQPixmap(img1);
					}
					else {
						TQPixmap gradientPix = qembed_findImage("scrollSliderVMask");
						TQPainter painter(&gradientPix);
						
						renderSurface(&painter, TQRect(0, 0, gradientPix.width(), gradientPix.height()), cg.button(), cg.button(), buttonColor, Is_ScrollBarBtn);
						TQImage img1 = gradientPix.convertToImage();
						TQImage img2 = qembed_findImage("scrollSliderVShadow");
						TQImage img3 = tintImage(qembed_findImage("scrollSliderVContour"), contourColor);
						
						blend(img2, img1, img1);
						blend(img3, img1, img1);
						
						sliderCap = new TQPixmap(img1);
					}
					TQPixmapCache::insert("sVCap"+TQString::number(buttonColor.pixel(), 16)+docked+configMode, sliderCap);
				}
			}
			
			
			////////////
			
			if(horiz) {
				if(sliderlen >= 10) {
					bp.drawPixmap(br.right()-8, 0, *addPageBtn, 9, 0, 9, 15);
					bp.drawPixmap(-6+sl, 0, *sliderCap, 8, 0, 8, 15);
				}
				bitBlt(p->device(), r.x()-sl, r.y(), &buffer, 0, 0, br.width(), br.height(), TQt::CopyROP);
			}
			else {
				if(sliderlen >= 10) {
					bp.drawPixmap(0, br.bottom()-8, *addPageBtn, 0, 9, 15, 9);
					bp.drawPixmap(0, (br.height() <= 6)? br.bottom()-6 :br.top(), *sliderCap, 0, 8, 15, 8);
				}
				bitBlt(p->device(), r.x(), r.y()-sl, &buffer, 0, 0, br.width(), br.height(), TQt::CopyROP);
			}
			break;
		}

		case PE_ScrollBarSubPage: { // top / left
			
			TQColor buttonColor = cg.button();
			TQColor contourColor = alphaBlendColors(buttonContour->contourColor(Contour_Default), buttonColor, 203);
			TQPixmap* subPageBtn;
			TQPixmap buffer;

			uint surfaceFlags = Is_ScrollBarBtn;
			
			if(horiz)
				surfaceFlags |= Is_Horizontal;
			
			
			int sl = 6;
			if(sliderlen < 14)
				sl = sliderlen/2;
			
			
			//// button part
			if(horiz) {
				buffer.resize(r.width()+sl, r.height());
				if(buffer.isNull()) break;
				
				if(!(subPageBtn = TQPixmapCache::find(TQString::number(buttonColor.pixel(), 16)+"sh"+configMode ))) {

					TQPixmap gradientPix = qembed_findImage("scrollBtnHMask");
					TQPainter painter(&gradientPix);
					renderSurface(&painter, TQRect(0, 0, gradientPix.width(), gradientPix.height()), buttonColor, buttonColor, buttonColor, surfaceFlags);
					TQImage img1 = gradientPix.convertToImage();
					TQImage img2 = qembed_findImage("scrollBtnHShadow");
					TQImage img3 = tintImage(qembed_findImage("scrollBtnHContour"), contourColor);
					
					blend(img2, img1, img1);
					blend(img3, img1, img1);
					
					subPageBtn = new TQPixmap(img1);
					
					TQPixmapCache::insert(TQString::number(buttonColor.pixel(), 16)+"sh"+configMode, subPageBtn);
				}
			}
			else {
				buffer.resize(r.width(), r.height()+sl);
				if(buffer.isNull()) break;
				
				if(!(subPageBtn = TQPixmapCache::find(TQString::number(buttonColor.pixel(), 16)+"sv"+configMode ))) {

					TQPixmap gradientPix = qembed_findImage("scrollBtnVMask");
					TQPainter painter(&gradientPix);
					renderSurface(&painter, TQRect(0, 0, gradientPix.width(), gradientPix.height()), buttonColor, buttonColor, buttonColor, surfaceFlags);
					TQImage img1 = gradientPix.convertToImage();
					TQImage img2 = qembed_findImage("scrollBtnVShadow");
					TQImage img3 = tintImage(qembed_findImage("scrollBtnVContour"), contourColor);
					
					blend(img2, img1, img1);
					blend(img3, img1, img1);
					
					subPageBtn = new TQPixmap(img1);

					TQPixmapCache::insert(TQString::number(buttonColor.pixel(), 16)+"sv"+configMode, subPageBtn);
				}
			}

			TQRect br(buffer.rect());
			TQPainter bp(&buffer);
			
			//// groove
			if(sliderlen >= 10) {
				surfaceFlags = Is_ScrollBarGroove;
				if(horiz)
					surfaceFlags |= Is_Horizontal;
				
				TQColor grooveLine = alphaBlendColors(black, buttonColor, 80);
				renderSurface(&bp, TQRect(0, 0, br.width(), br.height()), grooveLine, grooveLine, grooveLine, surfaceFlags);
				bp.setClipRegion(horiz ? TQRect(0, 1, br.width(), br.height()-2) : TQRect(1, 0, br.width()-2, br.height()));
				renderSurface(&bp, TQRect(0, 0, br.width(), br.height()), buttonColor, buttonColor, buttonColor, surfaceFlags);
				bp.setClipping(false);
			}
			else {
				renderSurface(&bp, TQRect(0, 0, br.width(), br.height()), buttonColor, buttonColor, buttonColor, surfaceFlags);
				uint contourFlags = Is_ScrollBarBtn;
				contourFlags |= (horiz)? Draw_Top|Draw_Bottom : Draw_Left|Draw_Right;
				renderContour(&bp, horiz?TQRect(-2, 0, br.width()+4, br.height()):TQRect(0, -2, br.width(), br.height()+4), buttonColor, buttonColor, contourFlags);
			}
			
			
			TQString docked = (!horiz && r.bottom() == 15) || (horiz && r.right() == 15) ? "1" : "0";
			TQPixmap* sliderCap;
			if(horiz) {
				if(!(sliderCap = TQPixmapCache::find("sHCap"+TQString::number(buttonColor.pixel(), 16)+docked+configMode))) {
					
					if(r.right() == 15) {
						TQPixmap gradientPix(16, 15);
						TQPainter painter(&gradientPix);
						renderSurface(&painter, TQRect(0, 0, gradientPix.width(), gradientPix.height()), cg.button(), cg.button(), buttonColor, Is_ScrollBarBtn|Is_Horizontal);
						TQImage img1 = gradientPix.convertToImage();
						TQImage img2 = qembed_findImage("scrollSliderHDockedShadow");
						TQImage img3 = tintImage(qembed_findImage("scrollSliderHDockedContour"), contourColor);
						
						bitBlt(&img1, 0, 0, &img2);
						bitBlt(&img1, 0, 0, &img3);
						
						sliderCap = new TQPixmap(img1);
					}
					else {
						TQPixmap gradientPix = qembed_findImage("scrollSliderHMask");
						TQPainter painter(&gradientPix);
						renderSurface(&painter, TQRect(0, 0, gradientPix.width(), gradientPix.height()), cg.button(), cg.button(), buttonColor, Is_ScrollBarBtn|Is_Horizontal);
						TQImage img1 = gradientPix.convertToImage();
						TQImage img2 = qembed_findImage("scrollSliderHShadow");
						TQImage img3 = tintImage(qembed_findImage("scrollSliderHContour"), contourColor);
						
						blend(img2, img1, img1);
						blend(img3, img1, img1);
						
						sliderCap = new TQPixmap(img1);
					}
					
					TQPixmapCache::insert("sHCap"+TQString::number(buttonColor.pixel(), 16)+docked+configMode, sliderCap);
				}
			}
			else {
				if(!(sliderCap = TQPixmapCache::find("sVCap"+TQString::number(buttonColor.pixel(), 16)+docked+configMode))) {
					
					if(r.bottom() == 15) {
						TQPixmap gradientPix(15, 16);
						TQPainter painter(&gradientPix);
						renderSurface(&painter, TQRect(0, 0, gradientPix.width(), gradientPix.height()), cg.button(), cg.button(), buttonColor, Is_ScrollBarBtn);
						TQImage img1 = gradientPix.convertToImage();
						
						TQImage img2 = qembed_findImage("scrollSliderVDockedShadow");
						TQImage img3 = tintImage(qembed_findImage("scrollSliderVDockedContour"), contourColor);
						
						bitBlt(&img1, 0, 0, &img2);
						bitBlt(&img1, 0, 0, &img3);
						
						sliderCap = new TQPixmap(img1);
					}
					else {
						TQPixmap gradientPix = qembed_findImage("scrollSliderVMask");
						TQPainter painter(&gradientPix);
						
						renderSurface(&painter, TQRect(0, 0, gradientPix.width(), gradientPix.height()), cg.button(), cg.button(), buttonColor, Is_ScrollBarBtn);
						TQImage img1 = gradientPix.convertToImage();
						TQImage img2 = qembed_findImage("scrollSliderVShadow");
						TQImage img3 = tintImage(qembed_findImage("scrollSliderVContour"), contourColor);
						
						blend(img2, img1, img1);
						blend(img3, img1, img1);
						
						sliderCap = new TQPixmap(img1);
					}
					
					
					TQPixmapCache::insert("sVCap"+TQString::number(buttonColor.pixel(), 16)+docked+configMode, sliderCap);
				}
			}
			
			if(horiz) {
				if(sliderlen >= 10) {
					bp.drawPixmap(0, 0, *subPageBtn, 0, 0, 9, 15);
					bp.drawPixmap((br.width() <= 6)? -2 : br.width()-8, 0, *sliderCap, 0, 0, 8, 15);
				}
			}
			else {
				if(sliderlen >= 10) {
					bp.drawPixmap(0, 0, *subPageBtn, 0, 0, 15, 9);
					bp.drawPixmap(0, br.bottom()-sl-2+1, *sliderCap, 0, 0, 15, 8);
				}
			}
			
			bitBlt(p->device(), r.x(), r.y(), &buffer, 0, 0, br.width(), br.height(), TQt::CopyROP);
			break;
		}

	// SCROLLBAR BUTTONS
	// -----------------

		case PE_ScrollBarSubLine: { // top / left button
			
			uint contourFlags = Is_ScrollBarBtn;
			
			TQRect cr = r;
			TQRect ar = r;
			TQRect sr = r;
			
			if(horiz) {
				contourFlags |= Is_Horizontal|Draw_Top|Draw_Bottom;
				if(r.x() == 0) { // = single Button
					sr.setX(2);
					sr.setWidth(13);
					ar.setX(3);
					contourFlags |= Draw_Left|Round_BottomLeft|Round_UpperLeft;
				}
				else {
					cr.setWidth(17);
					cr.setX(cr.x()-2);
				}
			}
			else {
				ar.setX(1);
				contourFlags |= Draw_Left|Draw_Right;
				if(r.y() == 0) {
					sr.setY(2);
					sr.setHeight(13);
					ar.setY(3);
					contourFlags |= Draw_Top|Round_UpperLeft|Round_UpperRight;
				}
				else {
					cr.setHeight(17);
					cr.setY(cr.y()-2);
				}
			}
			
			if(horiz) {
				renderSurface(p, TQRect(sr.x(), sr.y(), sr.width(), sr.height()), cg.button(), cg.button(), cg.button(), Is_ScrollBarBtn|Is_Horizontal);
				renderContour(p, TQRect(cr.x(), cr.y(), cr.width(), cr.height()), cg.button(), cg.button(), contourFlags);
			}
			else {
				p->setClipRegion(TQRect(sr.x()+2, sr.y(), sr.width()-4, sr.height()));
				renderSurface(p, TQRect(sr.x(), sr.y(), sr.width(), sr.height()), cg.button(), cg.button(), cg.button(), Is_ScrollBarBtn);
				p->setClipping(false);
				renderContour(p, TQRect(cr.x(), cr.y(), cr.width(), cr.height()), cg.button(), cg.button(), contourFlags);
			}
			
			TQColor color = dynamic_cast<TQWidget*>(p->device()) ? dynamic_cast<TQWidget*>(p->device())->palette().active().buttonText() : cg.buttonText();
			p->setPen(color);
			drawPrimitive((horiz ? PE_ArrowLeft : PE_ArrowUp), p, ceData, elementFlags, ar, cg, flags);

			break;
		}

		case PE_ScrollBarAddLine: { // bottom / right button
			
			TQRect cr = r;
			TQRect ar = r;
			TQRect sr = r;
			if(horiz) {
				sr.setWidth(13);
				ar.setX(r.x()-4);
			}
			else {
				sr.setHeight(13);
				ar.setY(r.y()-2);
				ar.setX(r.x()+1);
			}

			if(horiz) {
				uint contourFlags = Is_ScrollBarBtn|Is_Horizontal|Draw_Top|Draw_Bottom|Draw_Right|Round_UpperRight|Round_BottomRight;
				renderSurface(p, TQRect(sr.x(), sr.y(), sr.width(), sr.height()), cg.button(), cg.button(), cg.button(), Is_ScrollBarBtn|Is_Horizontal);
				renderContour(p, TQRect(cr.x(), cr.y(), cr.width(), cr.height()), cg.button(), cg.button(), contourFlags);
			}
			else {
				p->setClipRegion(TQRect(sr.x()+2, sr.y(), sr.width()-4, sr.height()));
				renderSurface(p, TQRect(sr.x(), sr.y(), sr.width(), sr.height()), cg.button(), cg.button(), cg.button(), Is_ScrollBarBtn);
				p->setClipping(false);
				uint contourFlags = Is_ScrollBarBtn|Draw_Bottom|Draw_Left|Draw_Right|Round_BottomLeft|Round_BottomRight;
				renderContour(p, TQRect(cr.x(), cr.y(), cr.width(), cr.height()), cg.button(), cg.button(), contourFlags);
			}
			
			TQColor color = dynamic_cast<TQWidget*>(p->device()) ? dynamic_cast<TQWidget*>(p->device())->palette().active().buttonText() : cg.buttonText();
			p->setPen(color);
			drawPrimitive((horiz ? PE_ArrowRight : PE_ArrowDown), p, ceData, elementFlags, ar, cg, flags);
			
			
			break;
		}
		
		case PE_ScrollBarSubLine2: { // second top / left button // ### remove
			
			uint contourFlags = Is_ScrollBarBtn;
			
			TQRect cr = r;
			TQRect ar = r;
			TQRect sr = r;
			
			if(horiz) {
				contourFlags |= Is_Horizontal|Draw_Top|Draw_Bottom;
			}
			else {
				ar.setX(1);
				contourFlags |= Draw_Left|Draw_Right;
			}
			
			if(horiz) {
				renderSurface(p, TQRect(sr.x(), sr.y(), sr.width(), sr.height()), cg.button(), cg.button(), cg.button(), Is_ScrollBarBtn|Is_Horizontal);
				renderContour(p, TQRect(cr.x(), cr.y(), cr.width(), cr.height()), cg.button(), cg.button(), contourFlags);
			}
			else {
				p->setClipRegion(TQRect(sr.x()+2, sr.y(), sr.width()-4, sr.height()));
				renderSurface(p, TQRect(sr.x(), sr.y(), sr.width(), sr.height()), cg.button(), cg.button(), cg.button(), Is_ScrollBarBtn);
				p->setClipping(false);
				renderContour(p, TQRect(cr.x(), cr.y(), cr.width(), cr.height()), cg.button(), cg.button(), contourFlags);
			}
			
			TQColor color = dynamic_cast<TQWidget*>(p->device()) ? dynamic_cast<TQWidget*>(p->device())->palette().active().buttonText() : cg.buttonText();
			p->setPen(color);
			drawPrimitive((horiz ? PE_ArrowLeft : PE_ArrowUp), p, ceData, elementFlags, ar, cg, flags);
			
			break;
		}

	// CHECKBOXES
	// ----------
		case PE_Indicator: {
			break;
		}

		case PE_IndicatorMask: {
			p->fillRect (r.x()+3, r.y()+3, r.width()-6, r.height()-7, color1);
			break;
		}

	// RADIOBUTTONS
	// ------------
		case PE_ExclusiveIndicator: {
			break;
		}

		case PE_ExclusiveIndicatorMask: {

			TQPointArray pa(8);
			pa.setPoint(0, 3,6);
			pa.setPoint(1, 6,3);
			pa.setPoint(2, 10,3);
			pa.setPoint(3, 13,6);
			pa.setPoint(4, 13,10);
			pa.setPoint(5, 10,13);
			pa.setPoint(6, 6,13);
			pa.setPoint(7, 3,10);

			p->setBrush(color1);
			p->setPen(color1);
			p->drawPolygon(pa);
			break;
		}

	// GENERAL PANELS
	// --------------
		case PE_Splitter: {
			
			p->fillRect(r, cg.background());
			int ch, cs, cv;
			cg.background().getHsv(ch, cs, cv);
			if(cv < 100)
				p->setPen(alphaBlendColors(cg.background(), white, 120));
			else
				p->setPen(alphaBlendColors(cg.background(), black, 180));

			p->setPen(dGetColor(cg.background(), 55));
			if (w > h) {
				int ycenter = r.height()/2;
				for(int k =r.width()/2-5; k < r.width()/2+5; k+=3) {
					p->drawRect(k, ycenter-1, 2,2);
				}
			}
			else {
				int xcenter = r.width()/2;
				for(int k =r.height()/2-5; k < r.height()/2+5; k+=3) {
					p->drawRect( xcenter-1, k, 2,2);
				}
			}
			
			break;
		}

		case PE_GroupBoxFrame:
		case PE_PanelGroupBox: { // TQFrame::GroupBoxPanel
			break;
		}

		case PE_WindowFrame: {
			if ( opt.isDefault() || opt.lineWidth() <= 0 )
				break;
			
			p->setPen(cg.background().dark(120));
			p->drawRect(r);
			p->setPen(cg.background().light(110));
			p->drawRect(TQRect(r.x()+1, r.y()+1, r.width()-2, r.height()-2));
			
			break;
		}

		case PE_Panel: { // TQFrame::StyledPanel
			if(kickerMode)
				break;
			
			p->save();
			// inside rect
			p->setPen(cg.background().dark(120));
			p->drawLine(r.x()+1, r.y()+1, r.right()-1, r.y()+1); //top
			p->drawLine(r.x()+1, r.bottom()-1, r.right()-1, r.bottom()-1);
			p->drawLine(r.x()+1, r.y()+1, r.x()+1, r.bottom()-1);
			p->drawLine(r.right()-1, r.y()+1, r.right()-1, r.bottom()-1);
			
			// outside rect
			p->setPen(cg.background());
			p->drawLine(r.x(), r.y(), r.right(), r.y()); //top
			p->setPen(alphaBlendColors(white, cg.background(), 30));
			p->drawLine(r.x(), r.y()+1, r.x(), r.bottom());
			p->drawLine(r.right(), r.y()+1, r.right(), r.bottom());
			p->setPen(alphaBlendColors(white, cg.background(), 50));
			p->drawLine(r.x()+1, r.bottom(), r.right()-1, r.bottom());
			
			p->restore(); // maybe we are a KArrowButton and need to draw the arrow
			break;
		}

		case PE_PanelLineEdit: { // TQFrame::LineEditPanel
			break;
		}

		case PE_PanelTabWidget: { // TQFrame::TabWidgetPanel
			
			// we get a wrong clip rect
			p->setClipping(false);
			
			bool roundTopLeft = true;
			bool roundTopRight = true;
			bool roundBottomLeft = true;
			bool roundBottomRight = true;
			bool tabsAbove = true;
			
// 			p->fillRect(TQRect(r.x()-10, r.y()-10, r.width()+20, r.height()+20), yellow);
			
			TQRect tr;
			TQWidget* w = dynamic_cast<TQWidget*>(p->device());
			TQTabWidget* tw = w ? dynamic_cast<TQTabWidget*>(w->parentWidget()) : 0;
			bool tabBarHidden = tw && !((DominoTQTabWidget*)tw)->tabBar()->isVisible();
			if(tw && !tabBarHidden) {
				
				tabsAbove = tw->tabPosition() == TQTabWidget::Top;
				
				if(tw->count() != 0) {
					
					TQTabBar* tb = ((DominoTQTabWidget*)tw)->tabBar();
					TQRect gr = tb->geometry();
					
					if(tb->isVisible()) {
						tr = tb->tabAt(tw->currentPageIndex())->rect();
						tr.setHeight(3);
						tr.moveBy(gr.x(), tabsAbove ? 0 : r.height()-2);
					}
					
					if(!tw->cornerWidget(TQt::TopLeft) && gr.x() < 7) {
						if(tabsAbove)
							roundTopLeft = false;
						else
							roundBottomLeft = false;
					}
					if(!tw->cornerWidget(TQt::TopRight) && gr.x()+gr.width() > tw->width()-7) {
						if(tabsAbove)
							roundTopRight = false;
						else
							roundBottomRight = false;
					}
				}
			}
			TQBrush background = tw ? tw->colorGroup().brush(TQColorGroup::Background) : cg.brush(TQColorGroup::Background);
			TQColor bottomGradient = alphaBlendColors(TQColor(0,0,0), cg.background(), 11);
			TQColor topGradient = alphaBlendColors(TQColor(255,255,255), cg.background(), 15);
			TQColor tabContour2 = cg.background().dark(150);
			
			
			TQString tabPos = tabsAbove ? "1" : "0";
			TQPixmap* tabWEdges;
			if(!(tabWEdges = TQPixmapCache::find("tabWEdges"+tabPos+TQString::number(background.color().pixel(), 16)+TQString::number(cg.background().pixel(), 16)))) {
				tabWEdges = new TQPixmap(16,16);
				TQPainter painter(tabWEdges);
				painter.fillRect(tabWEdges->rect(), background);
				painter.end();
				
				TQPixmap tabWEdgesMask = qembed_findImage("groupBoxMask");
				painter.begin(&tabWEdgesMask);
				painter.fillRect(tabWEdgesMask.rect(), cg.brush(TQColorGroup::Background));
				painter.end();
				bitBlt(tabWEdges, 0, 0, &tabWEdgesMask);
				
				TQPixmap circle = qembed_findImage("tabWidget");
				bitBlt(tabWEdges, 0, 0, &circle);
				
				TQPixmapCache::insert("tabWEdges"+tabPos+TQString::number(background.color().pixel(), 16)+TQString::number(cg.background().pixel(), 16), tabWEdges);
			}
			
			
			TQRect re = TQRect(r.x(), r.y(), r.width(), r.height()+1);
			TQColor bg = cg.background();
			TQColor bg2 = background.color(); // parent color
			
			// top
			TQColor c1 = alphaBlendColors(TQColor(0,0,0), bg2, 25);
			TQColor c2 = alphaBlendColors(TQColor(255,255,255), bg, 70);
			TQColor c3 = alphaBlendColors(TQColor(255,255,255), bg, 30);
				
			// left + right
			TQColor c4 = alphaBlendColors(TQColor(0,0,0), bg2, 40);
// 			TQColor c5 = alphaBlendColors(TQColor(255,255,255), bg, 30);
			TQColor c6 = alphaBlendColors(TQColor(255,255,255), bg, 4);
				
			// bottom
			TQColor c7 = alphaBlendColors(TQColor(249,249,249), bg, 25);
			TQColor c8 = alphaBlendColors(TQColor(0,0,0), bg2, 79);
			TQColor c9 = alphaBlendColors(TQColor(0,0,0), bg2, 30);
			
			// top
			p->setPen(c1);
			p->drawLine(re.left(), re.y(), re.right(), re.y());
			p->setPen(c2);
			p->drawLine(re.left(), re.y()+1, re.right(), re.y()+1);
			p->setPen(c3);
			p->drawLine(re.left(), re.y()+2, re.right(), re.y()+2);
			// bottom
			p->setPen(c7);
			p->drawLine(re.left()+1, re.bottom()-2, re.right(), re.bottom()-2);
			p->setPen(c8);
			p->drawLine(re.left()+1, re.bottom()-1, re.right(), re.bottom()-1);
			p->setPen(c9);
			p->drawLine(re.left(), re.bottom(), re.right(), re.bottom());
			// left
			p->setPen(c4);
			p->drawLine(re.left(), re.y()+1, re.left(), re.bottom()-1);
			p->setPen(c3);
			p->drawLine(re.left()+1, re.y()+2, re.left()+1, re.bottom()-2);
			p->setPen(c6);
			p->drawLine(re.left()+2, re.y()+3, re.left()+2, re.bottom()-3);
			// right
			p->drawLine(re.right()-2, re.y()+3, re.right()-2, re.bottom()-3);
			p->setPen(c3);
			p->drawLine(re.right()-1, re.y()+2, re.right()-1, re.bottom()-2);
			p->setPen(c4);
			p->drawLine(re.right(), re.y()+1, re.right(), re.bottom()-1);
			
			
			// unpainted area
			p->setPen(bg);
			p->drawLine(re.left()+3, re.y()+3, re.right()-3, re.y()+3);
			p->drawLine(re.left()+3, re.bottom()-4, re.right()-3, re.bottom()-4);
			p->drawLine(re.left()+3, re.bottom()-3, re.right()-3, re.bottom()-3);
			p->drawLine(re.left()+3, re.y()+3, re.left()+3, re.bottom()-4);
			p->drawLine(re.right()-3, re.y()+3, re.right()-3, re.bottom()-4);
			
			
			if(roundTopLeft) {
				bitBlt(p->device(), re.x(), re.y(), tabWEdges, 0, 0, 8, 8, TQt::CopyROP);
			}
			if(roundTopRight) {
				bitBlt(p->device(), re.width()-8, re.y(), tabWEdges, 8, 0, 8, 8, TQt::CopyROP);
			}
			if(roundBottomLeft) {
				bitBlt(p->device(), re.x(), re.height()-8, tabWEdges, 0, 8, 8, 8, TQt::CopyROP);
			}
			if(roundBottomRight) {
				bitBlt(p->device(), re.width()-8, re.height()-8, tabWEdges, 8, 8, 8, 8, TQt::CopyROP);
			}
			
			
			// paint over the frame to not disturb the transition from the tabWidget to the current tab
			if(tr.isValid()) {
				p->fillRect(tr, cg.background()); // ### shrink
				
				if(tabsAbove) {
					TQColor p1 = alphaBlendColors(TQColor(255,255,255), bg, 50);
					TQColor p2 = alphaBlendColors(TQColor(255,255,255), bg, 25);
					TQColor p3 = alphaBlendColors(TQColor(255,255,255), bg, 10);
					
					p->setPen(p1);
					p->drawPoint(tr.left(), tr.top()+1);
					p->drawPoint(tr.right(), tr.top()+1);
					p->setPen(p2);
					p->drawPoint(tr.left()+1, tr.top()+1);
					p->drawPoint(tr.left(), tr.top()+2);
					p->drawPoint(tr.right()-1, tr.top()+1);
					p->drawPoint(tr.right(), tr.top()+2);
					p->setPen(p3);
					p->drawPoint(tr.left()+1, tr.top()+2);
					p->drawPoint(tr.right()-1, tr.top()+2);
				}
				else {
					TQColor p1 = alphaBlendColors(TQColor(255,255,255), bg, 17);
					TQColor p2 = alphaBlendColors(TQColor(255,255,255), bg, 10);
					
					p->setPen(p1);
					p->drawPoint(tr.left(), tr.top());
					p->drawPoint(tr.right(), tr.top());
					
					p->setPen(p2);
					p->drawPoint(tr.left()+1, tr.top());
					p->drawPoint(tr.right()-1, tr.top());
					
				}
				
			}
			
			break;
		}

		case PE_PanelPopup: { // TQFrame::PopupPanel
			
			TQPopupMenu* pm = dynamic_cast<TQPopupMenu*>(p->device());
			TQColor background = dynamic_cast<TQListBox*>(p->device()) ? cg.base() : _customPopupMenuColor ? _popupMenuColor : cg.background();
			
			TQRegion mask(x, y+5, w, h-10);
			mask += TQRegion(x+5, y, w-10, h);
			mask += TQRegion(x+1, y+2, w-2, h-4);
			mask += TQRegion(x+2, y+1, w-4, h-2);
			
			if(_drawPopupMenuGradient) {
				TQPixmap buffer(r.width(), r.height());
				TQPainter bp(&buffer);
				renderGradient(&bp, r, lightenColor(background, 18), darkenColor(background, 12), true);
			
				if(pm) {
					pm->setUpdatesEnabled(false);
					pm->setPaletteBackgroundPixmap(buffer);
					pm->setUpdatesEnabled(true);
				}
				else {
					p->setClipRegion(mask);
					p->drawPixmap(r, buffer);
					p->setClipping(false);
				}
			}
			else {
				if(pm) {
					pm->setUpdatesEnabled(false);
					pm->setPaletteBackgroundColor(background);
					pm->setUpdatesEnabled(true);
				}
			}
			
			if(pm) {
				if(pm->isA("PrettyPopupMenu") || pm->isA("Amarok::Menu") || pm->isA("Digikam::DPopupMenu")) {
					// these popups have a side pixmap and are drawing the frame after the contents
					TQRect cr = pm->contentsRect();
					if(TQApplication::reverseLayout())
						pm->erase(mask-TQRegion(cr.width()+3, cr.y(), r.width()-cr.width()-6, cr.height()-1));
					else
						pm->erase(mask-TQRegion(r.x()+3, cr.y(), r.width()-cr.width()-6, cr.height()-1));
					((DominoTQFrame*)pm)->drawContents(p );
				}
				else
					pm->erase(mask);
			}
			
			
			bitBlt(p->device(), r.x(), r.y(), popupFrame, 0, 0, 5, 5, TQt::CopyROP);
			bitBlt(p->device(), r.width()-5, r.y(), popupFrame, 5, 0, 5, 5, TQt::CopyROP);
			bitBlt(p->device(), r.x(), r.bottom()-4, popupFrame, 0, 5, 5, 5, TQt::CopyROP);
			bitBlt(p->device(), r.width()-5, r.bottom()-4, popupFrame, 5, 5, 5, 5, TQt::CopyROP);
			
			p->setPen(background.dark(150));
			p->drawLine(r.x()+5, r.y(), r.width()-6, r.y());
			p->drawLine(r.x()+5, r.bottom(), r.width()-6, r.bottom());
			p->drawLine(r.x(), r.y()+5, r.x(), r.bottom()-5);
			p->drawLine(r.width()-1, r.y()+5, r.width()-1, r.bottom()-5);

			break;
		}

	// MENU / TOOLBAR PANEL
	// --------------------
		case PE_PanelMenuBar: // TQFrame::MenuBarPanel
		case PE_PanelDockWindow: { // TQFrame::ToolBarPanel

			p->setPen(cg.background());
			// overpainting the menus leads to flicker so we draw only the frame here.
			if(dynamic_cast<TQWidget*>(p->device()))
				p->drawRect(r);
			else
				p->fillRect(r, cg.brush(TQColorGroup::Background)); // colorpreview in kcontrol
			break;
		}

		case PE_StatusBarSection: {
			break;
		}

		case PE_TabBarBase: {
			break;
		}
		
	// TOOLBAR/DOCK WINDOW HANDLE
	// --------------------------
		case PE_DockWindowResizeHandle: {
			TQWidget* w = dynamic_cast<TQWidget*>(p->device()); // TQDockWindowResizeHandle
			
			if(w && !w->erasePixmap()) {
				TQPixmap pix(r.size());
				TQPainter painter(&pix);
				renderGradient(&painter, r, lightenColor(cg.background(), 40), darkenColor(cg.background(), 30), horiz);
				w->setErasePixmap(pix);
			}
			break;
		}

		case PE_DockWindowHandle: {
			TQWidget* widget = dynamic_cast<TQWidget*>(p->device()); // qt_dockwidget_internal - TQDockWindowHandle
			
			int ch, cs, cv;
			cg.background().getHsv(ch, cs, cv);
			if(cv < 100)
				p->setPen(alphaBlendColors(cg.background(), white, 120));
			else
				p->setPen(alphaBlendColors(cg.background(), black, 180));
			
			if(widget && widget == hoverWidget) {
				if (w > h) {
					int ycenter = r.height()/2;
					for(int k = r.width()/2-5; k < r.width()/2+5; k+=3) {
						p->drawRect(k, ycenter-1, 2, 2);
					}
				}
				else {
					int xcenter = r.width()/2;
					for(int k = r.height()/2-5; k < r.height()/2+5; k+=3) {
						p->drawRect(xcenter-1, k, 2, 2);
					}
				}
			}
			break;
		}

	// TOOLBAR SEPARATOR
	// -----------------
		case PE_DockWindowSeparator: {
			if(!_toolBtnAsBtn) {
				int ch, cs, cv;
				cg.background().getHsv(ch, cs, cv);
				if(cv < 100)
					p->setPen(alphaBlendColors(cg.background(), white, 150));
				else
					p->setPen(alphaBlendColors(cg.background(), black, 150));
				
				if(horiz) {
					int x = r.width()/2;
					for(int i = 2; i < r.height()-4; i += 3)
						p->drawPoint(x, i);
				}
				else {
					int y = r.height()/2;
					for(int i = 2; i < r.width()-4; i += 3)
						p->drawPoint(i, y);
				}
			}
			break;
		}
		case PE_CheckMark: {
			if( flags & Style_On ) {
				if(flags & Style_Enabled)
					p->drawPixmap(r.x()+1, r.y()+1, *checkMark, 0, 0, 16, 17);
				else
					p->drawPixmap(r.x()+1, r.y()+1, *checkMark, 16, 0, 16, 17);
			}
			else if ( flags & Style_Off ) {
			}
			else {// tristate
				p->setPen(_customCheckMarkColor ? _checkMarkColor : tqApp->palette().active().foreground());
				p->drawLine(6,6,11,6);
				p->drawLine(6,8,11,8);
				p->drawLine(6,10,11,10);
			}
			
			break;
		}

		case PE_SpinWidgetUp:
		case PE_SpinWidgetDown: {
			TQPixmap* arrow;
			bool isEnabled = (flags & Style_Enabled);
			TQString enabled = isEnabled ? "1" : "0";
			TQColor color = p->pen().color();
			
			if(!(arrow = TQPixmapCache::find(TQString::number(color.pixel(), 16)+"spinArrows"+enabled))) {
				TQImage ar = tintImage(qembed_findImage("spinBoxArrows"), color);
				if(!isEnabled) { // make it transparent
					ar = setImageOpacity(ar, 25);
				}
				arrow = new TQPixmap(ar);
				TQPixmapCache::insert(TQString::number(color.pixel(), 16)+"spinArrows"+enabled, arrow);
			}
			
			if(textEffectSettings.mode) {
				TQPixmap* effectArrow;
				if(!(effectArrow = TQPixmapCache::find(TQString::number(textEffectSettings.buttonColor.pixel(), 16)+"spinEArrows"+enabled))) {
					TQImage img = tintImage(qembed_findImage("spinBoxArrows"), textEffectSettings.buttonColor);
					int opacity = textEffectSettings.buttonOpacity*100/255;
					effectArrow = new TQPixmap(setImageOpacity(img, !isEnabled ? opacity*25/100 : opacity));
					TQPixmapCache::insert(TQString::number(textEffectSettings.buttonColor.pixel(), 16)+"spinEArrows"+enabled, effectArrow);
				}
				bitBlt(p->device(), r.x()+7/2+1+textEffectSettings.buttonPos.x(), r.y()+r.height()/2-3+textEffectSettings.buttonPos.y(), effectArrow, 0, pe == PE_SpinWidgetDown ? 5 : 0, 7, 5);
				
			}
			
			bitBlt(p->device(), r.x()+7/2+1, r.y()+r.height()/2-3, arrow, 0, pe == PE_SpinWidgetDown ? 5 : 0, 7, 5);
			break;
			}
		case PE_HeaderArrow:
		case PE_ArrowUp:
		case PE_ArrowDown:
		case PE_ArrowLeft:
		case PE_ArrowRight: {
			
			TQRect re = r;
			int x2, w2, h2;
			int x = -4;
			switch (pe) {
				case PE_ArrowUp: {
					
					x2 = 10;
					w2 = 7;
					h2 = 5;
					break;
				}
				case PE_ArrowDown: {
					x2 = 17;
					w2 = 7;
					h2 = 5;
					break;
				}
				case PE_ArrowLeft: {
					x += 1;
					x2 = 0;
					w2 = 5;
					h2 = 7;
					break;
				}
				case PE_ArrowRight: {
					x += 2;
					x2 = 5;
					w2 = 5;
					h2 = 7;
					break;
				}
				default: {
					if(flags & Style_Up) {
						x2 = 10;
						w2 = 7;
						h2 = 5;
					}
					else {
						x2 = 17;
						w2 = 7;
						h2 = 5;
					}
					break;
				}
			}
			
			
			TQPixmap* arrow;
			bool isEnabled = (flags & Style_Enabled);
			TQString enabled = isEnabled ? "1" : "0";
			TQColor color = p->pen().color();
			
			if(!(arrow = TQPixmapCache::find(TQString::number(color.pixel(), 16)+"scrollBarArrows"+enabled))) {
				TQImage ar = tintImage(qembed_findImage("scrollBarArrows"), color);
				if(!isEnabled) {
					ar = setImageOpacity(ar, 25);
				}
				arrow = new TQPixmap(ar);
				TQPixmapCache::insert(TQString::number(color.pixel(), 16)+"scrollBarArrows"+enabled, arrow);
			}
			
			if(/*pe == PE_HeaderArrow &&*/ textEffectSettings.mode) {
				TQPixmap* effectArrow;
				if(!(effectArrow = TQPixmapCache::find(TQString::number(textEffectSettings.buttonColor.pixel(), 16)+"scrollBarEArrows"+enabled))) {
					TQImage img = tintImage(qembed_findImage("scrollBarArrows"), textEffectSettings.buttonColor);
					int opacity = textEffectSettings.buttonOpacity*100/255;
					effectArrow = new TQPixmap(setImageOpacity(img, !isEnabled ? opacity*25/100 : opacity));
					TQPixmapCache::insert(TQString::number(textEffectSettings.buttonColor.pixel(), 16)+"scrollBarEArrows"+enabled, effectArrow);
				}
				p->drawPixmap(re.x()+re.width()/2+x+textEffectSettings.buttonPos.x(), re.y()+re.height()/2-3+textEffectSettings.buttonPos.y(), *effectArrow, x2, 0, w2, h2);
			}
			
			p->drawPixmap(re.x()+re.width()/2+x, re.y()+re.height()/2-3, *arrow, x2, 0, w2, h2);
			break;
		}

		case PE_CheckListIndicator: {
			// the rect in not correctly calculated in TQt, so the controller rect is 2px above the drawn rect.
			
			TQCheckListItem *item = opt.checkListItem();
			TQListView *lv = item->listView();
			if(!item)
				return;
			
			TQString state = flags& Style_On ? "1" : "0";
			state += flags& Style_Selected ? "1" : "0";
			state += flags& Style_NoChange ? "1" : "0";
			
			TQColor background = flags& Style_Selected ? cg.highlight() : cg.base();
			TQColor foreground = cg.text();
			
			TQPixmap* pix;
			if(!(pix = TQPixmapCache::find(TQString::number(background.pixel(), 16)+TQString::number(foreground.pixel(), 16)+"checkListIndicator"+state))) {
				pix = new TQPixmap(r.x()+lv->itemMargin()+r.width()+4, item->height());
				pix->fill(background);
				TQPainter painter(pix);
				
				painter.setPen(alphaBlendColors(foreground, background, 127));
				painter.drawLine(r.x()+1, r.y()+1, r.x()+12, r.y()+1); // t
				painter.drawLine(r.x()+1, r.y()+14, r.x()+12, r.y()+14); // b
				painter.drawLine(r.x(), r.y()+2, r.x(), r.y()+13); // l
				painter.drawLine(r.x()+13, r.y()+2, r.x()+13, r.y()+13); // r
				
				painter.setPen(alphaBlendColors(foreground, background, 80));
				painter.drawPoint(r.x(), r.y()+1);
				painter.drawPoint(r.x()+13, r.y()+1);
				painter.drawPoint(r.x(), r.y()+14);
				painter.drawPoint(r.x()+13, r.y()+14);
				
				
				if(flags& Style_NoChange) {
					painter.fillRect(r.x()+1, r.y()+2, 12, 12, dGetColor(background, 30));
					painter.drawPixmap(r.x()-1, r.y(), tintImage(qembed_findImage("checkmark"), foreground));
				}
				if(flags& Style_On)
					painter.drawPixmap(r.x()-1, r.y(), tintImage(qembed_findImage("checkmark"), foreground));
				
				TQPixmapCache::insert(TQString::number(background.pixel(), 16)+TQString::number(foreground.pixel(), 16)+"checkListIndicator"+state, pix);
			}
			
			p->drawPixmap(0, 0, *pix);
			break;
		}
		
		case PE_CheckListExclusiveIndicator: {
			TQColor background = flags& Style_Selected ? cg.highlight() : cg.base();
			p->drawPixmap(r.left()+3, r.top()+1, tintImage(qembed_findImage("checkListExclusiveIndicator"), alphaBlendColors(cg.text(), background, 127)));

			if(flags&Style_On)
				p->drawPixmap(r.x()+7, r.y()+5, tintImage(qembed_findImage("rb-dot"),cg.text()));
			break;
		}
		
		case PE_SizeGrip: {
			
			bool parentBgPix = cg.brush(TQColorGroup::Background).pixmap();
			TQString trans = parentBgPix ? "1" : "0";
			TQPixmap* grip;
			if(!(grip = TQPixmapCache::find(TQString::number(cg.background().pixel(), 16)+"sizeGrip"+trans))) {
				if(parentBgPix)
					grip = new TQPixmap(qembed_findImage("sizeGrip"));
				else {
					grip = new TQPixmap(4, 4);
					grip->fill(cg.background());
					TQPixmap tmpPix = qembed_findImage("sizeGrip");
					bitBlt(grip, 0, 0, &tmpPix, 0, 0, -1, -1, TQt::CopyROP);
				}
				TQPixmapCache::insert(TQString::number(cg.background().pixel(), 16)+"sizeGrip"+trans, grip);
			}
			
			bitBlt(p->device(), r.width()-(TQApplication::reverseLayout() ? 12 : 6), r.height()-12, grip, 0, 0, -1, -1, TQt::CopyROP);
			bitBlt(p->device(), r.width()-6, r.height()-6, grip, 0, 0, -1, -1, TQt::CopyROP);
			bitBlt(p->device(), r.width()-12, r.height()-6, grip, 0, 0, -1, -1, TQt::CopyROP);
			break;
		}
		
		
		
		
		case PE_RubberBand: {
			
#if TDE_VERSION >= 0x30506
			if(rubberBandType != ArgbRubber || !compositeManagerRunning) {
#else
			if(rubberBandType != ArgbRubber) {
#endif
				if(rubberBandType == LineRubber) {
					p->save();
					p->setPen(TQPen(black, 1, TQt::SolidLine));
					p->drawRect(r);
					p->restore();
				}
				else {
					TDEStyle::drawPrimitive(pe, p, ceData, elementFlags, r, cg, flags, opt);
				}
				break;
			}
			
			
			
			bool normalized = r.width() < 0 || r.height() < 0;
			TQRect re = normalized? r.normalize(): r;
			
			if(re.y() < 0)
				re.setY(-3);
			if(re.x() < 0)
				re.setX(-3);
			
			
			if(!viewPortPressed || re == oldRubberRect || re.width() == 0 || re.height() == 0) {
				break;
			}

			TQColor fg = alphaBlendColors(_argbRubberBandColor, black, 127);
			const TQWidget* w = dynamic_cast<TQWidget*>(p->device());
			if(!w)
				w = rubberViewPort;
			
			TQPoint po = w->mapToGlobal(TQPoint(0,0));
			TQRect gr = TQRect(po.x(), po.y(), w->width(), w->height());
			
			TQRegion mask(re.x()+1, re.y(), re.width()-2, re.height());
			mask += TQRegion(re.x(), re.y()+1, re.width(), re.height()-2);
			
			rubber->create(gr, mask);
			
			
			GC gc2 = XCreateGC(tqt_xdisplay(), rubber->window, 0, 0);
			
			/////// erasing
			XRectangle xrect;
			XRectangle outline[4];
			int num = 0;
			if(re.y() < oldRubberRect.y()) {// ^ top
				outline[num].x = oldRubberRect.x();
				outline[num].y = oldRubberRect.y();
				outline[num].width = oldRubberRect.width();
				outline[num].height = 1;
				num += 1;
				
			}
			if(oldRubberRect.y()+oldRubberRect.height() < re.y()+re.height()) {// v bottom
				outline[num].x = oldRubberRect.x();
				outline[num].y = oldRubberRect.y()+oldRubberRect.height()-1;
				outline[num].width = oldRubberRect.width();
				outline[num].height = 1;
				num += 1;
			}
			if(re.x() < oldRubberRect.x()) {// < left
				outline[num].x = oldRubberRect.x();
				outline[num].y = oldRubberRect.y();
				outline[num].width = 1;
				outline[num].height = oldRubberRect.height()-1;
				num += 1;
			}
			
			if(oldRubberRect.x()+oldRubberRect.width() < re.x()+re.width()) {// > right
				outline[num].x = oldRubberRect.x()+oldRubberRect.width()-1;
				outline[num].y = oldRubberRect.y();
				outline[num].width = 1;
				outline[num].height = oldRubberRect.height()-1;
				num += 1;
			}
			
			for(int i = 0; i<num; i++)
				XClearArea(tqt_xdisplay(), rubber->window, outline[i].x, outline[i].y, outline[i].width, outline[i].height, false);
			
			xrect.x = oldRubberRect.x()+1;
			xrect.y = oldRubberRect.y()+1;
			xrect.width = 2;
			xrect.height = 2;
			XClearArea(tqt_xdisplay(), rubber->window, xrect.x, xrect.y, xrect.width, xrect.height, false);
			
			xrect.x = oldRubberRect.x()+1;
			xrect.y = oldRubberRect.y()+oldRubberRect.height()-3;
			xrect.width = 2;
			xrect.height = 2;
			XClearArea(tqt_xdisplay(), rubber->window, xrect.x, xrect.y, xrect.width, xrect.height, false);
			
			xrect.x = oldRubberRect.x()+oldRubberRect.width()-3;
			xrect.y = oldRubberRect.y()+1;
			xrect.width = 2;
			xrect.height = 2;
			XClearArea(tqt_xdisplay(), rubber->window, xrect.x, xrect.y, xrect.width, xrect.height, false);
			
			xrect.x = oldRubberRect.x()+oldRubberRect.width()-3;
			xrect.y = oldRubberRect.y()+oldRubberRect.height()-3;
			xrect.width = 2;
			xrect.height = 2;
			XClearArea(tqt_xdisplay(), rubber->window, xrect.x, xrect.y, xrect.width, xrect.height, false);
			
			
			rubber->updateMask(mask);
			
			///////////// painting
			
			XSetForeground(tqt_xdisplay(), gc2, preMultiplyColor(tqRgba(fg.red(), fg.green(), fg.blue(),153)));
			XDrawRectangle(tqt_xdisplay(), rubber->window, gc2, re.x(), re.y(), re.width()-1, re.height()-1);
			
			// inside
			XRectangle xrects[8];
			// top left
			xrects[0].x = re.x()+2;
			xrects[0].y = re.y()+1;
			xrects[0].width = 1;
			xrects[0].height = 1;
			
			xrects[1].x = re.x()+1;
			xrects[1].y = re.y()+2;
			xrects[1].width = 1;
			xrects[1].height = 1;
			// top right
			xrects[2].x = re.x()+re.width()-3;
			xrects[2].y = re.y()+1;
			xrects[2].width = 1;
			xrects[2].height = 1;
			
			xrects[3].x = re.x()+re.width()-2;
			xrects[3].y = re.y()+2;
			xrects[3].width = 1;
			xrects[3].height = 1;
			// bottom left
			xrects[4].x = re.x()+1;
			xrects[4].y = re.y()+re.height()-3;
			xrects[4].width = 1;
			xrects[4].height = 1;
			
			xrects[5].x = re.x()+2;
			xrects[5].y = re.y()+re.height()-2;
			xrects[5].width = 1;
			xrects[5].height = 1;
			// bottom right
			xrects[6].x = re.x()+re.width()-2;
			xrects[6].y = re.y()+re.height()-3;
			xrects[6].width = 1;
			xrects[6].height = 1;
			
			xrects[7].x = re.x()+re.width()-3;
			xrects[7].y = re.y()+re.height()-2;
			xrects[7].width = 1;
			xrects[7].height = 1;
			
			TQColor blendc = tqRgba(fg.red(), fg.green(), fg.blue(), 36);
			XSetForeground(tqt_xdisplay(), gc2, preMultiplyColor(blendColors(_argbRubberBandColor, blendc).rgb()));
			XSetClipRectangles(tqt_xdisplay(), gc2, 0, 0, xrects, 8, Unsorted);
			XDrawRectangle(tqt_xdisplay(), rubber->window, gc2, re.x()+1, re.y()+1, re.width()-3, re.height()-3);
			
			XRectangle xrects2[8];
			// top left
			xrects2[0].x = re.x()+2;
			xrects2[0].y = re.y();
			xrects2[0].width = 1;
			xrects2[0].height = 1;
			
			xrects2[1].x = re.x()+1;
			xrects2[1].y = re.y()+1;
			xrects2[1].width = 1;
			xrects2[1].height = 1;
			
			xrects2[2].x = re.x();
			xrects2[2].y = re.y()+2;
			xrects2[2].width = 1;
			xrects2[2].height = 1;
			// top right
			xrects2[3].x = re.x()+re.width()-3;
			xrects2[3].y = re.y();
			xrects2[3].width = 1;
			xrects2[3].height = 1;
			
			xrects2[4].x = re.x()+re.width()-2;
			xrects2[4].y = re.y()+1;
			xrects2[4].width = 1;
			xrects2[4].height = 1;
			
			xrects2[5].x = re.x()+re.width()-1;
			xrects2[5].y = re.y()+2;
			xrects2[5].width = 1;
			xrects2[5].height = 1;
			// bottom left
			xrects2[6].x = re.x()+2;
			xrects2[6].y = re.y()+re.height()-1;
			xrects2[6].width = 1;
			xrects2[6].height = 1;
			
			xrects2[7].x = re.x()+1;
			xrects2[7].y = re.y()+re.height()-2;
			xrects2[7].width = 1;
			xrects2[7].height = 1;
			
			xrects2[8].x = re.x();
			xrects2[8].y = re.y()+re.height()-3;
			xrects2[8].width = 1;
			xrects2[8].height = 1;
			// bottom right
			xrects2[9].x = re.x()+re.width()-3;
			xrects2[9].y = re.y()+re.height()-1;
			xrects2[9].width = 1;
			xrects2[9].height = 1;
			
			xrects2[10].x = re.x()+re.width()-2;
			xrects2[10].y = re.y()+re.height()-2;
			xrects2[10].width = 1;
			xrects2[10].height = 1;
			
			xrects2[11].x = re.x()+re.width()-1;
			xrects2[11].y = re.y()+re.height()-3;
			xrects2[11].width = 1;
			xrects2[11].height = 1;
			
			
			XSetForeground(tqt_xdisplay(), gc2, preMultiplyColor(tqRgba(fg.red(), fg.green(), fg.blue(), 121)));
			XSetClipRectangles(tqt_xdisplay(), gc2, 0, 0, xrects2, 12, Unsorted);
			XDrawRectangle(tqt_xdisplay(), rubber->window, gc2, re.x()+1, re.y()+1, re.width()-3, re.height()-3);
			XDrawRectangle(tqt_xdisplay(), rubber->window, gc2, re.x(), re.y(), re.width()-1, re.height()-1);
			
			// outermost pixels
			XRectangle xrects3[8];
			// top left
			xrects3[0].x = re.x()+1;
			xrects3[0].y = re.y();
			xrects3[0].width = 1;
			xrects3[0].height = 1;
			
			xrects3[1].x = re.x();
			xrects3[1].y = re.y()+1;
			xrects3[1].width = 1;
			xrects3[1].height = 1;
			// top right
			xrects3[2].x = re.x()+re.width()-2;
			xrects3[2].y = re.y();
			xrects3[2].width = 1;
			xrects3[2].height = 1;
			
			xrects3[3].x = re.x()+re.width()-1;
			xrects3[3].y = re.y()+1;
			xrects3[3].width = 1;
			xrects3[3].height = 1;
			// bottom left
			xrects3[4].x = re.x()+1;
			xrects3[4].y = re.y()+re.height()-1;
			xrects3[4].width = 1;
			xrects3[4].height = 1;
			
			xrects3[5].x = re.x();
			xrects3[5].y = re.y()+re.height()-2;
			xrects3[5].width = 1;
			xrects3[5].height = 1;
			// bottom right
			xrects3[6].x = re.x()+re.width()-2;
			xrects3[6].y = re.y()+re.height()-1;
			xrects3[6].width = 1;
			xrects3[6].height = 1;
			
			xrects3[7].x = re.x()+re.width()-1;
			xrects3[7].y = re.y()+re.height()-2;
			xrects3[7].width = 1;
			xrects3[7].height = 1;
			
			XSetForeground(tqt_xdisplay(), gc2, preMultiplyColor(tqRgba(fg.red(), fg.green(), fg.blue(), 37)));
			XSetClipRectangles(tqt_xdisplay(), gc2, 0, 0, xrects3, 8, Unsorted);
			XDrawRectangle(tqt_xdisplay(), rubber->window, gc2, re.x(), re.y(), re.width()-1, re.height()-1);
			
			XFlush(tqt_xdisplay());
			XFreeGC(tqt_xdisplay(),gc2);
			oldRubberRect = re;
			
			break;
		}
		
		default: {
			return TDEStyle::drawPrimitive(pe, p, ceData, elementFlags, r, cg, flags, opt);
		}
	}
}

void DominoStyle::drawControl(ControlElement element,
							  TQPainter *p,
							  const TQStyleControlElementData &ceData,
							  ControlElementFlags elementFlags,
							  const TQRect &r,
							  const TQColorGroup &cg,
							  SFlags flags,
							  const TQStyleOption& opt,
							  const TQWidget *widget) const
{
	
	const bool enabled = (flags & Style_Enabled);

	//return TDEStyle::drawControl(element, p, ceData, elementFlags, r, cg, flags, opt, widget);
	
	switch (element) {

		case CE_ToolButtonLabel: {
			
			if(widget->isA("TDEToolBarButton")) {
				DominoKToolBarButton* tb= (DominoKToolBarButton *) widget;
	
				TQStyle::SFlags flags   = TQStyle::Style_Default;
				TQStyle::SCFlags active = TQStyle::SC_None;
	
				if (tb->isDown()) {
					flags  |= TQStyle::Style_Down;
					active |= TQStyle::SC_ToolButton;
				}
				if (tb->isEnabled()) 	flags |= TQStyle::Style_Enabled;
				if (tb->isOn()) 		flags |= TQStyle::Style_On;
				if (tb->isEnabled() && tb->hasMouse())	flags |= TQStyle::Style_Raised;
				if (tb->hasFocus())	flags |= TQStyle::Style_HasFocus;
				
				int dx, dy;
				TQFont tmp_font(TDEGlobalSettings::toolBarFont());
				TQFontMetrics fm(tmp_font);
				TQRect textRect;
				int textFlags = 0;
				
				
				TQPixmap pixmap;
				if (tb->iconTextMode() != TDEToolBar::TextOnly) {
					pixmap =tb->iconSet().pixmap( TQIconSet::Automatic,
						tb->isEnabled() ? (tb->isActive() ? TQIconSet::Active : TQIconSet::Normal) :
								TQIconSet::Disabled,
						tb->isOn() ? TQIconSet::On : TQIconSet::Off );
					
					TQImage img = pixmap.convertToImage();
					if((_toolBtnAsBtn || tb->isToggleButton()) && (tb->isDown() || tb->isOn()))
						pixmap = KImageEffect::fade(img, 0.10, black);
					else if(tb->isDown() || tb->isOn())
						pixmap = KImageEffect::fade(img, 0.15, black);
					else if(_highlightToolBtnIcon && tb->hasMouse() && tb->isEnabled())
						pixmap = KImageEffect::fade(img, 0.25, white);
					
				}
				
				TQPixmap outlinePixmap = 0;
				bool drawOutlinePixmap = false;
				if(flags &TQStyle::Style_HasFocus && focusIndicatorSettings.indicateFocus && !pixmap.isNull()) {
					outlinePixmap = renderOutlineIcon(&pixmap);
					drawOutlinePixmap = true;
				}
				
				if (tb->iconTextMode() == TDEToolBar::IconOnly) // icon only
				{
					if( !pixmap.isNull())
					{
						
						dx = ( tb->width() - pixmap.width() ) / 2;
						dy = ( tb->height()-1 - pixmap.height() ) / 2;
						
						if(drawOutlinePixmap) {
							p->drawPixmap( dx-1, dy-1, outlinePixmap );
						}
						
						p->drawPixmap( dx, dy, pixmap );
					}
				}
				
				else if (tb->iconTextMode() == TDEToolBar::IconTextRight) // icon and text (if any)
				{
					if( !pixmap.isNull())
					{
						dx = 4;
						dy = ( tb->height()-1 - pixmap.height() ) / 2;
						
						if(drawOutlinePixmap) {
							p->drawPixmap( dx-1, dy-1, outlinePixmap );
						}
						
						p->drawPixmap( dx, dy, pixmap );
					}
					if (!tb->textLabel().isNull())
					{
						textFlags = AlignVCenter|AlignLeft;
						if (!pixmap.isNull())
							dx = 4 + pixmap.width() + 2;
						else
							dx = 4;
						dy = 0;
	
						textRect = TQRect(dx, dy, tb->width()-dx, tb->height()-1);
					}
				}
				else if (tb->iconTextMode() == TDEToolBar::TextOnly)
				{
					if (!tb->textLabel().isNull())
					{
						textFlags = AlignVCenter|AlignLeft;
						dx = (tb->width() - fm.width(tb->textLabel())) / 2;
						dy = (tb->height()-1 - fm.lineSpacing()) / 2;
	
						textRect = TQRect( dx, dy, fm.width(tb->textLabel()), fm.lineSpacing() );
					}
				}
				else if (tb->iconTextMode() == TDEToolBar::IconTextBottom)
				{
					if( !pixmap.isNull())
					{
						dx = (tb->width() - pixmap.width()) / 2;
						dy = (tb->height()-1 - fm.lineSpacing() - pixmap.height()) / 2;
						
						if(drawOutlinePixmap) {
							p->drawPixmap( dx-1, dy-1, outlinePixmap );
						}
						
						p->drawPixmap( dx, dy, pixmap );
					}
	
					if (!tb->textLabel().isNull())
					{
						textFlags = AlignBottom|AlignHCenter;
						dx = (tb->width() - fm.width(tb->textLabel())) / 2;
						dy = tb->height()-1 - fm.lineSpacing() - 4;
	
						textRect = TQRect( dx, dy, fm.width(tb->textLabel()), fm.lineSpacing() );
					}
				}
				if (!tb->textLabel().isNull() && !textRect.isNull())
				{
					p->setFont(TDEGlobalSettings::toolBarFont());
					TQColor pencolor;
					if (!tb->isEnabled())
						pencolor = tb->palette().disabled().dark();
					// replaced through icon highlights
// 					else if(tb->isRaised())
// 						pencolor = TDEGlobalSettings::toolBarHighlightColor();
					else
						pencolor =  tb->colorGroup().buttonText();
					
					dominoDrawItem( p, textRect, textFlags, cg, enabled, 0, tb->textLabel(), -1, &pencolor, textEffectSettings.mode > 0 ? 1 : 0);
				}
			}
			else { // TQToolButton - bye bye win95 iconset mode :)
				
				const TQToolButton *toolbutton = (const TQToolButton *) widget;
				TQRect rect = r;
				TQt::ArrowType arrowType = opt.isDefault() ? TQt::DownArrow : opt.arrowType();
				
				if (!opt.isDefault()) {
					PrimitiveElement pe;
					switch (arrowType) {
						case TQt::LeftArrow:  pe = PE_ArrowLeft;  break;
						case TQt::RightArrow: pe = PE_ArrowRight; break;
						case TQt::UpArrow:    pe = PE_ArrowUp;    break;
						default:
						case TQt::DownArrow:  pe = PE_ArrowDown;  break;
					}
					
					drawPrimitive(pe, p, ceData, elementFlags, rect, cg, flags, opt);
				}
				else {
					
					TQColor btext = toolbutton->paletteForegroundColor();

					if (toolbutton->iconSet().isNull() && ! toolbutton->text().isNull() && ! toolbutton->usesTextLabel()) {
						int alignment = AlignCenter | ShowPrefix;
						if (!styleHint(SH_UnderlineAccelerator, ceData, elementFlags, TQStyleOption::Default, 0, widget))
							alignment |= NoAccel;
						dominoDrawItem( p, rect, alignment, cg, enabled, 0, toolbutton->text(), toolbutton->text().length(), &btext, textEffectSettings.mode > 0 ? 1 : 0);
					}
					else {
						TQPixmap pm;
						TQIconSet::Size size = toolbutton->usesBigPixmap() ? TQIconSet::Large : TQIconSet::Small;
						TQIconSet::State state = toolbutton->isOn() ? TQIconSet::On : TQIconSet::Off;
						TQIconSet::Mode mode;
/*						if (!toolbutton->isEnabled())
							mode = TQIconSet::Disabled;
						else*/ if (flags & (Style_Down | Style_On) || (flags & Style_Raised) && (flags & Style_AutoRaise))
							mode = TQIconSet::Active;
						else
							mode = TQIconSet::Normal;
						
						pm = toolbutton->iconSet().pixmap( size, mode, state );
						
						if(!toolbutton->isEnabled())
							pm = disableIcon(&pm);
						
						TQImage img = pm.convertToImage();
						if((_toolBtnAsBtn || toolbutton->isToggleButton()) && (toolbutton->isDown() || toolbutton->isOn()))
							pm = KImageEffect::fade(img, 0.10, black);
						else if(toolbutton->isDown() || toolbutton->isOn())
							pm = KImageEffect::fade(img, 0.15, black);
						else if(_highlightToolBtnIcon && toolbutton->hasMouse() && toolbutton->isEnabled())
							pm = KImageEffect::fade(img, 0.25, white);
						
						TQPixmap outlinePixmap = 0;
						bool drawOutlinePixmap = false;
						if(flags &TQStyle::Style_HasFocus && focusIndicatorSettings.indicateFocus) {
							outlinePixmap = renderOutlineIcon(&pm);
							drawOutlinePixmap = true;
						}
						
						if ( toolbutton->usesTextLabel() ) {
							p->setFont( toolbutton->font() );
							TQRect pr = rect, tr = rect;
							int alignment = ShowPrefix;
							if (!styleHint(SH_UnderlineAccelerator, ceData, elementFlags, TQStyleOption::Default, 0, widget))
								alignment |= NoAccel;

							if ( toolbutton->textPosition() == TQToolButton::Under ) {
								int fh = p->fontMetrics().height();
								pr.addCoords( 0, 1, 0, -fh-3 );
								tr.addCoords( 0, pr.bottom(), 0, -3 );
								
								if(drawOutlinePixmap)
									drawItem( p, pr, AlignCenter, cg, TRUE, &outlinePixmap, TQString::null );
								
								drawItem( p, pr, AlignCenter, cg, TRUE, &pm, TQString::null );
								alignment |= AlignCenter;
							} else {
								pr.setWidth( pm.width() + 8 );
								tr.addCoords( pr.right(), 0, 0, 0 );
								
								if(drawOutlinePixmap)
									drawItem( p, pr, AlignCenter, cg, TRUE, &outlinePixmap, TQString::null );
								
								drawItem( p, pr, AlignCenter, cg, TRUE, &pm, TQString::null );
								alignment |= AlignLeft | AlignVCenter;
							}
							dominoDrawItem( p, tr, alignment, cg, enabled, 0, toolbutton->textLabel(), toolbutton->textLabel().length(), &btext, textEffectSettings.mode > 0 ? 1 : 0);
						}
						else {
							if(drawOutlinePixmap)
								drawItem( p, rect, AlignCenter, cg, TRUE, &outlinePixmap, TQString::null );
							
							drawItem( p, rect, AlignCenter, cg, TRUE, &pm, TQString::null );
						}
					}
				}
			}
			break;
		}

	// PROGRESSBAR
	// -----------
		case CE_ProgressBarGroove: {
			drawPrimitive(PE_Panel, p, ceData, elementFlags, r, cg, flags, opt);
			break;
		}

		case CE_ProgressBarContents: {
			
			const TQProgressBar *pb = dynamic_cast<const TQProgressBar*>(widget);
			int steps = pb->totalSteps();
			
			const TQColor bg = enabled? cg.base(): cg.background(); // background
			const TQColor fg = cg.background();
			bool reverseLayout = TQApplication::reverseLayout();
			
			TQPixmap* prBgShadow;
			
			int h, s, v, bv;
			bg.getHsv(&h, &s, &v);
			cg.background().getHsv(&h, &s, &bv);
			int diff = KMAX(v-bv, 0);
			
			// if we don't adjust the shadow to the background, it will look strange
			TQColor tintColor = alphaBlendColors(TQt::black, bg, diff+30);
			
			if(!(prBgShadow = TQPixmapCache::find(TQString::number(bg.pixel(), 16)+TQString::number(cg.background().pixel(), 16)+"prBgShadow"))) {
				prBgShadow = new TQPixmap(4,4);
				prBgShadow->fill(bg);
				TQPainter painter(prBgShadow);
				painter.drawPixmap(0, 0, tintImage(qembed_findImage("progressShadow2"), tintColor));
				TQPixmapCache::insert(TQString::number(bg.pixel(), 16)+TQString::number(cg.background().pixel(), 16)+"prBgShadow", prBgShadow);
			}
			
			TQRect surface;
			TQRect rightBg;
			TQRect leftBg;
			p->setClipRegion(r);
			
			
			if( steps == 0 ) { // Busy indicator
				static const int barWidth = 10;
				int progress = pb->progress() % (2*(r.width()-barWidth));
				if( progress < 0)
					progress = 0;
				if( progress > r.width()-barWidth )
					progress = (r.width()-barWidth)-(progress-(r.width()-barWidth));
				
				surface  = TQRect(reverseLayout? r.right()-progress+1: r.x()+progress+1, r.top(), barWidth-2, r.height());
				rightBg = reverseLayout ? TQRect(r.x(), r.y(), r.width()-(progress-1), r.height()) :
						TQRect(r.x()+progress+barWidth-1, r.y(), r.width()-(progress+barWidth-1), r.height());
				
				if(rightBg.width()+surface.width() < r.width()) {
					leftBg = reverseLayout ? TQRect(rightBg.width()+surface.width(), r.y(), r.width()-(rightBg.width()+surface.width()-2), r.height()) :
							TQRect(r.x(), r.y(), r.x()+progress+1, r.height());
				}
			}
			else {
				double percent = static_cast<double>(pb->progress()) / static_cast<double>(steps);
				int w = static_cast<int>(r.width() * percent);
				if(w < 0)
					w = 0;
				int w2 = r.width()-(r.width()-w);
				rightBg = TQRect(reverseLayout? r.left(): r.left()+w, r.top(), r.width()-w, r.height());
				surface = TQRect(reverseLayout? r.right()-w2+1: r.left(), r.top(), w2, r.height());
			}
			
			
			
			TQPixmap* surfaceTile;
			if(!(surfaceTile = TQPixmapCache::find("prTile"+TQString::number(surface.height())+TQString::number(bg.pixel(), 16)))) {
				surfaceTile = new TQPixmap(20, surface.height());
				TQPainter tilePainter(surfaceTile);
				
				flatMode=true;
				renderSurface(&tilePainter, TQRect(0, 0, 20, surface.height()), fg,  cg.background(), fg , Is_Button|Is_Horizontal);
				flatMode=false;
				
				TQPixmap pix = qembed_findImage("progressTile");
				tilePainter.drawTiledPixmap(0,0, 20, surface.height(), pix);
				
				TQPixmapCache::insert("prTile"+TQString::number(surface.height())+TQString::number(bg.pixel(), 16), surfaceTile);
			}
			
			
			int staticShift = 0;
			int animShift = 0;
			
			// find the animation Offset for the current Widget
			TQWidget* nonConstWidget = const_cast<TQWidget*>(widget);
			TQMapConstIterator<TQWidget*, int> iter = progAnimWidgets.find(nonConstWidget);
			if (iter != progAnimWidgets.end())
				animShift = iter.data();
			
			int counter = 0;
			while(counter < (surface.width()+20)) {
				counter += 20;
				if (reverseLayout) {
					p->drawPixmap(surface.right()-counter+animShift+staticShift+1, r.top(), *surfaceTile);
				}
				else {
					p->drawPixmap(surface.left()+counter-20-animShift+staticShift, r.top(), *surfaceTile);
				}
			}
			
			
			// empty area
			
			TQColor color_d = alphaBlendColors(tintColor, bg, 170);
			TQColor color_m = alphaBlendColors(tintColor, bg, 85);
			TQColor color_l = alphaBlendColors(tintColor, bg, 25);
			
			if(leftBg.isValid()) {
				p->setClipRegion(leftBg);
				p->fillRect(leftBg, bg);
				
				p->setPen(color_d);
				p->drawLine(leftBg.x()+2, leftBg.y(), leftBg.right()-2, leftBg.y());
				p->setPen(color_m);
				p->drawLine(leftBg.x()+2, leftBg.y()+1, leftBg.right()-2, leftBg.y()+1);
				p->setPen(color_l);
				p->drawLine(leftBg.x()+2, leftBg.y()+2, leftBg.right()-2, leftBg.y()+2);
				p->drawLine(leftBg.x()+2, leftBg.bottom(), leftBg.right()-2, leftBg.bottom());

				//p->setPen(color_l);
				p->drawLine(leftBg.x()+1, leftBg.y()+3, leftBg.x()+1, leftBg.bottom()-1); // l
				p->drawLine(leftBg.right()-1, leftBg.y()+3, leftBg.right()-1, leftBg.bottom()-1); // r
			
				p->setPen(color_m);
				p->drawLine(leftBg.x(), leftBg.y()+3, leftBg.x(), leftBg.bottom()-1); // l
				p->drawLine(leftBg.right(), leftBg.y()+3, leftBg.right(), leftBg.bottom()-1); // r
			
				p->drawPixmap(leftBg.right()-1, leftBg.y(), *prBgShadow, 2, 0, 2, 3); // tr
				p->drawPixmap(leftBg.x(), leftBg.y(), *prBgShadow, 0, 0, 2, 3);
				p->drawPixmap(leftBg.right()-1, leftBg.bottom(), *prBgShadow, 2, 3, 2, 1); // br
				p->drawPixmap(leftBg.x(), leftBg.bottom(), *prBgShadow, 0, 3, 2, 1);
			}
			
			p->setClipRegion(rightBg);
			p->fillRect(rightBg, bg);
			
			p->setPen(color_d);
			p->drawLine(rightBg.x()+2, rightBg.y(), rightBg.right()-2, rightBg.y());
			p->setPen(color_m);
			p->drawLine(rightBg.x()+2, rightBg.y()+1, rightBg.right()-2, rightBg.y()+1);
			p->setPen(color_l);
			p->drawLine(rightBg.x()+2, rightBg.y()+2, rightBg.right()-2, rightBg.y()+2);
			p->drawLine(rightBg.x()+2, rightBg.bottom(), rightBg.right()-2, rightBg.bottom());

			//p->setPen(color_l);
			p->drawLine(rightBg.x()+1, rightBg.y()+3, rightBg.x()+1, rightBg.bottom()-1); // l
			p->drawLine(rightBg.right()-1, rightBg.y()+3, rightBg.right()-1, rightBg.bottom()-1); // r
			
			p->setPen(color_m);
			p->drawLine(rightBg.x(), rightBg.y()+3, rightBg.x(), rightBg.bottom()-1); // l
			p->drawLine(rightBg.right(), rightBg.y()+3, rightBg.right(), rightBg.bottom()-1); // r
			
			
			p->drawPixmap(rightBg.right()-1, rightBg.y(), *prBgShadow, 2, 0, 2, 3); // tr
			p->drawPixmap(rightBg.x(), rightBg.y(), *prBgShadow, 0, 0, 2, 3);
			p->drawPixmap(rightBg.right()-1, rightBg.bottom(), *prBgShadow, 2, 3, 2, 1); // br
			p->drawPixmap(rightBg.x(), rightBg.bottom(), *prBgShadow, 0, 3, 2, 1);
			
			if(rightBg.width() == 2) { // must overpaint two lighter pixel
				p->drawPixmap(rightBg.right(), rightBg.y()+2, *prBgShadow, 0, 3, 1, 1); // br
				p->drawPixmap(rightBg.right(), rightBg.bottom(), *prBgShadow, 0, 3, 1, 1); // br
			}
			
			p->setClipping(false);

			break;
		}
		case CE_ProgressBarLabel: {
			const TQProgressBar *progressbar = (const TQProgressBar *) widget;
			TQFont font = p->font();
			font.setBold(false);
			p->setFont(font);
			p->setPen(cg.buttonText());
			//p->drawText(r, AlignCenter | SingleLine, progressbar->progressString());
			dominoDrawItem( p, r, AlignCenter | SingleLine, cg, false, 0, progressbar->progressString(), -1,&cg.buttonText(), false);
			break;
		}
		
		case CE_CheckBox: {
			
			TQColorGroup g = cg;
			if(!tdehtmlWidgets.contains(widget))
				g.setColor(TQColorGroup::Button, tqApp->palette().active().background());
			
			TQPixmap insidePix = qembed_findImage("checkbox2inside");
			TQPainter painter(&insidePix);
			renderSurface(&painter, TQRect(3, 0, 14, 19), g.background(), g.button(), g.button(), Is_CheckItem);
			painter.end();
			TQImage inside = insidePix.convertToImage();
			
			TQImage checkbox;
			TQImage shadow = qembed_findImage("checkbox2shadow");
			TQImage circle = tintImage(qembed_findImage("checkbox2rect"), buttonContour->contourColor(Contour_Default));
			blend(shadow, inside, checkbox);
			blend(circle, checkbox, checkbox);
			
			if(flags&Style_Down) {
				TQImage pressed = tintImage(qembed_findImage("checkbox2pressed"), buttonContour->contourColor(Contour_Pressed));
				blend(pressed, checkbox, checkbox);
			}
			
			TQPixmap pix = TQPixmap(checkbox);
			if(flags&Style_On || flags&Style_NoChange) {
				painter.begin(&pix);
				drawPrimitive(PE_CheckMark, &painter, ceData, elementFlags, r, cg, flags);
				painter.end();
			}
			
			p->drawPixmap(r.left(), r.top(), pix);
			break;
		}
		
		case CE_CheckBoxLabel: {
			const TQCheckBox *cb = (const TQCheckBox *) widget;

			int alignment = TQApplication::reverseLayout() ? AlignRight : AlignLeft;
			if (!styleHint(SH_UnderlineAccelerator, ceData, elementFlags, TQStyleOption::Default, 0, widget))
				alignment |= NoAccel;
			
			TQRect re = focusIndicatorSettings.drawUnderline ? subRect(SR_CheckBoxFocusRect, ceData, elementFlags, cb) : r;
			
			if (flags& Style_HasFocus && focusIndicatorSettings.indicateFocus)
				drawFocusIndicator(p, re, alignment | AlignVCenter |ShowPrefix, cg, flags & Style_Enabled, cb->pixmap(), cb->text(), -1, focusIndicatorSettings.color, focusIndicatorSettings.drawUnderline);

			drawItem(p, r, alignment | AlignVCenter | ShowPrefix, cg,
				flags & Style_Enabled, cb->pixmap(), cb->text());
			break;
		}

	// RADIOBUTTONS
	// ------------
		case CE_RadioButton: {
			TQColorGroup g = cg;
			if(!tdehtmlWidgets.contains(widget))
				g.setColor(TQColorGroup::Button, tqApp->palette().active().background());
			
			TQString down = flags& Style_Down ? "1" : "0";
			
			TQPixmap* radio;
			if((flags & Domino_noCache) || !(radio = TQPixmapCache::find("tabEdges"+down))) {
				TQImage radioImg;
				
				TQPixmap insidePix = qembed_findImage("radio3inside");
				TQPainter painter(&insidePix);
				renderSurface(&painter, TQRect(r.left(), r.top(), r.width(), r.height()+1), g.background(), g.button(), g.background(), Is_CheckItem);
				TQImage inside = insidePix.convertToImage();
				
				TQImage shadow = qembed_findImage("radio3shadow");
				TQImage circle = tintImage(qembed_findImage("radio3circle"), buttonContour->contourColor(Contour_Default));
				blend(shadow, inside, inside);
				blend(circle, inside, radioImg);
				
				if(flags&Style_Down) {
					TQImage pressed = tintImage(qembed_findImage("radio3pressed"), buttonContour->contourColor(Contour_Default));
					blend(pressed, radioImg, radioImg);
				}
				
				radio = new TQPixmap(radioImg);
				if(!(flags & Domino_noCache))
					TQPixmapCache::insert("radio"+down, radio);
			
			}

			if(flags & Style_On) {
				if(flags & Style_Enabled)
					bitBlt(radio, 6, 6, radioIndicator, 0, 0, 5, 5);
				else
					bitBlt(radio, 6, 6, radioIndicator, 5, 0, 5, 5);
			}
			
			bitBlt(p->device(), r.x(), r.y(), radio);
			break;
		}
		
		case CE_RadioButtonLabel: {
			const TQRadioButton *radiobutton = (const TQRadioButton *) widget;

			int alignment = TQApplication::reverseLayout() ? AlignRight : AlignLeft;
			if (!styleHint(SH_UnderlineAccelerator, ceData, elementFlags, TQStyleOption::Default, 0, widget))
			alignment |= NoAccel;
			
			TQRect re = focusIndicatorSettings.drawUnderline ? subRect(SR_RadioButtonFocusRect, ceData, elementFlags, radiobutton) : r;
			
			if (flags& Style_HasFocus && focusIndicatorSettings.indicateFocus)
				drawFocusIndicator(p, re, alignment | AlignVCenter |ShowPrefix, cg, flags & Style_Enabled, radiobutton->pixmap(), radiobutton->text(), -1, focusIndicatorSettings.color, focusIndicatorSettings.drawUnderline);
			
			drawItem(p, r, alignment | AlignVCenter | ShowPrefix, cg,
				flags & Style_Enabled, radiobutton->pixmap(), radiobutton->text());
			
			break;
		}

	// TABS
	// ----
		case CE_TabBarTab: {
			
			TQTabBar * tb = (TQTabBar *) widget;
			
			bool konqTab = false;
			bool kickoffTab = false;
			if(tb->parentWidget()) {
				const TQWidget* w = tb->parentWidget();
				if(w->isA("KonqFrameTabs"))
					konqTab = true;
				else if(!strcmp(w->name(), "SUSE::Kickoff::KMenu"))
					kickoffTab = true;
			}

			TQTabBar::Shape tbs = tb->shape();
			bool selected = false;
			bool reverseLayout = TQApplication::reverseLayout();
			if (flags & Style_Selected) selected = true;
			TabPosition pos;
			if (tb->count() == 1) {
				pos = Single;
			} else if ((tb->indexOf(opt.tab()->identifier()) == 0)) {
				pos = reverseLayout?Last:First;
			} else if (tb->indexOf(opt.tab()->identifier()) == tb->count() - 1) {
				pos = reverseLayout?First:Last;
			} else {
				pos = Middle;
			}
			
			switch (tbs) {
				case TQTabBar::TriangularAbove:
					renderTab(p, r, cg, (flags & Style_MouseOver), selected, false, pos, true, false, konqTab);
					break;
				case TQTabBar::RoundedAbove:
					renderTab(p, r, cg, (flags & Style_MouseOver), selected, false, pos, false, false, konqTab);
					break;
				case TQTabBar::TriangularBelow:
					renderTab(p, r, cg, (flags & Style_MouseOver), selected, true, pos, true, false, konqTab);
					break;
				case TQTabBar::RoundedBelow:
					renderTab(p, r, cg, (flags & Style_MouseOver), selected, true, pos, false, false, konqTab);
					break;
				default:
					TDEStyle::drawControl(element, p, ceData, elementFlags, r, cg, flags, opt, widget);
			}
			
			// TQt3 uses this painter to draw the iconSet between CE_TabBarTab and CE_TabBarLabel. If we clip the painter here
			// we will have a clean area to draw the icon at the right position in CE_TabBarLabel.
			if(!kickoffTab)
				p->setClipRect(TQRect());
			break;
		}

		case CE_PushButton: {
			
			TQPushButton *button = (TQPushButton *)widget;
			bool tdehtmlMode = tdehtmlWidgets.contains(button);
			bool isDefault = enabled && button->isDefault();
			bool isHoverWidget = enabled && button == hoverWidget;
			bool isSunken = flags & Style_On || flags & Style_Down;
			
			uint contourFlags = Draw_Left|Draw_Right|Draw_Top|Draw_Bottom;
			uint surfaceFlags = Is_Button|Is_Horizontal;
			flatMode = button->isFlat();
			
			TQColor bg;
			if(!tdehtmlMode && !button->paletteBackgroundPixmap()) {
				
				if(dynamic_cast<TQGroupBox*>(button->parentWidget())) {
					bg = button->parentWidget()->paletteBackgroundColor();
				}
				else {
					bg = cg.background();
				}
				
				p->fillRect(TQRect(r.x(), r.y(), 6, 6), bg);
				p->fillRect(TQRect(r.width()-6, r.y(), 6, 6), bg);
				p->fillRect(TQRect(r.width()-6, r.height()-7, 6,7), bg);
				p->fillRect(TQRect(r.x(), r.height()-7, 6, 7), bg);
			}
			else {
				buttonContour->setAlphaMode();
				contourFlags|=Draw_AlphaBlend;
			}
			if(tdehtmlMode) contourFlags|=Draw_AlphaBlend;
			if(!enabled) {
				contourFlags|=Is_Disabled;
				surfaceFlags|=Is_Disabled;
			}
			if(isSunken) {
				surfaceFlags|=Is_Down;
				contourFlags|=Is_Down;
			}
			
			if(button->isDown())
				buttonContour->setState(Contour_Pressed);
			else if(isHoverWidget)
				buttonContour->setState(Contour_MouseOver);
			else if(isDefault)
				buttonContour->setState(Contour_DefaultButton);
			
			if(!flatMode) {
				renderSurface(p, TQRect(r.x()+2, r.y()+2, r.width()-4, r.height()-5), cg.background(), cg.button(), cg.button(), surfaceFlags);
				
				contourFlags |= Round_UpperLeft|Round_UpperRight|Round_BottomLeft|Round_BottomRight|Is_Button|Is_Horizontal;
 				renderContour(p, r, bg, cg.button(), contourFlags);
				
				if(isSunken) {
					renderButtonShadow(p, TQRect(r.x()+2, r.y()+2, r.width()-2, r.height()-3), contourFlags);
				}
			}
			else {
				renderSurface(p, TQRect(r.x()-3, r.y()-1, r.width()+6, r.height()+2), cg.background(), cg.button(), cg.button(), surfaceFlags);
				
				TQColor contourColor = alphaBlendColors(buttonContour->contourColor(buttonContour->state), cg.background(), 179);
				p->setPen(contourColor);
				if(dynamic_cast<KMultiTabBarTab*>(button)) {
					
					const TQWidget* parent = button->parentWidget();
					bool horizontal = parent->width() >= parent->height();
					
					KMultiTabBar* tabBar = static_cast<KMultiTabBar*>(widget->parentWidget()->parentWidget()->parentWidget()->parentWidget());
					
					KMultiTabBarTab* tab;
					TQPtrList<KMultiTabBarTab>* list = tabBar->tabs();
					for(tab = list->first(); tab; tab = list->next()) {
						if(horizontal && tab->x()+tab->width() == widget->x())
							break;
						else if(tab->y()+tab->height() == widget->y())
							break;
					}
					
					if(tab) {
						TQPainter painter(tab);
						painter.setPen(contourColor);
						TQRect re = tab->rect();
						if(horizontal)
							painter.drawLine(re.right(), re.y(), re.right(), re.bottom()); // right lines
						else
							painter.drawLine(re.x(), re.bottom(), re.right(), re.bottom());
					}
					
					if(horizontal) {
						if(button->x() == parent->x())
							p->drawLine(r.x(), r.y(), r.x(), r.bottom()); // first left line
						p->drawLine(r.right(), r.y(), r.right(), r.bottom()); // right lines
					}
					else {
						if(button->y() == parent->y())
							p->drawLine(r.right(), r.y(), r.right(), r.bottom());
						p->drawLine(r.x(), r.y(), r.x(), r.bottom());
					}
					// middle lines
					p->drawLine(r.x(), r.y(), r.right(), r.y());
					p->drawLine(r.x(), r.bottom(), r.right(), r.bottom());
					
// 					if(isSunken) {
// 						contourFlags = Draw_Top|Draw_Left|Draw_Right|Draw_Bottom|Rectangular_UpperLeft|Rectangular_UpperRight|Rectangular_BottomLeft|Rectangular_BottomRight;
// 						renderButtonShadow(p, TQRect(r.x()-1, r.y()-1, r.width()+5, r.height()+2), contourFlags);
// 						renderButtonShadow(p, re), contourFlags);
// 					}
					
					
				}
				else {
					p->drawRect(r);
				}
				flatMode = false;
			}
			
			buttonContour->reset();
			break;
		}
		
		case CE_PushButtonLabel:
		{
			
			int x, y, w, h;
			r.rect( &x, &y, &w, &h );
			
			const TQPushButton* button = static_cast<const TQPushButton *>( widget );
			bool cornArrow = false;
			bool hasFocus = button->hasFocus();

			p->setPen(button->colorGroup().buttonText());
			
			// Does the button have a popup menu?
			if ( button->popup() )
			{
				int dx = pixelMetric( PM_MenuButtonIndicator, ceData, elementFlags, widget );
				if ( button->iconSet() && !button->iconSet()->isNull()	&&
					(dx + button->iconSet()->pixmap (TQIconSet::Small, TQIconSet::Normal, TQIconSet::Off ).width()) >= w )
				{
					cornArrow = true; //To little room. Draw the arrow in the corner, don't adjust the widget
				}
				else
				{
					drawPrimitive( PE_ArrowDown, p, ceData, elementFlags, visualRect( TQRect(x + w - dx - 8, y + 3, dx, h - 3), r ), cg, flags, opt );
					w -= dx;
				}
			}
			
			
			// Draw the icon if there is one
			if ( button->iconSet() && !button->iconSet()->isNull() )
			{
				TQIconSet::Mode	mode  = TQIconSet::Disabled;
				TQIconSet::State state = TQIconSet::Off;
				
				if (button->isEnabled())
					mode = button->hasFocus() ? TQIconSet::Active : TQIconSet::Normal;
				if (button->isToggleButton() && button->isOn())
					state = TQIconSet::On;
				
				TQPixmap pixmap = button->iconSet()->pixmap( TQIconSet::Small, mode, state );
				bool focusIcon = hasFocus && focusIndicatorSettings.indicateFocus && !focusIndicatorSettings.drawUnderline;
				int pw = pixmap.width();
				
				if(button->text().isEmpty()) {
					int bpw = button->pixmap() ? button->pixmap()->width() : 0;
					if(focusIcon) {
						TQPixmap outlinePixmap = renderOutlineIcon(&pixmap);
						p->drawPixmap( x + (w - bpw -outlinePixmap.width())/2, y + (h - outlinePixmap.height())/ 2, outlinePixmap );
					}
					p->drawPixmap( x + (w - bpw - pw)/2, y + (h- pixmap.height()) / 2, pixmap );
				}
				else {
					int cw = p->fontMetrics().size(TQt::ShowPrefix, button->text()).width()+pw;
					if(focusIcon) {
						TQPixmap outlinePixmap = renderOutlineIcon(&pixmap);
						p->drawPixmap( x + (w - cw)/2 - 1 , y + (h - outlinePixmap.height())/ 2, outlinePixmap );
					}
					p->drawPixmap( x + (w - cw)/2 , y + (h - pixmap.height())/ 2, pixmap );
					
				}
				
				if (cornArrow) //Draw over the icon
					drawPrimitive( PE_ArrowDown, p, ceData, elementFlags, visualRect( TQRect(x + w - 6, x + h - 6, 7, 7), r ), cg, flags, opt );
				
				x += pw + 4;
				w -= pw + 4;
			}
			
			TQRect re = focusIndicatorSettings.drawUnderline ? subRect(SR_PushButtonFocusRect, ceData, elementFlags, button) : TQRect(x, y, w, h);
			
			if(hasFocus && focusIndicatorSettings.indicateFocus && !button->text().isNull())
				drawFocusIndicator(p, re, AlignCenter|ShowPrefix, cg, button->isEnabled(), 0, button->text(), -1, focusIndicatorSettings.buttonColor, focusIndicatorSettings.drawUnderline, true);
			
			TQPixmap buttonPixmap;
			if(button->pixmap()) {
				if(!enabled)
					buttonPixmap = disableIcon(button->pixmap());
				else
					buttonPixmap = *button->pixmap();
			}
			dominoDrawItem( p, TQRect(x, y, w, h), AlignCenter|ShowPrefix, button->colorGroup(),
					enabled, button->pixmap() ? &buttonPixmap : 0, button->text(), -1, &button->colorGroup().buttonText(), textEffectSettings.mode > 0 ? 1 : 0 );

			break;
		}
		case CE_TabBarLabel: {
			p->setClipping(false); // was set in CE_TabBarTab to clip the icon drawing
			
			if ( opt.isDefault() )
				break;
			const TQTabBar * tb = (const TQTabBar *) widget;
			TQTab * t = opt.tab();
			bool konqTab = false;
			bool kickoffTab = false;
			int shift, cshift;
			
			switch (tb->shape()) {
				case TQTabBar::RoundedAbove:
					shift = 4;
					cshift = 3;
					break;
				case TQTabBar::RoundedBelow:
					if((konqTab = tb->parentWidget() && tb->parentWidget()->isA("KonqFrameTabs")) ||
							(kickoffTab = tb->parentWidget() && !strcmp(tb->parentWidget()->name(), "SUSE::Kickoff::KMenu"))) {
						shift = 0;
						cshift = 0;
					}
					else {
						shift = -3;
						cshift = -1;
					}
					break;
				case TQTabBar::TriangularAbove:
					shift = 4;
					cshift = 3;
					break;
				case TQTabBar::TriangularBelow:
					shift = -5;
					cshift = -3;
					break;
				default:
					shift = 0;
					cshift = 0;
			}

			TQRect tr = r;
			bool currentTab =  t->identifier() == tb->currentTab();
			if (!currentTab)
				tr.setTop( tr.top() +shift );
			else
				tr.setTop( tr.top() +cshift );

			int alignment = AlignCenter | ShowPrefix;
			
			if (flags& Style_HasFocus && focusIndicatorSettings.indicateFocus && !t->text().isEmpty())
				drawFocusIndicator(p, TQRect(tr.x(), tr.y(), tr.width(), tr.height()), alignment, cg, flags & Style_Enabled, 0, t->text(), -1, focusIndicatorSettings.buttonColor, focusIndicatorSettings.drawUnderline, true);
			
			if(t->iconSet() && !tb->isA("KickoffTabBar")) {
				bool enabled = t->isEnabled() && tb->isEnabled();
				TQPixmap pixmap;
				
				if(!TDEApplicationMode) {
					TQIconSet::Mode mode = (t->identifier() && tb->keyboardFocusTab()) ? TQIconSet::Active : TQIconSet::Normal;
					pixmap = t->iconSet()->pixmap( TQIconSet::Small, mode );
					if(!enabled)
						pixmap = disableIcon(&pixmap);
				}
				else {
					TQIconSet::Mode mode = enabled ? TQIconSet::Normal : TQIconSet::Disabled;
					if ( mode == TQIconSet::Normal && (t->identifier() && tb->keyboardFocusTab()) )
						mode = TQIconSet::Active;
					pixmap = t->iconSet()->pixmap( TQIconSet::Small, mode );
				}
				
				int pixw = pixmap.width();
				int pixh = pixmap.height();
				TQRect ir = r;
				ir.setLeft( tr.left() - pixw - 4 );
				ir.setRight( tr.right() - 2 );
				int yoff = 0;
				if(!currentTab) {
					yoff = pixelMetric(TQStyle::PM_TabBarTabShiftVertical, ceData, elementFlags, tb);
				}
				
				switch(tb->shape()) {
					case TQTabBar::RoundedAbove:
					case TQTabBar::TriangularAbove:
						ir.setHeight(ir.height()+4);
						break;
					default:
						if(!konqTab)
							ir.setHeight(ir.height()-2);
				}
				
				p->drawPixmap( ir.left() + 2, ir.center().y()-pixh/2+ yoff, pixmap );
			}
			
			TQColor textColor = cg.foreground();
			if(konqTab)
				textColor = cg.foreground() != tb->palette().active().foreground() ? cg.foreground() : tb->palette().active().foreground();
			else if(konsoleMode)
				textColor = tb->palette().active().foreground();
			
			dominoDrawItem( p, tr, alignment, cg, flags & Style_Enabled, 0, t->text(), -1, &textColor/*&cg.foreground()*/, textEffectSettings.mode > 0 ? 1 : 0);
			break;
		}

		case CE_MenuBarItem: {
			
			bool active	 = flags & Style_Active;
			bool focused = flags & Style_HasFocus;
			bool down = flags & Style_Down;
			
			if (active && focused) {
				
				if(!macStyleBar)
					p->fillRect(r, cg.background()); // gtk-qt engine fix
				
				TQColor c = down ? dGetColor(cg.background(), 15) : dGetColor(cg.background(), 25);
				
				p->fillRect(TQRect(r.left()+3,r.y()+1, r.width()-7, r.height()), c);
				p->fillRect(TQRect(r.left(),r.top()+4, 3, r.height()-7), c);
				p->fillRect(TQRect(r.right()-3, r.y()+4, 3, r.height()-7), c);
		
				TQPixmap pix = tintImage(qembed_findImage("menuItem"), c);
				p->drawPixmap(r.left(),r.y()+1, pix, 0, 0, 3, 3);
				p->drawPixmap(r.left(),r.bottom()-2, pix, 0, 3, 3, 3);
				p->drawPixmap(r.right()-3,r.y()+1, pix, 3, 0, 3, 3);
				p->drawPixmap(r.right()-3,r.bottom()-2, pix, 3, 3, 3, 3);
			}
			
			p->setPen(cg.foreground() );
			drawItem(p, r, AlignVCenter | AlignHCenter | ShowPrefix | DontClip | SingleLine, cg, true, 0,
				 opt.menuItem()->text(), -1, &cg.foreground() );
			break;
		}

	// POPUPMENU ITEM (highlighted on mouseover)
	// ------------------------------------------
		case CE_PopupMenuItem: {
			
			const TQPopupMenu *popupmenu = static_cast< const TQPopupMenu * >( widget );
			TQMenuItem *mi = opt.menuItem();
			
			if ( !mi )
				break;
			
			bool checked = popupmenu->isCheckable() && mi->isChecked();
			int tab = opt.tabWidth();
			int maxpmw = mi->iconSet() || _indentPopupMenuItems ? opt.maxIconWidth() : 0;
			int cmwidth = _indentPopupMenuItems ? maxpmw ? 0 : 12 : 16; // checkmark, visible 10
			if(!_indentPopupMenuItems && checked)
				maxpmw += cmwidth-1;
			bool enabled = mi->isEnabled();
			bool active = flags & Style_Active;
			bool reverse = TQApplication::reverseLayout();
			bool separator = mi->isSeparator();
			
			
			TQColor color;
			if(separator || (active && enabled)) {
				
				color = separator ? dGetColor(_popupMenuColor, 20) : _selMenuItemColor;
				float val = 0;
				int ph = popupmenu->rect().height()/2;
				int part = separator ? TQMAX(1, ph/r.y()+r.height()) : TQMAX(1, ph/r.height());
					
				if(_drawPopupMenuGradient) {
					if(r.y()+r.height()/2 < ph) {
						for( int i=r.y(); i < ph; i += part) {
							val += 0.5;
						}
						color = lightenColor(color, (int)val);
					}
					else {
						for( int i=0; i < r.y()-ph; i += part) {
							val += 0.5;
						}
						color = darkenColor(color, (int)val);
					}
				}
			}
			
			
			
			// Draw the menu item background
			if (active) {
				if (enabled) {
					TQColor c = color;
					p->fillRect(TQRect(r.x()+3, r.y(), r.width()-6, r.height()), c);
					p->fillRect(TQRect(r.x(), r.y()+3, 3, r.height()-6), c);
					p->fillRect(TQRect(r.x()+r.width()-3, r.y()+3, 3, r.height()-6), c);
					
					TQPixmap pix = tintImage(qembed_findImage("menuItem"), c);
					bitBlt(p->device(), r.x(), r.y(), &pix, 0, 0, 3, 3, TQt::CopyROP);
					bitBlt(p->device(), r.x(), r.bottom()-2, &pix, 0, 3, 3, 3, TQt::CopyROP);
					bitBlt(p->device(), r.x()+r.width()-3, r.y(), &pix, 3, 0, 3, 3, TQt::CopyROP);
					bitBlt(p->device(), r.x()+r.width()-3, r.bottom()-2, &pix, 3, 3, 3, 3, TQt::CopyROP);
					
				}
			}
			
			// Are we a menu item separator?
			if(separator) {
				p->setPen(color);
				p->drawLine(r.x(), r.y()+2, r.right(), r.y()+2);
				break;
			}
			
			if(checked) {
				// We only have to draw the background if the menu item is inactive -
				// if it's active the "pressed" background is already drawn
				TQRect cmr = visualRect( TQRect( r.x()+itemFrame , r.y() + 1, TQMIN(TQMAX(maxpmw, cmwidth), r.height() - 2), r.height() - 2 ), r );
				
				// Draw the checkmark
				SFlags cflags = Style_On;
				if (enabled)
					cflags |= Style_Enabled;
				
				if(reverse && _indentPopupMenuItems)
					drawPrimitive( PE_CheckMark, p, ceData, elementFlags, TQRect(cmr.x() + (maxpmw ? (maxpmw-16)/2-4 : -1), cmr.y(), cmr.width(), cmr.height()), cg, cflags );
				else if(_indentPopupMenuItems)
					drawPrimitive( PE_CheckMark, p, ceData, elementFlags, TQRect(cmr.x() + (maxpmw ? (maxpmw-16)/2-3 : -6), cmr.y(), cmr.width(), cmr.height()), cg, cflags );
				else
					drawPrimitive( PE_CheckMark, p, ceData, elementFlags, TQRect(reverse ? cmr.x()+cmr.width()-15 : cmr.x()-3, cmr.y(), cmr.width(), cmr.height()), cg, cflags );
				
				
				
			}
			if(!(_indentPopupMenuItems && checked) && mi->iconSet()) {
				TQRect cr = visualRect( TQRect( (reverse ? r.x()-2 : r.x()) + itemFrame, r.y() + 1, maxpmw -1 , r.height() - 2 ), r );
				TQIconSet::Mode mode;

				// Select the correct icon from the iconset
				TQPixmap pixmap;
				if(TDEApplicationMode) {
					if (active)
						mode = enabled ? TQIconSet::Active : TQIconSet::Disabled;
					else
						mode = enabled ? TQIconSet::Normal : TQIconSet::Disabled;
					pixmap = mi->iconSet()->pixmap(TQIconSet::Small, mode);
				}
				else {
					pixmap = mi->iconSet()->pixmap(TQIconSet::Small, active ? TQIconSet::Active : TQIconSet::Normal);
					if(!enabled)
						pixmap = disableIcon(&pixmap);
				}
				
				if(checked && !reverse)
					cr.setX(cr.x()+cmwidth);
				p->drawPixmap( cr.x(), cr.y(), pixmap );
			}

			// Time to draw the menu item label...
			int xm =  itemFrame + maxpmw; // X position margin
			if(_indentPopupMenuItems)
				xm += cmwidth;
			
			int xp = reverse ? // X position
					r.x() + tab+ itemFrame*2 + itemHMargin + maxpmw +cmwidth + (_indentPopupMenuItems ? 16 : 0) - xm:
					r.x() + xm;
			

			// Label width (minus the width of the accelerator portion)
			int tw = r.width() - xm - tab - arrowHMargin - itemHMargin * 3 - itemFrame + 1;

			// Set the color for enabled and disabled text
			// (used for both active and inactive menu items)
			p->setPen( enabled ? cg.buttonText() : cg.mid() );

			// This color will be used instead of the above if the menu item
			// is active and disabled at the same time. (etched text)
			TQColor discol = cg.mid();

			// Does the menu item draw it's own label?
			if(mi->custom()) {
				int m = 2;
				// Save the painter state in case the custom
				// paint method changes it in some way
				mi->custom()->paint( p, cg, active, enabled, xp, r.y()+m, tw, r.height()-2*m );
			}
			else {
				// The menu item doesn't draw it's own label
				TQString s = mi->text();
				// Does the menu item have a text label?
				if ( !s.isNull() ) {
					int t = s.find( '\t' );
					int m = 2;
					int text_flags = AlignVCenter | ShowPrefix | DontClip | SingleLine;
					text_flags |= reverse ? AlignRight : AlignLeft;

					TQColor draw = (active && enabled) ? cg.highlightedText() : cg.foreground();
					p->setPen(draw);

					// Does the menu item have a tabstop? (for the accelerator text)
					if ( t >= 0 ) {
						
						int arrowMargin = (mi->popup() || _indentPopupMenuItems ) ? itemHMargin + arrowHMargin : 0;
						
						int tabx = reverse ? r.x() + arrowMargin + itemFrame : r.x() + r.width() - tab - arrowMargin- itemFrame;

						// Draw the right part of the label (accelerator text)
						//p->drawText( tabx, r.y()+m, tab, r.height()-2*m, text_flags, s.mid( t+1 ) );
						dominoDrawItem( p, TQRect(tabx, r.y()+m, tab, r.height()-2*m), text_flags, cg, flags & Style_Enabled, 0, s.mid( t+1 ), -1, &draw);
						s = s.left( t );
					}

					// Draw the left part of the label (or the whole label
					// if there's no accelerator)
					//p->drawText( xp, r.y()+m, tw, r.height()-2*m, text_flags, s, t );
					dominoDrawItem( p, TQRect(xp, r.y()+m, tw, r.height()-2*m), text_flags, cg, flags & Style_Enabled, 0, s, t, &draw);
					p->setPen(cg.text());
				}

				// The menu item doesn't have a text label
				// Check if it has a pixmap instead
				else if ( mi->pixmap() ) {
					TQPixmap *pixmap = mi->pixmap();

					// Draw the pixmap
					if ( pixmap->depth() == 1 )
						p->setBackgroundMode( OpaqueMode );

					int diffw = ( ( r.width() - pixmap->width() ) / 2 )
									+ ( ( r.width() - pixmap->width() ) % 2 );
					p->drawPixmap( r.x()+diffw, r.y()+1, *pixmap );

					if ( pixmap->depth() == 1 )
						p->setBackgroundMode( TransparentMode );
				}
			}

			// Does the menu item have a submenu?
			if ( mi->popup() ) {
				PrimitiveElement arrow = reverse ? PE_ArrowLeft : PE_ArrowRight;
				
				int dim = pixelMetric(PM_MenuButtonIndicator, ceData, elementFlags) - 1;
				TQRect vr = visualRect( TQRect( r.x() + r.width() - 5 - 1 - dim,
							r.y() + r.height() / 2 - dim / 2, dim, dim), r );

				TextEffect textEffectMode_save = textEffectSettings.mode;
				if(textEffectSettings.mode == TextEffect_OnlyButton)
					textEffectSettings.mode = TextEffect_None;
				if(enabled) {
					p->setPen(active? cg.highlightedText(): cg.foreground());
					drawPrimitive( arrow, p, ceData, elementFlags, vr, cg, Style_Enabled);
				}
				else {
					p->setPen(cg.mid());
					drawPrimitive( arrow, p, ceData, elementFlags, vr, cg, Style_Default);
				}
				textEffectSettings.mode = textEffectMode_save;
			}
			break;
		}

		case CE_ToolBoxTab: {
			
			bool selected= (flags & Style_Selected && ((TQToolBox*)widget)->currentItem());
			
			TQPixmap pix(widget->size());
			TQPainter painter(&pix);
			
			TQColor background = (flags&Style_Down && !selected) ? darkenColor(cg.background(), 15) : cg.background();
			
			painter.fillRect(TQRect(5, 0, r.width()-10, r.height()), background);
			renderGradient(&painter, TQRect(r.x(), r.y(), 5, r.height()), background.light(120), background, false);
			renderGradient(&painter, TQRect(r.width()-5, r.y(), 5, r.height()), background, background.light(115), false);
			painter.setPen(cg.background().dark(120));
			painter.drawLine(r.x(), r.bottom(), r.width(), r.bottom());
			painter.setPen((hoveredToolBoxTab && !selected) ? dGetColor(cg.background(), 95) : dGetColor(cg.background(), 45));
			
			PrimitiveElement arrow;
			TQRect re = TQRect(r.x()+6,r.y(),r.x()+10,r.height());
			if(selected) {
				arrow = PE_ArrowDown;
				re.setY(re.y()+1);
			}
			else {
				arrow = PE_ArrowRight;
			}
			drawPrimitive(arrow, &painter, ceData, elementFlags, re, cg, Style_Enabled);
			
			p->drawPixmap(r.x(), r.y(), pix);
			break;
		}
		
		case CE_HeaderLabel:
		{
			TQRect rect = r;
			const TQHeader* header = (const TQHeader *) widget;
			int section = opt.headerSection();

			TQIconSet* icon = header->iconSet( section );
			if ( icon ) {
				TQPixmap pixmap = icon->pixmap( TQIconSet::Small,
						flags & Style_Enabled ?
								TQIconSet::Normal : TQIconSet::Disabled );
				int pixw = pixmap.width();
				int pixh = pixmap.height();
				// "pixh - 1" because of tricky integer division

				TQRect pixRect = rect;
				pixRect.setY( rect.center().y() - (pixh - 1) / 2 );
				drawItem ( p, pixRect, AlignVCenter, cg, flags & Style_Enabled,
					   &pixmap, TQString::null );
				if (TQApplication::reverseLayout())
					rect.setRight(rect.right() - pixw - 2);
				else
					rect.setLeft(rect.left() + pixw + 2);
			}
			
			if (rect.isValid())
				dominoDrawItem ( p, rect, AlignVCenter, cg, flags & Style_Enabled,
					0, header->label( section ), -1, &(cg.buttonText()), textEffectSettings.mode > 0 ? 1 : 0 );
			break;
		}
		default:
		  TDEStyle::drawControl(element, p, ceData, elementFlags, r, cg, flags, opt, widget);
	}
}

void DominoStyle::drawControlMask(ControlElement element,
								  TQPainter *p,
								  const TQStyleControlElementData &ceData,
								  ControlElementFlags elementFlags,
								  const TQRect &r,
								  const TQStyleOption &opt,
								  const TQWidget *w) const
{

	switch (element) {
		case CE_PushButton: {
			break;
		}
		case CE_CheckBox: {
			drawPrimitive(PE_IndicatorMask, p, ceData, elementFlags, r, w->colorGroup(), Style_Default, opt);
			break;
		}
		case CE_RadioButton : {
			drawPrimitive(PE_ExclusiveIndicatorMask, p, ceData, elementFlags, r, w->colorGroup(), Style_Default, opt);
			break;
		}
		default: {
			break;
			//TDEStyle::drawControlMask (element, p, ceData, elementFlags, r, opt, w);
		}
	}
}

void DominoStyle::drawComplexControl(ComplexControl control,
									 TQPainter *p,
									 const TQStyleControlElementData &ceData,
									 ControlElementFlags elementFlags,
									 const TQRect &r,
									 const TQColorGroup &cg,
									 SFlags flags,
									 SCFlags controls,
									 SCFlags active,
									 const TQStyleOption& opt,
									 const TQWidget *widget) const
{
	const bool reverseLayout = TQApplication::reverseLayout();

	const bool enabled = (flags & Style_Enabled);

	//return TDEStyle::drawComplexControl(control, p, ceData, elementFlags, r, cg, flags, controls, active, opt, widget);
	
	switch(control) {

	// COMBOBOX
	// --------
		case CC_ComboBox: {

			static const unsigned int handleWidth = 15;
			const TQComboBox *cb = dynamic_cast<const TQComboBox*>(widget);
			bool editable = cb && cb->editable();
			bool isDown = cb && cb->listBox() && cb->listBox()->isVisible();
			bool hasFocus =(flags&Style_HasFocus);
			const TQColor inputColor = enabled ? (editable ? cg.base() : cg.button()) : cg.background();
			const TQColor bg = (cb && cb->parentWidget()) ?  cb->parentWidget()->paletteBackgroundColor() : cg.background();
			bool hasPixmap = cb && cb->count() > 0 && cb->pixmap(cb->currentItem());
			uint contourFlags = 0;
			bool isKhtmlWidget = tdehtmlWidgets.contains(cb);
			
			if(isKhtmlWidget || (cb && cb->parentWidget() && cb->parentWidget()->paletteBackgroundPixmap())) {
				contourFlags |= Draw_AlphaBlend;
				buttonContour->setAlphaMode();
			}
			else {
				p->fillRect(TQRect(r.x(), r.y(), 6, r.height()), bg);
				p->fillRect(TQRect(r.width()-6, r.y(), 6, r.height()), bg);
			}
			
			if(hasPixmap && editable && r.width() > 40) {
				int x = reverseLayout ? handleWidth+3 : 6;
				TQRegion mask(x, 0, 17, r.height());
				if(!reverseLayout)
					mask += TQRegion(x-2, 4, 2, r.height()-9);
				p->setClipRegion(mask);
			}
			
			contourFlags |= Round_UpperLeft|Round_BottomLeft|Round_UpperRight|Round_BottomRight|Draw_Right|Draw_Top|
					Draw_Bottom|Draw_Left|Is_Button|Is_Horizontal;
			uint surfaceFlags = Is_Button|Is_Horizontal;
			if(isDown) {
				surfaceFlags |= Is_Down;
				contourFlags |= Is_Down;
			}
			renderSurface(p, TQRect(r.left()+2, r.top()+2, r.width()-4, r.height()-5), cg.background(), cg.button(), cg.background(), surfaceFlags);
			
			if(isDown)
				buttonContour->setState(Contour_Pressed);
			else if(enabled && cb == hoverWidget)
				buttonContour->setState(Contour_MouseOver);
			renderContour(p, r, bg, cg.button(), contourFlags);
			
			
			if(editable) {
				TQColor lineEditColor = enabled ? cg.base() : cg.background();
				TQString isEnabled = enabled ? "1" : "0";
				TQPixmap* lineEditBtnEdges; // shared with spinwidget
				if(!(lineEditBtnEdges = TQPixmapCache::find(TQString::number(cg.button().pixel(), 16)+TQString::number(lineEditColor.pixel(), 16)+"lineEditBtnEdges"+isEnabled))) { // + buttoncolor
					
					// To not make the button contour appear thicker with dark button gradiens, we need a tad smaller rounding for the lineEdit edges.
					TQPixmap pixmap(1, r.height());
					TQPainter painter(&pixmap);
					flatMode = true;
					renderSurface(&painter, TQRect(0, 0, 1, r.height()), cg.background(), cg.button(), cg.background(), surfaceFlags);
					flatMode = false;
					TQImage img = pixmap.convertToImage();
					
					// Test, if we have a dark button. Not accurate, but...
					TQColor c1 = TQColor(img.pixel(0, r.y()+4));
					TQColor c2 = TQColor(img.pixel(0, r.height()-6));
					int v, v1, v2;
					c1.getHsv(&v, &v ,&v1);
					c2.getHsv(&v, &v ,&v2);
					TQImage edges = tintImage(qembed_findImage( (v1+v2)/2 < 200 ? "lineEditBtnEdges-d" : "lineEditBtnEdges"), lineEditColor);
					
					if(enabled) {
						TQImage shadow = qembed_findImage("lineEditBtnShadow");
						blend(shadow, edges, edges);
					}
					lineEditBtnEdges = new TQPixmap(edges);
					TQPixmapCache::insert(TQString::number(cg.button().pixel(), 16)+TQString::number(lineEditColor.pixel(), 16)+"lineEditBtnEdges"+isEnabled, lineEditBtnEdges);
				}
				
				if(reverseLayout) {
					bitBlt(p->device(), r.width()-6, r.y()+3, lineEditBtnEdges, 3, 0, 3, 3);
					bitBlt(p->device(), r.width()-6, r.height()-7, lineEditBtnEdges, 3, 3, 3, 3);
				}
				else {
					bitBlt(p->device(), r.x()+3, r.y()+3, lineEditBtnEdges, 0, 0, 3, 3);
					bitBlt(p->device(), r.x()+3, r.height()-7, lineEditBtnEdges, 0, 3, 3, 3);
				}
			}
			
			
			TQRect ar(reverseLayout ? r.left()+3 : r.width()-handleWidth-1, r.height()/2-2, handleWidth, 6);
			if(hasFocus && focusIndicatorSettings.indicateFocus && enabled && cb) {
				TQRect editField = querySubControlMetrics(control, ceData, elementFlags, SC_ComboBoxEditField, TQStyleOption::Default, widget);
				int pw = hasPixmap ? (cb->pixmap(cb->currentItem()))->width()+2 : 0;
				
				if(!editable) {
					int fmheight = p->fontMetrics().height();
					if(reverseLayout)
						editField.addCoords(pw+17, editField.height()/2-fmheight/2-1,0 , 0);
					else
						editField.addCoords(2+pw, editField.height()/2-fmheight/2-1,0 , 0);
					TQRect re = focusIndicatorSettings.drawUnderline ? subRect(SR_ComboBoxFocusRect, ceData, elementFlags, cb) : editField;
					drawFocusIndicator(p, re, AlignLeft, cg, true, 0, cb->currentText(), -1, focusIndicatorSettings.buttonColor, focusIndicatorSettings.drawUnderline, true);
				}
			}
			
			if(isDown) {
				uint shadowFlags = Draw_Top|Draw_Right|Draw_Bottom|Draw_Left;
				TQRect sr;
				if(editable) {
					shadowFlags |= reverseLayout? Round_UpperLeft|Round_BottomLeft|Rectangular_UpperRight|Rectangular_BottomRight :
							Rectangular_UpperLeft|Rectangular_BottomLeft|Round_UpperRight|Round_BottomRight;
					sr = TQRect(reverseLayout ? r.left()+2 : r.width()-handleWidth-3, r.y()+2, handleWidth+3, r.height()-3);
				}
				else {
					shadowFlags |= Round_UpperLeft|Round_BottomLeft|Round_UpperRight|Round_BottomRight;
					sr = TQRect(r.x()+2, r.y()+2, r.width()-2, r.height()-3);
				}
				
				renderButtonShadow(p, sr, shadowFlags);
			}
			buttonContour->reset();
			
			p->setPen(cb ? cb->palette().active().buttonText() : tqApp->palette().active().buttonText());
			uint aflags = Style_Default|Style_Raised;
			if(enabled)
				aflags |= Style_Enabled;
			drawPrimitive(PE_ArrowDown, p, ceData, elementFlags, ar, cg, aflags);
			
			p->setPen(cg.foreground());
			break;
		}
		
	// TOOLBUTTON
	// ----------
		case CC_ToolButton: {
			
			TQToolButton *tb = (TQToolButton *) widget;
			
			if(_toolBtnAsBtn && ::tqt_cast<TDEToolBarButton*>(tb)) {
				
				const bool reverse = TQApplication::reverseLayout();
				TDEToolBar *bar = dynamic_cast<TDEToolBar*>(tb->parentWidget());
				if(!bar) break;
				TDEToolBarButton* btn = ::tqt_cast<TDEToolBarButton*>(tb);
				TDEToolBarButton* prevBtn = 0;
				TDEToolBarButton* nextBtn = 0;
				bool prevBtnIsOn = false;
				bool nextBtnIsOn = false;
				bool isOn = flags &Style_On || flags &Style_Down;
				bool isDown = flags &Style_Down;
				const bool horizontal = bar->orientation() == TQt::Horizontal;
				
				TQRect cr = r , sr = r, bsr = r;
				int index = bar->itemIndex(btn->id());
				
				if(bar->getButton(bar->idAt(index-1))) {
					prevBtn = bar->getButton(bar->idAt(index-1));
					if((!reverse) ? (horizontal) ? prevBtn->x() + prevBtn->width() != btn->x() : prevBtn->y() + prevBtn->height() != btn->y() :
							(horizontal) ? prevBtn->x() != btn->x()+btn->width() : prevBtn->y() + prevBtn->height() != btn->y()
					  )
						prevBtn = 0;
					else
						prevBtnIsOn = prevBtn->isOn();
				}
				if(bar->getButton(bar->idAt(index+1))) {
					nextBtn= bar->getButton(bar->idAt(index+1));
					if((!reverse) ? (horizontal) ? nextBtn->x() != btn->x() + btn->width() : nextBtn->y() != btn->y() + btn->height() :
							(horizontal) ? nextBtn->x() + nextBtn->width() != btn->x() : nextBtn->y() != btn->y() + btn->height()
					   )
						nextBtn = 0;
					else
						nextBtnIsOn = nextBtn->isOn();
				}
				
				bool drawSeparator = false;
				uint contourFlags = Is_Button;
				uint surfaceFlags = Is_Button;
				
				if(horizontal) {
					surfaceFlags |=Is_Horizontal;
					contourFlags |=Is_Horizontal;
				}
				
				if(isOn) {
					surfaceFlags |= Is_Down;
					contourFlags |= Is_Down;
				}
				
				TQPixmap buffer(btn->size());
				TQPainter painter(&buffer);
				
				if(tb->parentWidget() && tb->parentWidget()->paletteBackgroundPixmap()) {
					painter.drawTiledPixmap(0, 0,  tb->width(), tb->height(), *tb->parentWidget()->paletteBackgroundPixmap(), tb->geometry().x(), tb->geometry().y());
					contourFlags |= Draw_AlphaBlend;
				}
				else
					painter.fillRect(buffer.rect(), cg.brush(TQColorGroup::Background));

				
				if(prevBtn) {
					if(nextBtn) {
						// middle
						if(horizontal) {
							contourFlags |= Draw_Top|Draw_Bottom;
							cr.setLeft(r.left()-6);
							cr.setWidth(r.width()+12);
							bsr.setLeft(r.left()-2);
							bsr.setWidth(r.width()+3);
							sr.addCoords(-1, 2, 0, -3);
							drawSeparator = true;
						}
						else {
							contourFlags |= Draw_Left|Draw_Right;
							cr.setY(r.y()-6);
							cr.setHeight(r.height()+13);
							bsr.addCoords(2, 0, 0, 1);
							sr.addCoords(2, -1, -2, 0);
							drawSeparator = true;
						}
					}
					else {
						// right / bottom
						if(!horizontal) {
							contourFlags |= Draw_Bottom|Draw_Right|Draw_Left|Round_BottomRight|Round_BottomLeft;
							cr.setY(r.y()-6);
							cr.setHeight(r.height()+6);
							bsr.addCoords(2, 0, 0, -1);
							sr.addCoords(2, -1, -2, -3);
						}
						else if(!reverse) {
							contourFlags |= Draw_Top|Draw_Bottom|Draw_Right|Round_UpperRight|Round_BottomRight;
							cr.setLeft(r.left()-6);
							cr.setWidth(r.width()+5);
							bsr.setLeft(r.left()-2);
							bsr.setWidth(r.width()+1);
							sr.addCoords(-1, 2, -3, -3);
							
						}
						else { // reverse
							contourFlags |= Draw_Top|Draw_Bottom|Draw_Left|Round_UpperLeft|Round_BottomLeft;
							cr.setWidth(r.width()+6);
							bsr.setWidth(r.width()+1);
							sr.addCoords(2, 2, 0, -3);
							drawSeparator = true;
						}
					}
				}
				else {
					if(nextBtn) {
						// left / top
						if(!horizontal) {
							contourFlags |= Draw_Top|Draw_Left|Draw_Right|Round_UpperLeft|Round_UpperRight;
							cr.setHeight(r.height()+7);
							bsr.addCoords(2, 2, 0, +1);
							sr.addCoords(2, 2, -2, 0);
							drawSeparator = true;
						}
						else if(!reverse) {
							contourFlags |= Draw_Top|Draw_Bottom|Draw_Left|Round_UpperLeft|Round_BottomLeft;
							cr.setWidth(r.width()+6);
							bsr.setWidth(r.width()+1);
							sr.addCoords(2, 2, 0, -3);
							drawSeparator = true;
						}
						else { //reverse
							contourFlags |= Draw_Top|Draw_Bottom|Draw_Right|Round_UpperRight|Round_BottomRight;
							cr.setLeft(r.left()-6);
							cr.setWidth(r.width()+5);
							bsr.setLeft(r.left()-2);
							bsr.setWidth(r.width()+1);
							sr.addCoords(-1, 2, -3, -3);
						}
					}
					else {
						// full
						if(horizontal) {
							cr.setWidth(r.width()-1);
							bsr.setWidth(r.width()-1);
							sr.addCoords(2, 2, -3, -3);
						}
						else {
							bsr.addCoords(2, 2, 0, -1);
							sr.addCoords(2, 2, -2, -3);
						}
						contourFlags |= Draw_Top|Draw_Bottom|Draw_Left|Draw_Right|Round_UpperLeft|Round_BottomLeft|
								Round_UpperRight|Round_BottomRight;
						
					}
				}
				
				
				renderSurface(&painter, sr, cg.background(), cg.background(), cg.background(), surfaceFlags);
				drawControl(CE_ToolButtonLabel, &painter, ceData, elementFlags, r, cg, flags, opt, widget);
				renderContour(&painter, cr, cg.background(), cg.background(), contourFlags);
				
				
				/////////////////////////////////////////// drop down indicator
				
				if(tb->popup()) {
					TQString isEnabled = enabled ? "1" : "0";
					TQPixmap* arrow;
					TQColor color = btn->palette().active().buttonText();
					if(!(arrow = TQPixmapCache::find(TQString::number(color.pixel(), 16)+"arrow_down"+isEnabled))) {
						TQImage ar = tintImage(qembed_findImage("arrow_down"), color);
						if(!isEnabled) {
							ar = setImageOpacity(ar, 25);
						}
						arrow = new TQPixmap(ar);
						TQPixmapCache::insert(TQString::number(color.pixel(), 16)+"arrow_down"+isEnabled, arrow);
					}
					
					TQPoint point;
					if(prevBtn)
						if(nextBtn)
							if(horizontal)
								point = TQPoint(cr.width()-19, cr.bottom()-8);
							else
								point = TQPoint(cr.width()-8, cr.bottom()-12);
						else
							if(!horizontal)
								point = TQPoint(cr.width()-8, cr.bottom()-8);
							else if(!reverse)
								point = TQPoint(cr.width()-15, cr.bottom()-8);
							else // reverse
								point = TQPoint(cr.width()-13, cr.bottom()-8);
					else
						if(nextBtn)
							if(!horizontal)
								point = TQPoint(cr.width()-8, cr.bottom()-12);
							else if(!reverse)
								point = TQPoint(cr.width()-13, cr.bottom()-8);
							else //reverse
								point = TQPoint(cr.width()-15, cr.bottom()-8);
						else
							if(horizontal)
								point = TQPoint(cr.width()-9, cr.bottom()-8);
							else
								point = TQPoint(cr.width()-8, cr.bottom()-8);
							
					bitBlt(&buffer, point.x(), point.y(), arrow);
					
				}
				
				
				/////////////////////////////////////////// separator
				
				if(drawSeparator) { // on the right side of the button
					
					ContourState cState;
					if(reverse && horizontal) {
						if( ((enabled && !isDown) || (prevBtn && prevBtn == hoverWidget)) && (hoverWidget && (tb == hoverWidget || (prevBtn == hoverWidget && prevBtn->isEnabled() && !prevBtn->isDown()))) )
							cState = Contour_MouseOver;
						else if(isDown || (prevBtn && prevBtn->isDown()))
							cState = Contour_Pressed;
						else
							cState = Contour_Default;
					}
					else {
						if( ((enabled && !isDown) || (nextBtn &&nextBtn == hoverWidget)) && (hoverWidget && (tb == hoverWidget || (nextBtn == hoverWidget && nextBtn->isEnabled() && !nextBtn->isDown()))) )
							cState = Contour_MouseOver;
						else if(isDown || (nextBtn && nextBtn->isDown()))
							cState = Contour_Pressed;
						else
							cState = Contour_Default;
					}
					
					painter.setPen(alphaBlendColors(buttonContour->contourColor(cState), cg.background(), 218));
					if(horizontal)
						painter.drawLine(r.width()-1, r.top()+1, r.width()-1, r.bottom()-2);
					else
						painter.drawLine(r.x()+1, r.bottom(), r.width()-2, r.bottom());
					
				}
				
				
				/////////////////////////////////////////// button shadow
				
				if(isOn && buttonContour->drawButtonSunkenShadow) {
					uint shadowFlags;
					if(prevBtnIsOn) { // or above is on
						if(nextBtnIsOn) { // or below is on
							if(horizontal) {
								shadowFlags = Draw_Top|Draw_Bottom;
								bsr.addCoords(-3, 2, +5, -1);
							}
							else {
								shadowFlags = Draw_Left|Draw_Right;
								bsr.addCoords(0, -5, 0, +4);
							}
						}
						else {
							if(horizontal) {
								if(!reverse) {
									shadowFlags = Draw_Top|Draw_Bottom|Draw_Right;
									shadowFlags |= contourFlags& Round_UpperRight ? Round_UpperRight : Rectangular_UpperRight;
									shadowFlags |= contourFlags& Round_BottomRight ? Round_BottomRight : Rectangular_BottomRight;
									bsr.addCoords(-3, 2, 0, -1);
								}
								else {
									shadowFlags = Draw_Top|Draw_Bottom|Draw_Left;
									shadowFlags |= contourFlags& Round_UpperLeft ? Round_UpperLeft : Rectangular_UpperLeft;
									shadowFlags |= contourFlags& Round_BottomLeft ? Round_BottomLeft : Rectangular_BottomLeft;
									bsr.addCoords(2, 2, 5, -1);
								}
							}
							else {
								shadowFlags = Draw_Bottom|Draw_Left|Draw_Right;
								shadowFlags |= contourFlags& Round_BottomLeft ? Round_BottomLeft : Rectangular_BottomLeft;
								shadowFlags |= contourFlags& Round_BottomRight ? Round_BottomRight : Rectangular_BottomRight;
								bsr.setY(bsr.y()-5);
							}
						}
					}
					else if(nextBtnIsOn) {
						if(horizontal) {
							if(!reverse) {
								shadowFlags = Draw_Top|Draw_Bottom|Draw_Left;
								shadowFlags |= (contourFlags& Round_UpperLeft) ? Round_UpperLeft : Rectangular_UpperLeft;
								shadowFlags |= (contourFlags& Round_BottomLeft) ? Round_BottomLeft : Rectangular_BottomLeft;
								bsr.addCoords(2, 2, 5, -1);
							}
							else {
								shadowFlags = Draw_Top|Draw_Bottom|Draw_Right;
								shadowFlags |= contourFlags& Round_UpperRight ? Round_UpperRight : Rectangular_UpperRight;
								shadowFlags |= contourFlags& Round_BottomRight ? Round_BottomRight : Rectangular_BottomRight;
								bsr.addCoords(-3, 2, 0, -1);
							}
						}
						else {
							shadowFlags = Draw_Top|Draw_Left|Draw_Right;
							shadowFlags |= contourFlags& Round_UpperLeft ? Round_UpperLeft : Rectangular_UpperLeft;
							shadowFlags |= contourFlags& Round_UpperRight ? Round_UpperRight : Rectangular_UpperRight;
							bsr.setHeight(bsr.height()+4);
						}
					}
					else {
						if(horizontal) {
							shadowFlags = Draw_Top|Draw_Bottom|Draw_Left|Draw_Right;
							shadowFlags |= contourFlags& Round_UpperLeft ? Round_UpperLeft : Rectangular_UpperLeft;
							shadowFlags |= contourFlags& Round_UpperRight ? Round_UpperRight : Rectangular_UpperRight;
							shadowFlags |= contourFlags& Round_BottomRight ? Round_BottomRight : Rectangular_BottomRight;
							shadowFlags |= contourFlags& Round_BottomLeft ? Round_BottomLeft : Rectangular_BottomLeft;
							bsr.addCoords(2, 2, 0, -1);
						}
						else {
							shadowFlags = Draw_Top|Draw_Bottom|Draw_Left|Draw_Right;
							shadowFlags |= contourFlags& Round_UpperLeft ? Round_UpperLeft : Rectangular_UpperLeft;
							shadowFlags |= contourFlags& Round_UpperRight ? Round_UpperRight : Rectangular_UpperRight;
							shadowFlags |= contourFlags& Round_BottomRight ? Round_BottomRight : Rectangular_BottomRight;
							shadowFlags |= contourFlags& Round_BottomLeft ? Round_BottomLeft : Rectangular_BottomLeft;
						}
					}
					renderButtonShadow(&painter, bsr, shadowFlags);
				}
				
				btn->setUpdatesEnabled(false);
				btn->setErasePixmap(buffer);
				btn->setUpdatesEnabled(true);
				btn->erase();
				
			}
			else if(_toolBtnAsBtn) { // not a TDEToolBarButton
				
				if(kickerMode && !(flags&(Style_Raised)))
					break;
				
				const TQRect br = querySubControlMetrics(control, ceData, elementFlags, SC_ToolButton, opt, widget);
				if(br.width() < 16 || br.height()< 16)
					break;
				
				TQColorGroup g = widget->colorGroup();
				TQColor bg;
				if(widget->parentWidget() && widget->paletteBackgroundColor() != widget->parentWidget()->paletteBackgroundColor()) {
					bg = widget->parentWidget()->paletteBackgroundColor();
					g.setColor(TQColorGroup::Background, bg);
				}
				else
					bg = widget->paletteBackgroundColor();
				
				if(!widget->paletteBackgroundPixmap()) {
					p->fillRect(TQRect(br.x(), br.y(), 6, 6), bg);
					p->fillRect(TQRect(br.width()-6, br.y(), 6, 6), bg);
					p->fillRect(TQRect(br.width()-6, br.height()-7, 6, 7), bg);
					p->fillRect(TQRect(br.x(), br.height()-7, 6, 7), bg);
				}
				else {
					buttonContour->setAlphaMode();
				}
				
				if(/*flags &Style_On || */flags &Style_Down)
					buttonContour->setState(Contour_Pressed);
				if(enabled && tb == hoverWidget)
					buttonContour->setState(Contour_MouseOver);
				else if(flags & Style_Default)
					buttonContour->setState(Contour_DefaultButton);
				
				renderButton(p, br, g, (flags & Style_On || flags & Style_Down), flags & Style_MouseOver, true, enabled, tdehtmlWidgets.contains(opt.widget()) );
				buttonContour->reset();
				
				
				if(tb->popup()) {
					TQString isEnabled = enabled ? "1" : "0";
					TQPixmap* arrow;
					TQColor color = tb->palette().active().buttonText();
					if(!(arrow = TQPixmapCache::find(TQString::number(color.pixel(), 16)+"arrow_down"+isEnabled))) {
						TQImage ar = tintImage(qembed_findImage("arrow_down"), color);
						if(!isEnabled) {
							ar = setImageOpacity(ar, 25);
						}
						arrow = new TQPixmap(ar);
						TQPixmapCache::insert(TQString::number(color.pixel(), 16)+"arrow_down"+isEnabled, arrow);
					}
					bitBlt(p->device(), r.width()-8, r.bottom()-8, arrow);
				}
				
			}
			else {
				
				bool isKbtn = ::tqt_cast<TDEToolBarButton*>(tb);
				TQPixmap buffer(tb->size());
				TQPainter painter(&buffer);
				
				TQColor bg = cg.background();
				
				if(tb->parentWidget() && tb->parentWidget()->paletteBackgroundPixmap()) {
					painter.drawTiledPixmap(0, 0,  tb->width(), tb->height(), *tb->parentWidget()->paletteBackgroundPixmap(), tb->geometry().x(), tb->geometry().y());
				}
				else if(tb->parentWidget() && widget->paletteBackgroundColor() != widget->parentWidget()->paletteBackgroundColor()) {
					bg = widget->parentWidget()->paletteBackgroundColor();
					painter.fillRect(buffer.rect(), bg);
				}
				else
					painter.fillRect(buffer.rect(), cg.brush(TQColorGroup::Background));
				
				
				TQRect fr = TQRect(1, 1, r.width()-2, r.height()-2);
				bool isOn = flags &Style_On;
				if(isOn) {
					TQRegion reg(fr.x()+2, fr.y()+1, fr.width()-4, fr.height()-2);
					reg += TQRegion(fr.x()+1, fr.y()+2, fr.width()-2, fr.height()-4);
					painter.setClipRegion(reg);
					painter.fillRect(r, alphaBlendColors(black, bg, 15));
					painter.setClipping(false);
				}
				if(isKbtn)
					drawControl(CE_ToolButtonLabel, &painter, ceData, elementFlags, r, cg, flags, opt, widget);
				
				if(isOn) {
					TQColor color = buttonContour->contourColor(Contour_Default);
					TQPixmap* frame;
					if(!(frame = TQPixmapCache::find(TQString::number(color.pixel(), 16)+"toolBtnFrameThin"))) {
						frame = new TQPixmap(tintImage(qembed_findImage("toolBtnFrameThin"), color));
						TQPixmapCache::insert(TQString::number(color.pixel(), 16)+"toolBtnFrameThin", frame);
					}
					
					bitBlt(&buffer, fr.x(), fr.y(), frame, 0, 0, 4, 4);
					bitBlt(&buffer, fr.width()-3, fr.y(), frame, 4, 0, 4, 4);
					bitBlt(&buffer, fr.x(), fr.height()-3, frame, 0, 4, 4, 4);
					bitBlt(&buffer, fr.width()-3, fr.height()-3, frame, 4, 4, 4, 4);
						
					painter.setPen(alphaBlendColors(color, bg, 195));
					painter.drawLine(fr.x()+4, fr.y(), fr.width()-4, fr.y());
					painter.drawLine(fr.x(), fr.y()+4, fr.x(), fr.height()-4);
					painter.drawLine(fr.width(), fr.y()+4, fr.width(), fr.height()-4);
					painter.drawLine(fr.x()+4, fr.height(), fr.width()-4, fr.height());
				}
				
				if(tb->popup() && (!tb->iconSet().isNull() || !tb->text().isEmpty() || tb->pixmap())) {
					TQString isEnabled = enabled ? "1" : "0";
					TQPixmap* arrow;
					TQColor color = tb->palette().active().buttonText();
					if(!(arrow = TQPixmapCache::find(TQString::number(color.pixel(), 16)+"arrow_down"+isEnabled))) {
						TQImage ar = tintImage(qembed_findImage("arrow_down"), color);
						if(!isEnabled) {
							ar = setImageOpacity(ar, 25);
						}
						arrow = new TQPixmap(ar);
						TQPixmapCache::insert(TQString::number(color.pixel(), 16)+"arrow_down"+isEnabled, arrow);
					}
					bitBlt(&buffer, r.width()-8, r.bottom()-4, arrow);
				}
				
				if(isKbtn) {
					tb->setUpdatesEnabled(false);
					tb->setErasePixmap(buffer);
					tb->erase();
					tb->setUpdatesEnabled(true);
				}
				else
					p->drawPixmap(0, 0, buffer);
			}
			
			p->setPen(cg.buttonText() );
			break;
		}

	// SPINWIDGETS
	// -----------
		case CC_SpinWidget: {
			
			if(active == SC_SpinWidgetUp || active == SC_SpinWidgetDown)
				break;
			
			static const unsigned int handleWidth = 15;
			const TQSpinWidget *sw = dynamic_cast<const TQSpinWidget *>(widget);
			const TQColor bg = cg.background();
			SFlags sflags = flags;
			PrimitiveElement pe;
			bool enabled = sw && sw->isEnabled();
			const TQColor buttonColor = enabled ? cg.button() : cg.background();
			
			uint contourFlags = Round_UpperLeft|Round_BottomLeft|Round_UpperRight|Round_BottomRight|Draw_Right|Draw_Top|
					Draw_Bottom|Draw_Left|Is_Button|Is_Horizontal;
			
			// fill edges
			if(sw && !sw->paletteBackgroundPixmap()) {
				p->fillRect(TQRect(r.x(), r.y(), 6, r.height()), bg);
				p->fillRect(TQRect(r.width()-6, r.y(), 6, r.height()), bg);
			}
			else {
				contourFlags |= Draw_AlphaBlend;
				buttonContour->setAlphaMode();
			}
			
			uint surfaceFlags = Is_Button|Is_Horizontal;
			if(flags& Style_Down) {
				surfaceFlags |= Is_Down;
				contourFlags |= Is_Down;
			}
			renderSurface(p, TQRect(r.x()+2, r.y()+2, r.width()-4, r.height()-5), cg.background(), cg.button(), cg.button(), surfaceFlags);
			
			if(flags & Style_Down)
				buttonContour->setState(Contour_Pressed);
			else if(enabled && sw == hoverWidget)
				buttonContour->setState(Contour_MouseOver);
			renderContour(p, r, cg.background(), cg.button(), contourFlags);
			
			if(flags & Style_Down)
				renderButtonShadow(p, TQRect(r.x()+2, r.y()+2, r.width()-2, r.height()-3), contourFlags);
			buttonContour->reset();
			
			
// 			TQColor lineEditColor = enabled ? cg.base() : cg.background();
			TQColor lineEditColor = enabled ? cg.base() : dynamic_cast<TQSpinBox*>(sw->parentWidget()) ?
					((DominoTQSpinBox*)sw->parentWidget())->editor()->palette().active().background(): tqApp->palette().active().background();
			TQString isEnabled = enabled ? "1" : "0";
			TQPixmap* lineEditBtnEdges;
			
			if(!(lineEditBtnEdges = TQPixmapCache::find(TQString::number(cg.button().pixel(), 16)+TQString::number(lineEditColor.pixel(), 16)+"lineEditBtnEdges"+isEnabled))) {
				
				// To not make the button contour appear thicker with dark button gradiens, we need a tad smaller rounding for the lineEdit edges.
				TQPixmap pixmap(1, r.height());
				TQPainter painter(&pixmap);
				flatMode = true;
				renderSurface(&painter, TQRect(0, 0, 1, r.height()), cg.background(), cg.button(), cg.button(), surfaceFlags);
				flatMode = false;
				TQImage img = pixmap.convertToImage();
				
				// Test, if we have a dark button. Not accurate, but...
				TQColor c1 = TQColor(img.pixel(0, r.y()+4));
				TQColor c2 = TQColor(img.pixel(0, r.height()-6));
				int v, v1, v2;
				c1.getHsv(&v, &v ,&v1);
				c2.getHsv(&v, &v ,&v2);
				
				TQImage edges = tintImage(qembed_findImage( (v1+v2)/2 < 127 ? "lineEditBtnEdges-d" : "lineEditBtnEdges"), lineEditColor);
				
				if(enabled) {
					TQImage shadow = qembed_findImage("lineEditBtnShadow");
					blend(shadow, edges, edges);
				}
				lineEditBtnEdges = new TQPixmap(edges);
				TQPixmapCache::insert(TQString::number(cg.button().pixel(), 16)+TQString::number(lineEditColor.pixel(), 16)+"lineEditBtnEdges"+isEnabled, lineEditBtnEdges);
			}
			
			if(reverseLayout) {
				bitBlt(p->device(), r.width()-6, r.y()+3, lineEditBtnEdges, 3, 0, 3, 3);
				bitBlt(p->device(), r.width()-6, r.height()-7, lineEditBtnEdges, 3, 3, 3, 3);
			}
			else {
				bitBlt(p->device(), r.x()+3, r.y()+3, lineEditBtnEdges, 0, 0, 3, 3);
				bitBlt(p->device(), r.x()+3, r.height()-7, lineEditBtnEdges, 0, 3, 3, 3);
			}
			
			
			TQRect upRect = TQRect(reverseLayout ? r.left()+2 : r.right()-handleWidth-1, r.height()/2-7, handleWidth, 6);
			TQRect downRect = TQRect(reverseLayout ? r.left()+2 : r.right()-handleWidth-1, r.height()/2+1, handleWidth, 6);
			// icons...
			//p->setPen(cg.foreground());
			p->setPen(sw ? sw->palette().active().buttonText() : tqApp->palette().active().buttonText());
			
			sflags = Style_Default;
			if(enabled)
				sflags |= Style_Enabled;
			if (active == SC_SpinWidgetUp) {
				sflags |= Style_On;
				sflags |= Style_Sunken;
			} else
				sflags |= Style_Raised;
				
			if (sw->buttonSymbols() == TQSpinWidget::PlusMinus) {
				pe = PE_SpinWidgetPlus;
				upRect.moveTop(upRect.y()+1);
			}
			else
				pe = PE_SpinWidgetUp;
			drawPrimitive(pe, p, ceData, elementFlags, upRect, cg, sflags);

			sflags = Style_Default;
			if(enabled)
				sflags |= Style_Enabled;
			if (active == SC_SpinWidgetDown) {
				sflags |= Style_On;
				sflags |= Style_Sunken;
			} else
				sflags |= Style_Raised;
			if (sw->buttonSymbols() == TQSpinWidget::PlusMinus)
				pe = PE_SpinWidgetMinus;
			else
				pe = PE_SpinWidgetDown;
			drawPrimitive(pe, p, ceData, elementFlags, downRect, cg, sflags);
			
			break;
		}

		case CC_ScrollBar: { // TODO: find a way to draw pressed buttons
			
			const TQScrollBar *sb = (const TQScrollBar*)widget;
			bool   maxedOut   = (sb->minValue()    == sb->maxValue());
			bool   horizontal = (sb->orientation() == TQt::Horizontal);
			SFlags sflags     = ((horizontal ? Style_Horizontal : Style_Default) |
					(maxedOut   ? Style_Default : Style_Enabled));

			TQRect  addline, subline, subline2, addpage, subpage, slider, first, last;
			subline = querySubControlMetrics(control, ceData, elementFlags, SC_ScrollBarSubLine, opt, widget);
			addline = querySubControlMetrics(control, ceData, elementFlags, SC_ScrollBarAddLine, opt, widget);
			subpage = querySubControlMetrics(control, ceData, elementFlags, SC_ScrollBarSubPage, opt, widget);
			addpage = querySubControlMetrics(control, ceData, elementFlags, SC_ScrollBarAddPage, opt, widget);
			slider  = querySubControlMetrics(control, ceData, elementFlags, SC_ScrollBarSlider,  opt, widget);
// 			first   = querySubControlMetrics(control, ceData, elementFlags, SC_ScrollBarFirst,   opt, widget);
// 			last    = querySubControlMetrics(control, ceData, elementFlags, SC_ScrollBarLast,    opt, widget);
// 			subline2 = addline;

// 			if (horizontal)
// 				subline2.moveBy(-addline.width(), 0);
// 			else
// 				subline2.moveBy(0, -addline.height());
			
			// Draw the up/left button set
			if ((controls & SC_ScrollBarSubLine) && subline.isValid()) {
				drawPrimitive(PE_ScrollBarSubLine, p, ceData, elementFlags, subline, cg,
					      sflags | (active == SC_ScrollBarSubLine ?
							      Style_Down : Style_Default));
				
				
				subline2 = addline;
				if (horizontal)
					subline2.moveBy(-addline.width(), 0);
				else
					subline2.moveBy(0, -addline.height());
				
				if (subline2.isValid())
					drawPrimitive((TQStyle::PrimitiveElement)PE_ScrollBarSubLine2, p,
						ceData, elementFlags, subline2, cg,
						sflags | (active == SC_ScrollBarSubLine ?
								Style_Down : Style_Default));
			}

			if ((controls & SC_ScrollBarAddLine) && addline.isValid())
				drawPrimitive(PE_ScrollBarAddLine, p, ceData, elementFlags, addline, cg,
					      sflags | ((active == SC_ScrollBarAddLine) ?
							      Style_Down : Style_Default));

			if ((controls & SC_ScrollBarSubPage) && subpage.isValid())
				drawPrimitive(PE_ScrollBarSubPage, p, ceData, elementFlags, subpage, cg,
					      sflags | ((active == SC_ScrollBarSubPage) ?
							      Style_Down : Style_Default));

			if ((controls & SC_ScrollBarAddPage) && addpage.isValid())
				drawPrimitive(PE_ScrollBarAddPage, p, ceData, elementFlags, addpage, cg,
					      sflags | ((active == SC_ScrollBarAddPage) ?
							      Style_Down : Style_Default));
			
// 			if ((controls & SC_ScrollBarFirst) && first.isValid())
// 				drawPrimitive(PE_ScrollBarFirst, p, ceData, elementFlags, first, cg,
// 					      sflags | ((active == SC_ScrollBarFirst) ?
// 							      Style_Down : Style_Default));
// 
// 			if ((controls & SC_ScrollBarLast) && last.isValid())
// 				drawPrimitive(PE_ScrollBarLast, p, ceData, elementFlags, last, cg,
// 					      sflags | ((active == SC_ScrollBarLast) ?
// 							      Style_Down : Style_Default));

			if ((controls & SC_ScrollBarSlider) && slider.isValid()) {
				drawPrimitive(PE_ScrollBarSlider, p, ceData, elementFlags, slider, cg,
					      sflags | ((active == SC_ScrollBarSlider) ?
							      Style_Down : Style_Default));
			}
			break;
		}
		
		
		
		case CC_TitleBar: {
			
			TQRect ir;
			bool down;
			TQColorGroup g = widget->colorGroup();
			
			if ( controls & SC_TitleBarLabel ) {
				TQPixmap pix(10, r.height());
				pix.fill(g.background());
				
				TQPainter painter(&pix);
				renderGradient(&painter, TQRect(0, 0, 10, r.height()/2), g.background().light(120), g.background(), true);
				painter.setPen(g.background().dark(105));
				painter.drawLine(0, r.bottom(), 10, r.bottom());
				p->drawTiledPixmap(0,0, r.width(), r.height(), pix);
				
				ir = visualRect( querySubControlMetrics( CC_TitleBar, ceData, elementFlags, SC_TitleBarLabel, TQStyleOption::Default, widget ), widget );
				p->setPen( g.foreground() );
				p->drawText(ir.x()+2, ir.y(), ir.width()-2, ir.height(), AlignCenter | AlignVCenter | SingleLine, widget->caption() );
			}
			if ( controls & SC_TitleBarCloseButton ) {
				ir = visualRect( querySubControlMetrics( CC_TitleBar, ceData, elementFlags, SC_TitleBarCloseButton, TQStyleOption::Default, widget ), widget );
				down = active & SC_TitleBarCloseButton;
				p->drawPixmap(ir.x(), ir.y(), qembed_findImage("DockCloseButton"), 0, down ? 12 : 0, 12, 12);
			}
			if ( controls & SC_TitleBarMaxButton ) {
				ir = visualRect( querySubControlMetrics( CC_TitleBar, ceData, elementFlags, SC_TitleBarMaxButton, TQStyleOption::Default, widget ), widget );
				down = active & SC_TitleBarMaxButton;
				p->drawPixmap(ir.x(), ir.y(), qembed_findImage("OverlapButton"), 0, down ? 12 : 0, 12, 12);
			}
			if ( controls & SC_TitleBarNormalButton) {
				ir = visualRect( querySubControlMetrics( CC_TitleBar, ceData, elementFlags, SC_TitleBarNormalButton, TQStyleOption::Default, widget ), widget );
				down = active & SC_TitleBarNormalButton;
				p->drawPixmap(ir.x(), ir.y(), qembed_findImage("ToDesktopButton"), 0, down ? 12 : 0, 12, 12);
			}
			if ( controls & SC_TitleBarMinButton) {
				ir = visualRect( querySubControlMetrics( CC_TitleBar, ceData, elementFlags, SC_TitleBarMinButton, TQStyleOption::Default, widget ), widget );
				down = active & SC_TitleBarMinButton;
				p->drawPixmap(ir.x(), ir.y(), qembed_findImage("DockbackButton"), 0, down ? 12 : 0, 12, 12);
			}
			if ( controls & SC_TitleBarSysMenu ) {
				if ( widget->icon() ) {
					ir = visualRect( querySubControlMetrics( CC_TitleBar, ceData, elementFlags, SC_TitleBarSysMenu, TQStyleOption::Default, widget ), widget );
					drawItem( p, ir, AlignCenter, widget->colorGroup(), TRUE, widget->icon(), TQString::null );
				}
			}
			
			break;
		}
		default:
			TDEStyle::drawComplexControl(control, p, ceData, elementFlags,
										r, cg, flags, controls,
										active, opt, widget);
			break;
	}
}

TQRect DominoStyle::subRect(SubRect r,
			    const TQStyleControlElementData &ceData,
			    ControlElementFlags elementFlags,
			    const TQWidget *widget) const
{
	switch (r) {
		case SR_PushButtonContents: {
			const TQPushButton* btn = static_cast<const TQPushButton*>(widget);
			TQRect rw = widget->rect();
			if(btn->text().isEmpty())
				return TQRect(rw.left()+2, rw.top()+2, rw.width()-4, rw.height()-4);
			return TQRect(rw.left()+2, rw.top()+3, rw.width()-4, rw.height()-7);
		}
		case SR_PushButtonFocusRect:
		{
			TQRect rect, wrect(widget->rect());
			const TQPushButton *button = (const TQPushButton *) widget;
			int dbw1 = 0, dbw2 = 0;
			if (button->isDefault() || button->autoDefault()) {
				dbw1 = pixelMetric(PM_ButtonDefaultIndicator, ceData, elementFlags, widget);
				dbw2 = dbw1 * 2;
			}

			int dfw1 = pixelMetric(PM_DefaultFrameWidth, ceData, elementFlags, widget) * 2,
			dfw2 = dfw1 * 2;

			rect.setRect(wrect.x()      + dfw1 + dbw1,
			wrect.y()      + dfw1 + dbw1,
			wrect.width()  - dfw2 - dbw2,
			wrect.height() - dfw2 - dbw2);
			return rect;
		}
		case SR_ComboBoxFocusRect: {
			return TQRect(4, 3, widget->width()-8, widget->height()-7);
// 			return querySubControlMetrics( CC_ComboBox, ceData, elementFlags, SC_ComboBoxEditField, TQStyleOption::Default, widget );
		}
		case SR_CheckBoxFocusRect:
		{
			TQRect cr = subRect(SR_CheckBoxContents, ceData, elementFlags, widget);
	    		TQRect fr = TDEStyle::subRect(r, ceData, elementFlags, widget);
			if(cr.width() <= 0) // no text
				fr.setHeight(fr.height()+2);
			else
				fr.addCoords(+2, 0, -2, 0);
	    		return fr;
		}
		case SR_RadioButtonFocusRect:
		{
			TQRect cr = subRect(SR_CheckBoxContents, ceData, elementFlags, widget);
			TQRect fr = TDEStyle::subRect(r, ceData, elementFlags, widget);
			if(cr.width() <= 0) // no text
				fr.setHeight(fr.height()+2);
			else
				fr.addCoords(+2, 0, -2, 0);
			return fr;
		}
		case SR_ProgressBarGroove: {
			return TQRect(widget->rect());
		}
		case SR_ProgressBarContents:
		case SR_ProgressBarLabel: {
			TQRect rw = widget->rect();
			return TQRect(rw.left()+2, rw.top()+2, rw.width()-4, rw.height()-4 );
		}
		case SR_ToolBoxTabContents: {
			TQRect rw = widget->rect();
			return TQRect(rw.left()+18, rw.top(), rw.width()-18, rw.height());
		}
		default: {
			return TDEStyle::subRect(r, ceData, elementFlags, widget);
		}
	}
}



TQRect DominoStyle::querySubControlMetrics(ComplexControl control,
										  const TQStyleControlElementData &ceData,
										  ControlElementFlags elementFlags,
										  SubControl subcontrol,
										  const TQStyleOption &opt,
										  const TQWidget *widget) const
{
	if (!widget) {
		return TQRect();
	}

	TQRect r(widget->rect());
	switch (control) {
		case CC_ComboBox: {
			switch (subcontrol) {
				case SC_ComboBoxEditField: {
					const TQComboBox* cb = dynamic_cast<const TQComboBox *>(widget);
					if(!cb) // maybe tdevelop's KComboView
						return TQRect(r.left()+4, r.top()+3, r.width()-4-15-3, r.height()-7);
					if(!cb->editable())
						return TQRect(r.left()+3, r.top()+3, r.width()-4-15-2, r.height()-6);
					
					return TQRect(r.left()+3, r.top()+3, r.width()-4-15-2, r.height()-7);
				}
				default: {
					return TDEStyle::querySubControlMetrics(control, ceData, elementFlags, subcontrol, opt, widget);
				}
			}
			break;
		}
		case CC_SpinWidget: {
			const int fw = 2; // Frame width...
			const int buttonsWidth = 15;
			const bool heightDividable = ((r.height()%2) == 0);
			
			const int buttonsLeft = r.right()-buttonsWidth+1-fw;
			switch (subcontrol) {
				case SC_SpinWidgetUp: { // rect without 2px frame
					return TQRect(buttonsLeft, r.top()+3, buttonsWidth+1, r.height()/2-3 );
				}
				case SC_SpinWidgetDown: {
					if(heightDividable) {
						return TQRect(buttonsLeft, r.top()+r.height()/2+1, buttonsWidth+1, r.height()/2-3);
					} else {
						return TQRect(buttonsLeft, r.top()+r.height()/2+1, buttonsWidth+1, r.height()/2-2);
					}
				}
				case SC_SpinWidgetFrame: {
					return TQRect(r.left(), r.top(), r.width(), r.height() );
				}
				case SC_SpinWidgetEditField: {
					return TQRect(r.left()+1+fw, r.top()+1+fw, r.width()-(buttonsWidth+2+fw*2), r.height()-3-fw*2);
				}
				case SC_SpinWidgetButtonField: {
					return TQRect(buttonsLeft, r.top()+2, buttonsWidth, r.height()-5);
				}
				default: {
					return TDEStyle::querySubControlMetrics(control, ceData, elementFlags, subcontrol, opt, widget);
				}
			}
			break;
		}

		case CC_ScrollBar: {
			
			const TQScrollBar *scrollbar = (const TQScrollBar *) widget;
			int sliderstart = scrollbar->sliderStart();
			const int buttonw = 15 /*- (fw * 2)*/;
			const int buttonh = 15 /*- (fw * 2)*/;

			int maxlen = ((scrollbar->orientation() == TQt::Horizontal) ?
					scrollbar->width() : scrollbar->height()) - buttonh * 3;

			// calculate slider length
			if (scrollbar->maxValue() != scrollbar->minValue()) {
				uint range = scrollbar->maxValue() - scrollbar->minValue();
				sliderlen = (scrollbar->pageStep() * maxlen) /
						(range + scrollbar->pageStep());

				if ( sliderlen < 32 || range > INT_MAX/2 )
					sliderlen = 32;
				if ( sliderlen > maxlen )
					sliderlen = maxlen;
			}
			else
				sliderlen = maxlen;
			
			switch(subcontrol) {
				case SC_ScrollBarAddLine: { // bottom/right button
					if (scrollbar->orientation() == TQt::Horizontal) {
						return TQRect(scrollbar->width() - buttonw , 0, buttonw, buttonh);
					} else {
						return TQRect(0, scrollbar->height() - buttonh, buttonw, buttonh);
					}
				}
				case SC_ScrollBarSubLine: { // top/left button
					return TQRect(0, 0, buttonw, buttonh);
				}
				case SC_ScrollBarSubPage: // top/left
					if (scrollbar->orientation() == TQt::Horizontal)
						return TQRect(buttonw, 0, sliderstart-buttonw+1, buttonw);
					return TQRect(0, buttonh, buttonw, sliderstart-buttonw+1);

				case SC_ScrollBarAddPage: // bottom/left
					if (scrollbar->orientation() == TQt::Horizontal)
						return TQRect(sliderstart + sliderlen-1, 0, maxlen - sliderstart - sliderlen + buttonw+1, buttonw);
					return TQRect(0, sliderstart + sliderlen-1, buttonw, maxlen - sliderstart - sliderlen + buttonw+1);

				case SC_ScrollBarGroove:
					if (scrollbar->orientation() == TQt::Horizontal)
						return TQRect(buttonw , 0, maxlen, buttonw);
					return TQRect(0, buttonw, buttonw, maxlen);

				case SC_ScrollBarSlider:
					if (scrollbar->orientation() == TQt::Horizontal)
						return TQRect(sliderstart, 0, sliderlen, buttonw);
					return TQRect(0, sliderstart, buttonw, sliderlen);
				default:
					break;
			}
		}
		default: {
			return TDEStyle::querySubControlMetrics(control, ceData, elementFlags, subcontrol, opt, widget);
		}
	}
}

int DominoStyle::pixelMetric(PixelMetric m,
			     const TQStyleControlElementData &ceData,
			     ControlElementFlags elementFlags,
			     const TQWidget *widget) const
{
	//return TDEStyle::pixelMetric(m, ceData, elementFlags, widget);
	
	switch(m) {
	// FRAMES
	// ------
		case PM_DefaultFrameWidth: {
			
			if(widget) {
				if(dynamic_cast<const TQPopupMenu*>(widget))
					return 3;
				
				// stolen from baghira
				if (dynamic_cast<TQTabWidget*>(widget->parentWidget()) && widget->parentWidget()->parentWidget() && (widget->parentWidget()->parentWidget()->isA("KonqMainWindow") || widget->parentWidget()->parentWidget()->isA("KonqFrameContainer")))
					return 0;
			
			}
			return 2;
		}
		case PM_MenuBarFrameWidth:
			return 1;
		case PM_SpinBoxFrameWidth:
			return 2;
			
	// CHECKBOXES / RADIO BUTTONS
	// --------------------------
		case PM_IndicatorWidth:		// Checkbox 18x19
				return 18;
		case PM_IndicatorHeight:
			return 19;

		case PM_ExclusiveIndicatorWidth:	// Radiobutton 17x17
		case PM_ExclusiveIndicatorHeight:
			return 17;

	// TABS
	// ----
		case PM_TabBarTabVSpace: {
			const TQTabBar * tb = (const TQTabBar *) widget;
			
			switch(tb->shape()) {
				case TQTabBar::RoundedAbove:
				case TQTabBar::RoundedBelow:
					return 12;
				default:
					return 4;
			}
			
		}
		case PM_TabBarTabShiftVertical: {
			
			const TQTabBar * tb = (const TQTabBar *) widget;
			switch (tb->shape()) {
				case TQTabBar::RoundedAbove:
					return 1;
				case TQTabBar::RoundedBelow:
					return (tb->parentWidget() && tb->parentWidget()->isA("KonqFrameTabs"))? 0 : -1;
				default:
					return 0;
			}
		}
		case PM_TabBarTabShiftHorizontal: {
			return 0;
		}
		case PM_TabBarTabOverlap: {
			return 1;
		}
		case PM_TabBarBaseOverlap: {
			const TQTabWidget * tw = (const TQTabWidget *) widget;
			if(((DominoTQTabWidget*)tw)->tabBar()->isHidden() || tw->isA("KonqFrameTabs"))
				return 0;
			return (tw->tabPosition() == TQTabWidget::Top) ? -3 : -4;
		}
#if (TQT_VERSION >= 0x030300) // requires TQt 3.3
	// extra space between menubar items
		case PM_MenuBarItemSpacing: {
			return 6;
		}
#endif

// #if (TQT_VERSION >= 0x030300) // requires TQt 3.3
//	   // extra space between toolbar items
//		   case PM_ToolBarItemSpacing: {
//			   return 4;
//		   }
// #endif

	// SCROLL BAR
// 		case PM_ScrollBarSliderMin: {
// 			return 21;
// 		}

		case PM_ScrollBarExtent: {
			return 15;
		}

		case PM_DockWindowSeparatorExtent:
			return 6;

	// SPLITTERS
	// ---------
		case PM_SplitterWidth: {
			return 6;
		}

	// PROGRESSBARS
	// ------------
		case PM_ProgressBarChunkWidth:
			return 10;

	// SLIDER
	// ------
		case PM_SliderLength:
		case PM_SliderThickness:
			return 15;

	// MENU INDICATOR
	// --------------
		case PM_MenuButtonIndicator:
			return 8;

		case PM_ButtonDefaultIndicator: {
			return 0;
		}

		case PM_ButtonMargin: {
			//return 2;
			return 4;
		}
		case PM_HeaderMargin:
			return 2;
		case PM_ButtonShiftVertical:
		case PM_ButtonShiftHorizontal: {
			return 0;
		}
 		case PM_CheckListControllerSize: // radio controller
		case PM_CheckListButtonSize: { // box controller
			return 16;
		}
// 		case PM_PopupMenuFrameVerticalExtra:
// 			return 1;
// 		case PM_PopupMenuFrameHorizontalExtra:
// 			return 1;
		default:
			return TDEStyle::pixelMetric(m, ceData, elementFlags, widget);
	}
}


TQSize DominoStyle::sizeFromContents(ContentsType t,
									const TQStyleControlElementData &ceData,
									ControlElementFlags elementFlags,
									const TQSize &s,
									const TQStyleOption &opt,
									const TQWidget *widget) const
{
	//return TDEStyle::sizeFromContents (t, ceData, elementFlags, s, opt, widget);
	
	switch (t) {

		case CT_PushButton:
		{
			const TQPushButton* btn = static_cast<const TQPushButton*>(widget);

			int w = s.width();
			int h = s.height();
			if ( btn->text().isEmpty() && s.width() < 32 ) {
				w += pixelMetric(PM_ButtonMargin, ceData, elementFlags, widget)*2;
				h += pixelMetric(PM_ButtonMargin, ceData, elementFlags, widget)*2;
				return TQSize(w, h);
			}
			
			int bm = pixelMetric(PM_ButtonMargin, ceData, elementFlags, widget);
			int fw = pixelMetric(PM_DefaultFrameWidth, ceData, elementFlags, widget) * 2;
			w += bm + fw + 22;
			h += bm + fw;
			return TQSize(w, h < 26 ? 26+_buttonHeightAdjustment : h+4 );
		}
		case CT_ComboBox: {
			int bm = pixelMetric(PM_ButtonMargin, ceData, elementFlags, widget);
			int fw = pixelMetric(PM_DefaultFrameWidth, ceData, elementFlags, widget) * 2;
			int w = s.width();
			int h = s.height();
			w += bm + fw + 22;
			h += bm + fw-3;
			return TQSize(w, h < 26 ? 26+_buttonHeightAdjustment : h+4 );
		}
		
		case CT_TabBarTab: {
			// konqi = tabbar
			// other = tab control
			// this is total crap but it helps to reduce the flicker in konqi.
			/////////////////////
			TQTabBar* tb = 0;
			if(::tqt_cast<TQTabBar*>(widget))
				tb = ::tqt_cast<TQTabBar*>(widget);
			else
				return TQSize(s.width(), s.height());
				
			if(!strcmp(widget->name(), "tabbar") && widget->parentWidget()->isA("KonqFrameTabs")) {
				
				TQTab* tab = opt.tab();
				int count = tb->count();

				int fm = tb->fontMetrics().width("about:blank");
				if(tb->parentWidget()->width() <= opt.tab()->rect().x()+44+fm)
					return TQSize(s.width(), s.height());

				int dots = tb->fontMetrics().width(".");
				if((dots*minTabLength+44)*count >= tb->width())  //  44 = frame+iconwidth
					return TQSize(s.width(), s.height());

				TQSize sz = TDEStyle::sizeFromContents( t, ceData, elementFlags, s, opt, widget );
	
				TQString str;
				str.fill(' ', minTabLength);
				if( tab->text().isEmpty() || tab->text() == str) {
					tab->setText("about:blank");
					//return TQSize(  fm+44, 26 );
					return TQSize(  fm+44, s.height());
				}
				return TQSize(s.width(), s.height());
			}
			else {
				switch (tb->shape()) {
					case TQTabBar::RoundedAbove:
					case TQTabBar::RoundedBelow:
						return TQSize( s.width(), s.height()-2 );
					default:
						return TQSize( s.width(), s.height() ); // triangular
				}
			}
		}
		
		case CT_ToolButton: {
			if(dynamic_cast<const TQToolButton*>(widget)) {
				if(dynamic_cast<TQTabWidget*>(widget->parentWidget())) // smaller cornerWidget
					return TQSize( s.width()+9, s.height()+7 );
				return TQSize( s.width()+11, s.height()+7 );
			}
			return TDEStyle::sizeFromContents( t, ceData, elementFlags, s, opt, widget ); // KMultiTabBar buttons
		}
		case CT_SpinBox: {
			TQSize sz = TDEStyle::sizeFromContents( t, ceData, elementFlags, s, opt, widget );
			int h = sz.height()%2 != 0 ? sz.height()+1 : sz.height();
			return ( TQSize( sz.width(), h < 24 ? 24 : h) );
		}
		
		case CT_Header: {
			TQSize sz = TDEStyle::sizeFromContents( t, ceData, elementFlags, s, opt, widget );
			return TQSize(sz.width(), sz.height()-2);
		}
		
		case CT_PopupMenuItem: {
			if (!widget || opt.isDefault())
				return s;
// 			static const int itemHMargin = 6;
// 			static const int itemFrame = 7;
// 			static const int arrowHMargin = 6;
			
			const TQPopupMenu *popup = dynamic_cast<const TQPopupMenu *>(widget);
			TQMenuItem *mi = opt.menuItem();
			int maxpmw = opt.maxIconWidth();
			int w = s.width(), h = s.height(); // includes pixmap width
			int cmwidth = 16;
			
			
			if (mi->custom()) {
				w = mi->custom()->sizeHint().width();
				h = mi->custom()->sizeHint().height();
				if (!mi->custom()->fullSpan() )
					h += 4;
			} else if (mi->widget()) {
			// don't change the size in this case.
			} else if (mi->isSeparator()) {
				w = 20;
				h = 5;
			} else {
				if (mi->pixmap()) {
					h = TQMAX(h, mi->pixmap()->height() + 2);
				} else {
					h = TQMAX(h, 16 + 2 );
					h = TQMAX(h, popup->fontMetrics().height() + 4 );
				}

				if (mi->iconSet()) {
					h = TQMAX(h, mi->iconSet()->pixmap(TQIconSet::Small, TQIconSet::Normal).height() + 2);
				}
			}
			
			if(_indentPopupMenuItems) {
				w += itemHMargin + arrowHMargin + itemFrame*2;
			}
			else {
				w += itemFrame*2;
				
				if (mi->popup()) {
					w += itemHMargin + arrowHMargin;
				}
				if (maxpmw) {
					w += itemHMargin;
				}
			}
			
			int t;
			if (!mi->text().isNull() && (t = mi->text().find('\t')) && t >= 0 && mi->text().at(t+1) != 0) {
				// space between text and accel + checkmark width (in guiStyle "Windows" isCheckable() returns always true...)
				w += 18+cmwidth;
			}
			else
				w += cmwidth;
			
			return TQSize(w, h);
		}
		default:
			return TDEStyle::sizeFromContents( t, ceData, elementFlags, s, opt, widget );
	}

	return TDEStyle::sizeFromContents( t, ceData, elementFlags, s, opt, widget );
}

int DominoStyle::styleHint( StyleHint stylehint,
								   const TQStyleControlElementData &ceData,
								   ControlElementFlags elementFlags,
								   const TQStyleOption &option,
								   TQStyleHintReturn* returnData,
								   const TQWidget *widget ) const
{
	switch (stylehint) {
		case SH_PopupMenu_SubMenuPopupDelay:
			//return 96; // Motif-like delay...
			return 250;
		case SH_GroupBox_TextLabelVerticalAlignment: {
			return TQt::AlignTop;
		}
		case SH_ScrollBar_BackgroundMode: {
			return TQt::PaletteBackground;
		}
		case SH_ScrollBar_ScrollWhenPointerLeavesControl:
			// if set to false (the default) it will also scroll when the subPage button is pressed, so no choice here (TQt 3.6)
			return true;
		case SH_TabBar_Alignment: {
			return _centerTabs ? AlignHCenter : AlignLeft;
		}
		case SH_ToolBox_SelectedPageTitleBold: {
			return false;
		}
		case SH_LineEdit_PasswordCharacter:
		{
			if (widget) {
				const TQFontMetrics &fm = widget->fontMetrics();
				if (fm.inFont(TQChar(0x25CF))) {
					return 0x25CF;
				} else if (fm.inFont(TQChar(0x2022))) {
					return 0x2022;
				}
			}
			return '*';
		}
		default:
			return TDEStyle::styleHint(stylehint, ceData, elementFlags, option, returnData, widget);
	}
}

TQPixmap DominoStyle::stylePixmap(StylePixmap stylepixmap,
				  const TQStyleControlElementData &ceData,
				  ControlElementFlags elementFlags,
				  const TQStyleOption& opt,
				  const TQWidget* widget ) const {
	
	switch (stylepixmap) {
		case SP_DockWindowCloseButton:
		case SP_TitleBarCloseButton:
			return TQPixmap(qembed_findImage("DockCloseButton").copy(0,0,12,12));
		case SP_TitleBarMinButton:
			return TQPixmap(qembed_findImage("DockbackButton").copy(0,0,12,12));
		case SP_TitleBarMaxButton:
			return TQPixmap(qembed_findImage("OverlapButton").copy(0,0,12,12));
		case SP_TitleBarNormalButton:
			return TQPixmap(qembed_findImage("ToDesktopButton").copy(0,0,12,12));
		default:
			return TDEStyle::stylePixmap(stylepixmap, ceData, elementFlags, opt, widget);
	}
}


TQColor DominoStyle::lightenColor(const TQColor &color, const int value) const
{
	if(value < 0)
		return darkenColor(color, TQABS(value));
	int r, g, b;
	color.getRgb(&r, &g, &b);
	r += value;
	if(r > 255)
		r =255;
	g += value;
	if(g > 255)
		g =255;
	b += value;
	if(b > 255)
		b =255;
	return TQColor(r, g, b);
}

TQColor DominoStyle::darkenColor(const TQColor &color, const int value) const
{
	if(value < 0)
		return lightenColor(color, TQABS(value));
	int r, g, b;
	color.getRgb(&r, &g, &b);
	r -= value;
	if(r < 0)
		r = 0;
	g -= value;
	if(g < 0)
		g = 0;
	b -= value;
	if(b < 0)
		b = 0;
	return TQColor(r, g, b);
}

TQColor DominoStyle::dGetColor(const TQColor &color, const int value) const
{
	int h, s, v;
	color.getHsv(&h, &s, &v);
	return (v<127)? lightenColor(color, value): darkenColor(color, value);
}


TQPixmap* DominoStyle::renderLineEditShadow(TQWidget* widget, TQRect r, TQColor bg, uint flags, bool /*reverse*/) {
	
	bool drawLeft = flags& Draw_Left;
	bool drawRight = flags& Draw_Right;
	
	int x, y, w, h;
	r.rect(&x, &y, &w, &h);
	if(!drawLeft) {
		x = -3;
		w += 3;
	}
	else if(!drawRight)
		w += 3;
	TQRect rect(x, y, w, h);
	
	
	TQColor tintColor;
	TQString enabled = widget->isEnabled() ? "1" : "0";
	if(!widget->isEnabled())
		tintColor =bg;
	else
		tintColor = alphaBlendColors(TQt::black, bg, 30+35);
	
	TQPixmap* prBgShadow;
	if(!(prBgShadow = TQPixmapCache::find(TQString::number(bg.pixel(), 16)+TQString::number(tqApp->palette().active().background().pixel(), 16)+"leBgShadow"+enabled))) {
		prBgShadow = new TQPixmap(4,4);
		prBgShadow->fill(bg);
		TQPixmap pix = tintImage(qembed_findImage("progressShadow2"), tintColor);
		bitBlt(prBgShadow, 0, 0, &pix);
		TQPixmapCache::insert(TQString::number(bg.pixel(), 16)+TQString::number(tqApp->palette().active().background().pixel(), 16)+"leBgShadow"+enabled, prBgShadow);
	}
	
	
	TQPixmap* pix = new TQPixmap(rect.size());
	pix->fill(bg);
	
	if(widget->isEnabled()) {
		TQPainter p(pix);
		
		TQColor color_d = alphaBlendColors(tintColor, bg, 170);
		TQColor color_m = alphaBlendColors(tintColor, bg, 85);
		TQColor color_l = alphaBlendColors(tintColor, bg, 25);
		
		p.setPen(color_d);
		p.drawLine(rect.x()+2, rect.y(), rect.right()-2, rect.y());
		p.setPen(color_m);
		p.drawLine(rect.x()+2, rect.y()+1, rect.right()-2, rect.y()+1);
		p.setPen(color_l);
		p.drawLine(rect.x()+2, rect.y()+2, rect.right()-2, rect.y()+2);
		p.drawLine(rect.x()+2, rect.bottom(), rect.right()-2, rect.bottom());
	
		//p.setPen(color_l);
		p.drawLine(rect.x()+1, rect.y()+3, rect.x()+1, rect.bottom()-1); // l
		p.drawLine(rect.right()-1, rect.y()+3, rect.right()-1, rect.bottom()-1); // r
				
		p.setPen(color_m);
		p.drawLine(rect.x(), rect.y()+3, rect.x(), rect.bottom()-1); // l
		p.drawLine(rect.right(), rect.y()+3, rect.right(), rect.bottom()-1); // r
		
		bitBlt(pix, rect.right()-1, rect.y(), prBgShadow, 2, 0, 2, 3, TQt::CopyROP);
		bitBlt(pix, rect.x(), rect.y(), prBgShadow, 0, 0, 2, 3, TQt::CopyROP);
		bitBlt(pix, rect.right()-1, rect.bottom(), prBgShadow, 2, 3, 2, 1, TQt::CopyROP);
		bitBlt(pix, rect.x(), rect.bottom(), prBgShadow, 0, 3, 2, 1, TQt::CopyROP);
		
		p.end();
	}
	return pix;
}

TQColor DominoStyle::getGroupBoxColor(const TQWidget* w) const {
	TQWidget* parent = w->parentWidget();
	int tint = groupBoxSettings.customColor ? 0 : groupBoxSettings.brightness;
	while(dynamic_cast<TQGroupBox*>(parent)) {
		parent = parent->parentWidget();
		tint += groupBoxSettings.brightness;
	}
	
	return TQColor(darkenColor(groupBoxSettings.customColor ? groupBoxSettings.color :
			tqApp->palette().active().background(), tint));
	
}

TQPixmap* DominoStyle::createCheckMark(const TQColor color) const {
	
	TQImage checkMark_enabled = qembed_findImage("checkmark");
	TQImage checkMark_disabled =  setImageOpacity(checkMark_enabled, 25);
	
	TQImage img(32, 17, 32); // left enabled, right disabled
	img.setAlphaBuffer(true);
	for(int x=0; x < checkMark_enabled.width(); ++x) {
		for(int y=0; y < checkMark_enabled.height(); ++y) {
			img.setPixel(x, y, checkMark_enabled.pixel(x, y));
		}
	}
	for(int x=0; x < checkMark_disabled.width(); ++x) {
		for(int y=0; y < checkMark_disabled.height(); ++y) {
			img.setPixel(x+16, y, checkMark_disabled.pixel(x, y));
		}
	}
	
	return new TQPixmap(tintImage(img, color));
}

TQPixmap* DominoStyle::createRadioIndicator(const TQColor color) const {
	
	TQImage dot_enabled = tintImage(qembed_findImage("rb-dot"),color);
	
	blend(qembed_findImage("rb-dot-shadow"), dot_enabled, dot_enabled);
	TQImage dot_disabled = setImageOpacity(dot_enabled, 25);

	TQImage img(10, 5, 32);
	img.setAlphaBuffer(true);
	for(int x=0; x < dot_enabled.width(); ++x) {
		for(int y=0; y < dot_enabled.height(); ++y) {
			img.setPixel(x, y, dot_enabled.pixel(x, y));
		}
	}
	for(int x=0; x < dot_disabled.width(); ++x) {
		for(int y=0; y < dot_disabled.height(); ++y) {
			img.setPixel(x+5, y, dot_disabled.pixel(x, y));
		}
	}
	
	return new TQPixmap(img);
}


void DominoStyle::drawFocusIndicator(TQPainter *p, const TQRect &r, int flags, const TQColorGroup cg, bool /*enabled*/,
			const TQPixmap* /*pixmap*/, const TQString & text, int /*len = -1*/, const TQColor& highlight, bool drawLine, bool isButton) const
{

	if(drawLine) {
// 		p->setPen(cg.foreground());
// 		TQPixmap edges = tintImage(qembed_findImage("indicatorEdges"), cg.foreground());
// 		bitBlt(p->device(), r.x(), r.bottom()-1, &edges, 0, 0, 2, 1, TQt::CopyROP);
// 		bitBlt(p->device(), r.right()-2, r.bottom()-1, &edges, 2, 0, 2, 1, TQt::CopyROP);
// 		p->drawLine(r.x()+2, r.bottom()-1, r.right()-3, r.bottom()-1);
		TQFont font = p->font();
		font.setUnderline(true);
		p->setFont(font);
	}
	else {
		TQRect br = p->fontMetrics().boundingRect(r.x(), r.y(), r.width(), r.height(), flags, text);
		TQPainter pixPainter;
		TQPixmap textPixmap(br.width()+2, br.height()+2);
		textPixmap.fill(TQColor(0,0,0));
		pixPainter.begin(&textPixmap);
		pixPainter.setPen(white);
		pixPainter.setFont(p->font());
		pixPainter.drawText( TQRect(1, 1, br.width()-1, br.height()-1), flags, text );
		pixPainter.end();
		
		
		DominoTQPixmap* pixm = (DominoTQPixmap*)&textPixmap;
		
		uint height = pixm->height();
		uint width = pixm->width();
		
		pixm->data->alphapm = new TQPixmap;
		
		DominoTQPixmap* alphapm = (DominoTQPixmap*)pixm->data->alphapm;
		
		alphapm->data->w = width;
		alphapm->data->h = height;
		alphapm->data->d = 8;
		alphapm->hd = XCreatePixmap(alphapm->x11Display(), RootWindow(alphapm->x11Display(), alphapm->x11Screen()), width, height, 8);
		alphapm->rendhd = (HANDLE) XftDrawCreateAlpha( alphapm->x11Display(), alphapm->hd, 8 );
		
		XImage *axi = XCreateImage(alphapm->x11Display(), (Visual *) alphapm->x11Visual(), 8, ZPixmap, 0, 0, width, height, 8, 0);
		axi->data = (char *) malloc((unsigned) axi->bytes_per_line * height);
		
		XImage* xi = XGetImage( tqt_xdisplay(), pixm->handle(), 0, 0, width, height, AllPlanes, ZPixmap );
		
		int alpha;
		float AXIS_FACTOR = 2.0;
		float DIAGONAL_FACTOR = 1.0;
		double alphaShadow;
		int customalpha = isButton ? focusIndicatorSettings.buttonOpacity : focusIndicatorSettings.opacity;
		
		for(uint x = 1; x < width-1; ++x) {
			for(uint y = 1; y < height-1; ++y) {
				
				alphaShadow = (tqBlue(XGetPixel(xi,x-1,y-1)) * DIAGONAL_FACTOR +
						tqBlue(XGetPixel(xi,x-1,y  )) * AXIS_FACTOR +
						tqBlue(XGetPixel(xi,x-1,y+1)) * DIAGONAL_FACTOR +
						tqBlue(XGetPixel(xi,x ,y-1)) * AXIS_FACTOR +
						0                         +
						tqBlue(XGetPixel(xi,x ,y+1)) * AXIS_FACTOR +
						tqBlue(XGetPixel(xi,x+1,y-1)) * DIAGONAL_FACTOR +
						tqBlue(XGetPixel(xi,x+1,y  )) * AXIS_FACTOR +
						tqBlue(XGetPixel(xi,x+1,y+1)) * DIAGONAL_FACTOR) / 2.0; // / multiplicationFactor
					
				alpha = (int)alphaShadow;
				XPutPixel(axi, x, y, TQMIN(255, alpha) *customalpha >> 8);
			}
		}
			
		GC gc = XCreateGC(alphapm->x11Display(), alphapm->hd, 0, 0);
		XPutImage(alphapm->x11Display(), alphapm->hd, gc, axi, 0, 0, 0, 0, width, height);
		
		textPixmap.fill(highlight);
		
		TQRect fr = TQRect(br.x(), br.y(), TQMIN((int)width-2, r.width()) , TQMIN((int)height-2, r.height()));
		if(fr.x() < r.x()) {
			p->setClipRegion(r);
			fr.setWidth(fr.width()+abs(fr.x())+2);
		}
		if(fr.isValid())
			p->drawPixmap(fr.x(), fr.y(), textPixmap, 1, 1, fr.width() , fr.height());
		if(fr.x() < r.x())
			p->setClipping(false);
		
		if(axi)
			XDestroyImage(axi);
		if(xi)
			XDestroyImage(xi);
		XFreeGC(alphapm->x11Display(), gc);
		
		p->setPen(cg.foreground());
	}
}

TQPixmap DominoStyle::renderOutlineIcon(const TQPixmap* icon) const
{
	TQImage img = icon->convertToImage();
	TQImage outlineIcon(img.width()+2, img.height()+2, 32);
	outlineIcon.setAlphaBuffer(true);
	
	unsigned int *outlineIconData = (unsigned int*) outlineIcon.bits();
	uint total = outlineIcon.width()*outlineIcon.height();
	for (uint current = 0 ; current < total ; ++current ) {
		outlineIconData[ current ] = 0x00000000;
	}
	
	bitBlt(&outlineIcon, 0, 0, &img);
	bitBlt(&outlineIcon, 1, 0, &img);
	bitBlt(&outlineIcon, 2, 0, &img);
	bitBlt(&outlineIcon, 0, 1, &img);
	bitBlt(&outlineIcon, 2, 1, &img);
	bitBlt(&outlineIcon, 0, 2, &img);
	bitBlt(&outlineIcon, 1, 2, &img);
	bitBlt(&outlineIcon, 2, 2, &img);
	
	uint customalpha = focusIndicatorSettings.buttonOpacity;
	for (uint current = 0 ; current < total ; ++current ) {
		outlineIconData[ current ] = tqRgba( focusIndicatorSettings.buttonColor.red(), focusIndicatorSettings.buttonColor.green(), focusIndicatorSettings.buttonColor.blue(), tqAlpha(outlineIconData[ current ]) * customalpha >> 8);
	}
	
	return TQPixmap(outlineIcon);
}




void DominoStyle::drawItem( TQPainter *p, const TQRect &r,
			    int flags, const TQColorGroup &g, bool enabled,
			    const TQPixmap *pixmap, const TQString& text, int len,
			    const TQColor* penColor ) const
{
	dominoDrawItem(p, r, flags, g, enabled, pixmap, text, len, penColor, false);
}

void DominoStyle::dominoDrawItem( TQPainter *p, const TQRect &r,
		       int flags, const TQColorGroup &g, bool enabled,
		       const TQPixmap *pixmap, const TQString& text, int len,
		       const TQColor* penColor, bool buttonTextEffect ) const
{
	
	int x = r.x();
	int y = r.y();
	int w = r.width();
	int h = r.height();

	p->setPen( penColor?*penColor:g.foreground() );
	if ( pixmap ) {
		TQPixmap  pm( *pixmap );
		bool clip = (flags & TQt::DontClip) == 0;
		if ( clip ) {
			if ( pm.width() < w && pm.height() < h ) {
				clip = FALSE;
			} else {
				p->save();
				TQRegion cr = TQRect(x, y, w, h);
				if (p->hasClipping())
					cr &= p->clipRegion(TQPainter::CoordPainter);
				p->setClipRegion(cr);
			}
		}
		if ( (flags & TQt::AlignVCenter) == TQt::AlignVCenter )
			y += h/2 - pm.height()/2;
		else if ( (flags & TQt::AlignBottom) == TQt::AlignBottom)
			y += h - pm.height();
		if ( (flags & TQt::AlignRight) == TQt::AlignRight )
			x += w - pm.width();
		else if ( (flags & TQt::AlignHCenter) == TQt::AlignHCenter )
			x += w/2 - pm.width()/2;
		else if ( ((flags & TQt::AlignLeft) != TQt::AlignLeft) && TQApplication::reverseLayout() ) // AlignAuto && rightToLeft
			x += w - pm.width();

		p->drawPixmap( x, y, pm );
		if ( clip )
			p->restore();
	}
	else if ( !text.isNull() ) {
		

		if(textEffectSettings.mode > 1 || buttonTextEffect) { // 0=none, 1=only buttons, 2=everywhere
			
			TQRect br = p->fontMetrics().boundingRect(x, y, w, h, flags, text);
			TQPainter pixPainter;
			TQPixmap textPixmap(br.width(), br.height());
			textPixmap.fill(TQColor(0,0,0));
			pixPainter.begin(&textPixmap);
			pixPainter.setPen(white);
			pixPainter.setFont(p->font());
			pixPainter.drawText( TQRect(0,0,br.width(), br.height()), flags, text );
			pixPainter.end();
			
			DominoTQPixmap* pixm = (DominoTQPixmap*)&textPixmap;
			
			uint height = pixm->height();
			uint width = pixm->width();
			
			pixm->data->alphapm = new TQPixmap;
			
			DominoTQPixmap* alphapm = (DominoTQPixmap*)pixm->data->alphapm;
			
			alphapm->data->w = width;
			alphapm->data->h = height;
			alphapm->data->d = 8;
			alphapm->hd = XCreatePixmap(alphapm->x11Display(), RootWindow(alphapm->x11Display(), alphapm->x11Screen()), width, height, 8);
			alphapm->rendhd = (HANDLE) XftDrawCreateAlpha( alphapm->x11Display(), alphapm->hd, 8 );
			
			XImage *axi = XCreateImage(alphapm->x11Display(), (Visual *) alphapm->x11Visual(), 8, ZPixmap, 0, 0, width, height, 8, 0);
			axi->data = (char *) malloc((unsigned) axi->bytes_per_line * height);
			XImage* xi = XGetImage( tqt_xdisplay(), pixm->handle(), 0, 0, width, height, AllPlanes, ZPixmap );
			
			int alpha;
			int customalpha = buttonTextEffect ? textEffectSettings.buttonOpacity : textEffectSettings.opacity;
			for(uint y = 0; y < height; ++y) {
				for(uint x = 0; x < width; ++x) {
					alpha = (XGetPixel(xi, x, y)& 0xff ) * customalpha >> 8;  // blue as alpha
					XPutPixel(axi, x, y, alpha);
				}
			}

			GC gc = XCreateGC(alphapm->x11Display(), alphapm->hd, 0, 0);
			XPutImage(alphapm->x11Display(), alphapm->hd, gc, axi, 0, 0, 0, 0, width, height);
			
			
			if(buttonTextEffect) {
				textPixmap.fill(textEffectSettings.buttonColor);
				
				TQRect tr = TQRect(br.x()+textEffectSettings.buttonPos.x(), br.y()+textEffectSettings.buttonPos.y(), r.width(), r.height());
				if(tr.x() < r.x()) {
					p->setClipRegion(r);
					tr.setWidth(tr.width()+r.x()+abs(tr.x()));
				}
				p->drawPixmap(tr.x(), tr.y(), textPixmap, 0, 0, tr.width(), tr.height());
				if(tr.x() < r.x())
					p->setClipping(false);
			}
			else {
				textPixmap.fill(textEffectSettings.color);
				
				TQRect tr = TQRect(br.x()+textEffectSettings.pos.x(), br.y()+textEffectSettings.pos.y(), r.width(), r.height());
				if(tr.x() < r.x()) {
					p->setClipRegion(r);
					tr.setWidth(tr.width()+r.x()+abs(tr.x()));
				}
				p->drawPixmap(tr.x(), tr.y(), textPixmap, 0, 0, tr.width(), tr.height());
				if(tr.x() < r.x())
					p->setClipping(false);
			}
			
			if(axi)
				XDestroyImage(axi);
			if(xi)
				XDestroyImage(xi);
			XFreeGC(alphapm->x11Display(), gc);
		}
		
		if(!enabled)
			p->setPen(g.text());
		p->drawText( r.x(), r.y(), r.width(), r.height(), flags, text, len );
		
		
	}
}


TQWidget::BackgroundOrigin DominoStyle::setPixmapOrigin(TQWidget::BackgroundOrigin origin)
{
		switch(origin) {
			case TQWidget::WidgetOrigin:
				return TQWidget::ParentOrigin;
			case TQWidget::ParentOrigin:
				return TQWidget::AncestorOrigin;
			default:
				return origin;
				break;
		}
}

void DominoStyle::setDominoButtonPalette(TQWidget* widget, PaletteTyp type) {
	TQPalette pal;
	switch(type) {
		case Palette_Application:
			pal = tqApp->palette();
			break;
		case Palette_Parent:
			pal = widget->parentWidget()->palette();
			break;
		case Palette_Widget:
			pal = widget->palette();
		default:
			break;
	}
	
	int h, s, v;
	pal.active().buttonText().hsv(&h, &s, &v);
	TQColor disabledColor = alphaBlendColors(pal.active().buttonText(), v < 127 ? white : black, 150);
	pal.setColor(TQPalette::Disabled, TQColorGroup::Text, disabledColor);
	
	widget->setPalette(pal);
}


void DominoStyle::updateTabWidgetFrame() {
	
	TQTabWidget* tw = dynamic_cast<TQTabWidget*>(sender()->parent());
	TQWidget* w = tw ? tw->currentPage() : 0;
	if(!w)
		    return;
	TQFrame* f = dynamic_cast<TQFrame*>(w->parentWidget());
	if(f) {
		TQRect r = f->rect();
		if(tw->tabPosition() == TQTabWidget::Top)
			r= TQRect(r.x(), r.y(), r.width(), 3);
		else
			r= TQRect(r.x(), r.y()+r.height()-4, r.width(), 2);
		f->repaint(r, false);
	}
}

TQPixmap DominoStyle::disableIcon(const TQPixmap* icon) const {
	
	TQImage img = icon->convertToImage();
	uint pixels = img.depth() > 8 ? img.width()*img.height() :  img.numColors();
	uint *data = img.depth() > 8 ? (unsigned int *)img.bits() : (unsigned int *)img.colorTable();
	uint val, i;
	for(i=0; i < pixels; ++i){
		val = tqGray(data[i]);
		data[i] = tqRgba(val, val, val, tqAlpha(data[i]));
	}
	img = setImageOpacity(img, 50);
	
	return TQPixmap(img);
}


// same as in renderSurface() but with darker colors
void DominoStyle::renderTabSeparator(TQPainter *p, const TQRect &r, const TQColor buttonColor, bool tabAbove) const {
	
	const DSurface* ds = tabAbove ? &tabTopSurface : &tabBottomSurface;
	
	int top = r.y()+r.height()*ds->g1Top/100;
	int bottom = r.height()*ds->g1Bottom/100;
	int top2 = r.y()+r.height()*ds->g2Top/100;
	int bottom2 = r.height()*ds->g2Bottom/100-top2;
	
	TQColor c1;
	TQColor c2;
	TQColor c3;
	TQColor c4;
	TQColor bg;
	
	if(buttonColor != tqApp->palette().active().button()) {
		c1 = alphaBlendColors(buttonColor, ds->g1Color1, 127);
		c2 = alphaBlendColors(buttonColor, ds->g1Color2, 127);
		c3 = alphaBlendColors(buttonColor, ds->g2Color1, 127);
		c4 = alphaBlendColors(buttonColor, ds->g2Color2, 127);
		bg = alphaBlendColors(buttonColor, ds->background, 127);
	}
	else {
		c1 = ds->g1Color1;
		c2 = ds->g1Color2;
		c3 = ds->g2Color1;
		c4 = ds->g2Color2;
		bg = ds->background;
	}
	
	const int alpha = 35; // 55, 25
	p->fillRect(r, alphaBlendColors(TQColor(0,0,0),bg , alpha));
	switch(ds->numGradients) {
		case 1: {
			c1 = alphaBlendColors(TQColor(0,0,0), c1, alpha);
			c2 = alphaBlendColors(TQColor(0,0,0), c2, alpha);
			renderGradient(p, TQRect(r.x(), top, r.width(), bottom), c1, c2, true);
			break;
		}
		case 2: {
			c1 = alphaBlendColors(TQColor(0,0,0), c1, alpha);
			c2 = alphaBlendColors(TQColor(0,0,0), c2, alpha);
			c3 = alphaBlendColors(TQColor(0,0,0), c3, alpha);
			c4 = alphaBlendColors(TQColor(0,0,0), c4, alpha);
			renderGradient(p, TQRect(r.x(), top, r.width(), bottom), c1, c2, true);
			renderGradient(p, TQRect(r.x(), top2, r.width(), bottom2), c3, c4, true);
		}
		default:
			break;
	}
}

void DominoStyle::renderGroupBox(TQObject *obj, TQEvent *ev) {
	
	TQGroupBox* gb = dynamic_cast<TQGroupBox*>(obj);
	bool paintEvent = ev->type() == TQEvent::Paint;
	TQRect r = gb->rect();
	
	if(gb->isFlat()) {
		
		TQString title = gb->title();
		int titleHeight = gb->fontMetrics().height();
		int titleWidth = gb->fontMetrics().width(title);
		if(title.contains("&"))
			titleWidth -= gb->fontMetrics().width("&");
		TQPainter p(gb);
// 		p.setPen(tqApp->palette().active().background().dark(120));
		p.setPen(alphaBlendColors(gb->paletteForegroundColor(), gb->paletteBackgroundColor(), 40));
		p.drawLine(0, titleHeight/2-2, r.width()/2-titleWidth/2-4, titleHeight/2-2);
		p.drawLine(r.width()/2+titleWidth/2+4, titleHeight/2-2, r.width(), titleHeight/2-2);
		
		TQColorGroup cg = gb->parentWidget()->colorGroup();
		dominoDrawItem(&p, TQRect(r.width()/2-titleWidth/2, -1, r.width(), titleHeight), ShowPrefix, cg, Style_Enabled, 0, title, -1, &cg.foreground(), false);
		p.setPen(cg.foreground());
		((DominoTQGroupBox*)gb)->drawContents(&p);
	}
	else {
		TQString title = gb->title();
		int titleHeight = gb->fontMetrics().height();
		TQColor outsideColor = gb->parentWidget() ? gb->parentWidget()->paletteBackgroundColor() : gb->paletteBackgroundColor();
		TQColor insideColor = groupBoxSettings.tintBackground ? getGroupBoxColor(gb) : gb->paletteBackgroundColor();
		bool pixmapExists = groupBoxPixmaps.contains(gb);
		
		if(paintEvent && pixmapExists) {
			TQPainter p;
			if(!title.isEmpty()) {
				int titleWidth = gb->fontMetrics().width(title);
				if(title.contains("&"))
					titleWidth -= gb->fontMetrics().width("&");
			
				TQPainter p(groupBoxPixmaps[gb]);
				TQRect titleRect = TQRect((r.width()-titleWidth)/2, -1, r.width(), titleHeight);
				p.fillRect(titleRect, outsideColor);
				dominoDrawItem(&p, titleRect, ShowPrefix, gb->colorGroup(), true, 0, title, -1, &gb->foregroundColor(), false);
				p.end();
			}
			// only needed for the case if a disabled groupbox gets disabled for a second time.
			// TQt3 just changes the palette to disabled without checking if it already is (and removes here the "hidden" background pixmap)
			bitBlt(gb, 0, 0, groupBoxPixmaps[gb]);
			p.begin(gb);
			((DominoTQGroupBox*)gb)->drawContents(&p);
			return;
		}
		
		bool isCheckable = gb->isCheckable();
		int x = r.x();
		int y = isCheckable ? r.y()+titleHeight+5 : (title.isNull() || title.isEmpty()) ? TQMAX(r.y()-1, 0) : r.y()+titleHeight-1;
		int w = r.width();
		int h = r.height();
		
// 		if(y+16 > h || 16 > w) // don't overlap the pixmaps
// 			return;
			
		
		TQPixmap buffer(r.width(), r.height());
		
		TQPainter p(&buffer);
		p.fillRect(TQRect(0, 0, w, y), outsideColor);
		p.fillRect(TQRect(x+3, y+3, w-6, h-6-y), insideColor);
		
		TQPixmap* gbPix = 0;
		if(!(gbPix = TQPixmapCache::find(TQString::number(outsideColor.pixel(), 16)+TQString::number(insideColor.pixel(), 16)+"groupbox"))) {
			gbPix = new TQPixmap(16, 16);
			gbPix->fill(outsideColor);
			
			TQPixmap groupBoxPixMask = qembed_findImage("groupBoxMask");
			groupBoxPixMask.fill(insideColor);
			bitBlt(gbPix, 0, 0, &groupBoxPixMask);
					
			TQPixmap groupBoxPix = qembed_findImage("groupBox");
			bitBlt(gbPix, 0, 0, &groupBoxPix);
			
			TQPixmapCache::insert(TQString::number(outsideColor.pixel(), 16)+TQString::number(insideColor.pixel(), 16)+"groupbox", gbPix);
		}
				
		bitBlt(&buffer, 0, y, gbPix, 0, 0, 8, 8);
		bitBlt(&buffer, w-8, y, gbPix, 8, 0, 8, 8);
		bitBlt(&buffer, 0, h-8, gbPix, 0, 8, 8, 8);
		bitBlt(&buffer, w-8, h-8, gbPix, 8, 8, 8, 8 );
		
		// top
		TQColor c1 = alphaBlendColors(TQColor(255,255,255), outsideColor, 25);
		TQColor c2 = alphaBlendColors(TQColor(0,0,0), insideColor, 70);
		TQColor c3 = alphaBlendColors(TQColor(0,0,0), insideColor, 30);
		// left + right
		TQColor c4 = alphaBlendColors(TQColor(255,255,255), outsideColor, 40);
		TQColor c5 = c3; //alphaBlendColors(TQColor(0,0,0), insideColor, 30);
		TQColor c6 = alphaBlendColors(TQColor(0,0,0), insideColor, 4);
		// bottom
		TQColor c7 = alphaBlendColors(TQColor(6,6,6), insideColor, 25);
		TQColor c8 = alphaBlendColors(TQColor(255,255,255), outsideColor, 79);
		TQColor c9 = alphaBlendColors(TQColor(255,255,255), outsideColor, 30);
		
		
		// top
		p.setPen(c1);
		p.drawLine(r.left()+8, y, r.right()-8, y);
		p.setPen(c2);
		p.drawLine(r.left()+8, y+1, r.right()-8, y+1);
		p.setPen(c3);
		p.drawLine(r.left()+8, y+2, r.right()-8, y+2);
		// bottom
		p.setPen(c7);
		p.drawLine(r.left()+8, r.bottom()-2, r.right()-8, r.bottom()-2);
		p.setPen(c8);
		p.drawLine(r.left()+8, r.bottom()-1, r.right()-8, r.bottom()-1);
		p.setPen(c9);
		p.drawLine(r.left()+8, r.bottom(), r.right()-8, r.bottom());
		// left / right
		p.setPen(c4);
		p.drawLine(r.left(), y+8, r.left(), r.bottom()-8);
		p.drawLine(r.right(), y+8, r.right(), r.bottom()-8);
		p.setPen(c5);
		p.drawLine(r.left()+1, y+8, r.left()+1, r.bottom()-8);
		p.drawLine(r.right()-1, y+8, r.right()-1, r.bottom()-8);
		p.setPen(c6);
		p.drawLine(r.left()+2, y+8, r.left()+2, r.bottom()-8);
		p.drawLine(r.right()-2, y+8, r.right()-2, r.bottom()-8);
		
		p.end();
		
		if(ev->type() == TQEvent::Resize)
			XSetWindowBackgroundPixmap( gb->x11Display(), gb->winId(), buffer.handle());
		else if(paintEvent) {
			if(!title.isEmpty()) {
				int titleWidth = gb->fontMetrics().width(title);
				if(title.contains("&"))
					titleWidth -= gb->fontMetrics().width("&");
				
				p.begin(&buffer);
				TQRect titleRect = TQRect((r.width()-titleWidth)/2, -1, r.width(), titleHeight);
				p.fillRect(titleRect, outsideColor);
				dominoDrawItem(&p, titleRect, ShowPrefix, gb->colorGroup(), true, 0, title, -1, &gb->foregroundColor(), false);
				p.end();
			}
			bitBlt(gb, 0, 0, &buffer);
			
			p.begin(gb);
			((DominoTQGroupBox*)gb)->drawContents(&p);
		}
		
		
		if(pixmapExists)
			delete groupBoxPixmaps[gb];
		groupBoxPixmaps[gb] = new TQPixmap(buffer);
		
	}
}

void DominoStyle::spinBoxValueChanged(int value) {
	TQSpinBox* sb = (TQSpinBox*)sender();
	if(spinWidgetDown) {
		spinWidgetDown = !(value == sb->maxValue() || value == sb->minValue());
		if(!spinWidgetDown) {
			// if we repaint directly, the last mousePressEvent wouldn't be down
			TQTimer::singleShot( 200, ((DominoTQSpinBox*)sb)->editor()->parentWidget(), SLOT(repaint()) );
		}
	}
}

uint DominoStyle::preMultiplyColor(const uint &c) const {
	XRenderColor clr;
	uint  color = c << 8 | tqAlpha(c);

	uint red = (color >> 24) & 0xff;
	uint green = (color >> 16) & 0xff;
	uint blue = (color >> 8) & 0xff;
	uint alpha = (color >> 0) & 0xff;

	red = red * alpha / 255;
	green = green * alpha / 255;
	blue = blue * alpha / 255;

	clr.red = (red << 8) + red;
	clr.green = (green << 8) + green;
	clr.blue = (blue << 8) + blue;
	clr.alpha = (alpha << 8) + alpha;
	
	return tqRgba(clr.red, clr.green, clr.blue, clr.alpha);
}

void DominoStyle::toolPopupPressed() {
	TQToolButton* tb = (TQToolButton*)sender();
	if(!tb )
		return;
	if(tb->popup() && tb->isEnabled() && tb->isDown()) {
		popupButton = tb;
		connect(popupTimer, SIGNAL(timeout()), this, SLOT(popupToolMenu()));
		popupTimer->start(600, true);
	}
}

void DominoStyle::popupToolMenu() {
	if(!popupButton )
		return;
	
	if(popupButton->popup() && !popupButton->popup()->isVisible() && popupButton->isEnabled() && popupButton->isDown()) {
		popupButton->openPopup();
	}
	popupButton = 0;
}

void DominoStyle::toolPopupReleased() {
	if(!popupButton)
		return;
	
	if(popupTimer->isActive()) {
		popupTimer->stop();
		popupButton = 0;
	}
}

#include "eventfilter.cpp"
#include "domino.moc"
