
#ifndef CONFIGPLUGINSPAGE_H
#define CONFIGPLUGINSPAGE_H

#include <configpagebase.h>

#include <tdeio/jobclasses.h>

class Config;
class KPushButton;
class TDEListBox;
class TQCheckBox;

/**
 * @short The page for configuring the plugins
 * @author Daniel Faust <hessijames@gmail.com>
 * @version 0.3
 */
class ConfigPluginsPage : public ConfigPageBase
{
    Q_OBJECT
  
public:
    /**
     * Default Constructor
     */
    ConfigPluginsPage( Config*, TQWidget *parent=0, const char *name=0 );

    /**
     * Default Destructor
     */
    virtual ~ConfigPluginsPage();

private:
    TDEListBox* lPlugins;
    KPushButton* pAddPlugin;
    TDEIO::FileCopyJob* getPluginJob;
    KPushButton* pRemovePlugin;
    KPushButton* pAboutPlugin;
    TDEListBox* lOnlinePlugins;
    KPushButton* pRefreshOnlinePlugins;
    TDEIO::FileCopyJob* refreshOnlinePluginsJob;
    KPushButton* pInstallOnlinePlugin;
    TDEIO::FileCopyJob* getOnlinePluginJob;
    KPushButton* pUpgradeOnlinePlugins;
    KPushButton* pAboutOnlinePlugin;
    TDEIO::FileCopyJob* aboutOnlinePluginJob;
    TQCheckBox* cCheckOnlinePlugins;

    TQString getPluginFilePathName;

    Config* config;

public slots:
    void resetDefaults();
    void saveSettings();

// signals:
//     void configChanged();
//     void recalcEnDecoderPage();
//     void reloadEnDecoderPage();
//     void rescanForBackends();

private slots:
    void pluginsSelectionChanged( int );
    void refreshPlugins();
    void getPlugin();
    void getPluginFinished( TDEIO::Job* );
    void removePlugin();
    void aboutPlugin();

    void onlinePluginsSelectionChanged( int );
    void refreshOnlinePlugins();
    void refreshOnlinePluginsFinished( TDEIO::Job* );
    void getOnlinePlugin();
    void getOnlinePluginFinished( TDEIO::Job* );
    void aboutOnlinePlugin();
    void aboutOnlinePluginFinished( TDEIO::Job* );

};

#endif // CONFIGPLUGINSPAGE_H

