

#include "configdialog.h"

#include "config.h"
#include "configgeneralpage.h"
#include "configpluginspage.h"
#include "configenvironmentpage.h"
#include "configbackendspage.h"

/*#include "config_dialogue_interface.h"
#include "config_dialogue_backend_plugins.h"
#include "config_dialogue_backends.h"
#include "config_dialogue_en_decoder.h"
#include "config_dialogue_en_decoder_options.h"

#include "tools.h"
#include "backend_plugins.h"
#include "replaygain_plugins.h"

#include <tqlayout.h>
*/
//#include <tdeconfig.h>
#include <kiconloader.h>
#include <tdelocale.h>
#include <kpushbutton.h>

ConfigDialog::ConfigDialog( Config* _config, TQWidget *parent, const char *name, Page startPage )
    : KDialogBase(
        IconList,
        i18n("Settings"),
        Apply | Cancel | Default | Help | Ok,
        Ok, // default button
        parent,
        name,
        true, // modal
        true // separator
    )
{
    config = _config;

    //resize( 600, 400 );

    binaries = config->binaries;

    connect( this, TQT_SIGNAL(applyClicked()),
               this,TQT_SLOT(applyClickedSlot())
             );
    connect( this, TQT_SIGNAL(okClicked()),
               this,TQT_SLOT(okClickedSlot())
             );
    connect( this, TQT_SIGNAL(defaultClicked()),
               this,TQT_SLOT(defaultClickedSlot())
             );

    generalPage = addPage( i18n("General"), "misc" );
    configGeneralPage = new ConfigGeneralPage( config, generalPage, "configGeneralPage" );
    connect( configGeneralPage, TQT_SIGNAL(configChanged()),
               this, TQT_SLOT(configChanged())
    );
    connect( this, TQT_SIGNAL(saveGeneral()),
               configGeneralPage, TQT_SLOT(saveSettings())
    );
    connect( this, TQT_SIGNAL(resetGeneral()),
               configGeneralPage, TQT_SLOT(resetDefaults())
    );

    pluginsPage = addPage( i18n("Plugins"), "connect_creating" );
    configPluginsPage = new ConfigPluginsPage( config, pluginsPage, "configPluginsPage" );
    connect( configPluginsPage, TQT_SIGNAL(configChanged()),
               this, TQT_SLOT(configChanged())
    );
    connect( this, TQT_SIGNAL(savePlugins()),
               configPluginsPage, TQT_SLOT(saveSettings())
    );
    connect( this, TQT_SIGNAL(resetPlugins()),
               configPluginsPage, TQT_SLOT(resetDefaults())
    );

    environmentPage = addPage( i18n("Environment"), "filefind" );
    configEnvironmentPage = new ConfigEnvironmentPage( config, &binaries, environmentPage, "configEnvironmentPage" );
    connect( configEnvironmentPage, TQT_SIGNAL(configChanged()),
               this, TQT_SLOT(configChanged())
    );
    connect( this, TQT_SIGNAL(saveEnvironment()),
               configEnvironmentPage, TQT_SLOT(saveSettings())
    );
    connect( this, TQT_SIGNAL(resetEnvironment()),
               configEnvironmentPage, TQT_SLOT(resetDefaults())
    );

    backendsPage = addPage( i18n("Backends"), "preferences-system" );
    configBackendsPage = new ConfigBackendsPage( config, &binaries, backendsPage, "configBackendsPage" );
    connect( configBackendsPage, TQT_SIGNAL(configChanged()),
               this, TQT_SLOT(configChanged())
    );
    connect( this, TQT_SIGNAL(saveBackends()),
               configBackendsPage, TQT_SLOT(saveSettings())
    );
    connect( this, TQT_SIGNAL(resetBackends()),
               configBackendsPage, TQT_SLOT(resetDefaults())
    );
    connect( configEnvironmentPage, TQT_SIGNAL(rebuildBackendsPage()),
               configBackendsPage, TQT_SLOT(rebuild())
    );

    setConfigChanged( false );

    showPage( startPage );
}

ConfigDialog::~ConfigDialog()
{
}

TQFrame *ConfigDialog::addPage(const TQString &itemName, const TQString &iconName)
{
    return KDialogBase::addPage( itemName, TQString(), MainBarIcon(iconName,32) );
}

void ConfigDialog::setConfigChanged( const bool value )
{
    actionButton( Apply )->setEnabled(value);
}

void ConfigDialog::configChanged()
{
    setConfigChanged( true );
}

void ConfigDialog::applyClickedSlot()
{
    okClickedSlot();
    setConfigChanged( false );
}

void ConfigDialog::okClickedSlot()
{
    emit saveGeneral();
    emit savePlugins();
    emit saveEnvironment();
    emit saveBackends();
    config->write();
}

void ConfigDialog::defaultClickedSlot()
{
    int index = activePageIndex();
    TQStringList listDefaults;

    if( index == -1 )
        return;

    if( index == pageIndex(generalPage) )
    {
        emit resetGeneral();
        setConfigChanged( true );
    }
    else if( index == pageIndex(pluginsPage) )
    {
        emit resetPlugins();
        setConfigChanged( true );
    }
    else if( index == pageIndex(environmentPage) )
    {
        emit resetEnvironment();
        setConfigChanged( true );
    }
    else if( index == pageIndex(backendsPage) )
    {
        emit resetBackends();
        setConfigChanged( true );
    }
}
