/***************************************************************************
                          kmylistview.h  -  description
                             -------------------
    begin                : Mit M� 27 2002
    copyright            : (C) 2002 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMYLISTVIEW_H
#define KMYLISTVIEW_H

#include "batchrenamer.h"
#include "kmylistbox.h"
#include <tdelistview.h>
#include <tqvaluelist.h>

class TQMouseEvent;
class KMyListView : public TDEListView  {
    Q_OBJECT
  
    public:
        KMyListView( TQValueList<manualchanges>* _changes, KMyListBox* _list, TQWidget* parent=0, const char* name=0 );
        ~KMyListView();

    signals:
        void itemChanged();
        void removeItem(int);
        void addFile();
                
    private slots:
        void changeItem( TQListViewItem* item, const TQPoint&, int );
        void showContext( TQListViewItem* item, const TQPoint& pos, int );
        void removeCurrentItem();
        void addFiles();
        void changeCurrentItem();
        void openCurrent();

    private:
        TQValueList<manualchanges>* changes;
        KMyListBox* list;
};

/////////////////////////////////////////////////////////////
class TQColor;
class TQString;
class KMyListViewItem : public TDEListViewItem {
    public:
        KMyListViewItem(TQListView *parent);
        KMyListViewItem(TQListViewItem *parent);
        KMyListViewItem(TQListView *parent, TQListViewItem *after);
        KMyListViewItem(TQListViewItem *parent, TQListViewItem *after);

        KMyListViewItem(bool m, TQListView *parent,
            TQString, TQString = TQString(),
            TQString = TQString(), TQString = TQString(),
            TQString = TQString(), TQString = TQString(),
            TQString = TQString(), TQString = TQString());

        KMyListViewItem(bool m, TQListViewItem *parent,
            TQString, TQString = TQString(),
            TQString = TQString(), TQString = TQString(),
            TQString = TQString(), TQString = TQString(),
            TQString = TQString(), TQString = TQString());

        KMyListViewItem(bool m, TQListView *parent, TQListViewItem *after,
            TQString, TQString = TQString(),
            TQString = TQString(), TQString = TQString(),
            TQString = TQString(), TQString = TQString(),
            TQString = TQString(), TQString = TQString());

        KMyListViewItem(TQListViewItem *parent, TQListViewItem *after,
            TQString, TQString = TQString(),
            TQString = TQString(), TQString = TQString(),
            TQString = TQString(), TQString = TQString(),
            TQString = TQString(), TQString = TQString());

        virtual ~KMyListViewItem();

        void paintCell( TQPainter *p, const TQColorGroup &cg, int column, int width, int alignment );

    private:
        bool modified;
};


#endif
