/***************************************************************************
                          knutpanelmeter.h  -  description
                             -------------------
    begin                : t b?e 16 2004
    copyright            : (C) 2004 by Daniel Prynych
    email                : Daniel.Prynych@alo.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNUTPANELMETER_H
#define KNUTPANELMETER_H

#include "knutanalog.h"
#include "knutvardata.h"


//#include <tqwidget.h>
#include <tqscrollview.h>


class TQLabel;
class TQFont;

/**
  *@author Daniel Prynych
  */
class KNutPanelMeter : public TQScrollView  {
   Q_OBJECT
  
public:

/**
 * Konstruktor
 *
 * Param taPanelPalette je paleta pozadi subpanelu MERAKU !!!
 * @param activeUpsInfo ukazatel na data o aktivni UPS
 * @param settingData ukazatel na zakladni data programu (barvy pozadi, mezikruzi, rucicky ... ,fonty atd )
 * @param analogRecords ukazatel na tridu ktera pracuje s daty o upsekach
 *
 * @since  0.2
 **/
  KNutPanelMeter(TQPalette aPanelPalette, KNutVarData::upsInfoDef* activeUpsInfo, KNutVarData::SettingDataDef* settingData, KNutVarData* analogRecords, TQWidget *parent=0, const char *name=0);

/**
 * Destruktor
 *
 * @since  0.1
 **/
  ~KNutPanelMeter();

/**
 * Zrusi analogove panely vcetne uvoneni pameti.
 *
 * @since  0.1
 **/
  void deActivateAnalogs (void);


/**
 * Vytvori a inicializuje analogove panely.
 *
 * @since  0.1
 **/
  void activateAnalogs (void);

/**
 * Rozmisti analogove panely po hlavnim panelu a spocte jeho rozmery.
 *
 * @param showPanels je true jsou rozsviceny (show) subpanely
 * @since  0.2
 **/
  void setSize (bool showPanels = false);


/**
 * Prekresli zmenu rozsahu pro dany analogovy panel (jenom jeden)
 * Pokud panel nepodporuje zmeny rozsahu neprovede nic.
 * Zmenu rozsahu podporuji nasledujici panely: Current,BattVolt,BattCurrent
 *
 * @param panelNumber je cislo analogoveho panelu.
 * @param value je hodnota na kterou je panel nastaven.
 *
 * @since  0.1
 **/
  void repaintScaleAnalogPanel (int panelNumber, float value);

/**
 * Paints pointer for selected analog panel
 * Prekresli rucicku pro vybrany analogovy panel.
 *
 * @param panelNumber is number of analog panel.
 * @param value is value of settimg amalog panel.
 * @param run = TRUE makes immediately repaint of panel 
 * @param panelNumber je cislo analogoveho panelu.
 * @param value je hodnota na kterou je panel nastaven.
 * @param run = TRUE provede okamzite prekresleni 
 *
 * @since  0.2
 **/
  void repaintAnalogPointer (int panelNumber, float value, bool run = true);


/**
 * Repaints analog panels
 * Repainting range of panel for frequency and voltage, based on current setting.
 * Prekresli a prebarvi analogove panely.
 * Prekresuje rozsah panelu pro frekvenci a nepeti na zaklade soucasneho nastaveni.
 *
 * @param repaintFrequencyPanels urcuje ze ma prekreslit panely ktere zobrazuji vstupni frequency.
 * @param repaintVoltagePanels urcuje ze ma prekreslit panely ktere zobrazuji vstupni a vystupni napeti.
 * @param repaintAllPanels urcuje ze ma prebarvit vsechny prvky panelu.
 *
 * @since  0.1
 **/
  void repaintAnalogPanels (bool repaintFrequencyPanels, bool repaintVoltagePanels, bool repaintAllPanels);






/**
 * Changes type of digital processing of pointer and repaints it.
 * Zmeni zpusob digitalniho zpracovani rucucky a  prekresli ji
 *
 * @since  0.1
 **/
  void changeAnalogPanelsDigProcessing (void);


/**
 * Sets value of panels to zero
 * Nastavi hodnotu vsech panelu na nulu
 *
 * @since  0.1
 **/
   void zeroingPanels (void);

/**
 * Repaints backgroud of analog panels
 * Prebarvi pozadi analogovych panelu.
 *
 * @param taPanelPalette je hodnota nove palety pro pozadi
 *
 * @since  0.1
 **/
  void setAnalogBG(TQPalette aPanelPalette);



/**
 * Vraci soucasnou velikost panelu.
 *
 * @since  0.1
 **/
  virtual TQSize sizeHint (void);

public slots:

  /**
   * Sets new font for all panels
   * Nastavy novy font ve vsech panelech.
   *
   * @since  0.1
   **/
  void slotSetPanelsFont(TQFont newFont);


private:
/************ private const *****************/

  static const int SpacePanels = 2; //vzdalenost mezi meraky, length between panels

  static const int MaxBattVolt = 350;   //   max battery.voltage
  static const int MaxCurrent = 50;    //     max output.current
  static const int MaxBattCurrent = 50;   //  max battery.current
/************ private struct ************************/

  struct analogPanelRecordsDef {
    int scaleEnd[knc::NumberOfVars];
    int scaleStart[knc::NumberOfVars];
    KNutAnalog* upsAnalogs[knc::NumberOfVars];
    };


/*********** private vars *******************/

  TQLabel* m_analogArea;

  analogPanelRecordsDef* m_analogPanels;

  KNutVarData::upsInfoDef* m_activeUpsInfo; // values for selected ups -- hodnoty pro vybrane ups
  KNutVarData::SettingDataDef* m_settingData;  // v teto strukture jsou ulozeny promene ktere nastavuji konfiguraci

  KNutVarData* m_analogRecords;

  TQPalette m_aPanelPalette;

  int m_widthArea;
  int m_heightArea;
};

#endif
