/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.

    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>

    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.

    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/

#ifndef _RG_ROSEGARDENTIMEWIDGET_H_
#define _RG_ROSEGARDENTIMEWIDGET_H_

#include "base/RealTime.h"
#include <tqgroupbox.h>
#include <tqstring.h>
#include <vector>
#include "base/Event.h"


class TQWidget;
class TQSpinBox;
class TQLineEdit;
class TQLabel;
class TQComboBox;


namespace Rosegarden
{

class Composition;


class TimeWidget : public TQGroupBox
{
    Q_OBJECT
  
public:
    /**
     * Constructor for absolute time widget
     */
    TimeWidget(TQString title,
               TQWidget *parent,
               Composition *composition, // for bar/beat/msec
               timeT initialTime,
               bool editable = true,
               bool constrainToCompositionDuration = true);

    /**
     * Constructor for duration widget.  startTime is the absolute time
     * at which this duration begins, necessary so that we can show the
     * correct real-time (based on tempo at startTime) etc.
     */
    TimeWidget(TQString title,
               TQWidget *parent,
               Composition *composition, // for bar/beat/msec
               timeT startTime,
               timeT initialDuration,
               bool editable = true,
               bool constrainToCompositionDuration = true);

    timeT getTime();
    RealTime getRealTime();

signals:
    void timeChanged(timeT);
    void realTimeChanged(RealTime);

public slots:
    void slotSetTime(timeT);
    void slotSetRealTime(RealTime);
    void slotResetToDefault();

    void slotNoteChanged(int);
    void slotTimeTChanged(int);
    void slotBarBeatOrFractionChanged(int);
    void slotSecOrMSecChanged(int);

private:
    Composition *m_composition;
    bool m_isDuration;
    bool m_constrain;
    timeT m_time;
    timeT m_startTime;
    timeT m_defaultTime;

    TQComboBox *m_note;
    TQSpinBox  *m_timeT;
    TQSpinBox  *m_bar;
    TQSpinBox  *m_beat;
    TQSpinBox  *m_fraction;
    TQLineEdit *m_barLabel;
    TQLineEdit *m_beatLabel;
    TQLineEdit *m_fractionLabel;
    TQLabel    *m_timeSig;
    TQSpinBox  *m_sec;
    TQSpinBox  *m_msec;
    TQLineEdit *m_secLabel;
    TQLineEdit *m_msecLabel;
    TQLabel    *m_tempo;

    void init(bool editable);
    void populate();

    std::vector<timeT> m_noteDurations;
};


}

#endif
