/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.

    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>

    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.

    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/

#ifndef _RG_ROSEGARDENFADER_H_
#define _RG_ROSEGARDENFADER_H_

#include "base/AudioLevel.h"
#include <map>
#include <tqcolor.h>
#include <tqwidget.h>
#include <utility>


class TQWheelEvent;
class TQTimer;
class TQPixmap;
class TQPaintEvent;
class TQMouseEvent;


namespace Rosegarden
{

class TextFloat;


class Fader : public TQWidget
{
    Q_OBJECT
  

public:
    /**
     * Construct a dB fader.  The fader calculates its orientation
     * based on the given dimensions.
     */
    Fader(AudioLevel::FaderType,
                    int width, int height, TQWidget *parent);

    /**
     * Construct a fader on an integral scale.  The fader calculates
     * its orientation based on the given dimensions.
     */
    Fader(int min, int max, int deflt,
                    int width, int height, TQWidget *parent);

    /**
     * Construct a fader on an integral scale, with a 1:1 ratio of
     * pixel positions and values.
     */
    Fader(int min, int max, int deflt,
                    bool vertical, TQWidget *parent);

    virtual ~Fader();
    
    void setOutlineColour(TQColor);

    float getFaderLevel() const;

public slots:
    void setFader(float value);
    void slotFloatTimeout();

signals:
    void faderChanged(float);

protected:
    virtual void paintEvent(TQPaintEvent *);
    virtual void mousePressEvent(TQMouseEvent *);
    virtual void mouseReleaseEvent(TQMouseEvent *);
    virtual void mouseMoveEvent(TQMouseEvent *);
    virtual void wheelEvent(TQWheelEvent *);

    float position_to_value(int);
    int value_to_position(float);

    void calculateGroovePixmap();
    void calculateButtonPixmap();
    void showFloatText();

    bool m_integral;
    bool m_vertical;

    int m_sliderMin;
    int m_sliderMax;
    float m_value;

    int m_min;
    int m_max;
    AudioLevel::FaderType m_type;

    int m_clickMousePos;
    int m_clickButtonPos;

    TextFloat *m_float;
    TQTimer              *m_floatTimer;

    TQPixmap *groovePixmap();
    TQPixmap *buttonPixmap();

    TQColor m_outlineColour;

    typedef std::pair<int, int> SizeRec;
    typedef std::map<unsigned int, TQPixmap *> ColourPixmapRec; // key is TQColor::pixel()
    typedef std::pair<ColourPixmapRec, TQPixmap *> PixmapRec;
    typedef std::map<SizeRec, PixmapRec> PixmapCache;
    static PixmapCache m_pixmapCache;
};


// AudioVUMeter - a vertical audio meter.  Default is stereo.
//

}

#endif
