/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.

    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>

    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.

    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/

#ifndef _RG_PLAYLIST_H_
#define _RG_PLAYLIST_H_

#include <tqvbox.h>


class TQWidget;
class TQPushButton;
class TQListViewItem;
class TQHBoxLayout;
class TQFrame;
class TQDropEvent;


namespace Rosegarden
{

class PlayListView;


class PlayList : public TQVBox
{
    Q_OBJECT
  

public:
    PlayList(TQWidget *parent = 0, const char *name = 0);
    ~PlayList();

    PlayListView* getListView() { return m_listView; }

    void enableButtons(TQListViewItem*);


signals:
    void play(TQString);

protected slots:
    void slotOpenFiles();
    void slotPlay();
    void slotMoveUp();
    void slotMoveDown();
    void slotDeleteCurrent();
    void slotClear();
    void slotCurrentItemChanged(TQListViewItem*);
    void slotDropped(TQDropEvent*, TQListViewItem*);

protected:
    void save();
    void restore();

    //--------------- Data members ---------------------------------
    PlayListView* m_listView;
    TQFrame* m_buttonBar;
    TQHBoxLayout* m_barLayout;

    TQPushButton* m_openButton;
    TQPushButton* m_playButton;
    TQPushButton* m_moveUpButton;
    TQPushButton* m_moveDownButton;
    TQPushButton* m_deleteButton;
    TQPushButton* m_clearButton;
};



}

#endif
