/**
 * This file is part of the System Settings package
 * Copyright (C) 2005 Benjamin C Meyer (ben+systempreferences at meyerhome dot net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "modulesview.h"

#include <tqlabel.h>
#include <tdelocale.h>
#include <kservicegroup.h>
#include <tqlayout.h>
#include <kiconloader.h>
#include <kcmultidialog.h>
#include <kdialogbase.h>
#include <kiconviewsearchline.h>
#include <tdeapplication.h>
#include <tdeaboutapplication.h>
#include <kdebug.h>
#include <tqiconview.h>

#include "kcmsearch.h"
#include "moduleiconitem.h"
#include "tdecmodulemenu.h"

ModulesView::ModulesView( TDECModuleMenu *rootMenu, const TQString &menuPath, TQWidget *parent,
		const char *name ) : TQWidget( parent, name ), rootMenu( NULL )
{
	this->rootMenu = rootMenu;	
	this->menuPath = menuPath;

	TQVBoxLayout *layout = new TQVBoxLayout( this, 11, 6, "layout" );

	displayName = this->rootMenu->caption;

	TQValueList<MenuItem> subMenus = rootMenu->menuList(menuPath);
 	TQValueList<MenuItem>::iterator it;
	for ( it = subMenus.begin(); it != subMenus.end(); ++it ){
		if( !(*it).menu )
			continue;

		// After the first time around add a line
		if( it != subMenus.begin() ){
			TQFrame *line = new TQFrame( this, "line");
			line->setFrameShadow( TQFrame::Sunken );
			line->setFrameShape( TQFrame::HLine );
			layout->addWidget( line );
		}

		// Build the row of modules/icons
		createRow( (*it).subMenu, layout );
	}
	layout->addStretch(1);

	// Make empty iconView for the search widget
	if( groups.count()==0 ) {
		RowIconView *iconView = new RowIconView( this, "groupiconview" );
		iconView->setLineWidth( 0 );
		groups.append( iconView );
	}
	setPaletteBackgroundColor( groups[0]->paletteBackgroundColor() );

	// Align them up!
	{

	uint most = 0;
	TQValueList<RowIconView*>::iterator it;
	for ( it = groups.begin(); it != groups.end(); ++it ){
		TQIconViewItem *item = (*it)->firstItem();
		while( item ) {
			if(item->width() > most)
				most = item->width();
			item = item->nextItem();
		}
	}

	for ( it = groups.begin(); it != groups.end(); ++it )
		(*it)->setGridX(most);

	}
}

ModulesView::~ModulesView()
{
}

void ModulesView::createRow( const TQString &parentPath, TQBoxLayout *boxLayout )
{
	KServiceGroup::Ptr group = KServiceGroup::group( parentPath );
	if ( !group ){
		kdDebug() << "Invalid Group \"" << parentPath << "\".  Check your installation."<< endl;
		return;
	}

	// Make header
	TQHBoxLayout *rowLayout = new TQHBoxLayout( 0, 0, 6, "rowLayout" );

	// Heaer Icon
	TQLabel *icon = new TQLabel( this, "groupicon" );
	icon->setPixmap( SmallIcon( group->icon() ) );
	icon->setSizePolicy( TQSizePolicy( (TQSizePolicy::SizeType)1,
		(TQSizePolicy::SizeType)5, 0, 0, icon->sizePolicy().hasHeightForWidth() ) );
	rowLayout->addWidget( icon );

	// Header Name
	TQLabel *textLabel = new TQLabel( this, "groupcaption" );
	textLabel->setText( group->caption() );
	textLabel->setSizePolicy( TQSizePolicy( (TQSizePolicy::SizeType)7,
		(TQSizePolicy::SizeType)5, 0, 0, textLabel->sizePolicy().hasHeightForWidth()));
	TQFont textLabel_font(  textLabel->font() );
	textLabel_font.setBold( true );
	textLabel->setFont( textLabel_font );
	rowLayout->addWidget( textLabel );

	boxLayout->addLayout( rowLayout );

	// Make IconView
	RowIconView *iconView = new RowIconView( this, "groupiconview" );
	iconView->setFrameShape( RowIconView::StyledPanel );
	iconView->setLineWidth( 0 );
	iconView->setSpacing( 0 );
	iconView->setMargin( 0 );
	iconView->setItemsMovable( false );
	iconView->setSelectionMode(TQIconView::NoSelection);
	groups.append( iconView );
	connect(iconView, TQT_SIGNAL( clicked( TQIconViewItem* ) ),
		      this, TQT_SIGNAL( itemSelected( TQIconViewItem* ) ) );
	boxLayout->addWidget( iconView );

	// Add all the items in their proper order
	TQValueList<MenuItem> list = rootMenu->menuList( parentPath );
 	TQValueList<MenuItem>::iterator it;
	for ( it = list.begin(); it != list.end(); ++it ){
		if( !(*it).menu )
			(void)new ModuleIconItem( iconView, (*it).item );
		else
		{
			TQString path = (*it).subMenu;
			KServiceGroup::Ptr group = KServiceGroup::group( path );
			if ( group ) {
				ModuleIconItem *item = new ModuleIconItem( ((TDEIconView*)iconView),
												group->caption(), group->icon() );
				item->modules = rootMenu->modules( path );
			}
		}
	}

	// Force the height for those items that have two words.
	iconView->setMinimumHeight( iconView->minimumSizeHint().height() );
}

void ModulesView::clearSelection() {
	TQValueList<RowIconView*>::iterator it;
	for ( it = groups.begin(); it != groups.end(); ++it ) {
		(*it)->clearSelection();
	}
}

#include "modulesview.moc"
