//////////////////////////////////////////////////////////////////////////
// bookmarkListItem.cpp                                                 //
//                                                                      //
// Copyright (C)  2005  Lukas Tinkl <lukas@kde.org>                     //
//                                                                      //
// This program is free software; you can redistribute it and/or        //
// modify it under the terms of the GNU General Public License          //
// as published by the Free Software Foundation; either version 2       //
// of the License, or (at your option) any later version.               //
//                                                                      //
// This program is distributed in the hope that it will be useful,      //
// but WITHOUT ANY WARRANTY; without even the implied warranty of       //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        //
// GNU General Public License for more details.                         //
//                                                                      //
// You should have received a copy of the GNU General Public License    //
// along with this program; if not, write to the Free Software          //
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA            //
// 02110-1301, USA.                                                     //
//////////////////////////////////////////////////////////////////////////

#include "bookmarkListItem.h"

#include <tdeglobal.h>
#include <tdelocale.h>

BookmarkListItem::BookmarkListItem( TQListView *parent, const TQString & url, const TQString & desc, time_t time )
    : TDEListViewItem( parent ), m_desc( desc )
{
    m_url = KURL::fromPathOrURL( url );
    m_dateTime.setTime_t( time );
}

int BookmarkListItem::compare( TQListViewItem * i, int col, bool ascending ) const
{
    if ( col == 1 )
    {
        TQDateTime them = static_cast<BookmarkListItem *>( i )->date();
        if ( m_dateTime < them )
            return -1;
        else if ( m_dateTime > them )
            return 1;
        else
            return 0;
    }
    return TQListViewItem::compare( i, col, ascending );
}

TQString BookmarkListItem::text( int column ) const
{
    if ( column == 0 )
        return m_desc;
    else if ( column == 1 )
        return TDEGlobal::locale()->formatDateTime( m_dateTime );

    return TQString();
}

KURL BookmarkListItem::url() const
{
    return m_url;
}

TQDateTime BookmarkListItem::date() const
{
    return m_dateTime;
}

TQString BookmarkListItem::desc() const
{
    return m_desc;
}
