/***************************************************************************
                          messageoutput.cpp  -  description
                             -------------------
    begin                : Thu Feb 24 2000
    copyright            : (C) 2000 by Yacovlev Alexander & Dmitry Poplavski <pdima@mail.univ.kiev.ua>
                           (C) 2003-2005 Andras Mantia <amantia@kde.org>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// KDE includes
#include <tdeapplication.h>
#include <kdebug.h>
#include <tdefiledialog.h>
#include <tdelocale.h>
#include <tdemessagebox.h>
#include <tdepopupmenu.h>
#include <kiconloader.h>

// TQt includes
#include <tqclipboard.h>
#include <tqfile.h>
#include <tqtextstream.h>

#include "messageoutput.h"
#include "messageitem.h"

MessageOutput::MessageOutput(TQWidget *parent, const char *name )
  : TQListBox(parent,name)
{
  m_maxItems = 2000;

  TQPalette pal = palette();
  pal.setColor(TQColorGroup::HighlightedText, pal.color(TQPalette::Active, TQColorGroup::Text));
  pal.setColor(TQColorGroup::Highlight,       pal.color(TQPalette::Active, TQColorGroup::Mid));
  setPalette(pal);
  setFocusPolicy( TQWidget::NoFocus );

  m_popupMenu = new TDEPopupMenu(this);
  connect(this, TQ_SIGNAL(contextMenuRequested(TQListBoxItem*, const TQPoint&)),
     this, TQ_SLOT(showMenu(TQListBoxItem*, const TQPoint&)));
  m_popupMenu->insertItem( SmallIconSet("edit-copy"), i18n("&Copy"), this, TQ_SLOT(copyContent()) ) ;
  m_popupMenu->insertItem( SmallIconSet("document-save-as"), i18n("&Save As..."), this, TQ_SLOT(saveContent()) ) ;
  m_popupMenu->insertSeparator();
  m_popupMenu->insertItem( SmallIconSet("edit-clear"), i18n("Clear"), this, TQ_SLOT(clear()) ) ;

  connect( this, TQ_SIGNAL(clicked(TQListBoxItem*)), TQ_SLOT(clickItem(TQListBoxItem*)) );
}

MessageOutput::~MessageOutput()
{
}

MessageItem *MessageOutput::insertItem(const TQString& s)
{
  checkMaxItems();
  MessageItem *it = new MessageItem(this, s);
  setBottomItem(count()>0?count()-1:0);
  return it;
}

void MessageOutput::addToLastItem(const TQString& s)
{
  int ind = count() - 1;
  if ( ind != -1 ) {
    MessageItem *it = dynamic_cast<MessageItem*>( item(ind) );
    if ( it )
      it->addText( s );
    else
      changeItem( text( ind )+ s, ind );
  }
}

void MessageOutput::showMessage(int line, int col, const TQString &fileName, const TQString& s, bool append)
{
  MessageItem *it = 0L;
  TQString message = s;
  int endPos;
  if ( !count() || (!append && !text(count()-1).stripWhiteSpace().isEmpty()) )
    it = insertItem("");
  while ( ( endPos = message.find('\n') ) != -1 ) {
    if (it)
    {
      it->setLine(line);
      it->setColumn(col);
      it->setFileName(fileName);
    }
    addToLastItem( message.left(endPos) );
    it = insertItem("");
    message.remove(0,endPos+1);
  }
  if (!message.isEmpty())
  {
    if (it)
    {
      it->setLine(line);
      it->setColumn(col);
      it->setFileName(fileName);
    }
    addToLastItem( message);
  }
  setBottomItem(count()>0?count()-1:0);
}

void MessageOutput::showMessage(const TQString& s, bool append)
{
  showMessage(-1, -1, "", s, append);
}


void MessageOutput::checkMaxItems()
{
  if ( count() >= m_maxItems )
    removeItem( index(firstItem()) );
}

void MessageOutput::clickItem( TQListBoxItem * l_item )
{
   MessageItem *item = dynamic_cast<MessageItem*>(l_item);
   if ( item )  {
//     kdDebug(24000) << "Column: " << item->column() << endl;
     if ( item->line() != -1  )
       emit clicked( item->fileName(), item->line() - 1, item->column() - 1);
   }
}

void MessageOutput::showMenu( TQListBoxItem*, const TQPoint& l_point )
{
  m_popupMenu->exec(l_point);
}

TQString MessageOutput::content()
{
  TQString p_content;
  for (uint i=0; i<count(); i++)
    p_content.append(text(i) + "\n");
  return p_content;
}

void MessageOutput::copyContent()
{
  tdeApp->clipboard()->setText(content(), TQClipboard::Clipboard);
}

void MessageOutput::saveContent()
{
  KURL url=KFileDialog::getSaveURL(TQDir::currentDirPath(),
    i18n("*.log|Log Files (*.log)\n*|All Files"), this, i18n("Save Log File"));
  if (url.isEmpty())
    return;

  TQFileInfo fileinfo(url.path());
  if (fileinfo.exists() && KMessageBox::warningContinueCancel(0,
      i18n("<qt>File<br><b>%1</b><br>already exists. Overwrite it?</qt>")
      .arg(url.path()), TQString(), i18n("Overwrite")) == KMessageBox::Cancel)
    return;

  TQFile file(url.path());
  if (!file.open(IO_WriteOnly)) {
     KMessageBox::error(0, i18n("<qt>Cannot save log file<br><b>%1</b></qt>")
         .arg(url.url()));
     return;
   }

   TQTextStream textfile(&file);
   textfile << content();
   file.close();

}


#include "messageoutput.moc"
