/*
    This file is part of KOrganizer.

    Copyright (c) 2002 Adriaan de Groot <groot@kde.org>
    Copyright (c) 2004 Cornelius Schumacher <schumacher@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

    As a special exception, permission is given to link this program
    with any edition of TQt, and distribute the resulting executable,
    without including the source code for TQt in the source distribution.
*/

#include <tqtimer.h>

#include <kdebug.h>
#include <tdelocale.h>
#include <tdeglobal.h>

#include "datechecker.h"

DateChecker::DateChecker( TQObject *parent, const char *name )
  : TQObject( parent, name ), mUpdateTimer( 0 )
{
  enableRollover( FollowMonth );
}

DateChecker::~DateChecker()
{
}

void DateChecker::enableRollover( RolloverType r )
{
  switch( r ) {
    case None:
      if ( mUpdateTimer ) {
        mUpdateTimer->stop();
        delete mUpdateTimer;
        mUpdateTimer = 0;
      }
      break;
    case FollowDay:
    case FollowMonth:
      if ( !mUpdateTimer ) {
        mUpdateTimer = new TQTimer( this, "mUpdateTimer" );
        connect( mUpdateTimer, TQ_SIGNAL( timeout() ),
                 TQ_SLOT( possiblyPastMidnight() ) );
      }
      mUpdateTimer->start( 0, true );
      mLastDayChecked = TQDate::currentDate();
  }
  mUpdateRollover = r;
}

void DateChecker::passedMidnight()
{
  TQDate today = TQDate::currentDate();

  if ( today.month() != mLastDayChecked.month() ) {
     if ( mUpdateRollover == FollowMonth ) {
       emit monthPassed( today );
     }
  }
  emit dayPassed( today );
}

void DateChecker::possiblyPastMidnight()
{
  if ( mLastDayChecked != TQDate::currentDate() ) {
    passedMidnight();
    mLastDayChecked = TQDate::currentDate();
  }
  // Set the timer to go off 1 second after midnight
  // or after 8 minutes, whichever comes first.
  if ( mUpdateTimer ) {
    TQTime now = TQTime::currentTime();
    TQTime midnight = TQTime( 23, 59, 59 );
    int msecsWait = TQMIN( 480000, now.msecsTo( midnight ) + 2000 );

    mUpdateTimer->stop();
    mUpdateTimer->start( msecsWait, true );
  }
}

#include "datechecker.moc"
