/***************************************************************************
 *   tdeio-locate: KDE I/O Slave for the locate command                      *
 *                                                                         *
 *   Copyright (C) 2005 by Tobi Vollebregt                                 *
 *   tobivollebregt@gmail.com                                              *
 *                                                                         *
 *   Thanks to Google's Summer Of Code Program!                            *
 *                                                                         *
 *   Copyright (C) 2004 by Armin Straub                                    *
 *   linux@arminstraub.de                                                  *
 *                                                                         *
 *   This program was initially written by Michael Schuerig.               *
 *   Although I have completely rewritten it, most ideas are adopted       *
 *   from his original work.                                               *
 *                                                                         *
 *   Copyright (C) 2002 by Michael Schuerig                                *
 *   michael@schuerig.de                                                   *
 *                                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include <tqtextcodec.h>

#include <kdebug.h>
#include <tdestandarddirs.h>

#include "locater.h"


Locater::Locater(TQObject *parent, const char *name)
	: TQObject(parent, name), m_process(TQTextCodec::codecForLocale())
{
	kdDebug(7134) << "Locater::Locater" << endl;

	connect(&m_process, TQ_SIGNAL(processExited(TDEProcess*)),
			 this, TQ_SLOT(finished(TDEProcess*)));
	connect(&m_process, TQ_SIGNAL(readReady(TDEProcIO*)),
			 this, TQ_SLOT(gotOutput(TDEProcIO*)));

	setupLocate();
}


Locater::~Locater()
{
	kdDebug(7134) << "Locater::~Locater" << endl;
}


void Locater::setupLocate(const TQString& binary, const TQString& additionalArguments)
{
	kdDebug(7134) << "Locater::setupLocate(" << binary << ", " << additionalArguments << ")" << endl;

    // Automatically choose the correct binary if not specified.
    if (binary.isEmpty()) {
        if (!TDEStandardDirs::findExe("slocate").isNull()) {
            m_binary = "slocate";
        } else if (!TDEStandardDirs::findExe("rlocate").isNull()) {
            m_binary = "rlocate";
        } else {
            m_binary = "locate";
        }
        kdDebug(7134) << "Using binary:" << m_binary << endl;
    } else {
        m_binary = binary;
    }
	m_additionalArguments = additionalArguments;
    m_binaryExists = TDEStandardDirs::findExe(m_binary) != TQString();
}


bool Locater::locate(const TQString& pattern, bool ignoreCase, bool regExp)
{
	kdDebug(7134) << "Locater::locate(" << pattern << "," << ignoreCase << "," << regExp << ")" << endl;

	m_process.resetAll();
	m_process << m_binary;
	if (!m_additionalArguments.isEmpty()) {
		m_process << m_additionalArguments;
	}
	if (ignoreCase) {
		// m_process << "--ignore-case";
		m_process << "-i";
	}
	if (regExp) {
		m_process << "-r";
	}
	m_process << pattern;

	return m_process.start(TDEProcess::Block, false);
}

void Locater::stop()
{
	kdDebug(7134) << "Locater::stop()" << endl;

	m_process.kill();
	emit finished();
}


void Locater::gotOutput(TDEProcIO* /*proc*/)
{
	//kdDebug(7134) << "Locater::gotOutput" << endl;

	TQStringList items;
	TQString line;

	while (m_process.readln(line) != -1) {
		//kdDebug(7134) << "OUTPUT>> '" << line << "'" << endl;

		items << line;
	}

	emit found(items);
}


void Locater::finished(TDEProcess* /*proc*/)
{
	kdDebug(7134) << "Locater::finished" << endl;

	emit finished();
}


#include "locater.moc"
