/***************************************************************************
 *   Copyright (C) 2007 by Marian Kyral                                    *
 *   mkyral@email.cz                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "sortdialog.h"
#include "tdeconfig.h"
#include <tqwhatsthis.h>

SortDialog::SortDialog ( TQWidget* parent, const char* name, bool modal, WFlags fl )
		: sortdialoglayout ( parent,name, modal,fl )
{
  // set labels
  TQWhatsThis::add(m_radioButtonAsc,i18n(
    "Sort in ascending order "
    "(from A to Z or 0 to 9)."));
  TQWhatsThis::add(m_radioButtonDesc,i18n(
    "Sort in descending order "
    "(from Z to A or 9 to 0)."));
  TQWhatsThis::add(m_checkBoxCase,i18n(
    "Check this for case sensitive sort."));
  TQWhatsThis::add(m_checkBoxUnique,i18n(
    "Check this to remove all duplicated records."));
  TQWhatsThis::add(m_checkBoxByCol,i18n(
    "Check this for sorting by specific column.\n\n"
    "If a part of one line is selected, "
    "this checkbox is automatically selected. "
    "Start and end fields are filled according to selection."));
  TQWhatsThis::add(m_lineEditStartCol,i18n(
    "Start column of the sorting area."));
  TQWhatsThis::add(m_lineEditEndCol,i18n(
    "End column of the sorting area."));
  TQWhatsThis::add(m_radioButtonAlphaSort,i18n(
    "Alphabetical sorting (A-Z)."));
  TQWhatsThis::add(m_radioButtonNumSort,i18n(
    "Numeric sorting (0-9)"));

  config_load();
}

SortDialog::~SortDialog()
{}

/*$SPECIALIZATION$*/
void SortDialog::reject()
{
	TQDialog::reject();
}

void SortDialog::accept()
{
	if (m_checkBoxByCol->isChecked())
  {
    if (m_lineEditStartCol->text().isEmpty() ||
        m_lineEditStartCol->text().toInt() == 0 ||
        m_lineEditEndCol->text().isEmpty() ||
        m_lineEditEndCol->text().toInt() == 0)
    {
      TQMessageBox::warning(this,i18n("Error"),
                                i18n("Fields:\n\"Starting at\" and \"Ending at\"\nhave to contains numbers."),
                                i18n("OK"));
      return;
    }
  }
  config_save();
  TQDialog::accept();
}

int SortDialog::exec()
{
  return TQDialog::exec();
}

void SortDialog::toggledCol()
{
   if (m_lineEditStartCol->isEnabled())
   {
     m_lineEditStartCol->setEnabled(false);
     m_lineEditEndCol->setEnabled(false);
   }
   else
   {
     m_lineEditStartCol->setEnabled(true);
     m_lineEditEndCol->setEnabled(true);
   }
}

void SortDialog::toggledType()
{
  if (m_radioButtonAlphaSort->isChecked())
    m_checkBoxCase->setEnabled(true);
  else
    m_checkBoxCase->setEnabled(false);
}

void SortDialog::config_load ()
{
//   tqDebug("config_load()");
  TDEConfig *config = new TDEConfig("katesortpluginrc");
  m_radioButtonAsc->setChecked(config->readBoolEntry("Asc",true));
  m_radioButtonDesc->setChecked(config->readBoolEntry("Desc",false));
  m_radioButtonAlphaSort->setChecked(config->readBoolEntry("Alpha",true));
  m_radioButtonNumSort->setChecked(config->readBoolEntry("Num",false));
  m_checkBoxCase->setChecked(config->readBoolEntry("Case",false));
  m_checkBoxUnique->setChecked(config->readBoolEntry("Unique",false));
  m_checkBoxByCol->setChecked(config->readBoolEntry("By col",false));
  m_lineEditStartCol->setText(config->readEntry("Start col"));
  m_lineEditEndCol->setText(config->readEntry("End col"));
}

void SortDialog::config_save ()
{
//   tqDebug("config_save()");
  TDEConfig *config = new TDEConfig("katesortpluginrc");
  config->writeEntry("Asc",m_radioButtonAsc->isOn());
  config->writeEntry("Desc", m_radioButtonDesc->isOn());
  config->writeEntry("Alpha",m_radioButtonAlphaSort->isOn());
  config->writeEntry("Num", m_radioButtonNumSort->isOn());
  config->writeEntry("Case", m_checkBoxCase->isOn());
  config->writeEntry("Unique", m_checkBoxUnique->isOn());
  config->writeEntry("By col", m_checkBoxByCol->isOn());
  config->writeEntry("Start col", m_lineEditStartCol->text());
  config->writeEntry("End col", m_lineEditEndCol->text());
  config->sync();
}

#include "sortdialog.moc"

