#ifndef _KVI_KVS_TREENODE_OPERATION_H_
#define _KVI_KVS_TREENODE_OPERATION_H_
//=============================================================================
//
//   File : kvi_kvs_treenode_operation.h
//   Created on Thu 18 Dec 2003 22:36:00 by Szymon Stefanek
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 2003 Szymon Stefanek <pragma at kvirc dot net>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================


#include "kvi_settings.h"
#include "kvi_qstring.h"
#include "kvi_kvs_treenode_instruction.h"

class KviKvsTreeNodeData;
class KviKvsRunTimeContext;

class KVIRC_API KviKvsTreeNodeOperation : public KviKvsTreeNodeInstruction
{
public:
	KviKvsTreeNodeOperation(const TQChar * pLocation);
	~KviKvsTreeNodeOperation();
protected:
	KviKvsTreeNodeData * m_pTargetData; // can't be null
public:
	void setTargetVariableReference(KviKvsTreeNodeData * r);
	virtual void contextDescription(TQString &szBuffer);
	virtual void dump(const char * prefix);
};

class KviKvsTreeNodeOperationAssignment : public KviKvsTreeNodeOperation
{
public:
	KviKvsTreeNodeOperationAssignment(const TQChar * pLocation,KviKvsTreeNodeData * pRightSide);
	~KviKvsTreeNodeOperationAssignment();
protected:
	KviKvsTreeNodeData * m_pRightSide; // can't be 0
public:
	virtual void contextDescription(TQString &szBuffer);
	virtual void dump(const char * prefix);
	virtual bool execute(KviKvsRunTimeContext * c);
};

class KviKvsTreeNodeOperationDecrement : public KviKvsTreeNodeOperation
{
public:
	KviKvsTreeNodeOperationDecrement(const TQChar * pLocation);
	~KviKvsTreeNodeOperationDecrement();
public:
	virtual void contextDescription(TQString &szBuffer);
	virtual void dump(const char * prefix);
	virtual bool execute(KviKvsRunTimeContext * c);
};

class KviKvsTreeNodeOperationIncrement : public KviKvsTreeNodeOperation
{
public:
	KviKvsTreeNodeOperationIncrement(const TQChar * pLocation);
	~KviKvsTreeNodeOperationIncrement();
public:
	virtual void contextDescription(TQString &szBuffer);
	virtual void dump(const char * prefix);
	virtual bool execute(KviKvsRunTimeContext * c);
};

class KviKvsTreeNodeOperationSelfAnd : public KviKvsTreeNodeOperation
{
public:
	KviKvsTreeNodeOperationSelfAnd(const TQChar * pLocation,KviKvsTreeNodeData * pRightSide);
	~KviKvsTreeNodeOperationSelfAnd();
protected:
	KviKvsTreeNodeData * m_pRightSide; // can't be 0
public:
	virtual void contextDescription(TQString &szBuffer);
	virtual void dump(const char * prefix);
	virtual bool execute(KviKvsRunTimeContext * c);
};

class KviKvsTreeNodeOperationSelfDivision : public KviKvsTreeNodeOperation
{
public:
	KviKvsTreeNodeOperationSelfDivision(const TQChar * pLocation,KviKvsTreeNodeData * pRightSide);
	~KviKvsTreeNodeOperationSelfDivision();
protected:
	KviKvsTreeNodeData * m_pRightSide; // can't be 0
public:
	virtual void contextDescription(TQString &szBuffer);
	virtual void dump(const char * prefix);
	virtual bool execute(KviKvsRunTimeContext * c);
};

class KviKvsTreeNodeOperationSelfModulus : public KviKvsTreeNodeOperation
{
public:
	KviKvsTreeNodeOperationSelfModulus(const TQChar * pLocation,KviKvsTreeNodeData * pRightSide);
	~KviKvsTreeNodeOperationSelfModulus();
protected:
	KviKvsTreeNodeData * m_pRightSide; // can't be 0
public:
	virtual void contextDescription(TQString &szBuffer);
	virtual void dump(const char * prefix);
	virtual bool execute(KviKvsRunTimeContext * c);
};

class KviKvsTreeNodeOperationSelfMultiplication : public KviKvsTreeNodeOperation
{
public:
	KviKvsTreeNodeOperationSelfMultiplication(const TQChar * pLocation,KviKvsTreeNodeData * pRightSide);
	~KviKvsTreeNodeOperationSelfMultiplication();
protected:
	KviKvsTreeNodeData * m_pRightSide; // can't be 0
public:
	virtual void contextDescription(TQString &szBuffer);
	virtual void dump(const char * prefix);
	virtual bool execute(KviKvsRunTimeContext * c);
};

class KviKvsTreeNodeOperationSelfOr : public KviKvsTreeNodeOperation
{
public:
	KviKvsTreeNodeOperationSelfOr(const TQChar * pLocation,KviKvsTreeNodeData * pRightSide);
	~KviKvsTreeNodeOperationSelfOr();
protected:
	KviKvsTreeNodeData * m_pRightSide; // can't be 0
public:
	virtual void contextDescription(TQString &szBuffer);
	virtual void dump(const char * prefix);
	virtual bool execute(KviKvsRunTimeContext * c);
};

class KviKvsTreeNodeOperationSelfShl : public KviKvsTreeNodeOperation
{
public:
	KviKvsTreeNodeOperationSelfShl(const TQChar * pLocation,KviKvsTreeNodeData * pRightSide);
	~KviKvsTreeNodeOperationSelfShl();
protected:
	KviKvsTreeNodeData * m_pRightSide; // can't be 0
public:
	virtual void contextDescription(TQString &szBuffer);
	virtual void dump(const char * prefix);
	virtual bool execute(KviKvsRunTimeContext * c);
};

class KviKvsTreeNodeOperationSelfShr : public KviKvsTreeNodeOperation
{
public:
	KviKvsTreeNodeOperationSelfShr(const TQChar * pLocation,KviKvsTreeNodeData * pRightSide);
	~KviKvsTreeNodeOperationSelfShr();
protected:
	KviKvsTreeNodeData * m_pRightSide; // can't be 0
public:
	virtual void contextDescription(TQString &szBuffer);
	virtual void dump(const char * prefix);
	virtual bool execute(KviKvsRunTimeContext * c);
};

class KviKvsTreeNodeOperationSelfSubtraction : public KviKvsTreeNodeOperation
{
public:
	KviKvsTreeNodeOperationSelfSubtraction(const TQChar * pLocation,KviKvsTreeNodeData * pRightSide);
	~KviKvsTreeNodeOperationSelfSubtraction();
protected:
	KviKvsTreeNodeData * m_pRightSide; // can't be 0
public:
	virtual void contextDescription(TQString &szBuffer);
	virtual void dump(const char * prefix);
	virtual bool execute(KviKvsRunTimeContext * c);
};

class KviKvsTreeNodeOperationSelfSum : public KviKvsTreeNodeOperation
{
public:
	KviKvsTreeNodeOperationSelfSum(const TQChar * pLocation,KviKvsTreeNodeData * pRightSide);
	~KviKvsTreeNodeOperationSelfSum();
protected:
	KviKvsTreeNodeData * m_pRightSide; // can't be 0
public:
	virtual void contextDescription(TQString &szBuffer);
	virtual void dump(const char * prefix);
	virtual bool execute(KviKvsRunTimeContext * c);
};

class KviKvsTreeNodeOperationSelfXor : public KviKvsTreeNodeOperation
{
public:
	KviKvsTreeNodeOperationSelfXor(const TQChar * pLocation,KviKvsTreeNodeData * pRightSide);
	~KviKvsTreeNodeOperationSelfXor();
protected:
	KviKvsTreeNodeData * m_pRightSide; // can't be 0
public:
	virtual void contextDescription(TQString &szBuffer);
	virtual void dump(const char * prefix);
	virtual bool execute(KviKvsRunTimeContext * c);
};

class KviKvsTreeNodeOperationStringAppend : public KviKvsTreeNodeOperation
{
public:
	KviKvsTreeNodeOperationStringAppend(const TQChar * pLocation,KviKvsTreeNodeData * pRightSide);
	~KviKvsTreeNodeOperationStringAppend();
protected:
	KviKvsTreeNodeData * m_pRightSide; // can't be 0
public:
	virtual void contextDescription(TQString &szBuffer);
	virtual void dump(const char * prefix);
	virtual bool execute(KviKvsRunTimeContext * c);
};

class KviKvsTreeNodeOperationArrayAppend : public KviKvsTreeNodeOperation
{
public:
	KviKvsTreeNodeOperationArrayAppend(const TQChar * pLocation,KviKvsTreeNodeData * pRightSide);
	~KviKvsTreeNodeOperationArrayAppend();
protected:
	KviKvsTreeNodeData * m_pRightSide; // can't be 0
public:
	virtual void contextDescription(TQString &szBuffer);
	virtual void dump(const char * prefix);
	virtual bool execute(KviKvsRunTimeContext * c);
};

class KviKvsTreeNodeOperationStringAppendWithComma : public KviKvsTreeNodeOperation
{
public:
	KviKvsTreeNodeOperationStringAppendWithComma(const TQChar * pLocation,KviKvsTreeNodeData * pRightSide);
	~KviKvsTreeNodeOperationStringAppendWithComma();
protected:
	KviKvsTreeNodeData * m_pRightSide; // can't be 0
public:
	virtual void contextDescription(TQString &szBuffer);
	virtual void dump(const char * prefix);
	virtual bool execute(KviKvsRunTimeContext * c);
};

class KviKvsTreeNodeOperationStringAppendWithSpace : public KviKvsTreeNodeOperation
{
public:
	KviKvsTreeNodeOperationStringAppendWithSpace(const TQChar * pLocation,KviKvsTreeNodeData * pRightSide);
	~KviKvsTreeNodeOperationStringAppendWithSpace();
protected:
	KviKvsTreeNodeData * m_pRightSide; // can't be 0
public:
	virtual void contextDescription(TQString &szBuffer);
	virtual void dump(const char * prefix);
	virtual bool execute(KviKvsRunTimeContext * c);
};

class KviKvsTreeNodeOperationStringTransliteration : public KviKvsTreeNodeOperation
{
public:
	KviKvsTreeNodeOperationStringTransliteration(const TQChar * pLocation,KviKvsTreeNodeData * pLeft,KviKvsTreeNodeData * pRight,KviKvsTreeNodeData * pFlags);
	~KviKvsTreeNodeOperationStringTransliteration();
protected:
	KviKvsTreeNodeData * m_pLeft; // can't be 0
	KviKvsTreeNodeData * m_pRight; // can't be 0
	KviKvsTreeNodeData * m_pFlags; // can't be 0
public:
	virtual void contextDescription(TQString &szBuffer);
	virtual void dump(const char * prefix);
	virtual bool execute(KviKvsRunTimeContext * c);
};

class KviKvsTreeNodeOperationStringSubstitution : public KviKvsTreeNodeOperation
{
public:
	KviKvsTreeNodeOperationStringSubstitution(const TQChar * pLocation,KviKvsTreeNodeData * pLeft,KviKvsTreeNodeData * pRight,KviKvsTreeNodeData * pFlags);
	~KviKvsTreeNodeOperationStringSubstitution();
protected:
	KviKvsTreeNodeData * m_pLeft; // can't be 0
	KviKvsTreeNodeData * m_pRight; // can't be 0
	KviKvsTreeNodeData * m_pFlags; // can't be 0
public:
	virtual void contextDescription(TQString &szBuffer);
	virtual void dump(const char * prefix);
	virtual bool execute(KviKvsRunTimeContext * c);
};


#endif //!_KVI_KVS_TREENODE_OPERATION_H_
