//
// C++ Interface: komposesettings
//
// Description:
//
//
// Author: Hans Oischinger <hans.oischinger@kde-mail.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KOMPOSESETTINGS_H
#define KOMPOSESETTINGS_H

#include <tqobject.h>
#include <tqcolor.h>
#include <tqfont.h>

#define MAX_DESKTOPS 16

enum KomposeDisplay { KOMPOSEDISPLAY_WORLD, KOMPOSEDISPLAY_VIRTUALDESKS, KOMPOSEDISPLAY_CURRENTDESK };

class TDEGlobalAccel;
class TQFontMetrics;


/**
@author Hans Oischinger
*/
class KomposeSettings : public TQObject
{
  TQ_OBJECT
protected:
  KomposeSettings(TQObject *parent = 0, const char *name = 0);

  ~KomposeSettings();

public:
  static KomposeSettings *instance();
  void readConfig();
  void writeConfig();

  bool hasDialogOpen() { return dialogOpen; }
  TDEGlobalAccel *getGlobalAccel() const { return globalAccel; }

  bool getUseComposite() const { return useComposite; }
  void setUseComposite( bool b ) { useComposite = b; }

  bool getPassiveScreenshots() const { return passiveScreenshots; }
  void setPassiveScreenshots( bool b ) { passiveScreenshots = b; }
  uint getScreenshotGrabDelay() { return screenshotGrabDelay; }
  void setScreenshotGrabDelay( uint val ) { screenshotGrabDelay=val; }
  bool getDynamicVirtDeskLayout() const { return dynamicVirtDeskLayout; }
  void setDynamicVirtDeskLayout( bool b ) { dynamicVirtDeskLayout = b; }
  bool getImageEffects() const { return imageEffects; }
  void setImageEffects( bool b ) { imageEffects = b; }
  bool getBlurBackground() const { return blurBackground; }
  void setBlurBackground( bool b ) { blurBackground = b; }

  int  getDefaultView() const { return defaultView; }
  void setDefaultView( int d ) { defaultView = d; }
  int getIconSize() { return iconSize; }
  void setIconSize( int i ) { iconSize = i; }
  int getShowIcons() { return showIcons; }
  void setShowIcons( bool b ) { showIcons = b; }
  int getIconSizePixels();

  void setWindowTitleFont( TQFont f ) { windowTitleFont = f; }
  const TQFont& getWindowTitleFont() const { return windowTitleFont; }
  int getShowWindowTitles() { return showWindowTitles; }
  void setShowWindowTitles( bool b ) { showWindowTitles = b; }
  int getShowWindowTitleShadow() { return showWindowTitleShadow; }
  void setShowWindowTitleShadow( bool b ) { showWindowTitleShadow = b; }
  const TQColor& getWindowTitleFontColor() const { return windowTitleFontColor; }
  void setWindowTitleFontColor( TQColor c ) { windowTitleFontColor = c; }
  const TQColor& getWindowTitleFontShadowColor() const { return windowTitleFontShadowColor; }
  void setWindowTitleFontShadowColor( TQColor c ) { windowTitleFontShadowColor = c; }

  const TQColor& getWindowBorderActiveColor() const { return windowBorderActiveColor; }
  void setWindowBorderActiveColor( TQColor c ) { windowBorderActiveColor = c; }
  const TQColor& getWindowBorderInactiveColor() const { return windowBorderInactiveColor; }
  void setWindowBorderInactiveColor( TQColor c ) { windowBorderInactiveColor = c; }
  int getWindowBorderActiveWidth() const { return windowBorderActiveWidth; }
  void setWindowBorderActiveWidth( int i ) { windowBorderActiveWidth = i; }
  int getWindowBorderInactiveWidth() const { return windowBorderInactiveWidth; }
  void setWindowBorderInactiveWidth( int i ) { windowBorderInactiveWidth = i; }
  int getWindowBorderActiveStyle() const { return windowBorderActiveStyle; }
  void setWindowBorderActiveStyle( int i ) { windowBorderActiveStyle = i; }
  int getWindowBorderInactiveStyle() const { return windowBorderInactiveStyle; }
  void setWindowBorderInactiveStyle( int i ) { windowBorderInactiveStyle = i; }

  const TQFontMetrics* getWindowTitleFontMetrics() { return windowTitleFontMetrics; }
  int getWindowTitleFontAscent() { return windowTitleFontAscent; }
  int getWindowTitleFontHeight() { return windowTitleFontHeight; }

  void setDesktopTitleFont( TQFont f ) { desktopTitleFont = f; }
  const TQFont& getDesktopTitleFont() const { return desktopTitleFont; }
  const TQColor& getDesktopTitleFontColor() const { return desktopTitleFontColor; }
  void setDesktopTitleFontColor( TQColor c ) { desktopTitleFontColor = c; }
  const TQColor& getDesktopTitleFontHighlightColor() const { return desktopTitleFontHighlightColor; }
  void setDesktopTitleFontHighlightColor( TQColor c ) { desktopTitleFontHighlightColor = c; }

  bool getCacheScaledPixmaps() const { return cacheScaledPixmaps; }
  void setCacheScaledPixmaps( bool b ) { cacheScaledPixmaps = b; }

  bool getActivateOnTopLeftCorner() const { return activateOnTopLeftCorner; }
  void setActivateOnTopLeftCorner( bool b ) { activateOnTopLeftCorner = b; }
  bool getActivateOnTopRightCorner() const { return activateOnTopRightCorner; }
  void setActivateOnTopRighCorner( bool b ) { activateOnTopRightCorner = b; }
  bool getActivateOnBottomLeftCorner() const { return activateOnBottomLeftCorner; }
  void setActivateOnBottomLeftCorner( bool b ) { activateOnBottomLeftCorner = b; }
  bool getActivateOnBottomRightCorner() const { return activateOnBottomRightCorner; }
  void setActivateOnBottomRightCorner( bool b ) { activateOnBottomRightCorner = b; }

  bool getActivateOnTopEdge() const { return activateOnTopEdge; }
  void setActivateOnTopEdge( bool b ) { activateOnTopEdge = b; }
  bool getActivateOnLeftEdge() const { return activateOnLeftEdge; }
  void setActivateOnLeftEdge( bool b ) { activateOnLeftEdge= b; }
  bool getActivateOnBottomEdge() const { return activateOnBottomEdge; }
  void setActivateOnBottomEdge( bool b ) { activateOnBottomEdge = b; }
  bool getActivateOnRightEdge() const { return activateOnRightEdge; }
  void setActivateOnRightEdge( bool b ) { activateOnRightEdge = b; }

  uint getAutoLockDelay() { return autoLockDelay; }
  void setAutoLockDelay( uint val ) { autoLockDelay=val; }

  void setShowDesktopNum( bool b ) { showDesktopNum = b; }
  bool getShowDesktopNum() const { return showDesktopNum; }

  void setViewScreen( int screen ) { viewScreen = screen; }
  int getViewScreen() const { return viewScreen; }

public slots:
  void showPreferencesDlg();

protected slots:
  void calcFontMetrics();

signals:
  void settingsChanged();

private:
  TDEGlobalAccel *globalAccel;
  bool dialogOpen;

  bool useComposite;
  bool passiveScreenshots;
  uint screenshotGrabDelay;

  bool dynamicVirtDeskLayout;

  bool imageEffects;
  bool blurBackground;
  int defaultView;

  int iconSize;
  bool showIcons;

  bool showWindowTitles;
  TQFont windowTitleFont;
  TQFontMetrics *windowTitleFontMetrics;
  int windowTitleFontAscent;
  int windowTitleFontHeight;
  TQColor windowTitleFontColor;
  bool showWindowTitleShadow;
  TQColor windowTitleFontShadowColor;

  TQColor windowBorderActiveColor;
  TQColor windowBorderInactiveColor;
  int windowBorderActiveWidth;
  int windowBorderInactiveWidth;
  int windowBorderActiveStyle;
  int windowBorderInactiveStyle;

  TQFont desktopTitleFont;
  TQColor desktopTitleFontColor;
  TQColor desktopTitleFontHighlightColor;

  bool cacheScaledPixmaps;

  bool activateOnTopLeftCorner;
  bool activateOnTopRightCorner;
  bool activateOnBottomLeftCorner;
  bool activateOnBottomRightCorner;

  bool activateOnTopEdge;
  bool activateOnLeftEdge;
  bool activateOnBottomEdge;
  bool activateOnRightEdge;

  uint autoLockDelay;

  bool showDesktopNum;
  int viewScreen;
};

#endif
