#ifndef TQPRO_STREAM_H
#define TQPRO_STREAM_H

//#define USE_QT

#ifdef USE_QT

#include <tqdatastream.h>
#include <tqbuffer.h>

typedef TQ_UINT8  TQP_UINT8;
typedef TQ_INT8   TQP_INT8;
typedef TQ_INT16  TQP_INT16;
typedef TQ_INT32  TQP_INT32;

class QpStream : public TQDataStream
{
public:
   QpStream(unsigned char* pBuffer, unsigned int pLen);
   ~QpStream();

protected:
   TQBuffer        cBuf;
   TQByteArray     cByteArray;

   unsigned char* cBuffer;
   unsigned int   cLen;
};

#else

#include <iostream>
using namespace std;

// ??? sort out how to do sizes

typedef char            TQP_INT8  ;
typedef unsigned char   TQP_UINT8  ;
typedef short           TQP_INT16 ;
typedef int             TQP_INT32 ;
typedef double          TQP_INT64 ;

class QpIStream
{
public:
   QpIStream(const char* pFileName);
   QpIStream(unsigned char* pBuffer, unsigned int pLen);
   ~QpIStream();

   int          get();

   QpIStream&   read(char* pBuf, TQP_INT16 pLen);

       operator void* ();
   int operator !();
 
   QpIStream& operator >> (TQP_INT8  &pI8);
   QpIStream& operator >> (TQP_UINT8 &pI8);
   QpIStream& operator >> (TQP_INT16 &pI16);
   QpIStream& operator >> (TQP_INT32 &pI32);
   QpIStream& operator >> (TQP_INT64 &pI64);
   QpIStream& operator >> (char*& pStr);

protected:
   istream*      cIn;
   long          cOffset;
   streambuf*    cStreamBuf;
};

#endif

#endif // TQPRO_STREAM_H
