/* ============================================================
 * 
 * Copyright 2004-2005 by Gilles Caulier (original work as  digikam curveswidget)
 * Copyright 2005 by Casper Boemann (reworked to be generic)
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * ============================================================ */

#ifndef KCURVE_H
#define KCURVE_H

// TQt includes.

#include <tqwidget.h>
#include <tqcolor.h>
#include <tqpair.h>
#include <tqptrlist.h>
#include <koffice_export.h>
class KRITAUI_EXPORT KCurve : public TQWidget
{
TQ_OBJECT
  

public:
    KCurve(TQWidget *parent = 0, const char *name = 0, WFlags f = 0);

    virtual ~KCurve();

    void reset(void);
    void setCurveGuide(TQColor color);
    void setPixmap(TQPixmap pix);


signals:
    
    void modified(void);
            
protected:

    void keyPressEvent(TQKeyEvent *);
    void paintEvent(TQPaintEvent *);
    void mousePressEvent (TQMouseEvent * e);
    void mouseReleaseEvent ( TQMouseEvent * e );
    void mouseMoveEvent ( TQMouseEvent * e );
    void leaveEvent ( TQEvent * );
    
public:
    static double getCurveValue(TQPtrList<TQPair<double,double> > &curve, double x);
    double getCurveValue(double x);
    
    TQPtrList<TQPair<double,double> > getCurve();
    void setCurve(TQPtrList<TQPair<double,double> >inlist);

private:
    double m_leftmost;
    double m_rightmost;
    TQPair<double,double> *m_grab_point;
    bool m_dragging;
    double m_grabOffsetX;
    double m_grabOffsetY;
    
    bool m_readOnlyMode;
    bool m_guideVisible;
    TQColor m_colorGuide;
    TQPtrList<TQPair<double,double> > m_points;
    TQPixmap *m_pix;
};


#endif /* KCURVE_H */
