/*******************************************************************************
  XDG desktop portal implementation for TDE
  Copyright © 2024 Mavridis Philippe <mavridisf@gmail.com>

  Partially based on code from kdbusnotification
  Copyright © 2021 Emanoil Kotsev <deloptes@gmail.com>

  This program or library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public License as
  published by the Free Software Foundation; either version 2.1 of the License,
  or (at your option) any later version.

  This library is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
  FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
  details.

  You should have received a copy of the GNU Lesser General Public License
  along with this library; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

  Improvements and feedback are welcome!
*******************************************************************************/

#ifndef __PORTAL_DAEMON_H
#define __PORTAL_DAEMON_H

// TQt
#include <tqdbusconnection.h>
#include <tqdbusmessage.h>

// TDE
#include <kuniqueapplication.h>

// DBus
#include "portal_service.h"

// Defines
#define DBUS_PORTAL_SERVICE "org.freedesktop.impl.portal.desktop.tde"
#define DBUS_RETRY_TIMEOUT  5000
#define DBUS_RETRY_COUNT    3

class PortalDaemon : public KUniqueApplication
{
    TQ_OBJECT

    public:
        PortalDaemon();
        virtual ~PortalDaemon();

    private:
        void connectDBus();
        void disconnectDBus();

    private slots:
        void slotDBusSignal(const TQT_DBusMessage&);

    private:
        RootNodeService        *d_root;
        OrgNodeService         *d_org;
        FreeDesktopNodeService *d_freedesktop;
        PortalNodeService      *d_portal;
        DesktopNodeService     *d_desktop;

        TQT_DBusConnection m_connection;
        uint m_retryCount;
};

#endif // __PORTAL_DAEMON_H

// kate: replace-tabs true; tab-width 4; indent-width 4;