//
// C++ Interface: global
//
// Description:
//
//
// Author: Paulo Moura Guedes <moura@kdewebdev.org>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef GLOBAL_H
#define GLOBAL_H

#include <tqobject.h>
class TQCString;

class DCOPClient;
class KURL;
class TDEProcess;

/**
@author Paulo Moura Guedes
*/
class Global : public TQObject
{
    TQ_OBJECT
  
public:
    static Global* self();
    ~Global();

    static bool isKLinkStatusEmbeddedInQuanta();
    static bool isQuantaRunningAsUnique();
    static bool isQuantaAvailableViaDCOP();
    static TQCString quantaDCOPAppId();
    static KURL urlWithQuantaPreviewPrefix(KURL const& url);
    
    //static void setLoopStarted(bool flag);
    static void openQuanta(TQStringList const& args);
    
private:
    Global(TQObject *parent = 0, const char *name = 0);
    static void execCommand(TQString const& command);

private slots:
    void slotGetScriptOutput(TDEProcess* process, char* buffer, int buflen);
    void slotGetScriptError(TDEProcess* process, char* buffer, int buflen);
    void slotProcessExited(TDEProcess* process);
    void slotProcessTimeout();

private:
    static Global* m_self_;

    DCOPClient* dcop_client_;
    bool loop_started_;
    TQString script_output_;
    TDEProcess* process_PS_;
};

#endif
