/*
 * cache.h - (c) 2003 Frerich Raabe <raabe@kde.org>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#ifndef CACHE_H
#define CACHE_H

#include <tqcstring.h>
#include <tqdatetime.h>
#include <tqdict.h>

#include <xmlrpciface.h>

class CacheEntry
{
	friend class Cache;
	friend TQDataStream &operator>>( TQDataStream &s, CacheEntry &e );
	public:
		const TQDateTime &timeStamp() const { return m_timeStamp; }
		const KXMLRPC::Query::Result result() const { return m_result; }
		bool isValid() const;
	
	private:
		TQDateTime m_timeStamp;
		KXMLRPC::Query::Result m_result;
};

class Cache : public TQDict<CacheEntry>
{
	public:
		static Cache &self();

		static TQString getCacheKey( const TQString &server,
		                            const TQString &method,
		                            const TQValueList<TQVariant> &args );

		void load();
		void save();

		void touch( const TQString &key );

		void insert( const TQString &key, const KXMLRPC::Query::Result &result );

	private:
		Cache();
		Cache( const Cache &rhs ); // disabled
		Cache &operator=( const Cache &rhs ); // disabled
		~Cache();

		TQString cacheFileName() const;

		static Cache *m_instance;
};

inline TQDataStream &operator<<( TQDataStream &s, const CacheEntry &e )
{
	s << e.timeStamp();
	s << e.result();
	return s;
}

inline TQDataStream &operator>>( TQDataStream &s, CacheEntry &e )
{
	s >> e.m_timeStamp;
	s >> e.m_result;
	return s;
}

#endif // CACHE_H
