###########################################
#                                         #
#  Improvements and feedback are welcome  #
#                                         #
#  This file is released under GPL >= 3   #
#                                         #
###########################################


# required stuff
find_package( TQt )

tde_setup_architecture_flags( )

include(TestBigEndian)
test_big_endian(WORDS_BIGENDIAN)

tde_setup_largefiles( )


##### check for gcc visibility support

if( WITH_GCC_VISIBILITY )
  tde_setup_gcc_visibility( )
endif( WITH_GCC_VISIBILITY )


##### check for zlib

find_package( ZLIB )
if( NOT ZLIB_FOUND )
  tde_message_fatal( "zlib is required, but not found on your system" )
endif( )


##### check for bzip2

find_package( BZip2 )
if( NOT BZIP2_FOUND )
  tde_message_fatal( "bzip2 is required, but not found on your system" )
endif( )


##### check for expat

find_package( EXPAT )
if( NOT EXPAT_FOUND )
  tde_message_fatal( "expat is required but not found on your system" )
endif()


##### check for fribidi
pkg_search_module( FRIBIDI fribidi )
if( NOT FRIBIDI_FOUND )
  tde_message_fatal( "fribidi is required, but not found on your system" )
endif( )


##### check for sqlite3
pkg_search_module( SQLITE sqlite3 )
if( NOT SQLITE_FOUND )
  tde_message_fatal( "sqlite3 is required, but not found on your system" )
endif( )


##### check for unibreak
pkg_search_module( UNIBREAK libunibreak )
if( NOT UNIBREAK_FOUND )
  tde_message_fatal( "unibreak is required, but not found on your system" )
endif( )


##### check for standalone iconv library
check_include_file( "iconv.h" HAVE_ICONV_H )
if( NOT HAVE_ICONV_H )
  tde_message_fatal( "iconv header is required, but not found on your system" )
endif( )

message( STATUS "Check for standalone libiconv" )
find_library( HAVE_LIBICONV iconv )
if( HAVE_LIBICONV )
  set( ICONV_LIBRARIES iconv )
  message( STATUS "Check for standalone libiconv - found" )
else( )
  set( ICONV_LIBRARIES "" )
  message( STATUS "Check for standalone libiconv - not found" )
endif( )
