/***************************************************************************
 *   Copyright (C) 2006-2012 by Thomas Schweitzer                          *
 *   thomas-schweitzer(at)arcor.de                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2.0 as   *
 *   published by the Free Software Foundation.                            *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program in the file LICENSE.GPL; if not, write to the *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "TemplateBatchScript.h"

/*
    \brief The only static function of this class returns a batch or shell script
    as string that can be used to call an indenter with the current settings from
    the command line.

    The returned string contains some placeholders where the indenter name needs to
    be filled in. The placeholders are "__INDENTERCALLSTRING1__" that should be replaced
    by the indenter call string that indents a complete directory.
    "__INDENTERCALLSTRING2__" the call string for indenting only one file.
    And "__INDENTERCALLSTRINGSCRIPTNAME__" which is only the shown name of the indenter.
 */
const char* TemplateBatchScript::getTemplateBatchScript()
{
	static const char *templateBatchScript =
	        "#!/bin/sh \n"
	        "\n"
	        "if [ ! -n \"$1\" ]; then\n"
	        "echo \"Syntax is: recurse.sh dirname filesuffix\"\n"
	        "echo \"Syntax is: recurse.sh filename\"\n"
	        "echo \"Example: recurse.sh temp cpp\"\n"
	        "exit 1\n"
	        "fi\n"
	        "\n"
	        "if [ -d \"$1\" ]; then\n"
	        "#echo \"Dir ${1} exists\"\n"
	        "if [ -n \"$2\" ]; then\n"
	        "filesuffix=$2\n"
	        "else\n"
	        "filesuffix=\"*\"\n"
	        "fi\n"
	        "\n"
	        "#echo \"Filtering files using suffix ${filesuffix}\"\n"
	        "\n"
	        "file_list=`find ${1} -name \"*.${filesuffix}\" -type f`\n"
	        "for file2indent in $file_list\n"
	        "do \n"
	        "echo \"Indenting file $file2indent\"\n"
	        "__INDENTERCALLSTRING1__\n"
	        "done\n"
	        "else\n"
	        "if [ -f \"$1\" ]; then\n"
	        "echo \"Indenting one file $1\"\n"
	        "__INDENTERCALLSTRING2__\n"
	        "else\n"
	        "echo \"ERROR: As parameter given directory or file does not exist!\"\n"
	        "echo \"Syntax is: __INDENTERCALLSTRINGSCRIPTNAME__ dirname filesuffix\"\n"
	        "echo \"Syntax is: __INDENTERCALLSTRINGSCRIPTNAME__ filename\"\n"
	        "echo \"Example: __INDENTERCALLSTRINGSCRIPTNAME__ temp cpp\"\n"
	        "exit 1\n"
	        "fi\n"
	        "fi\n";
	return templateBatchScript;
}
