/***************************************************************************
    copyright            : (C) 2003-2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#ifndef COLLECTIONFIELDSDIALOG_H
#define COLLECTIONFIELDSDIALOG_H

class KComboBox;
class KLineEdit;
class KPushButton;

class TQRadioButton;
class TQCheckBox;
class TQPainter;

#include "datavectors.h"
#include "gui/listboxtext.h"

#include <kdialogbase.h>

#include <tqmap.h>

namespace Tellico {
  namespace Data {
    class Collection;
  }

class FieldListBox : public GUI::ListBoxText {
public:
  FieldListBox(TQListBox* listbox, Data::FieldPtr field);
  FieldListBox(TQListBox* listbox, Data::FieldPtr field, TQListBoxItem* after);

  Data::FieldPtr field() const { return m_field; }
  void setField(Data::FieldPtr field) { m_field = field; }

private:
  Data::FieldPtr m_field;
};

/**
 * @author Robby Stephenson
 */
class CollectionFieldsDialog : public KDialogBase {
TQ_OBJECT
  

public:
  /**
   * The constructor sets up the dialog.
   *
   * @param coll A pointer to the collection parent of all the attributes
   * @param parent A pointer to the parent widget
   * @param name The widget name
   */
  CollectionFieldsDialog(Data::CollPtr coll, TQWidget* parent, const char* name=0);
  ~CollectionFieldsDialog();

signals:
  void signalCollectionModified();

protected slots:
  virtual void slotOk();
  virtual void slotApply();
  virtual void slotDefault();

private slots:
  void slotNew();
  void slotDelete();
  void slotMoveUp();
  void slotMoveDown();
  void slotTypeChanged(const TQString& type);
  void slotHighlightedChanged(int index);
  void slotModified();
  bool slotShowExtendedProperties();
  void slotSelectInitial();

private:
  void applyChanges();
  void updateField();
  void updateTitle(const TQString& title);
  bool checkValues();
  FieldListBox* findItem(const TQListBox* box, Data::FieldPtr field);
  TQStringList newTypesAllowed(int type);

  Data::CollPtr m_coll;
  Data::CollPtr m_defaultCollection;
  Data::FieldVec m_copiedFields;
  Data::FieldVec m_newFields;
  Data::FieldPtr m_currentField;
  bool m_modified;
  bool m_updatingValues;
  bool m_reordered;
  int m_oldIndex;

  TQListBox* m_fieldsBox;
  KPushButton* m_btnNew;
  KPushButton* m_btnDelete;
  KPushButton* m_btnUp;
  KPushButton* m_btnDown;

  KLineEdit* m_titleEdit;
  KComboBox* m_typeCombo;
  KLineEdit* m_allowEdit;
  KLineEdit* m_defaultEdit;
  KComboBox* m_catCombo;
  KLineEdit* m_descEdit;
  KPushButton* m_btnExtended;

  TQRadioButton* m_formatNone;
  TQRadioButton* m_formatPlain;
  TQRadioButton* m_formatTitle;
  TQRadioButton* m_formatName;
  TQCheckBox* m_complete;
  TQCheckBox* m_multiple;
  TQCheckBox* m_grouped;
};

} // end namespace
#endif
