/***************************************************************************
    copyright            : (C) 2003-2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#ifndef FETCHMANAGER_H
#define FETCHMANAGER_H

namespace Tellico {
  namespace Fetch {
    class SearchResult;
    class ConfigWidget;
    class ManagerMessage;
  }
}

#include "fetcher.h"
#include "../ptrvector.h"

#include <ksortablevaluelist.h>

#include <tqobject.h>
#include <tqmap.h>

namespace Tellico {
  namespace Fetch {

typedef KSortableItem<Type, TQString> TypePair; // fetcher info, type and name of type
typedef KSortableValueList<Type, TQString> TypePairList;
typedef TQMap<FetchKey, TQString> KeyMap; // map key type to name of key
typedef Vector<Fetcher> FetcherVec;

/**
 * A manager for handling all the different classes of Fetcher.
 *
 * @author Robby Stephenson
 */
class Manager : public TQObject {
Q_OBJECT
  

public:
  static Manager* self() {  if(!s_self) s_self = new Manager(); return s_self; }

  ~Manager();

  KeyMap keyMap(const TQString& source = TQString()) const;
  void startSearch(const TQString& source, FetchKey key, const TQString& value);
  void continueSearch();
  void stop();
  bool canFetch() const;
  bool hasMoreResults() const;
  void loadFetchers();
  const FetcherVec& fetchers() const { return m_fetchers; }
  FetcherVec fetchers(int type);
  TypePairList typeList();
  ConfigWidget* configWidget(TQWidget* parent, Type type, const TQString& name);

  // create fetcher for updating an entry
  FetcherVec createUpdateFetchers(int collType);
  FetcherVec createUpdateFetchers(int collType, FetchKey key);
  Fetcher::Ptr createUpdateFetcher(int collType, const TQString& source);

  static TQString typeName(Type type);
  static TQPixmap fetcherIcon(Fetch::Type type, int iconGroup=3 /*Small*/, int size=0 /* default */);
  static TQPixmap fetcherIcon(Fetch::Fetcher::CPtr ptr, int iconGroup=3 /*Small*/, int size=0 /* default*/);

signals:
  void signalStatus(const TQString& status);
  void signalResultFound(Tellico::Fetch::SearchResult* result);
  void signalDone();

private slots:
  void slotFetcherDone(Tellico::Fetch::Fetcher::Ptr);

private:
  friend class ManagerMessage;
  static Manager* s_self;

  Manager();
  Fetcher::Ptr createFetcher(TDEConfig* config, const TQString& configGroup);
  FetcherVec defaultFetchers();
  void updateStatus(const TQString& message);

  static TQString favIcon(const KURL& url);
  static bool bundledScriptHasExecPath(const TQString& specFile, TDEConfig* config);

  FetcherVec m_fetchers;
  int m_currentFetcherIndex;
  KeyMap m_keyMap;
  typedef TQMap<Fetcher::Ptr, TQString> ConfigMap;
  ConfigMap m_configMap;
  StringMap m_scriptMap;
  ManagerMessage* m_messager;
  uint m_count;
  bool m_loadDefaults : 1;
};

  } // end namespace
} // end namespace
#endif
