/***************************************************************************
    copyright            : (C) 2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#include "netaccess.h"
#include "../tellico_kernel.h"
#include "../tellico_debug.h"

#include <tdeversion.h>
#include <tdeio/job.h>
#include <tdeio/netaccess.h>
#include <tdeio/scheduler.h>
#include <tdeio/previewjob.h>
#include <tdetempfile.h>

#include <tqapplication.h>
#include <tqfile.h>

#include <unistd.h> // for unlink()

using Tellico::NetAccess;

TQStringList* NetAccess::s_tmpFiles = 0;

bool NetAccess::download(const KURL& url_, TQString& target_, TQWidget* window_) {
  if(url_.isLocalFile()) {
    return TDEIO::NetAccess::download(url_, target_, window_);
  }

//  if(!TDEIO::NetAccess::exists(url_, true, window_)) {
//    myDebug() << "NetAccess::download() - does not exist: " << url_ << endl;
//    return false;
//  }

  if(target_.isEmpty()) {
    KTempFile tmpFile;
    target_ = tmpFile.name();
    if(!s_tmpFiles) {
      s_tmpFiles = new TQStringList;
    }
    s_tmpFiles->append(target_);
  }

  KURL dest;
  dest.setPath(target_);

  TDEIO::Job* job = TDEIO::file_copy(url_, dest, -1, true /*overwrite*/, false /*resume*/, false /*showProgress*/);
  return TDEIO::NetAccess::synchronousRun(job, window_);
}

void NetAccess::removeTempFile(const TQString& name_) {
  if(!s_tmpFiles) {
    return;
  }
  if(s_tmpFiles->contains(name_)) {
    ::unlink(TQFile::encodeName(name_));
    s_tmpFiles->remove(name_);
  }
}

TQPixmap NetAccess::filePreview(const KURL& url, int size) {
  NetAccess netaccess;

  KURL::List list;
  list.append(url);
  TDEIO::Job* previewJob = TDEIO::filePreview(list, size, size);
  connect(previewJob, TQT_SIGNAL(gotPreview(const KFileItem*, const TQPixmap&)),
          &netaccess, TQT_SLOT(slotPreview(const KFileItem*, const TQPixmap&)));

  TDEIO::NetAccess::synchronousRun(previewJob, Kernel::self()->widget());
  return netaccess.m_preview;
}

TQPixmap NetAccess::filePreview(KFileItem* item, int size) {
  NetAccess netaccess;

  KFileItemList list;
  list.append(item);
  TDEIO::Job* previewJob = TDEIO::filePreview(list, size, size);
  connect(previewJob, TQT_SIGNAL(gotPreview(const KFileItem*, const TQPixmap&)),
          &netaccess, TQT_SLOT(slotPreview(const KFileItem*, const TQPixmap&)));

  TDEIO::NetAccess::synchronousRun(previewJob, Kernel::self()->widget());
  return netaccess.m_preview;
}

void NetAccess::slotPreview(const KFileItem*, const TQPixmap& pix_) {
  m_preview = pix_;
}

#include "netaccess.moc"
