/*
   Copyright (C) 2003 by Roberto Raggi <roberto@kdevelop.org>
   Copyright (C) 2005 by Nicolas Escuder <n.escuder@intra-links.com>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   version 2, License as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef __phpsupport_events_h
#define __phpsupport_events_h

#include <tqevent.h>
#include <tqvaluelist.h>

#include <tqmutex.h>

enum
{
   Event_AddFile =  TQEvent::User + 1000,
   Event_StartParse,
   Event_EndParse,
   Event_AddClass,
   Event_SetClass,
   Event_CloseClass,
   Event_AddFunction,
   Event_SetFunction,
   Event_CloseFunction,
   Event_AddVariable,
   Event_SetVariable,
   Event_AddTodo,
   Event_AddFixme
};

class FileParseEvent: public TQCustomEvent
{
public:
   FileParseEvent(long event, const TQString& fileName )
   : TQCustomEvent(event), m_fileName( fileName )
   {
      m_name = "";
      m_arguments = "";
      m_position = 0;
      m_global = FALSE;
   }

   FileParseEvent(long event, const TQString& fileName, int position )
   : TQCustomEvent(event), m_fileName( fileName ), m_position( position )
   {
      m_name = "";
      m_arguments = "";
      m_global = FALSE;
   }

   FileParseEvent(long event, const TQString& fileName, const TQString& name, const TQString& arguments )
   : TQCustomEvent(event), m_fileName( fileName ), m_name( name ), m_arguments( arguments )
   {
      m_position = 0;
      m_global = FALSE;
   }

   FileParseEvent(long event, const TQString& fileName, const TQString& name, const TQString& arguments, int position )
   : TQCustomEvent(event), m_fileName( fileName ), m_name( name ), m_arguments( arguments ), m_position( position )
   {
      m_global = FALSE;
   }

   FileParseEvent(long event, const TQString& fileName, const TQString& name, const TQString& arguments, int position, bool global )
   : TQCustomEvent(event), m_fileName( fileName ), m_name( name ), m_arguments( arguments ), m_position( position ), m_global( global )
   {
   }

   ~FileParseEvent()
   {
   }

    TQString fileName() const { return m_fileName; }
    TQString name() const { return m_name; }
    TQString arguments() const { return m_arguments; }
    int posititon() const { return m_position; }
    bool global() const { return m_global; }

private:
    TQString m_fileName;
    TQString m_name;
    TQString m_arguments;
    TQString m_accesstype;
    int m_position;
    bool m_global;

private:
    FileParseEvent( const FileParseEvent& source );
    void operator = ( const FileParseEvent& source );
};

#endif // __phpsupport_events_h
