/*
 *  Copyright (C) 2002 Harald Fernengel <harry@kdevelop.org>   
 */

#ifndef __KDEVPART_VALGRIND_H__
#define __KDEVPART_VALGRIND_H__

#include <tqguardedptr.h>
#include <tqstring.h>
#include <tqstringlist.h>
#include <kdevplugin.h>

class ValgrindWidget;
class TDEProcess;

class ValgrindPart : public KDevPlugin
{
  Q_OBJECT
  

public:   
  ValgrindPart( TQObject *parent, const char *name, const TQStringList & );
  ~ValgrindPart();
  
  void runValgrind( const TQString& exec, const TQString& parameters, const TQString& valExec, const TQString& valParameters );

  void savePartialProjectSession( TQDomElement* el );
  void restorePartialProjectSession( const TQDomElement* el );

private slots:
  void slotExecValgrind();
  void slotExecCalltree();
  void slotKillValgrind();
  void slotStopButtonClicked( KDevPlugin* which );
  void receivedStdout( TDEProcess*, char*, int );
  void receivedStderr( TDEProcess*, char*, int );
  void processExited( TDEProcess* );
  void loadOutput();
  void projectOpened();
  
private:
  void getActiveFiles();
  void appendMessage( const TQString& message );
  void appendMessages( const TQStringList& lines );
  void receivedString( const TQString& str );
  void clear();
  TQString _lastExec, _lastParams, _lastValExec, _lastValParams,
      _lastCtExec, _lastCtParams, _lastKcExec;
  TDEProcess* proc;
  TQString currentMessage;
  TQString lastPiece;
  TQStringList activeFiles;
  int currentPid;
  TQGuardedPtr<ValgrindWidget> m_widget;
  struct {
      bool runKc;
      TQString kcPath;
//      TQString kcWorkDir;
  } kcInfo;
};


#endif
