/***************************************************************************
                          tdefilereplaceview.h  -  description
                             -------------------
    begin                : sam oct 16 15:28:00 CEST 1999
    copyright            : (C) 1999 by François Dupoux <dupoux@dupoux.com>
                           (C) 2004 Emiliano Gulmini <emi_barbarossa@yahoo.it>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TDEFILEREPLACEVIEW_H
#define TDEFILEREPLACEVIEW_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

//QT
#include <tqlcdnumber.h>
#include <tqwidgetstack.h>
class TQPixMap;

//KDE
class TDEPopupMenu;
class TDEListView;

//local
#include "tdefilereplaceviewwdg.h"
#include "configurationclasses.h"

class coord
{
  public:
    int line,
        column;
  public:
    coord(){ line = 1;
             column = 1;}
    coord(const coord& c) { line = c.line;
                            column = c.column;}
    coord operator=(const coord& c) { line = c.line;
                                      column = c.column;
                                      return (*this);}
};


/**
 * The view of KFilereplace.
 */
class TDEFileReplaceView : public TDEFileReplaceViewWdg
{
  Q_OBJECT
  
  public://Constructors
    TDEFileReplaceView(RCOptions* info, TQWidget *parent,const char *name);

  public:
    TQString getItemPath(const TQListViewItem *lvi);
    TQListViewItem* getCurrItemTopLevelParent();
    void showSemaphore(TQString s);
    void displayScannedFiles(int foldersNumber, int filesNumber);
    void stringsInvert(bool invertAll);
    void changeViews(bool searchingOnlyMode);
    TDEListView* getResultsView();
    TDEListView* getStringsView();
    void updateOptions(RCOptions* info) { m_option = info; }
    void loadMap(KeyValueMap extMap){ loadMapIntoView(extMap); }
    KeyValueMap getStringsViewMap()const { return m_option->m_mapStringsView;}
    //void emitSearchingOnlyMode(bool b) { emit searchingOnlyMode(b); }

  public slots:
    void slotResultMouseButtonClicked(int button, TQListViewItem *lvi, const TQPoint &pos);
    void slotResultReturnPressed(TQListViewItem *lvi);
    void slotResultProperties();
    void slotResultOpen();
    void slotResultOpenWith();
    void slotResultDirOpen();
    void slotResultEdit();
    void slotResultRemoveEntry();
    void slotResultDelete();
    void slotResultTreeExpand();
    void slotResultTreeReduce();
    void slotResultLoad();
    void slotResultSave();
    void slotResultHeaderClicked(int sortCol);
    void slotStringsAdd();
    void slotQuickStringsAdd(const TQString& quickSearch, const TQString& quickReplace);
    void slotStringsDeleteItem();
    void slotStringsEmpty();
    void slotStringsLoad();
    void slotStringsSave();
    void slotStringsInvertCur();
    void slotStringsInvertAll();

  private:
    void initGUI();
    void changeViews();
    coord extractWordCoordinates(TQListViewItem* lvi);
    void expand(TQListViewItem *lviCurrent, bool b);
    void updateStringMap();
    void loadMapIntoView(KeyValueMap map);
    void whatsThis();

  signals:
    void updateGUI();
  //  void searchingOnlyMode(bool);
  
  private:
    TDEPopupMenu *m_menuResult;
    RCOptions *m_option;
    TDEListView *m_rv, * m_sv;
};

#endif // TDEFILEREPLACEVIEW_H
