/*
 *   This file is part of ScalixAdmin.
 *
 *   Copyright (C) 2007 Trolltech ASA. All rights reserved.
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <tdeaboutdata.h>
#include <tdeapplication.h>
#include <tdecmdlineargs.h>
#include <tdelocale.h>

#include "mainwindow.h"

static const char description[] = I18N_NOOP("Configuration Tool for Scalix Groupware Konnector");

static TDECmdLineOptions options[] =
{
  TDECmdLineLastOption
};

int main( int argc, char **argv )
{
  TDEAboutData aboutData( "scalixadmin", I18N_NOOP("ScalixAdmin"), "1.0", description,
                        TDEAboutData::License_GPL, "(c) 2007, Tobias Koenig" );
  aboutData.addAuthor( "Tobias Koenig",0, "tokoe@kde.org" );
  TDECmdLineArgs::init( argc, argv, &aboutData );
  TDECmdLineArgs::addCmdLineOptions( options );

  TDEApplication app;

  TDEGlobal::locale()->insertCatalogue( "scalixadmin" );

  MainWindow *window = new MainWindow;
  window->show();

  app.setMainWidget( window );

  return app.exec();
}
