 /*
    This file is part of tdepim.

    Copyright (c) 2004 Cornelius Schumacher <schumacher@kde.org>
    Copyright (c) 2004 Till Adam <adam@kde.org>
    Copyright (c) 2005 Reinhold Kainhofer <reinhold@kainhofer.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/
#ifndef KCAL_CALENDARADAPTOR_H
#define KCAL_CALENDARADAPTOR_H

#include "groupwaredataadaptor.h"


#include <libkcal/incidence.h>
#include <kdemacros.h>
#include <kurl.h>

namespace KPIM {
class GroupwareUploadItem;
}

namespace KCal {
class ResourceCached;
class CalendarAdaptor;

class CalendarUploadItem : public KPIM::GroupwareUploadItem
{
  public:
    CalendarUploadItem( CalendarAdaptor *adaptor, KCal::Incidence *incidence, UploadType type );
    virtual ~CalendarUploadItem() {}

  protected:
    CalendarUploadItem( UploadType type ) : KPIM::GroupwareUploadItem( type ) {}
};


class KDE_EXPORT CalendarAdaptor : public KPIM::GroupwareDataAdaptor
{
  TQ_OBJECT
  
  public:
    CalendarAdaptor();

    TQValueList<KPIM::FolderLister::ContentType> supportedTypes()
    {
      TQValueList<KPIM::FolderLister::ContentType> types;
      types << KPIM::FolderLister::Event;
      types << KPIM::FolderLister::Todo;
      types << KPIM::FolderLister::Journal;
      return types;
    }
    
    /**
      Set resource.
    */
    void setResource( KCal::ResourceCached *v )
    {
      mResource = v;
    }
    /**
      Get resource. See setResource().
    */
    KCal::ResourceCached *resource() const
    {
      return mResource;
    }

    virtual TQString mimeType() const;
    bool localItemExists( const TQString &localId );
    bool localItemHasChanged( const TQString &localId );
    void deleteItem( const TQString &localId );
    void clearChange( const TQString &uid );

    virtual KPIM::GroupwareUploadItem *newUploadItem( KCal::Incidence*it,
           KPIM::GroupwareUploadItem::UploadType type );

  public slots:
    /** newLocalId is the new id that was (randomly) assigned to the item */
    virtual void calendarItemDownloaded( KCal::Incidence *inc,
           const TQString &newLocalId, const KURL &remoteId,
           const TQString &fingerprint, const TQString &storagelocation );

  protected:
    void addItem( KCal::Incidence *i );
  private:
    KCal::ResourceCached *mResource;

    TQStringList mAddedItems;
    TQStringList mChangedItems;
    TQStringList mDeletedItems;
};

}

#endif
