/*
    This file is part of KDE.

    Copyright (c) 2004 Cornelius Schumacher <schumacher@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
    
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.
    
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include "opengroupware.h"
#include "webdavhandler.h"

#include <kdebug.h>
#include <kurl.h>
#include <tdeio/job.h>
#include <tdeio/davjob.h>
#include <tdelocale.h>

#include <libtdepim/tdeabcresourcecached.h>

#include <libkcal/freebusy.h>
#include <libkcal/icalformat.h>
#include <libkcal/scheduler.h>
#include <libkcal/calendarlocal.h>

#include <tdeabc/vcardconverter.h>

#include <kinstance.h>
#include <kdebug.h>
#include <tdelocale.h>
#include <tdetempfile.h>

#include <sys/types.h>
#include <unistd.h>
#include <stdlib.h>

#include <kdemacros.h>

namespace TDEABC {

class ResourceMemory : public ResourceCached
{
  public:
    ResourceMemory() : ResourceCached( 0 ) {}
    
    Ticket *requestSaveTicket() { return 0; }
    bool load() { return true; }
    bool save( Ticket * ) { return true; }
    void releaseSaveTicket( Ticket * ) {}
};

}


extern "C" {
KDE_EXPORT int kdemain( int argc, char **argv );
}

int kdemain( int argc, char **argv )
{
  TDEInstance instance( "tdeio_OpenGroupware" );
  
  kdDebug(7000) << "Starting tdeio_OpenGroupware(pid:  " << getpid() << ")" << endl;
  
  if (argc != 4) {
    fprintf( stderr, "Usage: tdeio_OpenGroupware protocol domain-socket1 domain-socket2\n");
    exit( -1 );
  }
  
  OpenGroupware slave( argv[1], argv[2], argv[3] );
  slave.dispatchLoop();
  
  return 0;
}

OpenGroupware::OpenGroupware( const TQCString &protocol, const TQCString &pool,
  const TQCString &app )
  : SlaveBase( protocol, pool, app )
{
}

void OpenGroupware::get( const KURL &url )
{
  kdDebug(7000) << "OpenGroupware::get()" << endl;
  kdDebug(7000) << " URL: " << url.url() << endl;
  #if 1
  kdDebug(7000) << " Path: " << url.path() << endl;
  kdDebug(7000) << " Query: " << url.query() << endl;
  kdDebug(7000) << " Protocol: " << url.protocol() << endl;
  kdDebug(7000) << " Filename: " << url.filename() << endl;
  #endif

  mimeType( "text/plain" );

  TQString path = url.path();
  debugMessage( "Path: " + path );

  if ( path.startsWith( "/freebusy/" ) ) {
    getFreeBusy( url );
  } else if ( path.startsWith( "/calendar/" ) ) {
    getCalendar( url );
  } else if ( path.startsWith( "/addressbook/" ) ) {
    getAddressbook( url );
  } else {
    TQString error = i18n("Unknown path. Known paths are '/freebusy/', "
      "'/calendar/' and '/addressbook/'.");
    errorMessage( error );
  }
  
  kdDebug(7000) << "OpenGroupwareCgiProtocol::get() done" << endl;
}

void OpenGroupware::getFreeBusy( const KURL &url )
{
  TQString file = url.filename();
  if ( file.right( 4 ) != ".ifb" ) {
    TQString error = i18n("Illegal filename. File has to have '.ifb' suffix.");
    errorMessage( error );
  } else {
    TQString email = file.left( file.length() - 4 );
    debugMessage( "Email: " + email );

    TQString user = url.user();
    TQString pass = url.pass();

    debugMessage( "URL: "  );
    debugMessage( "User: " + user );
    debugMessage( "Password: " + pass );

    KCal::FreeBusy *fb = new KCal::FreeBusy;

    if ( user.isEmpty() || pass.isEmpty() ) {
      errorMessage( i18n("Need username and password.") );
    } else {
      // FIXME get from server

      // FIXME: Read range from configuration or URL parameters.
      TQDate start = TQDate::currentDate().addDays( -3 );
      TQDate end = TQDate::currentDate().addDays( 60 );

      fb->setDtStart( start );
      fb->setDtEnd( end );

      kdDebug() << "Login" << endl;

    }

#if 0
    TQDateTime s = TQDateTime( TQDate( 2004, 9, 27 ), TQTime( 10, 0 ) );
    TQDateTime e = TQDateTime( TQDate( 2004, 9, 27 ), TQTime( 11, 0 ) );

    fb->addPeriod( s, e );
#endif

    KCal::ICalFormat format;

    TQString ical = format.createScheduleMessage( fb, KCal::Scheduler::Publish );

    data( ical.utf8() );

    finished();
  }
}


void OpenGroupware::getCalendar( const KURL &_url )
{

  KURL url( _url ); // we'll be changing it
  TQString user = url.user();
  TQString pass = url.pass();

  TQDomDocument props = WebdavHandler::createAllPropsRequest();

  debugMessage( "URL: "  );
  debugMessage( "User: " + user );
  debugMessage( "Password: " + pass );

  url.setProtocol( "webdav" );
  url.setPath ( "/zidestore/dav/till/" );

  kdDebug(7000) << "getCalendar: " << url.prettyURL() << endl;

  // FIXME do progress handling
  mListEventsJob = TDEIO::davPropFind( url, props, "0", false );
  connect( mListEventsJob, TQT_SIGNAL( result( TDEIO::Job * ) ),
           TQT_SLOT( slotGetCalendarListingResult( TDEIO::Job * ) ) );
}

void OpenGroupware::getAddressbook( const KURL &url )
{
  
}

void OpenGroupware::errorMessage( const TQString &msg )
{
  error( TDEIO::ERR_SLAVE_DEFINED, msg );
}

void OpenGroupware::debugMessage( const TQString &msg )
{
#if 0
  data( ( msg + "\n" ).utf8() );
#else
  Q_UNUSED( msg );
#endif
}


void OpenGroupware::slotGetCalendarListingResult( TDEIO::Job *job )
{
  
  kdDebug(7000) << k_funcinfo << endl;

  if (  job->error() ) {
    job->showErrorDialog(  0 );
  } else {
    kdDebug() << "ResourceSlox::slotResult() success" << endl;

    TQDomDocument doc = mListEventsJob->response();

  }
  KCal::ICalFormat format;
  KCal::CalendarLocal calendar;

  TQString ical = format.toString( &calendar );

  data( ical.utf8() );

  finished();
}


void OpenGroupware::slotGetCalendarResult( TDEIO::Job *job )
{
  Q_UNUSED( job );
}
#include "opengroupware.moc"

