/***************************************************************************
                          tdepacman.h  -  description
                             -------------------
    begin                : Sam Jan 19 13:37:57 CET 2002
    copyright            : (C) 1998-2003 by Jörg Thönnissen
    email                : joe@dsite.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TDEPACMAN_H
#define TDEPACMAN_H


#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

// include files for TQt
#include <tqptrlist.h>
#include <tqfileinfo.h>
#include <tqregexp.h>

//include files for TDE
#include <kapp.h>
#include <tdemainwindow.h>
#include <tdepopupmenu.h>
#include <tdeaction.h>
#include <tdelocale.h>
#include <tdemenubar.h>

// application specific includes
#include "tdepacmanview.h"
#include "referee.h"
#include "status.h"
#include "score.h"
#include "keys.h"

// forward declaration of the TDEpacman classes
class TDEpacmanView;

/**
 * The base class for TDEpacman application.
 */
class TDEpacmanApp : public TDEMainWindow
{
  TQ_OBJECT

  friend class TDEpacmanView;

  public:
    /** constructor of TDEpacmanApp, calls all init functions to create the application.
     */
    TDEpacmanApp(TQWidget *parent = 0, const char *name = 0);
    virtual ~TDEpacmanApp();

  protected:
    /** save general Options like all bar positions and status as well as the application specific
     * Options to the configuration file
     */
    void saveOptions();
    /** read general Options again and initialize all variables
     */
    void readOptions();
    /** read graphic schemes and build menu items for selection
     */
    void readSchemes();
    /** initializes the TDEActions of the application */
    void initActions();
    /** sets up the statusbar for the main window by initialzing a statuslabel.
     */
    void initStatusBar();
    /** creates the centerwidget of the KTMainWindow instance and sets it as the view
     */
    void initView();
    /** queryExit is called by KTMainWindow when the last window of the application is going to be closed
     * during the closeEvent().
     * Against the default implementation that just returns true, this calls saveOptions() to save the
     * settings of the window's properties.
     * @see KTMainWindow#queryExit
     * @see KTMainWindow#closeEvent
     */
    virtual bool queryExit();


  public slots:
    /** play new game
     */
    void slotGameNew();
    /** pause (continue) game
     */
    void slotGamePause();
    /** pause (continue) game triggered by focus events
     */
    void slotFocusedGamePause();
    /** toggle the highscores
     */
    void slotGameHighscores();
    /** toggle the highscores, forced by the referee
     */
    void slotForcedGameHighscores();
    /** save the options, then quits the application.
     */
    void slotGameQuit();
    /** toggles the menubar
     */
    void slotShowMenuBar();
    /** toggles the toolbar
     */
    void slotShowToolBar();
    /** toggles the statusbar
     */
    void slotShowStatusBar();
    /** toggles the mousecursor
     */
    void slotShowMouseCursor();
    /** graphic scheme activated
     * @param id the id of the activated/selected menuitem
     */
    void slotSchemeActivated(int id);
    /** toggles the focus out pause
     */
    void slotFocusOutPause();
    /** toggles the focus in continue
     */
    void slotFocusInContinue();
    /** changes the statusbar contents for the standard label permanently, used to indicate current actions.
     * @param text the text that is displayed in the statusbar
     */
    void slotStatusMsg(const TQString &text);
    /** configure keysbindings dialog
     */
    void slotKeyBindings();
    /** game (including highscores displayed) has been finished
     */
    void slotGameFinished();

  private:
    /** the configuration object of the application */
    TDEConfig *config;
    /** view is the main widget which represents your working area. The View
     * class should handle all events of the view widget.  It is kept empty so
     * you can create your view according to your application's needs by
     * changing the view class.
     */
    TDEpacmanView *view;

    // TDEAction pointers to enable/disable actions
    TDEAction* gameNew;
    TDEToggleAction* gamePause;
    TDEAction* gameHighscores;
    TDEAction* gameQuit;
    TDEToggleAction* showMenuBar;
    TDEToggleAction* showToolBar;
    TDEToggleAction* showStatusBar;
    TDEToggleAction* showMouseCursor;
    TDEToggleAction* focusOutPause;
    TDEToggleAction* focusInContinue;
    TDEActionMenu* selectGraphicScheme;

    // active scheme/mode
    int scheme;
    int mode;

    TDEPopupMenu *modesPopup;						// TDEAction main scheme selection menu
    TQPtrList<TDEPopupMenu> *schemesPopup;	// submenus for selecting scheme

    // ID's of the menuitem(s) for finding/selecting scheme by id
    TQMemArray<int> modeID;
    TQMemArray<int> schemeID;

    TQMemArray<int> schemeMode;						// mode(group) of the schemes, -1 if no group

    bool highscoresChecked;						// highscores display active
    bool focusedPause;								// Pause caused by focusEvents
};

#endif // TDEPACMAN_H
