/***************************************************************************
 *
 * main.cpp - A NetworkManager frontend for TDE 
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Timo Hoenig <thoenig@suse.de>, <thoenig@nouse.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

// TDE includes
#include <tdeglobal.h>
#include <tdeaboutdata.h>
#include <tdecmdlineargs.h>
#include <dcopclient.h>
#include <dcopref.h>

// TQt includes
#include <tqtimer.h>

// TDENM includes
#include "tdenetman.h"


static const char* tdenm_version = I18N_NOOP(TDENETWORKMANAGER_VERSION_STRING);
static const char* tdenm_descr   = I18N_NOOP("A NetworkManager front-end for TDE");
static const char* tdenm_copy    = I18N_NOOP("Copyright (C) 2012 Trinity Desktop Project");
static const char* tdenm_webpage = I18N_NOOP("http://www.trinitydesktop.org");

extern "C" KDE_EXPORT int
kdemain (int argc, char* argv[])
{
	TDEAboutData aboutData ("tdenetworkmanager", I18N_NOOP("TDENetworkManager"),
			      tdenm_version, tdenm_descr, TDEAboutData::License_GPL,
			      tdenm_copy, 0, tdenm_webpage );

	aboutData.addAuthor ("Timothy Pearson", I18N_NOOP("TDE Rewrite"), "kb9vqf@pearsoncomputing.net");
	aboutData.addAuthor ("Helmut Schaa", I18N_NOOP("Maintainer"), "hschaa@suse.de");
	aboutData.addAuthor ("Timo Hoenig", I18N_NOOP("Maintainer"), "thoenig@suse.de");
	aboutData.addAuthor ("Will Stephenson", I18N_NOOP("Additional code"), "wstephenson@suse.de");
	aboutData.addAuthor ("Valentine Sinitsyn", I18N_NOOP("Additional code"), "e_val@inbox.ru");
	aboutData.addAuthor ("Stefan Bogner", I18N_NOOP("TDEWallet integration"), "sbogner@suse.de");

	TDECmdLineArgs::init (argc, argv, &aboutData);

	if (TDENetworkManager::start()) {
		TDENetworkManager app;
		app.disableSessionManagement();

		if (!TDEGlobal::hardwareDevices()) {
			printf("[ERROR] Unable to load tdenetworkmanager due to invalid TDEGlobal::hardwareDevices() object\n"); fflush(stdout);
			return -1;
		}
		if (!TDEGlobal::networkManager()) {
			printf("[ERROR] Unable to load tdenetworkmanager due to invalid TDEGlobal::hardwareDevices() object\n"); fflush(stdout);
			return -1;
		}

		return app.exec();
	}
	return 0;
}
