// *************************************************************************
// * Taken from the GSM TA/ME library
// *
// * File:    gsm_unix_port.h
// *
// * Purpose: UNIX serial port implementation with extras
// *
// * Original Author:  Peter Hofmann (software@pxh.de)
// * Modified by: Justin Huff (jjhuff@mspin.net)
// *
// * Created: 4.5.1999
// *************************************************************************

#ifndef GSM_UNIX_SERIAL_KOPETE_H
#define GSM_UNIX_SERIAL_KOPETE_H

#include "config.h"

#include <string>
#include <gsmlib/gsm_error.h>
#include <gsmlib/gsm_port.h>
#include <gsmlib/gsm_util.h>
#include <sys/types.h>
#include <termios.h>

#include <tqobject.h>

class TQSocketNotifier;
namespace gsmlib
{

class KopeteUnixSerialPort : public TQObject, public Port
{
	TQ_OBJECT
	

protected:
	int _fd;                    // file descriptor for device
	int _oldChar;               // character set by putBack() (-1 == none)
	long int _timeoutVal;       // timeout for getLine/readByte

	TQSocketNotifier* _readNotifier;

	// throw GsmException include UNIX errno
	void throwModemException(std::string message);

public:
	// create Port given the UNIX device name
	KopeteUnixSerialPort(std::string device, speed_t lineSpeed = DEFAULT_BAUD_RATE,
				   std::string initString = DEFAULT_INIT_STRING,
				   bool swHandshake = false);
	virtual ~KopeteUnixSerialPort();

	// inherited from Port
	void putBack(unsigned char c);
	int readByte();
	std::string getLine();
	void putLine(std::string line, bool carriageReturn = true);
	bool wait(GsmTime timeout);
	void setTimeOut(unsigned int timeout);

signals:
	void activated();
};

}
#endif // GSM_UNIX_SERIAL_KOPETE_H
