	/*

	Copyright (C) 1998 Stefan Westerfeld
                       stefan@space.twc.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

    */

#include "portposdlg.h"
#include "structureport.h"
#include <tqlayout.h>
#include <tqlabel.h>
#include <tqlistbox.h>
#include <kbuttonbox.h>
#include <tdelocale.h>
#include <kinputdialog.h>
#include <tqbuttongroup.h>
#include <tqradiobutton.h>
#include <tdeapplication.h>
#include <kiconloader.h>
#include <kseparator.h>
#include <tqlineedit.h>
#include <stdio.h>
#include <arts/debug.h>
#include <tqpushbutton.h>
#include <kstdguiitem.h>

using namespace std;

PortPosDlg::PortPosDlg(TQWidget *parent, Structure *structure) :TQDialog(parent,"Props", TRUE)
{
	this->structure = structure;

	setCaption(i18n("aRts: Structureport View"));

	TQVBoxLayout *mainlayout = new TQVBoxLayout(this);
	//TQHBoxLayout *contentslayout = new TQHBoxLayout;

// object type
/*
	mainlayout->addSpacing(5);
	TQLabel *objectlabel = new TQLabel(this);
	TQFont labelfont(objectlabel->font());
	labelfont.setPointSize(labelfont.pointSize()*3/2);
	objectlabel->setFont(labelfont);
	objectlabel->setText(TQString(" ")+i18n("Object type: ")+TQString(port->owner->name())+TQString(" "));
	objectlabel->setAlignment(AlignCenter);
	min_size(objectlabel);
	mainlayout->addWidget(objectlabel);
*/

// port description

/*
	mainlayout->addSpacing(5);
	TQLabel *portlabel = new TQLabel(this);
	labelfont.setPointSize(labelfont.pointSize()*4/5);
	portlabel->setFont(labelfont);
	portlabel->setText(i18n("Port description: ")+ port->description);
	min_size(portlabel);
	portlabel->setAlignment(AlignCenter);
	mainlayout->addWidget(portlabel);

	int labelwidth = imax(portlabel->sizeHint().width(),objectlabel->sizeHint().width());

	portlabel->setMinimumWidth(labelwidth);
	objectlabel->setMinimumWidth(labelwidth);

// hruler

	mainlayout->addSpacing(5);
	KSeparator *ruler = new KSeparator( KSeparator::HLine, this);
	mainlayout->addWidget(ruler);
	mainlayout->addSpacing(5);
	mainlayout->addLayout(contentslayout);
*/
// list

	listbox = new TQListBox(this);

	update();

	listbox->setMinimumSize(100,200);
	mainlayout->addWidget(listbox);
// hruler

	mainlayout->addSpacing(5);
	KSeparator *ruler2 = new KSeparator( KSeparator::HLine, this);
	mainlayout->addWidget(ruler2);

// buttons

	TQHBoxLayout *buttonlayout = new TQHBoxLayout;
	mainlayout->addSpacing(5);
	mainlayout->addLayout(buttonlayout);
	mainlayout->addSpacing(5);

	buttonlayout->addSpacing(5);
	KButtonBox *bbox = new KButtonBox(this);

	bbox->addButton(KStdGuiItem::help(), this, TQ_SLOT( help() ));
	bbox->addStretch(1);

	TDEIconLoader iconloader;
	TQButton *raise = bbox->addButton(i18n("&Raise"));
	raise->setPixmap(iconloader.loadIcon("go-up", TDEIcon::Small));
	connect( raise, TQ_SIGNAL( clicked() ), TQ_SLOT( raise() ));

	TQButton *lower = bbox->addButton(i18n("&Lower"));
	lower->setPixmap(iconloader.loadIcon("go-down", TDEIcon::Small));
	connect( lower, TQ_SIGNAL( clicked() ), TQ_SLOT( lower() ));

	TQButton *rename = bbox->addButton(i18n("R&ename..."));
	connect( rename, TQ_SIGNAL( clicked() ), TQ_SLOT( rename() ));

	TQButton *okbutton = bbox->addButton(KStdGuiItem::ok());
	connect( okbutton, TQ_SIGNAL( clicked() ), TQ_SLOT(accept() ) );

/*
	TQButton *cancelbutton = bbox->addButton(i18n("Cancel"));
	connect( cancelbutton, TQ_SIGNAL( clicked() ), TQ_SLOT(reject() ) );
*/
	bbox->layout();
	//min_size(bbox);

	buttonlayout->addWidget(bbox);
	buttonlayout->addSpacing(5);

	//mainlayout->activate();
	mainlayout->freeze();
}

void PortPosDlg::raise()
{
	int i = listbox->currentItem();
	arts_debug("selected %d",i);
	if(i < 0) return;

	StructurePort *port = listports[i];
	assert(port);

	// hmm ok this is ugly that the raise function calls lowerPosition
	port->lowerPosition();
	update();

	unsigned long l;
	for(l=0;l<listports.size();l++)
		if(listports[l]->id() == port->id())
			listbox->setCurrentItem(l);
}

void PortPosDlg::lower()
{
	int i = listbox->currentItem();
	arts_debug("selected %d",i);
	if(i < 0) return;
	StructurePort *port = listports[i];
	assert(port);

	port->raisePosition();
	update();

	unsigned long l;
	for(l=0;l<listports.size();l++)
		if(listports[l]->id() == port->id())
			listbox->setCurrentItem(l);
}

void PortPosDlg::rename()
{
	int i = listbox->currentItem();
	arts_debug("selected %d",i);
	if(i < 0) return;
	StructurePort *port = listports[i];
	assert(port);

    bool ok;
    TQString name = KInputDialog::getText( i18n( "Rename Port" ),
      i18n( "Enter port name:" ), port->name(), &ok, this );
	if (ok)
	{
		arts_debug("rename OK...");
		port->rename(name.local8Bit());
	}
	update();

	unsigned long l;
	for(l=0;l<listports.size();l++)
		if(listports[l]->id() == port->id())
			listbox->setCurrentItem(l);
}
void PortPosDlg::update()
{
	list<StructureComponent *> &cl = *structure->getComponentList();
	list<StructureComponent *>::iterator ci;

	listports.erase(listports.begin(), listports.end());
	listbox->clear();

	// first incoming ports, then outgoing (which are represented by
	// the opposite directions inside the structure)
	for(int direction = 0; direction < 2; direction++)
	{
		map<long, StructurePort *> pmap;
		int finddirection = ModulePort::in;
		int pcount = 0;

		if(direction == 0) finddirection = ModulePort::out;

		for(ci = cl.begin(); ci != cl.end(); ++ci)
		{
			StructureComponent *component = *ci;
			if(component->type() == StructureComponent::ctPort)
			{
				StructurePort *port = (StructurePort *)component;
				if(port->port()->direction == finddirection)
				{
					arts_debug("port %s position %ld",
							port->name().local8Bit().data(), port->position());
					pmap[port->position()] = port;
					pcount++;
				}
			}
		}
		for(int i=0;i<pcount;i++)
		{
			StructurePort *port = pmap[i];
			if (port)
			{
				assert(port);
				listbox->insertItem(port->name(),listports.size());
				listports.push_back(port);
				arts_debug("listports.size() is now %d",listports.size());
			}
		}
	}
	listbox->repaint();
}

void PortPosDlg::help()
{
	TDEApplication::kApplication()->invokeHelp("", "karts");
}

#include "portposdlg.moc"
