// Author: Denis Kozadaev - (c) 2017-2020


#include "mainwindow.h"

#include <tdeaboutdata.h>
#include <tdeapplication.h>
#include <tdecmdlineargs.h>
#include <tdelocale.h>


const int XSize = 640, YSize = 480;
static const char description[] = I18N_NOOP("TDEFifteen is a sliding puzzle\n"
                                            "that consists of a frame of numbered square tiles\n"
                                            "in random order with one tile missing.");


int main(int argc, char *argv[])
{
    TDEAboutData about( "tdefifteen",                                   // program name used internally
                        I18N_NOOP("TDEFifteen"),                        // displayable program name
                        "14.0.10",                                      // program version string
                        description,                                    // short description
                        TDEAboutData::License_GPL,                      // licence type
                        I18N_NOOP("(c) 2017-2020 Denis Kozadaev"),      // copyright statement
                        0,                                              // text - any information
                        "http://trinitydesktop.org",                    // home page address
                        0);                                             // bug email address

    about.addAuthor( "Denis Kozadaev", "Author", "denis@tambov.ru" );

    TDECmdLineArgs::init(argc, argv, &about);
    TDEApplication app;
    MainWindow* mainWin = new MainWindow();

    mainWin->resize(XSize, YSize);
    mainWin->setMinimumSize( mainWin->size() );
    mainWin->setMaximumSize( mainWin->size() );

    app.setMainWidget( mainWin );
    app.miniIcon();
    mainWin->show();

    return app.exec();
}
