# Overview

A set of applications to provide modern Bluetooth functionality to TDE.

Originally it was introduced around 2008 in SUSE, but it was not included in the main KDE3 set of applications.

Due to the major API change from Bluez4 to Bluez5 in Linux it was necessary to completely rewrite most of the applications while adding new and removing old parts of the functionality that were obsoleted.

Lack of devices for testing and differences in hardware standards make testing even more difficult and suggest unexpected behavior and issues. 

Please test and report back so that we can improve the application and its components.


# Applications and libraries

You can install the package tdebluez-api-doc and use the API documentation online. There you will find information on the libraries tdebluez and tdeobex. 

## tdebluez
This is the main application that provides the main functionality.

* Requires at least bluez 5.43

* It provides agent for pairing.

* Allows to configure bluetooth adapters and devices.

* User must be member of group netdev for `/dev/rfkill` access. This is required to make BT adapter switch on/off to work.

* pulseaudio-module-bluetooth needs to be installed for a2dp to work

* Tray icon

  ![Tray Icon](doc/images/trayicon.png)

* Adapter (device) configuration

  ![Adapter (device) configuration](doc/images/adapterconfig.png)
  
* Discovering devices

  ![Discovering devices](doc/images/devices_discovering.png)
  
* Device setup wizard

  ![Device setup wizard](doc/images/devicesetupwizard.png)
  
* Pairing agent implements [BlueZ D-Bus Agent API](https://git.kernel.org/pub/scm/bluetooth/bluez.git/tree/doc/agent-api.txt) (example pairing with PIN)

  ![Pairing with PIN](doc/images/pairingwithpin.png)
  
* Connect services (profiles)

  ![Connect services (profiles)](doc/images/selectprofiles.png)


## libtdebluez
Almost complete rewrite for BlueZ 5 D-Bus API.
This is the main library providing the core functionality.

## libtdeobex

New for BlueZ 5 D-Bus API.


## tdebluezauth
This is helper application that can be run stand alone, but it is usually started from tdebluez.
It provides agent for authentication utilizing several DBus interfaces.

## bluez-obexd
This can be seen as third party application that can be started as stand alone application or by tdebluez.
It provides Obex FTP, OPP, Message Access, PSE.

* FTP is working per default in `~/Download` directory. 
If you want to change this, open `.trinity/share/config/tdebluezrc` and add/modify entry 
 `downloadDir=Downloads`
 
You can use absolute or relative path. Both absolute and relative can be used, but relative paths are assumed to be relative to user `$HOME` folder. Default `$HOME/Downloads`.

## openobex
This is third party library providing functionality for SyncML like used in SyncEvolution. 

Please, note that v1.7 is broken and only v1.5 works.

# Configuration

The configuration file is `~/.trinity/share/config/tdebluezrc`

Here is an example (see details below)

```
[20:xx:xx:xx:xx:xx]
profile=0000110a-0000-1000-8000-00805f9b34fb,0000111f-0000-1000-8000-00805f9b34fb

[38:xx:xx:xx:xx:xx]
profile=0000110a-0000-1000-8000-00805f9b34fb,0000111f-0000-1000-8000-00805f9b34fb

[3A:xx:xx:xx:xx:xx]
profile=0000110b-0000-1000-8000-00805f9b34fb

[50:xx:xx:xx:xx:xx]
profile=0000110b-0000-1000-8000-00805f9b34fb,00001108-0000-1000-8000-00805f9b34fb

[55:xx:xx:xx:xx:xx]
profile=0000110b-0000-1000-8000-00805f9b34fb,0000111e-0000-1000-8000-00805f9b34fb


[General]
authAgent=true
autoStart=true
downloadDir=Downloads
obexSrv=true
obexSrvExe[$e]=/usr/libexec/bluetooth/obexd

[Notification Messages]
systemtrayquitTDEBluetooth=false
```

## General

### authAgent

Start the ```tdebluezauth``` process

Default:
```authAgent=true```

### obexSrv

Start/stop the ```obexSrv``` process

Default:
```obexSrv=true```
obexSrvExe[$e]=/usr/libexec/bluetooth/obexd

### autoStart

Start/stop ```tdebluez``` automatically

Default:
```autoStart=true```

### downloadDir

When using Obex Push where to save the file transfered.

In future it is planned to provide a configurable menu item.

Default:
```downloadDir=Downloads```


## Notification Messages

Default: 
```systemtrayquitTDEBluetooth=false```

## Device settings

The selected profiles are stored in the corresponding section for each device

Example:

```
[20:xx:xx:xx:xx:xx]
profile=0000110a-0000-1000-8000-00805f9b34fb,0000111f-0000-1000-8000-00805f9b34fb
```

Following IDs are recognized, but not all of them are for direct use and they are not offered in the GUI.

*Note:* 
If you need an ID supported in GUI, let us know.

*Note:*
The application tries to connect all configured profiles.

Please note that some IDs conflict with each other and can not be used together. Most likely you will get some kind of error in such case.  


```
 "00001203-0000-1000-8000-00805f9b34fb"  -  "Generic Audio" 
 "00001108-0000-1000-8000-00805f9b34fb"  -  "Headset" 
 "00001112-0000-1000-8000-00805f9b34fb"  -  "Headset AG" 

 "0000111e-0000-1000-8000-00805f9b34fb"  -  "Handsfree" 
 "0000111f-0000-1000-8000-00805f9b34fb"  -  "Handsfree AG" 

 "0000110d-0000-1000-8000-00805f9b34fb"  -  "Advanced Audio" 

 "0000110a-0000-1000-8000-00805f9b34fb"  -  "A2DP Source"  //Advanced Audio Distribution Profile
 "0000110b-0000-1000-8000-00805f9b34fb"  -  "A2DP Sink" 

 "0000110e-0000-1000-8000-00805f9b34fb"  -  "A/V Remote Ctrl"  //Audio/Video Remote Control Profile
 "0000110c-0000-1000-8000-00805f9b34fb"  -  "A/V Remote Ctrl Tgt" 

 "00001115-0000-1000-8000-00805f9b34fb"  -  "PANU" 
 "00001116-0000-1000-8000-00805f9b34fb"  -  "NAP" 
 "00001117-0000-1000-8000-00805f9b34fb"  -  "GN" 
 "0000000f-0000-1000-8000-00805f9b34fb"  -  "BNEP Service"  //Bluetooth Network Encapsulation Protocol

 "00002a50-0000-1000-8000-00805f9b34fb"  -  "PNPID" 
 "0000180a-0000-1000-8000-00805f9b34fb"  -  "Device Information" 

 "00001801-0000-1000-8000-00805f9b34fb"  -  "GATT"  //Generic Access Profile (Generic Attributes)
 "00001802-0000-1000-8000-00805f9b34fb"  -  "Immediate Alert" 
 "00001803-0000-1000-8000-00805f9b34fb"  -  "Link Loss" 
 "00001804-0000-1000-8000-00805f9b34fb"  -  "TX Power" 

 "0000112d-0000-1000-8000-00805f9b34fb"  -  "SAP" 

 "0000180d-0000-1000-8000-00805f9b34fb"  -  "Heart Rate" 
 "00002a37-0000-1000-8000-00805f9b34fb"  -  "Heart Rate Measurement" 
 "00002a38-0000-1000-8000-00805f9b34fb"  -  "Body Sensor Location" 
 "00002a39-0000-1000-8000-00805f9b34fb"  -  "Heart Rate Control Point" 

 "00001809-0000-1000-8000-00805f9b34fb"  -  "Health Thermometer" 
 "00002a1c-0000-1000-8000-00805f9b34fb"  -  "Temp Measurement" 
 "00002a1d-0000-1000-8000-00805f9b34fb"  -  "Temp Type" 
 "00002a1e-0000-1000-8000-00805f9b34fb"  -  "Immediate Temp" 
 "00002a21-0000-1000-8000-00805f9b34fb"  -  "Measurement Interval" 

 "00001816-0000-1000-8000-00805f9b34fb"  -  "Cycling SC" 
 "00002a5b-0000-1000-8000-00805f9b34fb"  -  "CSC Measurement" 
 "00002a5c-0000-1000-8000-00805f9b34fb"  -  "CSC Feature" 
 "00002a5d-0000-1000-8000-00805f9b34fb"  -  "Sensor Location" 
 "00002a55-0000-1000-8000-00805f9b34fb"  -  "SC Control Point" 

 "00000003-0000-1000-8000-00805f9b34fb"  -  "RFCOMM" 

 "00001400-0000-1000-8000-00805f9b34fb"  -  "HDP" 
 "00001401-0000-1000-8000-00805f9b34fb"  -  "HDP Source" 
 "00001402-0000-1000-8000-00805f9b34fb"  -  "HDP Sink" 

 "00001124-0000-1000-8000-00805f9b34fb"  -  "HID" 

 "00001103-0000-1000-8000-00805f9b34fb"  -  "DUN Gateway"  //Dial-up Networking Profile

 "00001800-0000-1000-8000-00805f9b34fb"  -  "GAP"  //Generic Access Profile
 "00001200-0000-1000-8000-00805f9b34fb"  -  "PNP" 

 "00001101-0000-1000-8000-00805f9b34fb"  -  "SPP"  //Serial Port Profile

 "00001104-0000-1000-8000-00805f9b34fb"  -  "OBEX Sync" 
 "00001105-0000-1000-8000-00805f9b34fb"  -  "OBEX OPP" 
 "00001106-0000-1000-8000-00805f9b34fb"  -  "OBEX FTP" 
 "f9ec7bc4-953c-11d2-984e-525400dc9e09"  -  "OBEX DIR" 
 "0000112e-0000-1000-8000-00805f9b34fb"  -  "OBEX PCE" 
 "0000112f-0000-1000-8000-00805f9b34fb"  -  "OBEX PSE" 
 "00001130-0000-1000-8000-00805f9b34fb"  -  "OBEX PBAP" 
 "00001132-0000-1000-8000-00805f9b34fb"  -  "OBEX Msg Access Srv" 
 "00001133-0000-1000-8000-00805f9b34fb"  -  "OBEX Msg Notif. Srv" 
 "00001134-0000-1000-8000-00805f9b34fb"  -  "OBEX MAP" 
    // taken from
    // https://www.vistax64.com/threads/bluetooth-peripheral-device-cannot-be-found.62944/
    // https://together.jolla.com/question/64565/accessing-bluetooth-profiles/
    // http://www.sensi.org/~ak/tmp/n95.txt
 "00005005-0000-1000-8000-0002ee000001"  -  "Nokia PC Suite" 
 "00005601-0000-1000-8000-0002ee000001"  -  "Nokia SyncML Server" 
 "00000001-0000-1000-8000-0002ee000001"  -  "SyncML Server" 
 "00000002-0000-1000-8000-0002ee000002"  -  "OBEX Syncevolution" 
 "00000004-0000-1000-8000-0002ee000002"  -  "SyncML DM Client"
```

# Known issues
Please report back your experience, so that we can improve the code.

* At the moment there is issue when pairing two devices with same name.

* Due to lack of HID devices, the code was tested only with 
** mobile phones (Android, Sailfish OS)
** head sets
** head phones 

* The ioslaves support only file/directory listing. [**broken**]

# Improvements
## 14.1 TODO List
1. fix the Async error while pairing (and connecting) [**done**]
    * Async error is OK and correct
        * some profiles are not compatible with other profiles (can not be connected simultaniusly)
    * Connecting now works with more than one device
        * it can connect one device at a time
        * some profiles are allowed to connect only once
2. flip the mouse press button on the tray icon [**done**] 
3. fix the wizard when pairing (test with Android phone and non Android also with Headsets) [**done**] 
4. add some logic so that sub-processes are killed in case tdebluez crashes [**done**] 
5. add obexFTP/OPP support [**14.2**] 
6. add support for multiple adapters [**done**] 
7. add autoconnect option [**14.2**]
8. Port the UUID logic from https://codebrowser.dev/qt5/qtconnectivity/src/bluetooth/qbluetoothuuid.h.html  [**14.2**]

## 14.2 TODO List
1. add obexFTP/OPP support 
2. add autoconnect option
3. Port the UUID logic from https://codebrowser.dev/qt5/qtconnectivity/src/bluetooth/qbluetoothuuid.h.html

