/*
 *
 *  Adapter Manager Gui for tdebluez
 *
 *  Copyright (C) 2018  Emanoil Kotsev <deloptes@gmail.com>
 *
 *
 *  This file is part of tdebluez.
 *
 *  tdebluez is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  tdebluez is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with kbluetooth; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */
#ifndef ADAPTERCONFIGDIALOG_H_
#define ADAPTERCONFIGDIALOG_H_

#include <tqmap.h>
#include <kdialogbase.h>

#include <adapterImpl.h>

#include "application.h"
#include "adapterconfig.h"

using namespace TDEBluetooth;

class AdapterConfigDialog: public KDialogBase
{
    Q_OBJECT

public:
    AdapterConfigDialog(TDEBluetoothApp *app);
    ~AdapterConfigDialog();

public slots:
    void addAdapter(const TQString&);
    void removeAdapter(const TQString&);
    void slotChangeName(const TQString&);
    void slotCurrentChanged(TQWidget *);

signals:
    void signalAdapterSelected(const TQString&, const TQString&);

private:
    TQLabel *nodevice;

    TDEBluetoothApp *app;
    ObjectManagerImpl *manager;
    TQMap<TQString,AdapterConfig *> adapterList;

    void addAdapterDialog(AdapterImpl *adapter);
    void addAdapterDialogInfo(AdapterImpl &adapater,
            AdapterDialog *adapterDialog);

    TQTabWidget *tabWidget;
};

#endif	// ADAPTERCONFIGDIALOG_H_

