# Overview

A set of applications to provide modern Bluetooth functionality to TDE.

Originally it was introduced around 2008 in SUSE, but it was not included in the main KDE3 set of applications.

Due to the major API change from Bluez4 to Bluez5 in Linux it was necessary to completely rewrite most of the applications while adding new and removing old parts of the functionality that were obsoleted.

Lack of devices for testing and differences in hardware standards make testing even more difficult and suggest unexpected behavior and issues. Please test and report back so that we can improve the application and its components.


# Applications and libraries

## tdebluez
This is the main application that provides the main functionality.

* Requires at least bluez 5.43

* It provides agent for pairing.

* Allows to configure bluetooth adapters and devices.

* User must be member of group netdev for /dev/rfkill access. This is required to make BT adapter switch on/off to work.

* pulseaudio-module-bluetooth needs to be installed for a2dp to work

* Tray icon

  ![Tray Icon](doc/images/trayicon.png)

* Adapter (device) configuration

  ![Adapter (device) configuration](doc/images/adapterconfig.png)
  
* Discovering devices

  ![Discovering devices](doc/images/devices_discovering.png)
  
* Device setup wizard

  ![Device setup wizard](doc/images/devicesetupwizard.png)
  
* Pairing agent implements [BlueZ D-Bus Agent API](https://git.kernel.org/pub/scm/bluetooth/bluez.git/tree/doc/agent-api.txt) (example pairing with PIN)

  ![Pairing with PIN](doc/images/pairingwithpin.png)
  
* Connect services (profiles)

  ![Connect services (profiles)](doc/images/selectprofiles.png)


## libtdebluez
Almost complete rewrite for BlueZ 5 D-Bus API.
This is the main library providing the core functionality.

## libtdeobex

New for BlueZ 5 D-Bus API.


## tdebluezauth
This is helper application that can be run stand alone, but it is usually started from tdebluez.
It provides agent for authentication utilizing several DBus interfaces.

## bluez-obexd
This can be seen as third party application that can be started as stand alone application or by tdebluez.
It provides Obex FTP, OPP, Message Access, PSE.

* FTP is working per default in ~/Download directory. 
If you want to change this, open .trinity/share/config/tdebluezrc and add/modify entry 
 downloadDir=Downloads
You can use absolute or relative path. Both absolute and relative can be used, but relative paths are assumed to be relative to user $HOME folder. Default $HOME/Downloads.

## openobex
This is third party library providing functionality for SyncML like used in SyncEvolution. Please, note that only v1.5 works. v1.7 is broken.

# Configuration

The configuration file is `~/.trinity/share/config/tdebluezrc`

Here is an example

```
[20:xx:xx:xx:xx:xx]
profile=0000110a-0000-1000-8000-00805f9b34fb,0000111f-0000-1000-8000-00805f9b34fb

[38:xx:xx:xx:xx:xx]
profile=0000110a-0000-1000-8000-00805f9b34fb,0000111f-0000-1000-8000-00805f9b34fb

[3A:xx:xx:xx:xx:xx]
profile=0000110b-0000-1000-8000-00805f9b34fb

[50:xx:xx:xx:xx:xx]
profile=0000110b-0000-1000-8000-00805f9b34fb,00001108-0000-1000-8000-00805f9b34fb

[55:xx:xx:xx:xx:xx]
profile=0000110b-0000-1000-8000-00805f9b34fb,0000111e-0000-1000-8000-00805f9b34fb


[General]
authAgent=true
autoStart=true
downloadDir=Downloads
obexSrv=true
obexSrvExe[$e]=/usr/libexec/bluetooth/obexd

[Notification Messages]
systemtrayquitTDEBluetooth=false
```

# Known issues
Please report back your experience, so that we can improve the code.

* At the moment support for only one adapter was tested.

* Due to lack of HID devices, the code was tested only with 
** mobile phones (Android, Sailfish OS)
** headset 
** head phones 

* The ioslaves support only file/directory listing.

# Improvements
## 14.1 TODO List
1. fix the Async error while pairing (and connecting) [**done**]
    * Async error is OK and correct
        * some profiles are not compatible with other profiles (can not be connected simultaniusly)
    * Connecting now works with more than one device
        * it can connect one device at a time
        * some profiles are allowed to connect only once
2. flip the mouse press button on the tray icon [**done**] 
3. fix the wizard when pairing (test with Android phone and non
Android also with Headsets) [**done**] 
4. add some logic so that sub-processes are killed in case tdebluez crashes

After the 14.1 release

5. add obexFTP/OPP support
6. add support for multiple adapters
7. add autoconnect option
8. Port the UUID logic from https://codebrowser.dev/qt5/qtconnectivity/src/bluetooth/qbluetoothuuid.h.html


