/***************************************************************************
* $Id$
**
* Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
* This file is part of an example program for Qt.  This example
* program may be used, distributed and modified without limitation.
**
****************************************************************************/

import org.trinitydesktop.qt.*;


class ImageTextEditor  extends TQDialog
{
private TQImage image;
private TQComboBox languages;
private TQComboBox keys;
private TQMultiLineEdit text;
private TQLineEdit newlang;
private TQLineEdit newkey;



ImageTextEditor( TQImage i, TQWidget parent )
{
	this(i, parent, null, 0);
}

ImageTextEditor( TQImage i, TQWidget parent, String name, int f )
{
    super(parent,name,true,f);
    image = i;
    TQVBoxLayout vbox = new TQVBoxLayout(this,8);
    vbox.setAutoAdd(true);

    TQGrid controls = new TQGrid(3,TQGrid.Horizontal,this);
    controls.setSpacing(8);
    TQLabel l;
    l=new TQLabel("Language",controls); l.setAlignment(AlignCenter);
    l=new TQLabel("Key",controls); l.setAlignment(AlignCenter);
    new TQLabel("",controls); // dummy
    languages = new TQComboBox(controls);
    keys = new TQComboBox(controls);
    TQPushButton remove = new TQPushButton("Remove",controls);

    newlang = new TQLineEdit(controls);
    newkey = new TQLineEdit(controls);
    TQPushButton add = new TQPushButton("Add",controls);

    text = new TQMultiLineEdit(this);

    TQHBox hbox = new TQHBox(this);
    TQPushButton cancel = new TQPushButton("Cancel",hbox);
    TQPushButton ok = new TQPushButton("OK",hbox);

    connect(add,SIGNAL("clicked()"),
	this,SLOT("addText()"));

    connect(remove,SIGNAL("clicked()"),
	this,SLOT("removeText()"));

    connect(ok,SIGNAL("clicked()"),
	this,SLOT("accept()"));

    connect(cancel,SIGNAL("clicked()"),
	this,SLOT("reject()"));

    connect(languages,SIGNAL("activated(int)"),
	this,SLOT("updateText()"));

    connect(keys,SIGNAL("activated(int)"),
	this,SLOT("updateText()"));

    imageChanged();
}

void imageChanged()
{
    languages.clear();
    keys.clear();
    text.clear();
    languages.insertItem("<any>");

    languages.insertStringList( (String[]) image.textLanguages().toArray(new String[0]) );
    keys.insertStringList( (String[]) image.textKeys().toArray(new String[0]) );

    updateText();
}

public void accept()
{
    storeText();
    super.accept();
}

void updateText()
{
    storeText();
    newlang.setText(languages.currentText());
    newkey.setText(keys.currentText());
    String t = image.text(currKey(),currLang());

    text.setText(t);
}

String currKey()
{
    return newkey.text();
}

String currLang()
{
    String l = newlang.text();
    if ( l.equals("<any>") )
	l = "";
    return l;
}

String currText()
{
    String t = text.text();
    if ( t == null ) t = "";
    return t;
}


void removeText()
{
    image.setText(currKey(),currLang(),"");
}

void addText()
{
    storeText();
}

void storeText()
{
    if ( currKey().length() > 0 ) {
	image.setText(currKey(),currLang(),currText());
    }
}
}
