#include <kinstance.h>
#include <tqstring.h>
#include <kimageio.h>
#include <tdelocale.h>

#include "metabarwidget.h"
#include "metabar.h"
#include "metabar.moc"

Metabar::Metabar(TDEInstance *inst,TQObject *parent,TQWidget *widgetParent, TQString &desktopName, const char* name):
                   KonqSidebarPlugin(inst,parent,widgetParent,desktopName,name)
{
  KImageIO::registerFormats();
  TDEGlobal::locale()->insertCatalogue( "konqsidebar_metabar" );

  widget = new MetabarWidget(widgetParent, "metabarwidget");
}


Metabar::~Metabar()
{
}

void Metabar::handleURL(const KURL &url)
{
  const KFileItem *item = new KFileItem(KFileItem::Unknown, KFileItem::Unknown, url, true);
  KFileItemList list;
  list.append(item);
  
  widget->setFileItems(list);
}

void Metabar::handlePreview(const KFileItemList &items)
{
  widget->setFileItems(items);
}


extern "C"
{
	KDE_EXPORT bool add_konqsidebar_metabar(TQString* fn, TQString* param, TQMap<TQString,TQString> *map)
	{
		Q_UNUSED(param);

		map->insert("Type", "Link");
		map->insert("Icon", "metabar");
		map->insert("Name", "Metabar");
		map->insert("Open", "true");
		map->insert("X-TDE-KonqSidebarModule","konqsidebar_metabar");
		fn->setLatin1("metabar%1.desktop");
		return true;
	}
}

extern "C"
{
	KDE_EXPORT void* create_konqsidebar_metabar(TDEInstance *instance,TQObject *par,TQWidget *widp,TQString &desktopname,const char *name)
	{
		return new Metabar(instance,par,widp,desktopname,name);
	}
}
