
#ifndef STARTMENU_H
#define STARTMENU_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <tqpoint.h>
#include <tqwidget.h>
#include <tqlabel.h>
#include <tqlayout.h>
#include <tqscrollview.h>
#include <tqmap.h>
#include <tqpixmap.h>
#include <tqsortedlist.h>
#include <tqptrlist.h>
#include <klineedit.h>
#include <kservicegroup.h>
#include "mykey.h"

class TDEIconLoader;
class TQPaintEvent;
class TQMouseEvent;
class TQEvent;
class TQPixmap;
class TQVBoxLayout;
class TQComboBox;
class StartMenuButton;
class TDEConfig;
class LinkConfig;

class Panel : public TQWidget//TQScrollView
{
   friend class StartMenu;
   friend class StartMenuButton;
Q_OBJECT
      
public:
   Panel(int size = 32, TQWidget * parent = 0, const char * name = 0);
   Orientation orientation(){ return _orientation; }
   void setOrientation ( Orientation o );
//    void addItem ( TQWidget *w );
   StartMenuButton* addIcon ( TQString icon, TQString title, TQString command, TQPoint pt = TQPoint(-1,-1) );
   void save(TDEConfig* config);
   void repositionIcon ( StartMenuButton* bt, TQPoint pt );
   void ensureVisible(TQRect & rect);
   void reloadIcons(int size);
   void poof();
public slots:
   void updateSize(int);
protected:
   void wheelEvent ( TQWheelEvent * );
   void dragEnterEvent ( TQDragEnterEvent * );
   void dropEvent ( TQDropEvent * );
   void mouseReleaseEvent ( TQMouseEvent * e );
   void resizeEvent ( TQResizeEvent * );
   LinkConfig *linkConfigDialog;
   int _size;
private:
   int _count;
   Orientation _orientation;
   bool _draggedMe;
   int _poofIndex;
   TQPoint iconAddPosition;
   TQPixmap *_poofPix;
   TQPixmap *_poofAnimPix;
   TQWidget *_poof;
private slots:
   void addIcon();
   void runPoof();
signals:
   void message(const TQString&);
   void clearStatus();
};

class TQTextDrag;

class StartMenuButton : public TQWidget
{
   friend class Panel;
   Q_OBJECT

public:
   enum Orientation { Horizontal = 0, Vertical, Status };
   StartMenuButton ( int size, TQString icon, TQString title, TQString command, Orientation orientation, TQWidget* parent = 0, const char * name = 0);
   void smartMove(TQPoint & pt); // prevents collisions with other childs of parentWidget()
   void smartMove(int x, int y);
   void reloadIcon(int size);
public slots:
   void edit();
protected:
   TQString & command(){return m_command;}
   TQString & title(){return m_title;}
   TQString & icon(){return m_icon;}
   void mouseReleaseEvent ( TQMouseEvent * e );
   void mouseMoveEvent ( TQMouseEvent * e );
   void enterEvent( TQEvent * );
   void leaveEvent( TQEvent * );
   bool isMoving() {return _moving;}
private:
   Orientation m_orientation;
   bool _moving;
   TQTextDrag *myDrag;
   TQString m_command;
   TQString m_title;
   TQString m_icon;
   TQLabel* m_titleLabel;
   TQLabel* m_pixmapLabel;
   TQPixmap m_pix;
   TQPixmap m_hoverPix;
signals:
   void pressed(const TQString &);
   void hovered(const TQString &);
   void unhovered();
   void updateSize(int);
};

class KService;
class TQDate;
class AppList;

class StartMenuEntry : public TQWidget
{
   friend class AppList;
   Q_OBJECT
public:
   StartMenuEntry(KService * service, TQString relPath, int size = 32, bool neewbie = false, TQWidget * parent = 0);
   ~StartMenuEntry();
   void reloadIcon(int size);
   bool display;
   TQString title();
   void saveStats();
   int rank;
   bool forNewbie;
   //--- operators to allow use of qHeapSort()
   bool operator==( const StartMenuEntry& se ) const;
   bool operator!=( const StartMenuEntry& se ) const;
   bool operator<( const StartMenuEntry& se ) const;
   bool operator>( const StartMenuEntry& se ) const;
   bool operator==( const double& d ) const;
   bool operator!=( const double& d ) const;
   bool operator<( const double& d ) const;
   bool operator>( const double& d ) const;
protected:
   void focusInEvent ( TQFocusEvent * );
   void focusOutEvent ( TQFocusEvent * );
   void mouseReleaseEvent ( TQMouseEvent * e );
   void mouseMoveEvent ( TQMouseEvent * mme );
   void keyPressEvent ( TQKeyEvent * e );
   void enterEvent( TQEvent * );
   void leaveEvent( TQEvent * );
   KService* m_service;
   TQString groupPath;
   TQDate lastUse;
   uint usage;
private:
   void execute();
   TQString exec;
   bool isCurrent;
   TQLabel* m_titleLabel;
   TQLabel* m_commentLabel;
   TQLabel* m_pixmapLabel;
   TQPixmap m_pix;
   TQPixmap m_hoverPix;
signals:
   void closeMenu();
   void pressed();
   void appDown();
   void appUp();
   void appLeft();
   void hovered(const TQString &);
   void sayText(const TQString&);
   void unhovered();
   void popup(StartMenuEntry*);
   void executed();
};

class TDEPopupMenu;
class ConfigDialog;
class HelpDialog;

class AppList : public TQScrollView
{
   friend class StartMenu;
Q_OBJECT

public:
   AppList(int size = 32, TQWidget * parent = 0);
   StartMenuEntry* addApp(KService * service, TQStringList & captions, TQString relPath);
   void finish();
   StartMenuEntry* handledEntry; // for rightclick menu action
   void writeEntry(TQString path, bool hidden = false); // for add/edit
   void reloadIcons(int size);
public slots:
   void addEntry();
   void addDialog();
   void removeEntry();
   void editEntry();
   void editDialog();
   void clear();
   void reset();
   void search(const TQString & string);
   void appDown();
   void appUp();
   void appLeft();
   void sort();
   void showCategory(const TQString & string);
   void unblockPopup(){popupBlocked_ = false;}
protected:
   TQStringList categories;
   int favItemAmount;
   void save(TDEConfig* config);
   void mouseReleaseEvent ( TQMouseEvent * e );
   void windowActivationChange ( bool oldActive );
private:
   void init();
   void insertGroup(KServiceGroup *g, TQStringList & captions, TQStringList & paths);
   KServiceGroup::Ptr m_root;
   TDEIconLoader *m_iconLoader;
   TQLabel *infoLabel;
   TQVBoxLayout * infoLayout;
   TQVBoxLayout * m_VLayout;
   TQFrame * m_widget;
   bool newbie;
   TQStringList neewbieApps;
   TDEPopupMenu *m_popup;
   bool popupBlocked_;
   int _size;
   typedef TQSortedList<StartMenuEntry> StartMenuEntryList;
   typedef TQMap<TQString,StartMenuEntryList> KeyWordList;
   StartMenuEntryList entryList;
   KeyWordList m_keywordList;
   KeyWordList m_groupList;
   ConfigDialog* configDialog_;
   HelpDialog* helpDialog_;
private slots:
   void popup(StartMenuEntry*);
signals:
   void looseKey();
   void message(const TQString&);
   void sayText(const TQString&);
   void clearStatus();
};

class TQStringList;

class SearchLine : public KLineEdit
{
   Q_OBJECT
public:
   SearchLine( TQWidget * parent );
   bool blocked;
protected slots:
   void makeCompletion (const TQString &);
   void block(){blocked = true;}
signals:
   void typedTextChanged(const TQString & string);
};

class KURIFilterData;
class StarterConfig;
class TQSignalMapper;
class KSqueezedTextLabel;

class StartMenu : public TQWidget
{
   friend class starter; // to allow setting the shortcutlis directly
   Q_OBJECT
public:
   enum PanelPosition { North = 0, South, West, East, Nowhere };
   StartMenu ( int size = 32, TQWidget * parent = 0, WFlags f = 0 );
   ~StartMenu();
   void show();
   void hide();
   void reloadIcons(int size);
   TQStringList & categories(){return appList->categories;};
   typedef TQMap<MyKey,TQString> ShortcutList;
   void updateShortcuts(ShortcutList &);
   void setFavItemAmount(int i) {if (appList) appList->favItemAmount = i;}
   void setPanelPosition(PanelPosition p);
public slots:
   void sayText(const TQString &text);
   void toggleKTTS(bool);
   void setCategory(const TQString & category);
   void save();
protected:
   bool eventFilter ( TQObject * o, TQEvent * e );
   ShortcutList shortcutList;
private slots:
   void message(const TQString &text);
   void centerMessage(const TQString &text);
   void clearStatus();
   void execute(const TQString & command);
   void search(const TQString & string);
   void endHistory();
//    void slotLock();
private:
   bool inMove;
   uint m_spokenText;
   int _size;
   TQWidget *header;
   TQPoint movePoint;
   KURIFilterData *_filterData;
   AppList *appList;
   TQComboBox *categoryCombo;
   SearchLine *searchLine;
   KSqueezedTextLabel *statusBar;
   Panel *m_panel;
   TQStringList history;
   TQStringList::Iterator currentHistoryItem;
   PanelPosition m_panelPos;
   StartMenuButton *userButton;
   TQGridLayout *panelLayout;
   
signals:
   void aboutToHide();
};

#endif
