/***************************************************************************
    smb4ksearchdialogitem  -  This class is an enhanced version of a list
    box item for Smb4K.
                             -------------------
    begin                : So Jun 3 2007
    copyright            : (C) 2007 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,   *
 *   MA  02110-1301 USA                                                    *
 ***************************************************************************/

#ifndef SMB4KSEARCHDIALOGITEM_H
#define SMB4KSEARCHDIALOGITEM_H


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// TQt includes
#include <tdelistview.h>

// application specific includes
#include "../core/smb4knetworkitems.h"


/**
 * This class is an enhanced version of TDEListViewItem, that is used
 * by the search dialog of Smb4K to show the search results. It
 * encapsulates a Smb4KHostItem which carries all the information needed.
 *
 * @author Alexander Reinholdt <dustpuppy@users.berlios.de>
 */

class Smb4KSearchDialog;
class Smb4KSearchDialogItem : public TDEListViewItem
{
  public:
    /**
     * The constructor. It will construct an list view item and set its
     * text according to the contents of @p item. If the search failed
     * and @p item is empty, an error message will be displayed.
     *
     * @param listBox           The parent list box.
     *
     * @param item              The host item that represents the search
     *                          result.
     *
     * @param serial            The user supplied serial number of this item. It
     *                          is used for sorting. See compare() for further information.
     */
    Smb4KSearchDialogItem( TDEListView *listView, Smb4KHostItem *item, int serial = 0 );

    /**
     * The destructor
     */
    ~Smb4KSearchDialogItem();

    /**
     * This function returns the Smb4KHostItem object that is encapsulated
     * here.
     *
     * Make sure you copy the contents to a new item, because the pointer
     * will be invalidated if this Smb4KSearchDialogItem is deleted.
     *
     * @returns the encapsulated Smb4KHostItem object.
     */
    Smb4KHostItem *hostItem() { return &m_item; }

    /**
     * This function returns TRUE, if the item is regular, that means it
     * represents a host. If it represents a failed search, it returns
     * FALSE.
     *
     * @returns TRUE is the item is a regular one.
     */
    bool isRegular() { return m_is_regular; }

    /**
     * This function notifies the item that the host that it represents is
     * known to the application, i.e. it is in the list of hosts. It will set
     * the pixmap accordingly and sets m_is_known.
     *
     * @param known             Should be TRUE is the host is known.
     */
    void setKnown( bool known );

    /**
     * This function returns TRUE, if the item is already known by the scanner.
     *
     * @returns TRUE is the item is already known.
     */
    bool isKnown() { return m_is_known; }

    /**
     * This function is used for sorting.
     *
     * @returns the serial number of this item.
     */
    int serialNumber() const { return m_serial; }

    /**
     * Reimplemented from TQListViewItem. It is used for sorting and compares the
     * serial numbers of this item and @p item. If @p ascending is TRUE and the
     * serial number of this item is greater than that of @p item, it will be inserted
     * before @p item and else it will be inserted after. In this implementation,
     * @p col is *not* used.
     *
     * @param item              The list view item with that this one is compared.
     *
     * @param col               The column that should be used for sorting. It is
     *                          not used in this implementation.
     *
     * @param ascending         Sort ascending if TRUE or descending if FALSE.
     *
     * @returns 0 if serialNumber() and @p item->serialNumber() are equal and != 0 if
     * they are not. Which value and especially which algebraic sign is returned depends
     * on the values that are returned by of both serialNumber() functions and on @p ascending.
     */
    int compare( TQListViewItem *item, int col, bool ascending ) const;

  private:
    /**
     * The Smb4KHostItem object
     */
    Smb4KHostItem m_item;

    /**
     * TRUE, if we have a regular item
     */
    bool m_is_regular;

    /**
     * TRUE is the item is known
     */
    bool m_is_known;

    /**
     * This function sets the icon of the item. It looks at m_is_known and
     * m_is_regular to decide which icon to choose.
     */
    void setIcon();

    /**
     * The user defined index of this item.
     */
    int m_serial;
};


#endif
