/***************************************************************************
    smb4kauthinfo.h  -  This class provides a container for the
    authentication data.
                             -------------------
    begin                : Sa Feb 28 2004
    copyright            : (C) 2004-2007 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,   *
 *   MA  02110-1301 USA                                                    *
 ***************************************************************************/

#ifndef SMB4KAUTHINFO_H
#define SMB4KAUTHINFO_H

// TQt includes
#include <tqstring.h>
#include <tqcstring.h>

#include <kdemacros.h>

/**
 * This class provides a container for the authentication data.
 *
 * @author Alexander Reinholdt <dustpuppy@users.berlios.de>
 */


class KDE_EXPORT Smb4KAuthInfo
{
  public:
    /**
     * The constructor.
     *
     * @param workgroup The workgroup of the share the auth info is for.
     *
     * @param hosts     The host's name
     *
     * @param share     The share's name
     *
     * @param user      The username that's used for authentication. Default is TQString().
     *
     * @param password  The password that's used for authentication. Default is TQString().
     */
    Smb4KAuthInfo( const TQString &workgroup,
                   const TQString &host,
                   const TQString &share,
                   const TQString &user = TQString(),
                   const TQString &password = TQString() );
    /**
     * The empty constructor.
     */
    Smb4KAuthInfo() {}
    /**
     * The copy constructor.
     *
     * @param info      The Smb4KAuthInfo object that will be copied.
     */
    Smb4KAuthInfo( Smb4KAuthInfo &info );
    /**
     * The destructor
     */
    ~Smb4KAuthInfo();
    /**
     * Returns the name of the workgroup.
     *
     * @returns         The workgroup of the server/share for which this
     *                  authentication data is for.
     */
    const TQString &workgroup() const { return m_workgroup; }
    /**
     * Returns the name of the server (host).
     *
     * @returns         The server name
     */
    const TQString &host() const { return m_host; }
    /**
     * Returns the name of the share.
     *
     * @returns         The share name
     */
    const TQString &share() const { return m_share; }
    /**
     * Returns the user's name.
     *
     * @returns         The user name
     */
    const TQCString &user() const { return m_user; }
    /**
     * Returns the (unescaped) password.
     */
    const TQCString &password() const { return m_password; }
    /**
     * Sets the user name.
     *
     * @param user      The user name for the server/share
     */
    void setUser( const TQString &user );
    /**
     * Sets the password.
     *
     * @param passwd    The password for the server/share
     */
    void setPassword( const TQString &passwd );
    /**
     * Sets the share name.
     *
     * @param share     The name of the share
     */
    void setShare( const TQString &share );

  private:
    /**
     * The workgroup object.
     */
    TQString m_workgroup;
    /**
     * The host object.
     */
    TQString m_host;
    /**
     * The share object.
     */
    TQString m_share;
    /**
     * The user name for this share.
     */
    TQCString m_user;
    /**
     * The password object for this share.
     */
    TQCString m_password;

};

#endif
