/***************************************************************************
    smb4kprintdialog  -  The print dialog for Smb4K
                             -------------------
    begin                : So Apr 11 2004
    copyright            : (C) 2004-2007 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,   *
 *   MA  02110-1301 USA                                                    *
 ***************************************************************************/

#ifndef SMB4KPRINTDIALOG_H
#define SMB4KPRINTDIALOG_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// TQt includes
#include <tqstring.h>

// KDE includes
#include <kdialogbase.h>

// forward declarations
class Smb4KShareItem;


/**
 * This class provides the print dialog for Smb4K. You can choose the
 * file that is to be printed and you can define the number of copies
 * you want to have.
 *
 * @author Alexander Reinholdt <dustpuppy@users.berlios.de>
 */

class Smb4KPrintDialog : public KDialogBase
{
  TQ_OBJECT
  

  public:
    /**
     * The constructor.
     *
     * @param item        The Smb4KShareItem of the printer.
     *
     * @param parent      The parent widget of this dialog.
     *
     * @param name        The name of this dialog.
     */
    Smb4KPrintDialog( Smb4KShareItem *item, TQWidget *parent = 0, const char *name = 0 );
    /**
     * The destructor
     */
    ~Smb4KPrintDialog();

  protected slots:
    /**
     * Reimplemented from KDialogBase.
     */
    void slotUser1();

    /**
     * Reimplemented from KDialogBase.
     */
    void slotCancel();

    /**
     * This slot is connected to the Smb4KPrint::state() signal.
     */
    void slotPrintStateChanged( int state );

    /**
     * This slot is being enabled if there is input text.
     *
     * @param text        The input text.
     */
    void slotInputValueChanged( const TQString &text );

  private:
    /**
     * The Smb4KShareItem object.
     */
    Smb4KShareItem *m_item;
    /**
     * Holds the IP address.
     */
    TQString m_ip;
};

#endif
