/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.
 
    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>
 
    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.
 
    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.
 
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/


#include "DocumentConfigureDialog.h"
#include <tqlayout.h>

#include <tdelocale.h>
#include "ConfigureDialogBase.h"
#include "document/RosegardenGUIDoc.h"
#include "gui/configuration/AudioPropertiesPage.h"
#include "gui/configuration/ColourConfigurationPage.h"
#include "gui/configuration/DocumentMetaConfigurationPage.h"
#include "gui/configuration/GeneralConfigurationPage.h"
#include <kdialogbase.h>
#include <tqstring.h>
#include <tqwidget.h>
#include <kstddirs.h>


namespace Rosegarden
{
static TQPixmap loadIcon(const char *name)
{
    TQString pixmapDir = TDEGlobal::dirs()->findResource("appdata", "pixmaps/");
    TQString fileBase = pixmapDir + "/misc/";
    fileBase += name;
    if (TQFile(fileBase + ".png").exists()) {
        return TQPixmap(fileBase + ".png");
    } else if (TQFile(fileBase + ".xpm").exists()) {
        return TQPixmap(fileBase + ".xpm");
    }

    TQPixmap pmap = TDEGlobal::instance()->iconLoader()
        ->loadIcon(TQString::fromLatin1(name), TDEIcon::NoGroup, TDEIcon::SizeMedium);
    return pmap;
}


DocumentConfigureDialog::DocumentConfigureDialog(RosegardenGUIDoc *doc,
        TQWidget *parent,
        const char *name)
        : ConfigureDialogBase(parent, i18n("Document Properties"), name)
{
    TQWidget *pageWidget = 0;
    TQVBoxLayout *vlay = 0;
    ConfigurationPage* page = 0;

    // Document Meta Page
    //
    pageWidget = addPage(DocumentMetaConfigurationPage::iconLabel(),
                         DocumentMetaConfigurationPage::title(),
                         loadIcon(DocumentMetaConfigurationPage::iconName().ascii()));
    vlay = new TQVBoxLayout(pageWidget, 0, spacingHint());
    page = new DocumentMetaConfigurationPage(doc, pageWidget);
    vlay->addWidget(page);
    page->setPageIndex(pageIndex(pageWidget));
    m_configurationPages.push_back(page);

    // Audio Page
    //
    pageWidget = addPage(AudioPropertiesPage::iconLabel(),
                         AudioPropertiesPage::title(),
                         loadIcon(AudioPropertiesPage::iconName().ascii()));
    vlay = new TQVBoxLayout(pageWidget, 0, spacingHint());
    page = new AudioPropertiesPage(doc, pageWidget);
    vlay->addWidget(page);
    page->setPageIndex(pageIndex(pageWidget));
    m_configurationPages.push_back(page);

    // Colour Page
    pageWidget = addPage(ColourConfigurationPage::iconLabel(),
                         ColourConfigurationPage::title(),
                         loadIcon(ColourConfigurationPage::iconName().ascii()));

    vlay = new TQVBoxLayout(pageWidget, 0, spacingHint());
    page = new ColourConfigurationPage(doc, pageWidget);
    vlay->addWidget(page);
    page->setPageIndex(pageIndex(pageWidget));
    m_configurationPages.push_back(page);

    resize(minimumSize());
}

void
DocumentConfigureDialog::showAudioPage()
{
    int index = 0;

    for (configurationpages::iterator i = m_configurationPages.begin();
            i != m_configurationPages.end(); ++i) {

        AudioPropertiesPage *page =
            dynamic_cast<AudioPropertiesPage *>(*i);

        if (!page) {
            ++index;
            continue;
        }

        showPage(index);
        return ;
    }
}

/* hjj: WHAT TO DO WITH THIS ?
void
DocumentConfigureDialog::selectMetadata(TQString name)
{
    int index = 0;

    for (configurationpages::iterator i = m_configurationPages.begin();
            i != m_configurationPages.end(); ++i) {

        DocumentMetaConfigurationPage *page =
            dynamic_cast<DocumentMetaConfigurationPage *>(*i);

        if (!page) {
            ++index;
            continue;
        }

        page->selectMetadata(name);
        showPage(index);
        return ;
    }
}
*/

}
