/**********************************************************************
** Copyright (C) 2000 Trolltech AS.  All rights reserved.
** Copyright (c) 2001 Phil Thompson <phil@river-bank.demon.co.uk>
**
** This file is part of TQt Designer.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#ifndef UIC_H
#define UIC_H
#include <tqdom.h>
#include <tqstring.h>
#include <tqstringlist.h>
#include <tqmap.h>
#include <tqtextstream.h>
#include <tqpalette.h>
#include <tqvariant.h>


#define	PYTQT_VERSION	"3.18.1"


class PyIndent
{
public:
	PyIndent() : tabStop(4), current(0) {calc();}

	void setTabStop(uint n) {tabStop = n; calc();}
	uint setIndent(uint i) {uint old = current; current = i; calc(); return old;}
	void operator++() {++current; calc();}
	void operator--() {--current; calc();}
	operator TQString() {return indstr;}

private:
	uint tabStop;
	uint current;
	TQString indstr;

	void calc();
};


class Uic : public TQt
{
public:
    Uic( const TQString &fn, const char *outputFn, TQTextStream& out,
	 TQDomDocument doc, bool subcl, const TQString &trm,
	 const TQString& subclname, TQString &uicClass );

    static void setIndent(const PyIndent &pyind) {indent = pyind; trindent = pyind;}

    void createFormImpl( const TQDomElement &e );

    void createSubImpl( const TQDomElement &e, const TQString& subclname );

    void createActionImpl( const TQDomElement& e, const TQString &parent );
    void createToolbarImpl( const TQDomElement &e, const TQString &parentClass, const TQString &parent );
    void createMenuBarImpl( const TQDomElement &e, const TQString &parentClass, const TQString &parent );
    void createPopupMenuImpl( const TQDomElement &e, const TQString &parentClass, const TQString &parent );
    TQString createObjectImpl( const TQDomElement &e, const TQString& parentClass, const TQString& parent, const TQString& layout = TQString::null );
    TQString createLayoutImpl( const TQDomElement &e, const TQString& parentClass, const TQString& parent, const TQString& layout = TQString::null );
    TQString createObjectInstance( const TQString& objClass, const TQString& parent, const TQString& objName );
    TQString createSpacerImpl( const TQDomElement &e, const TQString& parentClass, const TQString& parent, const TQString& layout = TQString::null );
    void createExclusiveProperty( const TQDomElement & e, const TQString& exclusiveProp );
    TQString createListBoxItemImpl( const TQDomElement &e, const TQString &parent, TQString *value = 0 );
    TQString createIconViewItemImpl( const TQDomElement &e, const TQString &parent );
    TQString createListViewColumnImpl( const TQDomElement &e, const TQString &parent, TQString *value = 0 );
    TQString createTableRowColumnImpl( const TQDomElement &e, const TQString &parent, TQString *value = 0 );
    TQString createListViewItemImpl( const TQDomElement &e, const TQString &parent,
				    const TQString &parentItem );
    void createColorGroupImpl( const TQString& cg, const TQDomElement& e );
    TQColorGroup loadColorGroup( const TQDomElement &e );

    TQDomElement getObjectProperty( const TQDomElement& e, const TQString& name );
    TQString getPixmapLoaderFunction( const TQDomElement& e );
    TQString getFormClassName( const TQDomElement& e );
    TQString getClassName( const TQDomElement& e );
    TQString getObjectName( const TQDomElement& e );
    TQString getLayoutName( const TQDomElement& e );
    TQString getInclude( const TQString& className );

    TQString setObjectProperty( const TQString& objClass, const TQString& obj, const TQString &prop, const TQDomElement &e, bool stdset );

    TQString registerObject( const TQString& name );
    TQString registeredName( const TQString& name );
    bool isObjectRegistered( const TQString& name );
    TQStringList unique( const TQStringList& );

    TQString trcall( const TQString& sourceText, const TQString& comment = "" );

    static void embed( TQTextStream& out, const char* project, const TQStringList& images );

private:
    TQTextStream& out;
    TQTextOStream trout;
    TQString languageChangeBody;
    TQCString outputFileName;
    TQStringList objectNames;
    TQMap<TQString,TQString> objectMapper;
    TQStringList tags;
    TQStringList layouts;
    TQString formName;
    TQString lastItem;
    TQString trmacro;
    static PyIndent indent, trindent;

    struct Buddy
    {
	Buddy( const TQString& k, const TQString& b )
	    : key( k ), buddy( b ) {}
	Buddy(){} // for valuelist
	TQString key;
	TQString buddy;
	bool operator==( const Buddy& other ) const
	    { return (key == other.key); }
    };
    struct CustomInclude
    {
	TQString header;
	TQString location;
    };
    TQValueList<Buddy> buddies;

    TQStringList layoutObjects;
    bool isLayout( const TQString& name ) const;

    uint item_used : 1;
    uint cg_used : 1;
    uint pal_used : 1;
    uint stdsetdef : 1;
    uint externPixmaps : 1;

    TQString uiFileVersion;
    TQString nameOfClass;
    TQStringList namespaces;
    TQString bareNameOfClass;
    TQString pixmapLoaderFunction;

    void registerDatabases( const TQDomElement& e );
    bool isWidgetInTable( const TQDomElement& e, const TQString& connection, const TQString& table );
    bool isFrameworkCodeGenerated( const TQDomElement& e );
    TQString getDatabaseInfo( const TQDomElement& e, const TQString& tag );
    void createFormImpl( const TQDomElement& e, const TQString& form, const TQString& connection, const TQString& table );
    void writeFunctionsSubImpl( const TQStringList &fuLst, const TQStringList &typLst, const TQStringList &specLst,
                                const TQString &subClass, const TQString &descr );
    TQStringList dbConnections;
    TQMap< TQString, TQStringList > dbCursors;
    TQMap< TQString, TQStringList > dbForms;

    static bool isMainWindow;
    static TQString mkBool( bool b );
    static TQString mkBool( const TQString& s );
    bool toBool( const TQString& s );
    static TQString fixString( const TQString &str, bool encode = false );
    static bool onlyAscii;
    static TQString mkStdSet( const TQString& prop );
    static TQString getComment( const TQDomNode& n );
    TQVariant defSpacing, defMargin;
    TQString fileName;
    bool writeFunctImpl;

    void pySlot(TQStringList::ConstIterator &it);

    TQString pyCode;
    bool pyNeedTr, pyNeedTrUtf8;
};

#endif
