import sys
sys.path.append ("./uimodules")

from PyTQt.tqt import TQSplitter, TQWidgetStack, TQWidget, TQListViewItem, SIGNAL, TQCString , TQScrollView, TQRect, TQt

from tdecore import TDEApplication, TDECmdLineArgs, TDEAboutData
from tdeui import TDEMainWindow, TDEListView

from uidialogs import *
from uiwidgets import *
from uimenus import *
from uixml import *
from uimisc import *

listItems = {"Dialogs":
                {"TDEAboutDialog": ["TDEAboutApplication", "TDEAboutContainer", "KImageTrackLabel",\
                                  "TDEAboutContainerBase", "TDEAboutContributor", "TDEAboutWidget"],\
                "TDEAboutKDE": [],\
                "KBugReport": [],\
                "KColorDialog": [],\
                "KDialog": [],\
                "KDialogBase": ["KDialogBaseButton", "KDialogBase::SButton", "KDialogBaseTile"],\
                "TDEFontDialog": [],\
                "KKeyDialog": [],\
                "KLineEditDlg": [],\
                "KMessageBox": [],\
                "KPasswordDialog": [],\
                "KWizard": []},\
            "Widgets":
                {"KAnimWidget": [],\
                 "KAuthIcon": ["KRootPermsIcon", "KWritePermsIcon"],\
                 "KButtonBox": [],\
                 "KCharSelect": ["KCharSelectTable"],\
                 "KColorButton": [],\
                 "KColorCells": [],\
                 "KColorCombo": [],\
                 "KColorPatch": [],\
                 "KComboBox": [],\
                 "TDECompletionBox": [],\
                 "KContainerLayout": ["KContainerLayout::KContainerLayoutItem"],\
                 "KCursor": [],\
                 "KDatePicker": ["KDateInternalMonthPicker", "KDateInternalYearSelector"],\
                 "KDateTable": [],\
                 "KDualColorButton": [],\
                 "KEdit": ["KEdFind", "KEdGotoLine", "KEdReplace"],\
                 "KEditListBox": [],\
                 "TDEFontChooser": [],\
                 "KHSSelector": [],\
                 "TDEIconView": [],\
                 "KJanusWidget": ["KJanusWidget::IconListBox"],\
                 "KKeyChooser": [],\
                 "KLed": [],\
                 "KLineEdit": [],\
                 "TDEListBox": [],\
                 "TDEListView": [],\
                 "KNumInput": ["KDoubleNumInput", "KIntNumInput"],\
                 "KPaletteTable": [],\
                 "KPasswordEdit": [],\
                 "KProgress": [],\
                 "KRootPixmap": [],\
                 "TDEMainWindow": [],\
                 "KRestrictedLine": [],\
                 "KRuler": [],\
                 "TDESelector": ["KGradientSelector", "KValueSelector", "KHSSelector", "KXYSelector"],\
                 "KSeparator": [],\
                 "KSqueezedTextLabel": [],\
                 "KTabCtl": [],\
                 "KTextBrowser": [],\
                 "KURLLabel": []},\
            "XML":
                {"TDEActionCollection": [],\
                 "KEditToolbar": [],\
                 "KEditToolbarWidget": [],\
                 "KXMLGUIBuilder": [],\
                 "KXMLGUIClient": ["KXMLGUIClient::DocStruct"],\
                 "KXMLGUIFactory": []},\
            "Menus/Toolbars":
                {"TDEAccelMenu": [],\
                 "TDEAction": ["TDEFontAction", "TDEFontSizeAction", "TDEListAction", "TDERecentFilesAction", "TDERadioAction",\
                             "TDESelectAction", "TDEToggleAction"],\
                 "TDEActionMenu": [],\
                 "TDEActionSeparator": [],\
                 "KContextMenuManager": [],\
                 "KDCOPActionProxy": [],\
                 "KHelpMenu": [],\
                 "KMenuBar": [],\
                 "KPanelApplet": [],\
                 "KPanelExtension": [],\
                 "KPanelMenu": [],\
                 "TDEPopupFrame": [],\
                 "TDEPopupMenu": [],\
                 "TDEPopupTitle": [],\
                 "KStatusBar": [],\
                 "KStatusBarLabel": [],\
                 "KStdAction": [],\
                 "TDEToolBar": ["TDEToolBarButton", "TDEToolBarButtonList", "TDEToolBarPopupAction",\
                              "TDEToolBarRadioGroup", "TDEToolBarSeparator"],\
                 "KWindowListMenu": []},\
            "Other":
                {"KAlphaPainter": [],\
                 "TDECModule": [],\
                 "KColor": [],\
                 "KColorDrag": [],\
                 "KCommand": ["KMacroCommand"],\
                 "KCommandHistory": [],\
                 "KDateValidator": [],\
                 "KDockWindow": ["KDockButton_Private - KPanelMenu", "KDockButton_Private",\
                                 "KDockSplitter", "KDockTabCtl_PrivateStruct", "KDockWidgetAbstractHeader",\
                                 "KDockWidgetAbstractHeaderDrag", "KDockWidgetHeader",\
                                 "KDockWidgetHeaderDrag", "KDockWidgetPrivate"],\
                 "KFloatValidator": [],\
                 "KIntValidator": [],\
                 "KPixmapIO": [],\
                 "TDESharedPixmap": [],\
                 "KSystemTray": [],\
                 "KThemeBase": ["KThemeCache", "KThemePixmap", "KThemeStyle"],\
                 "QXEmbed": []}}

prefix = {"Dialogs": "dlg", "Widgets": "wid", "XML": "xml", "Menus/Toolbars": "menu", "Other": "misc"}

# The following leave about 375 x 390 for the rt hand panel
mainGeom  = TQRect (0, 0, 640, 500)
treeWidth = 220

blankMsg = """ UISampler - provides examples of PyTDE widgets

Select a dialog/widget/menu/etc example from the tree at left
"""


class MainWin (TDEMainWindow):
    def __init__ (self, *args):
        TDEMainWindow.__init__(*(self,) + args)

        self.setCaption ("Samples of PyTDE widget usage")
        self.setGeometry (mainGeom)

        # create the main view - list view on the left and an
        # area to display frames on the right
        self.mainView  = TQSplitter (self, "main view")
        self.tree      = TDEListView (self.mainView, "tree")
        self.page      = TQWidgetStack (self.mainView, "page")
        self.blankPage = TQWidget (self.page, "blank")
        self.blankPage.setGeometry (0, 0, 375, 390)
        self.blankPage.setBackgroundMode (TQWidget.PaletteBase)

        blankLbl = TQLabel (blankMsg, self.blankPage)
        blankLbl.setGeometry (40, 10, 380, 150)
        blankLbl.setBackgroundMode (TQWidget.PaletteBase)

        blankPM = TQPixmap ("pytestimage.png")
        pmLbl   = TQLabel ("", self.blankPage)
        pmLbl.setPixmap (blankPM)
        pmLbl.setGeometry (40, 160, 300, 200)
        pmLbl.setBackgroundMode (TQWidget.PaletteBase)

        self.page.addWidget (self.blankPage, 1)
        self.page.raiseWidget (1)

        self.setCentralWidget (self.mainView)

        self.initListView ()
        self.connect (self.tree, SIGNAL ("clicked (TQListViewItem *)"), self.lvClicked)

        self.edit = None
        self.currentPageObj = None

    def initListView (self):
        self.tree.addColumn ("Category", treeWidth - 21)
#        self.tree.setMaximumWidth (treeWidth)
        self.mainView.setSizes ([treeWidth, 375])
        self.tree.setRootIsDecorated (True)
        self.tree.setVScrollBarMode (TQScrollView.AlwaysOn)
        topLevel = list(listItems.keys ())
        for item_1 in topLevel:
            parent = TQListViewItem (self.tree, item_1)
            secondLevel = list(listItems [item_1].keys ())
            for item_2 in secondLevel:
                child = TQListViewItem (parent, item_2)
                for item_3 in listItems [item_1][item_2]:
                    TQListViewItem (child, item_3)

    def lvClicked (self, lvItem):
        if not lvItem:
            return

        if lvItem.text (0).latin1 () in list(listItems.keys ()):
            return

        p = lvItem.parent ()
        if p.text (0).latin1 () in list(listItems.keys ()):
            pfx = prefix [p.text (0).latin1 ()]
            funcCall = pfx + lvItem.text (0).latin1 () + "(self)"
        else:
            pfx = prefix [p.parent ().text (0).latin1 ()]
            funcCall = pfx + lvItem.parent ().text (0).latin1 () + "(self)"

        eval (funcCall)

    def addPage (self):
        self.edit = None
        self.currentPageObj = None
        current = self.page.widget (2)
        if current:
            self.page.removeWidget (current)
            del current

        newPage = TQWidget (self.page)
        newPage.setGeometry (0, 0, 375, 390)
#        newPage.setBackgroundMode (TQWidget.PaletteBase)
        self.page.addWidget (newPage, 2)
        self.page.raiseWidget (2)

        return newPage


#-------------------- main ------------------------------------------------

appName = b"UISampler"
app = TDEApplication (sys.argv, appName)
mainWindow = MainWin (None, b"main window")
mainWindow.show()
app.exec_loop()

